var PG = PG || {};

// ※表示タイトル
PG.title = "西山動物園レッサーパンダ";

// ※プロパティの設定
PG.property = {
	image : "photo",
	label : "name",
	detail : "remarks",
	address : "residence",
	long : "http://www.w3.org/2003/01/geo/wgs84_pos#long",
	lat : "http://www.w3.org/2003/01/geo/wgs84_pos#lat"
}

window.onload = function() {
	var list = "";
	$("#container").prepend("<h3>" + PG.title + "</h3>");
	// 指定されたworkを全件取得
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// workに含まれるfileを全件取得
		var propUri = stringToUri(PG.property, workValue);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			// subjectを全件取得
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var image = "";
				var label = "";
				var detail = "";
				var address = "";
				var longitude = "";
				var latitude = "";
				var str = "";
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ( prop == propUri.image )  image = obj;
					else if ( prop == propUri.label ) label = obj ;
					else if ( prop == propUri.detail ) detail = obj ;
					else if ( prop == propUri.address && obj.length != 0) address = "<p class=\"address\"><img src=\"http://app.linkdata.org/asset/47cb55da.png\" />" + obj + "</p>" ;
					else if ( prop == propUri.long ) longitude = obj;
					else if ( prop == propUri.lat ) latitude = obj;
				});
				str += "<li class=\"flipImage\"><div class=\"front\"><a href='#'><img src=\"" + image + "\" alt=\"image\" /></a></div><div class=\"back\"><p class=\"label\">" + label + "<p class=\"detail\">" + detail  + "</p>" + address + "<span class=\"button\">" + addLinkToMap(latitude, longitude) + "</span></div></li>"
				list += str;
			});
		});
	});
	$("#result").append( list );
	
	// 画像を正方形にトリミング
	$(".front").imgLiquid();
	
	// 画像が読み込めなかった時の処理
	$("img").error(function(){
		$(this).before("No Image");
	});
	
	$( 'a' )
	  .bind( 'touchstart', function(){
 	   $( this ).addClass( 'hover' );
	}).bind( 'touchend', function(){
	    $( this ).removeClass( 'hover' );
	});
};

// Google Mapのルート検索へのリンクを追加
function addLinkToMap( latitude, longitude )
{
	var str = "";
	if (latitude.length != 0 && longitude.length != 0) {
		str = "<a target=\"_blank\" class=\"object\" href=\"http://maps.google.co.jp/maps?daddr=" + latitude + "," + longitude + "\">ルート検索</a>"
	}
	return str;
}

function stringToUri (p, workId) {
	$.each (p, function(propKey, propVal){
		if(propVal.indexOf("http") != 0){
			p[propKey] = "http://linkdata.org/property/" + workId + "#" + encodeURIComponent(propVal);
		}
	})
	return p;
}
