var PG = PG || {};

// ※表示タイトル
PG.title = "長野県聖地巡礼図";

// ※プロパティの設定
PG.property = {
	front_image : "source_image",
	back_image : "original_image",
	label : "yomi_name",
	detail : "title",
	//address : "http://schema.org/address",
	long : "http://www.w3.org/2003/01/geo/wgs84_pos#long",
	lat : "http://www.w3.org/2003/01/geo/wgs84_pos#lat"
}

window.onload = function() {
	var list = "";
	$("#container").prepend("<h3>" + PG.title + "</h3>");
	// 指定されたworkを全件取得
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// workに含まれるfileを全件取得
		var propUri = stringToUri(PG.property, workValue);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			// subjectを全件取得
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var front_image= "";
				var back_image= "";
				var label = "";
				var detail = "";
				var address = "";
				var longitude = "";
				var latitude = "";
				var str = "";
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ( prop == propUri.front_image )  front_image = obj;
					else if ( prop == propUri.back_image )  back_image = obj;
					else if ( prop == propUri.label ) label = obj ;
					else if ( prop == propUri.detail ) detail = obj ;
					else if ( prop == propUri.address && obj.length != 0) address = "<p class=\"address\"><img src=\"http://app.linkdata.org/asset/47cb55da.png\" />" + obj + "</p>" ;
					else if ( prop == propUri.long ) longitude = obj;
					else if ( prop == propUri.lat ) latitude = obj;
				});
				str += "<li class=\"flipImage\"><div class=\"front\"><a href='#'><img src=\"" + front_image + "\" alt=\"image\" /></a></div><div class=\"back\"><a href='#'><img src=\"" + back_image + "\" alt=\"image\" /></a></div></li>"
				list += str;
			});
		});
	});
	$("#result").append( list );
	
	// 画像を正方形にトリミング
	$(".front").imgLiquid();
	$(".back").imgLiquid();
	// 画像が読み込めなかった時の処理
	$("img").error(function(){
		$(this).before("No Image");
	});
	
	$( 'a' )
	  .bind( 'touchstart', function(){
 	   $( this ).addClass( 'hover' );
	}).bind( 'touchend', function(){
	    $( this ).removeClass( 'hover' );
	});
};

// Google Mapのルート検索へのリンクを追加
function addLinkToMap( latitude, longitude )
{
	var str = "";
	if (latitude.length != 0 && longitude.length != 0) {
		str = "<a target=\"_blank\" class=\"object\" href=\"http://maps.google.co.jp/maps?daddr=" + latitude + "," + longitude + "\">ルート検索</a>"
	}
	return str;
}

function stringToUri (p, workId) {
	$.each (p, function(propKey, propVal){
		if(propVal.indexOf("http") != 0){
			p[propKey] = "http://linkdata.org/property/" + workId + "#" + encodeURIComponent(propVal);
		}
	})
	return p;
}
