var PG = PG || {};

// ※表示タイトル
PG.title = "平和を伝える絵本ギャラリー";

// ※プロパティの設定
PG.property = {
	image : "表紙",
	label : "タイトル",
	detail : "内容紹介",
	address : "著者",
	isbn : "ISBN"
}

window.onload = function() {
	var list = "";
	$("#container").prepend("<h3>" + PG.title + "</h3>");
	// 指定されたworkを全件取得
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// workに含まれるfileを全件取得
		var propUri = stringToUri(PG.property, workValue);
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			// subjectを全件取得
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var image = "";
				var label = "";
				var detail = "";
				var address = "";
				var isbn = "";
				var str = "";
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ( prop == propUri.image )  image = obj;
					else if ( prop == propUri.label ) label = obj ;
					else if ( prop == propUri.detail ) detail = obj ;
					else if ( prop == propUri.address && obj.length != 0) address = "<p class=\"address\">" + obj + "</p>" ;
					else if ( prop == propUri.isbn ) isbn = obj;
				});
				str += "<li class=\"flipImage\"><div class=\"front\"><a href='#'><img src=\"" + image + "\" alt=\"image\" /></a></div><div class=\"back\"><p class=\"label\">" + label + "<p class=\"detail\">" + detail  + "</p>" + address + "<span class=\"button\">" + addLinkToMap(isbn) + "</span></div></li>"
				list += str;
			});
		});
	});
	$("#result").append( list );
	
	// 画像を正方形にトリミング
	$(".front").imgLiquid();
	
	// 画像が読み込めなかった時の処理
	$("img").error(function(){
		$(this).before("No Image");
	});
	
	$( 'a' )
	  .bind( 'touchstart', function(){
 	   $( this ).addClass( 'hover' );
	}).bind( 'touchend', function(){
	    $( this ).removeClass( 'hover' );
	});
};

// Google Mapのルート検索へのリンクを追加
function addLinkToMap(isbn)
{
	var str = "";
	if (isbn.length != 0) {
		str = "<a target=\"_blank\" class=\"object\" href=\"https://calil.jp/book/" + isbn + "\">この本を図書館でさがす</a>"
	}
	return str;
}

function stringToUri (p, workId) {
	$.each (p, function(propKey, propVal){
		if(propVal.indexOf("http") != 0){
			p[propKey] = "http://linkdata.org/property/" + workId + "#" + encodeURIComponent(propVal);
		}
	})
	return p;
}
