MotifRanking = function( containerId, options ){
	var app = new Application.motifRanking( containerId, options );
};

if( Application === "undefined" || !Application )
{
	var Application = {};
}

Application.motifRanking = function() {
	this._init.apply( this, arguments );
};

Application.motifRanking.prototype = {
	_containerId : null,
	_baseSequence : null,
	_options : null,
	_motifProperty : null,
	_heptamer : null,
	_octamer : null,
	_appSequence : null,
	_filteredSubjectList : null,
	_motifViewDialogId : null,
	_geneInfoContainerId : null,
	
	_default : {
		appName : "MotifRanking",
		selectPropertyCaption : "Select Property",
		selectPropertyAreaClass : "selectPropertyArea",
		selectPropertyClass : "selectProperty",
		
		// 発現ランキング関係の定数
		selectRankingCaption : "Expression Ranking",
		selectRankingAreaClass : "selecRankingArea",
		selectRankingClass : "selectRanking",
		rankingRange : 10,
		
		// 順序選択関係の定数
		selectOrderCaption : "Order",
		selectOrderAreaClass : "selectOrderArea",
		selectOrderName : "selectOrder",
		topValue : "top",
		bottomValue : "bottom",
		topLabel : "Top",
		bottomLabel : "Bottom",
		
		resultAreaClass : "resultArea",
		replaceButtonAreaClass : "replaceButtonArea",
		replaceButtonClass : "replaceButton",
		nextButtonAreaClass : "nextButtonArea",
		replaceSequenceClass : "replaceSequence",
		errorMessageAreaClass : "errorMessage",
		dialogErrorMessageClass : "dialogErrorMessage",
		dialogOutRangeValueMessage : "Please input a value between {0} and {1}",
		databaseInfoClass : "databaseInfo",
		geneLabelClass : "geneUrl",
		geneInfoLinkClass : "geneInfoLink",
		motifSequenceProperty : "motif sequence",
		motifPositionProperty : "motif position",
		typeProperty : "type",
		validType : "REG",
		motifViewDialogId : "motifViewDialog",
		motifViewDialogClass : "motifViewDialog",
		motifViewDialogTitle : "Motif View",
		minSequenceClass : "minSeq",
		maxSequenceClass : "maxSeq",
		websiteNameAtted : "ATTED",
		websiteNamePpdb : "PPDB",
		baseSequenceMinLength : 50,
		dialogImageUrl : "http://app.linkdata.org/asset/a06f4de4.png",
		callback : function() {},
		loadingImageContainer : "loadingImageContainer",
		loadingImageUrl : "http://app.linkdata.org/asset/67556085.gif",
		loadingMessageClass : "loadingMessage",
		loadingMessage : "Loading linked data, it may take a few minutes..."
	},
	
	_tag : {
		topResult : "result_top",
		bottomResult : "result_bottom"
	},
	
	_init : function( containerId, options ) {
		this._containerId = containerId;
		this._options = $.extend( {}, this._default, options );
		this._baseSequence = this._options.baseSequence;
		this.filteredSubjectList = [];
		var date = new Date();
		this._geneInfoContainerId = "gene_info_containerId_" + date.getTime();
		this._initMotifProperty(this._options);
		this._initAppSequence(this._options);
		this._initHeptamer();
		this._initOctamer();
		this._initView();
		this._initMotifViewDialog();
	},
	
	_initMotifProperty : function( opts ) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._motifProperty = new Application.motifProperty( obj );
	},
	
	_initAppSequence : function( opts ) {
		var self = this;
		var timer = new Application.timer();
		var init = function() {
			var seqProperty = self._motifProperty.getPropertyByLabel( self._options.motifSequenceProperty );
			var posProperty = self._motifProperty.getPropertyByLabel( self._options.motifPositionProperty );
			if( seqProperty && posProperty )
			{
				var obj = {
					workId : opts.workId,
					fileName : opts.fileName,
					baseSequence : self._baseSequence,
					motifSequenceProperty : seqProperty,
					motifPositionProperty : posProperty,
					containerId : self._containerId,
					errorMessageClass : self._options.errorMessageAreaClass,
					baseSequenceMinLength : self._options.baseSequenceMinLength
				};
				self._appSequence = new Application.sequence( obj );
			}
			else
			{
				timer.call( init );
			}
		};
		init();
	},
	
	_initHeptamer : function() {
		this._heptamer = new Application.heptamer();
	},
	
	_initOctamer : function() {
		this._octamer = new Application.octamer();
	},
	
	_initView : function() {
		this._initMainView();
		this._initDialogView();
	},
	
	_initMainView : function() {
		var self = this;
		var timer = new Application.timer();
		var fillOptionMethod = function() {
			var optionArray = self._motifProperty.getOptionArray();
			if( optionArray )
			{
				var sb = [];
				sb[ sb.length ] = "<div class='" + self._options.selectPropertyAreaClass + " row'>";
				sb[ sb.length ] = " <div class='label left'>" + self._options.selectPropertyCaption + "</div>";
				sb[ sb.length ] = " <div class='left'>";
				sb[ sb.length ] = "  <select class='" + self._options.selectPropertyClass + "'>";
				sb[ sb.length ] = "   <option value='" + -1 + "'>-- Select Property --</option>";
				$.each( optionArray, function( key, obj ) {
					sb[sb.length] = "<option value='" + obj.key + "'>" + obj.value + "</option>";
				} );
				sb[ sb.length ] = "  </select>";
				sb[ sb.length ] = " </div>";
				sb[ sb.length ] = "</div>";
				
				// 順序の選択のためのエリア
				sb[ sb.length ] = "<div class='" + self._options.selectOrderAreaClass + " row hidden'>";
				sb[ sb.length ] = " <div class='label left'>" + self._options.selectOrderCaption + "</div>";
				sb[ sb.length ] = " <div class='left'>";
				sb[ sb.length ] = "  <lable><input name='" + self._options.selectOrderName + "'";
				sb[ sb.length ] = "   type='radio' value='" + self._options.topValue +"'>" + self._options.topLabel + "</label>";
				sb[ sb.length ] = "  <label><input name='" + self._options.selectOrderName + "'";
				sb[ sb.length ] = "   type='radio' value='"+ self._options.bottomValue +"'>" + self._options.bottomLabel + "</label>";
				sb[ sb.length ] = " </div>";
				sb[ sb.length ] = "</div>";
				
				//発現ランキングのエリア
				sb[ sb.length ] = "<div class='" + self._options.selectRankingAreaClass + " row hidden'>";
				sb[ sb.length ] = " <div class='label left'>" + self._options.selectRankingCaption + "</div>";
				sb[ sb.length ] = " <div class='left'>";
				sb[ sb.length ] = "  <select class='" + self._options.selectRankingClass + "'>";
				sb[ sb.length ] = "   <option value='" + -1 + "'>-- Select Gene --</option>";
				sb[ sb.length ] = "  </select>";
				sb[ sb.length ] = " </div>";
				sb[ sb.length ] = "</div>";
				
				sb[ sb.length ] = "<div class='" + self._options.databaseInfoClass + " hidden'></div>";
				sb[ sb.length ] = "<div id='" + self._geneInfoContainerId + "'></div>";
				sb[ sb.length ] = "<div class='" + self._options.resultAreaClass + " hidden'></div>";
				sb[ sb.length ] = "<div class='" + self._options.errorMessageAreaClass + " hidden'>error</div>";
				sb[ sb.length ] = "<div class='" + self._options.replaceButtonAreaClass + " hidden'>";
				sb[ sb.length ] = "<a class='" + self._options.replaceButtonClass + " btn btn-lightblue'>Replace</a>";
				sb[ sb.length ] = "</div>";
				sb[ sb.length ] = "<div class='" + self._options.replaceSequenceClass + " hidden'></div>";
				sb[ sb.length ] = "<div class='" + self._options.loadingImageContainer + " hidden' align='center'>";
				sb[ sb.length ] = "<div class='" + self._options.loadingMessageClass + "'>" + self._options.loadingMessage + "</div>";
				sb[ sb.length ] = "<div>";
				sb[ sb.length ] = "<img src='" + self._options.loadingImageUrl + "'/>";
				sb[ sb.length ] = "</div>";
				sb[ sb.length ] = "</div>";
				$( "#" + self._containerId ).html( sb.join( "" ) );
				
				// イベントに関数をバインドする処理
				self._initSelectPropertyListener();
				self._initSelectOrderListener();
				self._initRankingListener();
			}
			else
			{
				timer.call(fillOptionMethod);
			}
		};
		fillOptionMethod();
	},
	
	_initDialogView : function() {
		var sb = [], self = this, date = new Date(); 
		this._motifViewDialogId = "motifViewDialog_id_" + self._containerId + "_" + date.getTime();
		sb[ sb.length ] = "<div id='" + this._motifViewDialogId + "' class='hidden'>";
		sb[ sb.length ] = "<input type='hidden' class='sequence'>";
		sb[ sb.length ] = "<div>";
		sb[ sb.length ] = "<span>Place motif at position</span>";
		sb[ sb.length ] = "<input type='text' class='position'/>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div>";
		sb[ sb.length ] = "<span class='explanation'>Replace with prefer position between ";
		sb[ sb.length ] = "<span class='minSeq'></span> and <span class='maxSeq'>";
		sb[ sb.length ] = "</span>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div>";
		sb[ sb.length ] = "<span>Number of extra copies</span>";
		sb[ sb.length ] = "<input type='text' class='extraCopies' value='0'/>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div>";
		sb[ sb.length ] = "<span>Space between copies (Base Pairs)</span>";
		sb[ sb.length ] = "<input type='text' class='basePairs' value='0'/>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div class='motifImageArea'>";
		sb[ sb.length ] = "<img src='" + this._options.dialogImageUrl + "'/>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div>";
		sb[ sb.length ] = "<span class='explanation'>Click ";
		sb[ sb.length ] = "<a class='moreInfo'>here</a> to see the additional information about motif from " + self._getDataBaseWebsiteName() + " website";
		sb[ sb.length ] = "</span>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div>";
		sb[ sb.length ] = "<span class='dialogErrorMessage errorMessage hidden'></span>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "</div>";
		$( "#" + this._containerId ).append( sb.join( "" ) );
	},
	
	_initSelectPropertyListener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		var timer = new Application.timer();
		var setSelectListener = function() {
			if($( "#" + self._containerId + " ." + self._options.selectPropertyClass ).length !== 0 )
			{
				$( "#" + self._containerId + " ." + self._options.selectPropertyClass ).change( function() {
					// すでに後続の部品がすでに表示されている場合に備え、それらを一旦隠す。
					self._appSequence.hideError();
					$( "#" + self._containerId + " ." + self._options.selectOrderAreaClass ).hide();
					$( "#" + self._containerId + " ." + self._options.selectRankingAreaClass ).hide();
					$( "#" + self._containerId + " ." + self._options.resultAreaClass ).hide();
					$( "#" + self._containerId + " ." + self._options.replaceButtonAreaClass ).hide();
					$( "#" + self._containerId + " ." + self._options.replaceSequenceClass ).hide();
					$( "#" + self._containerId + " ." + self._options.databaseInfoClass ).hide();
					$( "#" + self._containerId + " #" + self._geneInfoContainerId ).hide();
					// 順序選択のためのラジオボタンをリセット
					$( "#" + self._containerId + " [name=" + self._options.selectOrderName + "]" ).attr( "checked", false );
					// 選択されたのが「-- Select Property --」でなければ
					if( $( this ).val() !== "-1" )
					{
						$( "#" + self._containerId + " ." + self._options.selectOrderAreaClass ).show();
					}
				} );
			}
			else
			{
				timer.call( setSelectListener );
			}
		};
		setSelectListener();
	},
	
	_initSelectOrderListener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		var timer = new Application.timer();
		var setSelectListener = function() {
				if( $( "#" + self._containerId + " [name=" + self._options.selectOrderName + "]" ).length !== 0 )
				{
					$( "#" + self._containerId + " [name=" + self._options.selectOrderName + "]" ).change( function() {
						// ロード中の表示
						$( "#" + self._containerId + " ." + self._options.loadingImageContainer ).show();
						// すでに後続の部品がすでに表示されている場合に備え、それらを一旦隠す。
						self._appSequence.hideError();
						$( "#" + self._containerId + " ." + self._options.selectRankingAreaClass ).hide();
						$( "#" + self._containerId + " ." + self._options.resultAreaClass ).hide();
						$( "#" + self._containerId + " ." + self._options.replaceButtonAreaClass ).hide();
						$( "#" + self._containerId + " ." + self._options.replaceSequenceClass ).hide();
						$( "#" + self._containerId + " ." + self._options.databaseInfoClass ).hide();
						$( "#" + self._containerId + " #" + self._geneInfoContainerId ).hide();
						
						var propLabel = $( "#" + self._containerId + " ." + self._options.selectPropertyClass + " option:selected" ).val();
						var order = $( this ).val();
						// ランキング生成へ
						self._showMotifSequence( workId, fileName, propLabel, order );
					} );
				}
				else
				{
					timer.call( setSelectListener );
				}
			};
		setSelectListener();
	},
	
	_initRankingListener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		var timer = new Application.timer();
		var setSelectListener = function() {
			if($( "#" + self._containerId + " ." + self._options.selectRankingClass ).length !== 0 ) {
				$( "#" + self._containerId + " ." + self._options.selectRankingClass ).change( function() {
					// すでに後続の部品がすでに表示されている場合に備え、それらを一旦隠す。
					self._appSequence.hideError();
					$( "#" + self._containerId + " ." + self._options.resultAreaClass ).hide();
					$( "#" + self._containerId + " ." + self._options.replaceButtonAreaClass ).hide();
					$( "#" + self._containerId + " ." + self._options.replaceSequenceClass ).hide();
					$( "#" + self._containerId + " ." + self._options.databaseInfoClass ).hide();
					$( "#" + self._containerId + " #" + self._geneInfoContainerId ).hide();
					// 選択されたのが「-- Select Gene --」でなければ
					if( $( this ).val() !== "-1" )
					{
						$( "#" + self._containerId + " ." + self._options.loadingImageContainer ).show();
						var subject = $( "option:selected", this ).val();
						var propLabel = $( "#" + self._containerId + " ." + self._options.selectPropertyClass + " option:selected" ).val();
						self._motifSequence( workId, fileName, subject, propLabel );
					}
				} );
			}
			else
			{
				timer.call( setSelectListener );
			}
		};
		setSelectListener();
	},
	
	_showGenePlot : function( subject, property ) {
		var self = this;
		$( "#" + self._containerId + " #" + self._geneInfoContainerId ).show();
		var options = {
			workId : self._options.workId,
			fileName : self._options.fileName,
			subject : subject,
			property : property
		};
		var app = new Application.geneChart( self._geneInfoContainerId, options );
	},
	
	_showDataBaseInformationList : function() {
		var self = this, seqVal = [];
		$( "#" + self._containerId + " .userSequence .hdnSequence" ).each( function() {
			var tmpPos = $( this ).siblings( ".hdnPosition" ).val();
			seqVal.push( $( this ).val() + "[" + tmpPos + "]" );
		} );
		self._showDatabaseInfo( seqVal.join( ", " ) );
	},
	
	_initReplaceButtonLitener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		$( "#" + self._containerId + " ." + self._options.replaceButtonClass ).click( function() {
			self._appSequence.hideError();
			$( "#" + self._containerId + " ." + self._options.replaceSequenceClass ).show();
			var seqs = [];
			$( "#" + self._containerId + " .userSequence" ).each( function() {
				seqs.push($( this ).text() );
			} );
			var html = self._appSequence.replace( seqs );
			$( "#" + self._containerId + " ." + self._options.replaceSequenceClass ).html( html );
			self._showDataBaseInformationList();
			self._options.callback();
		} );
	},
	
	_initMotifSequenceListener : function() {
		var self = this;
		$( "#" + self._containerId + " .motifSequence" ).click( function() {
			$( "." + self._options.motifViewDialogClass ).hide();
			var parent = $( this ).closest( ".userSequence" );
			var container = $( this ).closest( ".userSequence" );
			var seq = $( parent ).find( ".hdnSequence" ).val();
			var pos = $( parent ).find( ".hdnPosition" ).val();
			var seqEl = self._getSeqElBySeq( seq );
			var appropriatePos = ( seqEl && seqEl.getAppropriatePos() ) ? seqEl.getAppropriatePos() : pos;
			self._initSequencePopup( seqEl );
			$( "#" + self._motifViewDialogId + " ." + self._options.dialogErrorMessageClass ).hide();
			$( "#" + self._motifViewDialogId + " .sequence" ).val( seq );
			$( "#" + self._motifViewDialogId + " .position" ).val( appropriatePos );
			$( "#" + self._motifViewDialogId + " .extraCopies" ).val( 0 );
			$( "#" + self._motifViewDialogId + " .basePairs" ).val( 0 );
			$( "#" + self._motifViewDialogId + " .minSeq" ).html( self._getMinPosition( seq ) );
			$( "#" + self._motifViewDialogId + " .maxSeq" ).html( self._getMaxPosition( seq ) );
			self._initPositionInsert( seq, appropriatePos );
			$( "#" + self._motifViewDialogId ).dialog( { title: self._default.motifViewDialogTitle + " - " + seq } );
			$( "#" + self._motifViewDialogId ).dialog( "open" );
			$( "#" + self._motifViewDialogId ).closest( '.' + self._options.motifViewDialogClass ).show();
		} );
	},
	
	_initSequencePopup : function( seqEl ) {
		var self = this;
		$( "#" + self._motifViewDialogId + " .moreInfo" ).unbind( "click" );
		var url = ( seqEl && seqEl.getExternalUrl() ) ? seqEl.getExternalUrl() : "#";
		$( "#" + self._motifViewDialogId + " .moreInfo" ).click( function() {
			self._showPopupWindow( url );
		} );
	},
	
	_showPopupWindow : function( url ) {
		var winWidth = 800;
		var winHeight = 800;
		var winLeft = parseInt( ( screen.availWidth / 2 ) - ( winWidth / 2 ), 10 );
		var winTop = parseInt( ( screen.availHeight / 2 ) - ( winHeight / 2 ), 10 );
		var winStyle = "width=" + winWidth + ",height=" + winHeight + ",left=" + winLeft + ",top="
			+ winTop + ",screenX=" + winLeft + ",screenY=" + winTop + ",scrollbars=1";
		window.open( url, "Motif", winStyle );
	},
	
	_initPositionInsert : function( seq, pos ) {
		var self = this;
		var mod = seq.length % 2;
		$( "#" + self._motifViewDialogId + " .position" ).unbind( "keyup" );
		$( "#" + self._motifViewDialogId + " .position" ).keyup( function() {
			var val = $( this ).val();
			if( isNaN( val ) ) {
				$( this ).val( pos );
				return;
			}
			var tmpVal = val.toString();
			if( mod === 0 )
			{
				if( tmpVal.indexOf( "." ) === -1 )
				{
					$( this ).val( tmpVal + ".5" );
				}
				else
				{
					$( this ).val( tmpVal.split( "." )[ 0 ] + ".5" );
				}
			}
			else
			{
				if( tmpVal.indexOf( "." ) > -1 )
				{
					$( this ).val( tmpVal.split( "." )[ 0 ] );
				}
			}
		} );
	},
	
	_initMotifViewDialog : function() {
		var self = this;
		$( "#" + self._motifViewDialogId).dialog( {
			autoOpen: false,
			title: self._default.motifViewDialogTitle,
			width: 520,
			dialogClass : self._options.motifViewDialogClass,
			buttons : [
				{
					text: "Replace",
					click : function() {
						var seq = $( "#" + self._motifViewDialogId ).find( ".sequence" ).val();
						var pos = $( "#" + self._motifViewDialogId ).find( ".position" ).val();
						var extraCopies = parseInt( $( "#" + self._motifViewDialogId ).find( ".extraCopies" ).val(), 10 );
						var basePairs = parseInt( $( "#" + self._motifViewDialogId ).find( ".basePairs" ).val(), 10 );
						var minPos = parseFloat( $( "#" + self._motifViewDialogId ).find( ".minSeq" ).html(), 10 );
						var maxPos = parseFloat( $( "#" + self._motifViewDialogId ).find( ".maxSeq" ).html(), 10 );
						if( minPos > pos || maxPos < pos ) {
							$dialogError = $( "#" + self._motifViewDialogId + " ." + self._options.dialogErrorMessageClass );
							$dialogError.html( self._options.dialogOutRangeValueMessage.replace( "{0}", minPos ).replace( "{1}", maxPos ) );
							$dialogError.show();
							return;
						}
						self._appSequence.hideError();
						self._replaceWithSequence( seq, pos, extraCopies, basePairs );
						$(this).dialog( "close" );
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog( "close" );
					}
				}
			]
		} );
	},
	
	//要約ファイル(処理速度向上のために発現量が上位あるいは下位の遺伝子をリストアップしたファイル)がない場合に発現を最大にするモチーフを取り出す
	_getMotifTripleRanking : function( workId, fileName, property, order ) {
		var self = this;
		// まずは8000件を読み込む
		var index = new Application.index(1, 8000);
		var totalList = [];
		var getTriplesByProperty = function( tripleList ) {
			// 新たに読み込んだtripleの配列を連結
			totalList = totalList.concat( tripleList );
			// まだ続きがあれば次の8000件を読み込む
			if( tripleList && tripleList.length === index.getItemCount() ) {
				//再帰的に繰り返し。
				LinkData.getTriplesByProperty( workId, fileName, property, getTriplesByProperty, index.increment() );
			}
			else
			{
				var i;
				var subjects = [];
				var len = totalList.length;
				var cnt = 0;
				// 順序を切り替えるための係数
				var sign = ( order === self._options.topValue ) ? 1 : -1;
				// 発現量でソート
				totalList.sort( function( a, b ) { return (b.object - a.object) * sign; } );
				// 所定の個数のsubjectが集まるか、全subjectを読み切るまでループ
				for( i = 0; i < len && cnt < self._options.rankingRange; i++ )
				{
					// 重複のチェック
					var j;
					for( j = 0; j < cnt; j++ )
					{
						if( totalList[ i ].subject === subjects[ j ] )
						{
							break;
						}
					}
					// 重複がなければランキングに追加
					if( j === cnt )
					{
						subjects[ cnt++ ] = totalList[ i ].subject;
					}
				}
				self._showRanking( subjects );
			}
		};
		
		//データベースからtriplesを読み込み、getTriplesByPropertyにそれを渡す。
		LinkData.getTriplesByProperty( workId, fileName, property, getTriplesByProperty, index.getIndex() );
	},
	
	//発現ランキングの生成
	_showRanking : function( subjects ) {
		var self = this;
		var $select = $( "#" + self._containerId + " ." + self._options.selectRankingClass );
		$( "option", $select ).remove();
		$select.append( "<option value='-1'>-- Select Gene --</option>" );
		$.each( subjects, function( tKey, tValue ) {
			var gene = self._motifProperty.getGeneBySubject( tValue );
			$select.append( "<option value='" + tValue + "'>" + ( tKey + 1 ) + ":" + gene + "</option>" );
		} );
		$( "#" + self._containerId + " ." + self._options.loadingImageContainer ).hide();
		$( "#" + self._containerId + " ." + self._options.selectRankingAreaClass ).show();
	},
	
	// 下記関数内で要約ファイルがある場合とない場合に分岐
	_showMotifSequence : function( workId, fileName, propLabel, order ) {
		var self = this, foundAbstractFile = false;
		var getFilesByTag = function( resultList ) {
			$.each( resultList, function( wId, fileList ) {
				$.each( fileList, function( fileKey, fName ) {
					var tmpName;
					// 要約ファイルの有無の判定の準備
					if( order === self._options.topValue )
					{
						tmpName = fName.split( "_top" );
					}
					else
					{
						tmpName = fName.split( "_bottom" );
					}
					
					if(fileName.indexOf( tmpName[ 0 ] ) > -1 )
					{
						// 要約ファイルが存在する場合
						self._getAbstractFilePropertyList( workId, fileName, wId, fName, propLabel );
						foundAbstractFile = true;
						return false;
					}
				} );
			} );
			if( !foundAbstractFile )
			{
				// 要約ファイルが存在しない場合
				var property = self._motifProperty.getPropertyByLabel( propLabel );
				self._getMotifTripleRanking( workId, fileName, property, order );
			}
		};
		LinkData.getFilesByTag( null, self._tag.topResult, getFilesByTag );
	},
	
	_getAbstractFilePropertyList : function( workId, fileName, topWorkId, topFileName, propLabel ) {
		var self = this;
		var getProperties = function( propList ) {
			$.each(propList, function( propKey, propValue ) {
				var tmpProperty = self._motifProperty._getLabel( propValue );
				if( tmpProperty.indexOf( propLabel ) > -1 )
				{
					var property = self._motifProperty.getPropertyByLabel( propLabel );
					self._showMotif( workId, fileName, property, topWorkId, topFileName, propValue );
					return false;
				}
			} );
		};
		LinkData.getProperties( topWorkId, topFileName, getProperties );
	},
	
	_showMotif : function( workId, fileName, property, topWorkId, topFileName, topProperty ) {
		var self = this;
		var index = new Application.index( 1, 1000 );
		var getTriplesByProperty = function( tripleList ) {
			self._showMotifByTripleList( workId, fileName, property, tripleList );
		};
		LinkData.getTriplesByProperty( topWorkId, topFileName, topProperty, getTriplesByProperty, index.getIndex() );
	},

	_showMotifByTripleList : function( workId, fileName, property, tripleList ) {
		var self = this, i = 0, subject = tripleList [ i ].object;
		var cnt = 0;
		var subjects = [];
		var posProperty = self._motifProperty.getPropertyByLabel( self._options.motifPositionProperty );
		var showMotif = function( posTripleList ) {
			var found = false;
			i++;
			$.each( posTripleList, function( pKey, pValue ) {
				var tmpPos = parseInt( pValue, 10 );
				// モチーフの位置がベース配列の範囲内に収まっていれば
				if( self._options.baseSequenceMinLength < tmpPos && self._options.baseSequence.length >= tmpPos )
				{
					// 発見のフラグを立てる。
					found = true;
					return false;
				}
			} );
			if( found )
			{
				var j;
				// 適合するモチーフをランキングのための配列に追加
				for( j = 0; j < cnt; j++ )
				{
					if( subject === subjects[ j ] )
					{
						break;
					}
				}
				if( j === cnt )
				{
					subjects[ cnt++ ] = subject;
				}
			}
			
			if( cnt < self._options.rankingRange )
			{
				// 次のtripleへ。
				subject = tripleList[ i ].object;
				LinkData.getObjects( workId, fileName, subject, posProperty, showMotif );
			}
			else
			{
				// 規定数の遺伝子が集まった場合はランキング生成へ
				self._showRanking( subjects );
			}
		};
		LinkData.getObjects( workId, fileName, subject, posProperty, showMotif );
	},
	
	_getDataBaseWebsiteName : function() {
		var self = this;
		var fileName = self._options.fileName;
		var rtnVal;
		if( fileName.indexOf( self._options.websiteNameAtted ) > -1 )
		{
			rtnVal = self._options.websiteNameAtted;
		}
		else if( fileName.indexOf( self._options.websiteNamePpdb ) > -1 )
		{
			rtnVal = self._options.websiteNamePpdb;
		}
		else
		{
			rtnVal = "UNKNOWN";
		}
		return rtnVal;
	},
	
	_motifSequence : function( workId, fileName, subject, property ) {
		var self = this;
		var drawSequence = function( seqHtml ) {
			var sb = [];
			sb[sb.length] = "<input type='hidden' class='" + self._default.geneLabelClass + "' value='" + subject + "'/>";
			sb[sb.length] = "<div class='baseSequence'>" + self._baseSequence + "</div>";
			sb[sb.length] = seqHtml;
			$( "#" + self._containerId + " ." + self._options.resultAreaClass ).html( sb.join( "" ) );
			if( seqHtml.length === 0 )
			{
				$( "#" + self._containerId + " ." + self._options.replaceButtonAreaClass ).hide();
			}
			self._initMotifSequenceListener();
			self._initReplaceButtonLitener();
			self._showDataBaseInformationList();
			self._showGenePlot( subject, property );
			$( "#" + self._containerId + " ." + self._options.resultAreaClass ).show();
			$( "#" + self._containerId + " ." + self._options.replaceButtonAreaClass ).show();
			$( "#" + self._containerId + " ." + self._options.loadingImageContainer ).hide();
		};
		self._appSequence.getSequenceHtml( subject, drawSequence );
	},
	
	_getMinPosition : function( seq ) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = ( mod === 1 ) ? 1 : 0.5;
		return self._default.baseSequenceMinLength + Math.floor( seq.length / 2 ) + tHold;
	},
	
	_getMaxPosition : function( seq ) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod === 1) ? 0 : 0.5;
		return self._baseSequence.length - 1 - Math.floor( seq.length / 2 ) + tHold;
	},
	
	_getSeqElBySeq : function( seq ) {
		var rtnVal;
		if( seq && seq.trim().length === 7 )
		{
			rtnVal = this._heptamer.getBySequence( seq );
		}
		else if( seq && seq.trim().length === 8 )
		{
			rtnVal = this._octamer.getBySequence( seq );
		}
		return rtnVal;
	},
	
	_showDatabaseInfo : function( seqVal )
	{
		var self = this, fileName = self._options.fileName, appName = self._options.appName;
		var propLabel = $( "option:selected", "#" + self._containerId + " ." + self._options.selectPropertyClass ).val();
		var subject = $( "#" + self._containerId + " ." + self._options.geneLabelClass ).val();
		// TopかBottomか。
		var order = $( "#" + self._containerId + " [name=" + self._options.selectOrderName + "]:checked" ).val();
		// コンボボックスの何個目か = 順位
		var rank = $( "#" + self._containerId + " ." + self._options.selectRankingClass ).find( "option:selected" ).index();
		var label = self._motifProperty._getDisplayLabel( propLabel );
		label = ( label && label.trim().length !== 0 ) ? label : propLabel;
		var usedMotif = ( seqVal.length !== 0 ) ? seqVal : "-";
		var dbInfoHtml = self._getDatabaseInfo( fileName, appName, subject, label, usedMotif, order, rank );
		$( "#" + self._containerId + " ." + self._options.databaseInfoClass ).html( dbInfoHtml );
		$( "#" + self._containerId + " ." + self._options.databaseInfoClass ).show();
		self._genePreviewListener(subject);
	},
	
	_genePreviewListener : function( subject ) {
		var self = this;
		$( "#" + self._containerId + " ." + self._options.geneInfoLinkClass ).click( function() {
			self._showPopupWindow( subject );
		} );
	},
	
	_getDatabaseInfo : function( fileName, method, subject, property, motif, order, rank ) {
		var self = this;
		var gene = self._motifProperty.getGeneBySubject( subject );
		var sb = [];
		sb[ sb.length ] = "<div class='row'>";
		sb[ sb.length ] = "<div class='label left'>Database</div>";
		sb[ sb.length ] = "<div class='left'>" + fileName + "</div>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div class='row'>";
		sb[ sb.length ] = "<div class='label left'>Application</div>";
		sb[ sb.length ] = "<div class='left'>" + method + "</div>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div class='row'>";
		sb[ sb.length ] = "<div class='label left'>Rank </div>";
		sb[ sb.length ] = "<div class='left'>" + ( ( order === self._options.topValue ) ? "Top" : "Bottom" ) + "&nbsp;" + rank + "</div>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div class='row'>";
		sb[ sb.length ] = "<div class='label left'>Gene Locus</div>";
		sb[ sb.length ] = "<div class='left'>";
		sb[ sb.length ] = "<a href='javascript:void(0);' class='" + self._options.geneInfoLinkClass + "'>" + gene + "</a>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div class='row'>";
		sb[ sb.length ] = "<div class='label left'>Property</div>";
		sb[ sb.length ] = "<div class='left'>" + property + "</div>";
		sb[ sb.length ] = "</div>";
		sb[ sb.length ] = "<div class='row'>";
		sb[ sb.length ] = "<div class='label left'>Motif</div>";
		sb[ sb.length ] = "<div class='left motif'>" + motif + "</div>";
		sb[ sb.length ] = "</div>";
		return sb.join( "" );
	},
	
	_replaceWithSequence : function( seq, pos, extraCopies, basePairs ) {
		var self = this;
		var html = self._appSequence.replaceWith( seq, pos, extraCopies, basePairs );
		$( "#" + self._containerId + " ." + self._options.replaceSequenceClass ).html( html );
		$( "#" + self._containerId + " ." + self._options.replaceSequenceClass ).show();
		var seqLabel = seq + "[" + pos + "]";
		self._showDatabaseInfo( seqLabel );
		self._options.callback();
	}
	
};

Application.geneChart = function() {
	this._init.apply( this, arguments );
};

Application.geneChart.prototype = {
	
	_containerId : null,
	_options : null,
	_workId : null,
	_fileName : null,
	_subject : null,
	_property : null,
	_highChartContainerId : null,
	_appProperty : null,
	
	_default : {
		filterNamespace : "http://linkdata.org/",
		acceptPropLabelPrefix : "label:"
	},
	
	_init : function( containerId, options ) {
		this._containerId = containerId;
		this._options = $.extend( {}, this._default, options );
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		this._subject = this._options.subject;
		this._property = this._options.property;
		var date = new Date();
		this._highChartContainerId = "gene_chart_" + date.getTime();
		this._initAppProperty( this._options );
		this._initView();
		this._drawHighChart( this._subject, this._property );
	},
	
	_initAppProperty : function( opts ) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._appProperty = new Application.motifProperty( obj );
	},
	
	_initView : function() {
		var self = this;
		var sb = [];
		sb[ sb.length ] = "<div id='" + self._highChartContainerId + "'></div>";
		$( "#" + self._containerId ).html( sb.join( "" ) );
	},
	
	_ignore : function( label ) {
		var self = this;
		if( label.indexOf( self._default.acceptPropLabelPrefix ) > -1 )
		{
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function( value ) {
		var self = this;
		var propLabel = value;
		var arr = value.split( self._default.acceptPropLabelPrefix );
		if( arr.length > 1 )
		{
			propLabel = decodeURIComponent( arr[  1] );
		}
		return propLabel;
	},
	
	_drawHighChart : function( subject, highlightProperty ) {
		var self = this;
		var getDataArray = function( tripleList ) {
			var dataArray = [];
			var dataObject = {};
			var array = [];
			var duplicateProperty = [];
			$.each (tripleList, function( tKey, tValue ) {
				var property = tValue.property;
				if( property.indexOf( self._options.filterNamespace ) === -1 )
				{
					return;
				}
				if( $.inArray( property, duplicateProperty ) > -1 )
				{
					return;
				}
				var label = self._getLabelAfterHash( property );
				if( !self._ignore( label ) )
				{
					var val = parseFloat( tValue.object );
					if( highlightProperty === property )
					{
						val = self._getHighLightColumn( parseFloat( tValue.object ) );
					}
					array.push( val );
					duplicateProperty.push( property );
				}
			} );
			dataObject.name = self._getLabel( subject );
			dataObject.data = array;
			dataArray.push( dataObject );
			self._getXCategory( tripleList, dataArray, highlightProperty );
		};
		LinkData.getTriplesBySubject( self._workId, self._fileName, subject, getDataArray );
	},
	
	_getXCategory : function( tripleList, dataArray, highlightProperty ) {
		var self = this;
		var array = [];
		var duplicateProperty = [];
		var hLabel = self._getLabelAfterHash( highlightProperty );
		$.each ( tripleList, function( tKey, tValue ) {
			var property = tValue.property;
			if( property.indexOf( self._options.filterNamespace ) === -1 )
			{
				return;
			}
			if( $.inArray( property, duplicateProperty ) > -1 )
			{
				return;
			}
			var label = self._getLabelAfterHash( property );
			if( !self._ignore( label ) )
			{
				var displayLabel = self._getDisplayLabel( label );
				var hDisplayLabel = self._getDisplayLabel( hLabel );
				if( displayLabel === hDisplayLabel )
				{
					displayLabel = "<span style=\"color:#FB3B44\">" + hDisplayLabel + "</span>";
				}
				array.push( displayLabel );
				duplicateProperty.push( property );
			}
		} );
		self._drawChart( self._highChartContainerId, dataArray, array );
	},
	
	_getHighLightColumn : function( val ) {
		var obj = {};
		obj.y = val;
		obj.marker = {
			lineWidth: 3,
			lineColor: "#FB3B44",
			fillColor: "#FB3B44"
		};
		return obj;
	},
	
	_drawChart : function( containerId, dataArray, xCategory ) {
		var self = this;
		var chart = new Highcharts.Chart( {
			chart: {
				renderTo: containerId,
				type: 'line',
				marginRight: 130,
				marginBottom: 125
			},
			title: {
				text: self._fileName
			},
			xAxis: {
				categories: xCategory,
				labels : {
					rotation: 315
				}
			},
			tooltip: {
				formatter: function() {
					return '<b>'+ this.series.name + '</b><br/>' + this.x + ' [' + this.y + ']';
				}
			},
			legend: {
				layout: 'vertical',
				align: 'right',
				verticalAlign: 'top',
				x: -10,
				y: 100,
				borderWidth: 0
			},
			series: dataArray
		} );
	},
	
	_getLabel : function( value ) {
		var self = this, label;
		if( value.indexOf( "#" ) > -1 )
		{
			label = self._getLabelAfterHash( value );
		}
		else
		{
			label = self._appProperty.getGeneBySubject( value );
		}
		if( !label )
		{
			label = value;
		}
		return label;
	},
	
	_getPropertyLabel : function( value ) {
		var propLabel = value;
		var arr = value.split( "#" );
		if( arr.length > 1 )
		{
			propLabel = decodeURIComponent( arr[ 1 ] );
			propLabel = this._appProperty.getPropertyNameByLabel( propLabel );
		}
		return propLabel;
	},
	
	_getLabelAfterHash : function( value ) {
		var propLabel = value;
		var arr = value.split( "#" );
		if( arr.length > 1 )
		{
			propLabel = decodeURIComponent( arr[ 1 ] );
		}
		return propLabel;
	}
	
};

Application.motifProperty = function() {
	this._init.apply( this, arguments );
};

Application.motifProperty.prototype = {

	_options : null,
	_propMap : null,
	_nameMap : null,
	_optionArray : null,
	
	_default : {
		acceptPropLabelPrefix : "label:",
		subjectATTEDUriPhrase : "http://atted.jp/data/locus/",
		subjectPPDBUriPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene="
	},
	
	_init : function( options ) {
		this._options = $.extend( {}, this._default, options );
		this._propMap = [];
		this._nameMap = [];
		this._initPropMap( this._options );
	},
	
	_initPropMap : function( opts ) {
		var self = this, workId = opts.workId, fileName = opts.fileName;
		var method = function( properties ) {
			self._fillPropMap( self, properties );
			self._initOptionArray( properties );
		};
		LinkData.getProperties( workId, fileName, method );
	},
	
	_fillPropMap : function( self, properties ) {
		$.each( properties, function( key, value ) {
			var label = self._getLabel( value );
			if( !self._propMap[ label ] )
			{
				self._propMap[ label ] = value;
			}
		} );
	},
	
	_initOptionArray : function( propertyList ) {
		var self = this, list = {};
		var workId = self._options.workId, fileName = self._options.fileName;
		self._optionArray = [];
		$.each(propertyList, function( key, value ) {
			var propLabel = self._getLabel( value );
			if( !self._ignore( propLabel ) )
			{
				var obj = {};
				obj.key = propLabel;
				obj.value = self._getDisplayLabel( propLabel );
				self._optionArray.push( obj );
			}
		} );
	},
	
	_ignore : function (label ) {
		var self = this;
		if( label.indexOf( self._default.acceptPropLabelPrefix ) > -1 )
		{
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function( value ) {
		var self = this;
		var propLabel = value;
		var arr = value.split( self._default.acceptPropLabelPrefix );
		if( arr.length > 1 )
		{
			propLabel = decodeURIComponent( arr[ 1 ] );
		}
		return propLabel;
	},
	
	_getLabel : function( value ) {
		var propLabel = value;
		var arr = value.split( "#" );
		if( arr.length > 1 )
		{
			propLabel = decodeURIComponent( arr[ 1 ] );
		}
		return propLabel;
	},

	getOptionArray : function() {
		return this._optionArray;
	},
	
	getPropertyByLabel : function( label ) {
		return this._propMap[ label ];
	},
	
	getGeneBySubject : function( subject ) {
		var self = this, htmlExt = ".html", geneLabel;
		if( subject.indexOf( self._default.subjectATTEDUriPhrase ) > -1 )
		{
			geneLabel = subject.replace( self._default.subjectATTEDUriPhrase, "" );
		}
		else if( subject.indexOf( self._default.subjectPPDBUriPhrase ) > -1 )
		{
			geneLabel = subject.replace( self._default.subjectPPDBUriPhrase, "" );
		}
		if( geneLabel && geneLabel.indexOf( htmlExt ) > -1 )
		{
			geneLabel = geneLabel.replace( htmlExt, "" );
		}
		return geneLabel;
	}
	
};

Application.sequence = function() {
	this._init.apply( this, arguments );
};

Application.sequence.prototype = {
	
	CHAR_SEQ_EMPTY : "-",
	
	_options : null,
	_workId : null,
	_fileName : null,
	_seqProperty : null,
	_posProperty : null,
	_baseSequence : null,
	_sequenceList : null,
	_positionList : null,
	_containerId : null,
	_errorContainerClass : null,
	_outOfRangeArray : null,
	
	_default : {
		msgInvalidSequence: "invalid sequence.",
		msgOutOfRangeSequence: "out of range sequence : {0}"
	},
	
	_init : function( options ) {
		this._options = options;
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		this._seqProperty = this._options.motifSequenceProperty;
		this._posProperty = this._options.motifPositionProperty;
		this._baseSequence = this._options.baseSequence;
		this._containerId = this._options.containerId;
		this._errorContainerClass = this._options.errorMessageClass;
	},
	
	_getCustomSequenceHtml : function( baseSequence, sequence, position ) {
		var i;
		var seqLen = sequence.length;
		var tHold = Math.floor( seqLen / 2 ) + 1;
		var pos = parseInt( position, 10 );
		var baseSeqLen = baseSequence.length;
		var suffixLen = baseSeqLen - tHold - pos;
		var sb = [];
		if( pos > this._options.baseSequenceMinLength && suffixLen > 0) {
			for( i = 0; i < suffixLen; i++ )
			{
				sb.push( this.CHAR_SEQ_EMPTY );
			}
			sb.push( "<a href='javascript:void(0)' class='motifSequence'>" + sequence + "</a>" );
			sb.push( "<input type='hidden' class='hdnSequence' value='" + sequence + "'/>" );
			sb.push( "<input type='hidden' class='hdnPosition' value='" + pos + "'/>" );
		}
		else
		{
			//_showError($appContainer, opts.msgOutOfRangeSequence.replace( "{0}", sequence ) );
			this._outOfRangeArray.push( sequence + "[" + pos + "]" );
			this._showError( this._default.msgOutOfRangeSequence.replace( "{0}", this._outOfRangeArray.join( ", " ) ) );
		}
		return sb.join( "" );
	},
	
	_isValidSequenceList : function( seqs ) {
		var i;
		var count = seqs.length;
		var maxlength = 0;
		for( i = 0; i < count; i++ )
		{
			if( seqs[ i ].length > maxlength )
			{
				maxlength = seqs[ i ].length;
			}
		}
		var result = true;
		for( i = 0; i < maxlength; i++ )
		{
			var j;
			var chars = [];
			for( j = 0; j < count; j++ )
			{
				chars.push( seqs[ j ].charAt( i ) );
			}
			if( !this._isValidChars( chars.join( "" ) ) )
			{
				result = false;
				break;
			}
		}
		return result;
	},
	
	_isValidChars : function( charString ) {
		var i;
		var charLen = charString.length;
		var result = true;
		var first = null;
		for( i = 0; i < charLen; i++)
		{
			if( charString.charAt( i ) !== this.CHAR_SEQ_EMPTY )
			{
				if( !first )
				{
					first = charString.charAt( i );
				}
				var current = charString.charAt( i );
				if( current && first !== current )
				{
					result = false;
					break;
				}
			}
		}
		return result;
	},
	
	_getReplacedCustomSequence : function( seqs ) {
		var i;
		var mergeSequence = this._getmergeCharSequence( seqs );
		var maxlength = this._baseSequence.length;
		var sb = [];
		for( i = 0; i < maxlength; i++ )
		{
			var bChar = this._baseSequence.charAt( i );
			var mChar = mergeSequence.charAt( i );
			if( mChar !== this.CHAR_SEQ_EMPTY )
			{
				// replaced
				sb.push( mChar );
			}
			else
			{
				sb.push( bChar );
			}
		}
		
		return sb.join( "" );
	},
	
	_getmergeCharSequence : function( seqs ) {
		var i;
		var count = seqs.length;
		var maxlength = this._baseSequence.length;
		var sb = [];
		for( i = 0; i < maxlength; i++ )
		{
			var j;
			var chars = [];
			for( j = 0; j < count; j++ )
			{
				chars.push( seqs[ j ].charAt( i ) || this.CHAR_SEQ_EMPTY );
			}
			sb.push( this._getMergeChar( chars.join( "" ) ) );
		}
		return sb.join( "" );
	},
	
	_getMergeChar : function( charString ) {
		var i;
		var charLen = charString.length;
		var result = null;
		for( i = 0; i < charLen; i++ )
		{
			if( charString.charAt( i ) !== this.CHAR_SEQ_EMPTY )
			{
				result = charString.charAt( i );
				break;
			}
		}
		if( !result )
		{
			result = this.CHAR_SEQ_EMPTY;
		}
		return result;
	},
	
	_wrappedReplacedSequenceHtml : function( replaceSequence, seqs ) {
		var i;
		var mergeSequence = this._getmergeCharSequence( seqs );
		var length = this._baseSequence.length;
		var sb = [];
		for( i = 0; i < length; i++ )
		{
			var bChar = this._baseSequence.charAt( i );
			var rChar = replaceSequence.charAt( i );
			var mChar = mergeSequence.charAt( i );
			var seqChar = ( bChar !== rChar ) ? "<span class='replace'>" + rChar + "</span>" : rChar;
			if( mChar !== this.CHAR_SEQ_EMPTY )
			{
				sb.push( "<span class='highlight-sequence'>" + seqChar + "</span>" );
			}
			else
			{
				sb.push( seqChar );
			}
		}
		return sb.join( "" );
	},
	
	_showError : function( message ) {
		$errorMessageContainer = $( "#" + this._containerId + " ." + this._errorContainerClass );
		$errorMessageContainer.html( message );
		$errorMessageContainer.show();
	},
	
	getSequenceHtml : function( subject, drawSequence ) {
		var self = this;
		self._outOfRangeArray = [];
		var sb = [], baseSequence = self._baseSequence;
		var getTriplesBySequenceProperty = function( sequenceList ) {
			self._getTriplesBySequenceProperty( subject, drawSequence, sequenceList );
		};
		LinkData.getObjects( self._workId, self._fileName, subject, self._seqProperty, getTriplesBySequenceProperty );
	},
	
	_getTriplesBySequenceProperty : function( subject, drawSequence, sequenceList ) {
		var self = this;
		var getTriplesByPositionProperty = function( positionList ) {
			self._drawSequenceList( drawSequence, sequenceList, positionList );
		};
		LinkData.getObjects( self._workId, self._fileName, subject, self._posProperty, getTriplesByPositionProperty );
	},
	
	_drawSequenceList : function( drawSequence, sequenceList, positionList ) {
		var i;
		var self = this, sb = [];
		if( !sequenceList || sequenceList.length === 0) {
			return;
		}
		for( i = 0; i < sequenceList.length; i++ ) {
			var customSeqString = self._getCustomSequenceHtml( self._baseSequence, sequenceList[ i ], positionList[ i ] );
			if( customSeqString.length > 0 )
			{
				sb.push( "<div class='userSequence'>" + customSeqString + "</div>" );
			}
		}
		drawSequence( sb.join( "\n" ) );
	},
	
	replace : function( seqs ) {
		var isValid = this._isValidSequenceList( seqs );
		if( isValid )
		{
			if( seqs.length > 0 )
			{
				var replaceSeq = this._getReplacedCustomSequence( seqs );
				var replaceSeqHtml = this._wrappedReplacedSequenceHtml( replaceSeq, seqs );
				return replaceSeqHtml;
			}
		}
		else
		{
			this._showError( this._default.msgInvalidSequence );
		}
	},
	
	replaceWith : function( seq, pos, extraCopies, basePairs ) {
		var j;
		var main = [];
		var seqLen = seq.length;
		var tHold = Math.floor( seqLen / 2 ) + 1;
		pos = parseInt( pos, 10 );
		var baseSeqLen = this._baseSequence.length;
		var len = baseSeqLen - tHold - pos;
		for( j = 0; j < extraCopies + 1; j++ )
		{
			var i;
			var array = [];
			for( i = 0; i < len; i++ )
			{
				array.push( this.CHAR_SEQ_EMPTY );
			}
			array.push( seq );
			main.push( array.join( "" ) );
			len = len - seqLen - basePairs;
			if( len < 0 )
			{
				break;
			}
		}
		return this.replace( main );
	},
	
	hideError : function() {
		$errorMessageContainer = $( "#" + this._containerId + " ." + this._errorContainerClass ).hide();
	}
	
};

Application.heptamer = function() {
	this._init.apply( this, arguments );
};

Application.heptamer.prototype = {
	
	_heptamerMap : null,
	_motifSequenceProperty : null,
	_appropriatePositionProperty : null,
	
	_default : {
		heptamerTag : "heptamer",
		filterSequencePropertyPhrase : "motif_sequence",
		filterMaxCEGPropertyPhrase : "maxCEG",
		filterAppropriatePosition : "Appropriateposition(%C2%B1%2040%20bp)"
	},
	
	_init : function() {
		this._heptamerMap = [];
		this._initHeptamerList();
	},
	
	_initHeptamerList : function() {
		var self = this;
		var getFilesByTag = function( result ) {
			$.each(result, function( workId, fileList ) {
				$.each(fileList, function( fileKey, fileName ) {
					self._initHeptamer( workId, fileName );
					return false;
				} );
			} );
		};
		LinkData.getFilesByTag( null, self._default.heptamerTag, getFilesByTag );
	},
	
	_initHeptamer : function( workId, fileName ) {
		var self = this;
		var getPropertyList = function( propertyList ) {
			self._initProperty( propertyList );
			self._getSequenceTriple( workId, fileName );
		};
		LinkData.getProperties( workId, fileName, getPropertyList );
	},
	
	_initProperty : function( propertyList ) {
		var self = this;
		$.each(propertyList, function( propKey, propValue ) {
			if( propValue.indexOf(self._default.filterSequencePropertyPhrase) > -1 )
			{
				self._motifSequenceProperty = propValue;
			}
			else if( propValue.indexOf( self._default.filterAppropriatePosition ) > -1 )
			{
				self._appropriatePositionProperty = propValue;
			}
		} );
	},
	
	_getSequenceTriple : function( workId, fileName ) {
		var self = this;
		var getSequenceTripleList = function( sequenceTripleList ) {
			self._fillHeptamerMap( workId, fileName, sequenceTripleList );
		};
		LinkData.getTriplesByProperty( workId, fileName, self._motifSequenceProperty, getSequenceTripleList );
	},
	
	_fillHeptamerMap : function( workId, fileName, sequenceTripleList ) {
		var i;
		var self = this;
		var getPositionTripleList = function( positionTripleList ) {
			for( i = 0; i < sequenceTripleList.length; i++ )
			{
				var seqTriple = sequenceTripleList[ i ];
				var posTriple = positionTripleList[ i ];
				var seqEl = new Application.seqElement();
				seqEl.setExternalUrl( seqTriple.subject );
				seqEl.setSequence( seqTriple.object );
				seqEl.setAppropriatePos( posTriple.object );
				self._heptamerMap[ seqTriple.object ] = seqEl;
			}
		};
		LinkData.getTriplesByProperty( workId, fileName, self._appropriatePositionProperty, getPositionTripleList );
	},
	
	getBySequence : function( sequence ) {
		return this._heptamerMap[ sequence ];
	}
	
};

Application.octamer = function() {
	this._init.apply( this, arguments );
};

Application.octamer.prototype = {
	
	_octamerMap : null,
	_motifSequenceProperty : null,
	_appropriatePositionProperty : null,
	
	_default : {
		octamerTag : "octamer",
		filterSequencePropertyPhrase : "sequence",
		filterAppropriatePosition : "Appropriate%20position"
	},
	
	_init : function() {
		this._octamerMap = [];
		this._initOctamerList();
	},
	
	_initOctamerList : function() {
		var self = this;
		var getFilesByTag = function( result ) {
			$.each( result, function( workId, fileList ) {
				$.each(fileList, function( fileKey, fileName ) {
					self._initOctamer( workId, fileName );
					return false;
				} );
			} );
		};
		LinkData.getFilesByTag( null, self._default.octamerTag, getFilesByTag );
	},
	
	_initOctamer : function( workId, fileName ) {
		var self = this;
		var getProperties = function( propertyList ) {
			self._initProperty( propertyList );
			self._getSequenceTriple( workId, fileName );
		};
		LinkData.getProperties( workId, fileName, getProperties );
	},
	
	_initProperty : function( propertyList ) {
		var self = this;
		$.each( propertyList, function( propKey, propValue) {
			if( propValue.indexOf( self._default.filterSequencePropertyPhrase ) > -1 )
			{
				self._motifSequenceProperty = propValue;
			}
			else if( propValue.indexOf( self._default.filterAppropriatePosition ) > -1 )
			{
				self._appropriatePositionProperty = propValue;
			}
		} );
	},
	
	_getSequenceTriple : function( workId, fileName ) {
		var self = this;
		var getSequenceTripleList = function( sequenceTripleList ) {
			self._fillOctamerMap( workId, fileName, sequenceTripleList );
		};
		LinkData.getTriplesByProperty( workId, fileName, self._motifSequenceProperty, getSequenceTripleList );
	},
	
	_fillOctamerMap : function( workId, fileName, sequenceTripleList ) {
		var i;
		var self = this;
		var getPositionTripleList = function( positionTripleList ) {
			for( i = 0; i < sequenceTripleList.length; i++ )
			{
				var j = Math.floor( i / 2 );
				var seqTriple = sequenceTripleList[ i ];
				var posTriple = positionTripleList[ j ];
				var seqEl = new Application.seqElement();
				seqEl.setExternalUrl( seqTriple.subject );
				seqEl.setSequence( seqTriple.object );
				seqEl.setAppropriatePos( posTriple.object );
				self._octamerMap[ seqTriple.object ] = seqEl;
			}
		};
		LinkData.getTriplesByProperty( workId, fileName, self._appropriatePositionProperty, getPositionTripleList );
	},
	
	getBySequence : function( sequence ) {
		return this._octamerMap[ sequence ];
	}
	
};

Application.seqElement = function() {
	this._init.apply( this, arguments );
};

Application.seqElement.prototype = {
	
	_externalUrl : null,
	_sequence : null,
	_appropriatePos : null,
	
	_init : function() {},
	
	getExternalUrl : function() {
		return this._externalUrl;
	},

	setExternalUrl : function( externalUrl ) {
		this._externalUrl = externalUrl;
	},
	
	getSequence : function() {
		return this._sequence;
	},
	
	setSequence : function( sequence ) {
		this._sequence = sequence;
	},
	
	getAppropriatePos : function() {
		return this._appropriatePos;
	},
	
	setAppropriatePos : function( appropriatePos ) {
		this._appropriatePos = appropriatePos;
	}
	
};

Application.timer = function() {
	this._init.apply( this, arguments );
};

Application.timer.prototype = {
	
	_delay : null,
	_retry : null,
	_maxRetry : null,
	
	_init : function() {
		this._delay = 1000;
		this._retry = 0;
		this._maxRetry = 100;
	},
	
	call : function( func ) {
		if( this._retry < this._maxRetry )
		{
			setTimeout( func, this._delay );
		}
		this._retry++;
	}
};

Application.index = function() {
	this._init.apply( this, arguments );
};

Application.index.prototype = {
	
	_start : null,
	_end : null,
	
	_init : function( start, end ) {
		this._start = start;
		this._end = end;
	},
	
	getIndex : function() {
		return { start : this._start, end : this._end };
	},
	
	getItemCount : function() {
		return ( this._end - this._start + 1 );
	},
	
	increment : function() {
		var itemCount = this.getItemCount();
		this._start = this._start + itemCount;
		this._end = this._end + itemCount;
		return { start : this._start, end : this._end };
	},
	
	getStartIndex : function() {
		return this._start;
	},
	
	getEndIndex : function() {
		return this._end;
	}
	
};

$(document).ready(function() {
	var fillDatabase = function( resultList ) {
		$( ".motifRankingDatabase" ).append( "<option value='-1' selected='selected'>-- Select Database --</option>" );
		$.each( resultList, function( workId, fileList ) {
			$.each( fileList, function( fileKey, fileName ) {
				$( ".motifRankingDatabase" ).append( "<option value='" + workId + "|" + fileName + "'>" + fileName + "</option>" );
			} );
		 } );
		$( ".motifRankingDatabase " ).change( function() {
			var dbKey = $( "option:selected", $( this ) ).val();
			if( dbKey === -1 ) {
				$( "#container" ).html( "" );
				return;
			}
			var array = dbKey.split( "|" );
			var containerId = "container";
			var options = {
				workId : array[ 0 ],
				fileName : array[ 1 ],
				baseSequence : "GAAAAAAGACGTTCCAACCACGTCTTCAAAGCAAGTGATTGGATTAAGGTTCTTCCACACGGTAAGGGATGGCACTAACACCTACCATCCTTCGCAAGACCCTTCCTCTATATAAGGAAGTTCATTTCATTTGGAGAGGACCTCGAC"
			};
			var app = new Application.motifRanking( containerId, options );
		} );
	};
	LinkData.getFilesByTag( null, "database", fillDatabase );
} );
