if(typeof Application==="undefined"||!Application){var Application= {};}

Application.lc = function() {
	this._init.apply(this, arguments);
}

Application.lc.prototype = {
	
	_data : null,
	_options : null,
	_mainArray : null,
	
	_init : function() {
		this._mainArray = [];
		this._mainArray = this._getObjectArray();
		this._options = this._getGoogleOption();
		this._initCheckBox();
	},

	_initCheckBox : function() {
		var array = this._getSubjectKeyValuePair();
		$.each(array, function(i, obj) {
			var checked = "";
			if (i == 0/* || i ==2*/) {
				checked = "checked='checked'";
			}
			$("<div class='entry'><input type='checkbox' class='chkPrefecture' value='" + obj.key + "' " + checked + "/><span>" + obj.value + "</span></div>").appendTo("#checkBoxAreaId");
		});
	},
	
	_configArray : function() {
		var array = [
			{
				"caption" : "平成22年",
				"property" : "2010"
			},
			{
				"caption" : "平成23年",
				"property" : "2011"
			},
			{	
				"caption" : "平成24年",
				"property" : "2012"
			},
			{
			    "caption" : "平成25年",
				"property" : "2013"
			},
			{
				"caption" : "平成26年",
				"property" : "2014"
			},
			{
				"caption" : "平成27年",
				"property" : "2015"			
			},
			{
				"caption" : "平成28年",
				"property" : "2016"			
			},
			{
				"caption" : "平成29年",
				"property" : "2017"			
			},
			{
				"caption" : "平成30年",
				"property" : "2018"			
			},
		];
		return array;
	},
	
	_getGoogleOption : function() {	
		var options = {
			title: '高齢化率',
			vAxis: {title: '単位：％', titleTextStyle: {color: '#A9A9A9'}}
      	};
		return options;
	},
	
	_getObjectArray : function() {
		var main = [];
		$.each(LinkData.getWorks(), function(workKey, workValue) {
			$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
				$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
					var array = [];
					$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
						var propLabel = propValue;
						var arr = propValue.split("#");
						if (arr.length > 1) {
							propLabel = decodeURIComponent(arr[1]);
						}
						var obj = {};
						var objValue = LinkData.getObjects(workValue, fileValue, subjValue, propValue)[0];
						obj.property = propLabel;
						obj.value = objValue;
						array.push(obj);
					});
					main[subjValue] = array;
				});
			});
		});
		return main;
	},
	
	_getSubjectKeyValuePair : function() {
		var array = [];
		for (var key in this._mainArray) {
			var obj = {};
			var label = key.replace("http://ja.wikipedia.org/wiki/", "");
			obj.key = key;
			obj.value = label;
    		array.push(obj);
		}
		return array;
	},
	
	getDataByKey : function(keyArray) {
		var self = this;
		var main = [];
		var titleArray = [];
		titleArray.push("");
		$.each(keyArray, function(i, key) {
			key = key.replace("http://ja.wikipedia.org/wiki/", "");
			titleArray.push(key);
		});
		main.push(titleArray);
		var configArray = this._configArray();
		$.each(configArray, function(k, obj) {
			var arr = [];
			arr.push(obj.property);
			$.each(keyArray, function(i, key) {
				var array = self._mainArray[key];
				$.each(array, function(j, objData) {
					if (objData.property === obj.property) {
						//alert(objData.property + " | " + obj.property + " | " + objData.value);
						var val = objData.value;
						if (! isNaN(val)) {
							val = parseFloat(val);
						}
						arr.push(val);
					}
				});
			});
			main.push(arr);
		});
		return main;
	},
	
	getData : function() {
		return this._data;
	},
	
	getOptions : function() {
		return this._options;
	}
	
}      

var drawMarkersMap = function() {
	var lc = new Application.lc();
	var options = lc.getOptions();
	var chart = new google.visualization.LineChart(document.getElementById('chart_div'));
	var runApp = function(dataArray) {
		$("#chart_div").show();
		if (dataArray.length == 0) {
			$("#chart_div").hide();
			return;
		}
		var array = lc.getDataByKey(dataArray);
		var data = google.visualization.arrayToDataTable(array);
		chart.draw(data, options);	
	}
	var initArray = [];
	$(".chkPrefecture:checked").each(function() {
		initArray.push($(this).val());
	});
	runApp(initArray);
	$(".chkPrefecture").change(function() {
		var arr = [];
		$(".chkPrefecture:checked").each(function () {
			arr.push($(this).val());
		});
		runApp(arr);
	});
	$("#selectAllButton").click(function() {
		var arr = [];
		$(".chkPrefecture").each(function () {
			$(this).attr("checked", "checked");
			arr.push($(this).val());
		});
		runApp(arr);
	});
	$("#clearAllButton").click(function() {
		var arr = [];
		$(".chkPrefecture").each(function () {
			$(this).removeAttr("checked");
		});
		runApp(arr);
	});
}

google.load("visualization", "1", {packages:["corechart"]});
google.setOnLoadCallback(drawMarkersMap);
