/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/

// Implement forEach for IE
// Production steps of ECMA-262, Edition 5, 15.4.4.18
// Reference: http://es5.github.io/#x15.4.4.18
if (!Array.prototype.forEach) {

  Array.prototype.forEach = function(callback/*, thisArg*/) {

    var T, k;

    if (this == null) {
      throw new TypeError('this is null or not defined');
    }

    // 1. Let O be the result of calling toObject() passing the
    // |this| value as the argument.
    var O = Object(this);

    // 2. Let lenValue be the result of calling the Get() internal
    // method of O with the argument "length".
    // 3. Let len be toUint32(lenValue).
    var len = O.length >>> 0;

    // 4. If isCallable(callback) is false, throw a TypeError exception. 
    // See: http://es5.github.com/#x9.11
    if (typeof callback !== 'function') {
      throw new TypeError(callback + ' is not a function');
    }

    // 5. If thisArg was supplied, let T be thisArg; else let
    // T be undefined.
    if (arguments.length > 1) {
      T = arguments[1];
    }

    // 6. Let k be 0.
    k = 0;

    // 7. Repeat while k < len.
    while (k < len) {

      var kValue;

      // a. Let Pk be ToString(k).
      //    This is implicit for LHS operands of the in operator.
      // b. Let kPresent be the result of calling the HasProperty
      //    internal method of O with argument Pk.
      //    This step can be combined with c.
      // c. If kPresent is true, then
      if (k in O) {

        // i. Let kValue be the result of calling the Get internal
        // method of O with argument Pk.
        kValue = O[k];

        // ii. Call the Call internal method of callback with T as
        // the this value and argument list containing kValue, k, and O.
        callback.call(T, kValue, k, O);
      }
      // d. Increase k by 1.
      k++;
    }
    // 8. return undefined.
  };
}

data_url = "http://linkdata.org/property/rdf1s7638i"
var all_data;        
function initialize(){
	all_data = new Array();
	// データをLinkDataから取得 
	tmp_a_data = new Array();
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var tmp_data = {}
				tmp_data["id"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						if(propValue == "http://imi.ipa.go.jp/ns/core/rdf#名称"){
							tmp_data["name"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#lat"){
							tmp_data["lat"] = objValue;
						}else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#long"){
							tmp_data["lng"] = objValue;
						}else if(propValue == "http://imi.ipa.go.jp/ns/core/rdf#住所"){
							tmp_data["location"] = objValue;
						}else if(propValue == data_url + "#" + encodeURIComponent("利用時間")){
							tmp_data["genre"] = objValue;
						}else if(propValue == data_url + "#" + encodeURIComponent("利用日")){
						    tmp_data["capacity"] = objValue;
						}else if(propValue == data_url + "#" + encodeURIComponent("備考")){
							tmp_data["area"] = objValue;
						}else if(propValue == data_url + "#" + encodeURIComponent("種別")){
							tmp_data["wifi_type"] = objValue;
						}else if(propValue == data_url + "#" + encodeURIComponent("鍵有無")){
							tmp_data["has_key"] = objValue;
						}else if(propValue == data_url + "#" + encodeURIComponent("ssid")){
							tmp_data["ssid"] = objValue;
						}else if(propValue == data_url + "#" + encodeURIComponent("key")){
							tmp_data["key"] = objValue;
						}
					});
				});
				tmp_a_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = tmp_a_data;

	//地図センター緯度経度の初期値は「燕市役所」
	var myLatLng = new google.maps.LatLng(37.673215,138.882446);
	var myMap = new google.maps.Map(document.getElementById('result'), {
		zoom: 12,
		center: myLatLng,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scaleControl: true,
		scrollwheel: true,
		draggable: true
	});
 
	//ポイントの設定
	var latlng;
	var data = new Array();

	for (var i in all_data) {
		icon = "http://app.linkdata.org/asset/51e2d0c2.png";
		if(all_data[i].wifi_type == "観光防災"){
			if(all_data[i].has_key == "有り"){
				icon = "http://app.linkdata.org/asset/71bbe83d.png";
			}else{
				icon = "http://app.linkdata.org/asset/a1c7fbb4.png";
			}
		}else{
			if(all_data[i].has_key == "有り"){
				icon = "http://app.linkdata.org/asset/c7cca87d.png";
			}else{
				icon = "http://app.linkdata.org/asset/d4238101.png";
			}
		}
		var image = {
   			url : icon,
    		scaledSize : new google.maps.Size(64, 64)
  		}
		var gmarker = new google.maps.Marker({  
			position: new google.maps.LatLng(all_data[i].lat,all_data[i].lng),       // 緯度・経度は地図の中心  
			title: all_data[i].name,// ツールチップ 
			openInfo:true,
			icon: image,
			map: myMap  
	 	}); 
		// ウィンドウに表示するデータをつくる
		var ssid_text = "";
		var ssid_list = JSON.parse(all_data[i].ssid);
		var key_list = JSON.parse(all_data[i].key);
		var j = 0;
		ssid_list.forEach(function(id, j){
			var key = "N/A";
			if (key_list[j] != undefined){
				key = key_list[j];
			}
			ssid_text = ssid_text + "<br>【SSID" + (j+1) + "】" + id  + "<br>【セキュリティキー" + (j+1) + "】" + key;
			j++;
		})
		var spot_info = all_data[i].name + '<small>'
			+ (all_data[i].location != undefined ? ('<br>【住所】' + all_data[i].location) : "")
			+ (all_data[i].genre != undefined ? ('<br>【利用時間】' + all_data[i].genre) : "")
			+ (all_data[i].capacity != undefined ? ('<br>【利用日】' + all_data[i].capacity) : "")
			+ (all_data[i].area != undefined ? ('<br>【主なサービスエリア】' + all_data[i].area) : "")
			+ (all_data[i].wifi_type != undefined ? ('<br>【Wi-Fi種別】' + all_data[i].wifi_type) : "")
			+ ssid_text
			+ '</small>';
		data.push({
			position: new google.maps.LatLng(all_data[i].lat, all_data[i].lng), 
			content: spot_info
		});
		// 地図上にウィンドウで表示
		attachMessage(gmarker, data[i].content);
	}; //for toji 
};//initialize toji

// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	new google.maps.InfoWindow({
			content: msg
        }).open(marker.getMap(), marker);
    });
};
window.onload = function() {
    $(function(){initialize();});	
};
