window.onload = function() {
	initArea();
	resetCheckBox();
	resetTable();
	
	$(".chkItem").change(function() {
		resetTable();
	});
	$("#selectAllButton").click(function() {
		$(".chkItem").prop('checked', true);
		resetTable();
	});
	$("#clearAllButton").click(function() {
		$(".chkItem").prop('checked', false);
		resetTable();
	});
};

function initArea() {
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$("#result").append("<h3>" + LinkData.getWorkName(workValue) + "</h3>");
		$("#result").append("<hr>");
		$("#result").append("<div id=\"checkBoxAreaId\"></div>");
		$("#result").append("<div><input type=\"button\" id=\"selectAllButton\" value=\"Select All\"/><input type=\"button\" id=\"clearAllButton\" value=\"Clear All\"/></div>");
		$("#result").append("<hr>");
	});
};

function resetCheckBox() {
	// default
	var displayList = [
		"NO",
		"データ名称",
		"分類",
		"更新頻度",
		"URL",
		"最終更新日"
		];
	
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
				var checked = "";
				if (displayList.includes(getLastName(propValue))) {
					checked = "checked=\"checked\"'";
				}
				$("#checkBoxAreaId").append("<div class=\"entry\"><input type=\"checkbox\" class=\"chkItem\" value=\"" + getLastName(propValue) + "\" " + checked + "/><span>" + getLastName(propValue) + "</span></div>");
			});
		});
	});
};

function resetTable() {
	$("#dataTabeleArea").remove();
	$("#result").append("<div id=\"dataTabeleArea\"></div>");
	$("#dataTabeleArea").append("<table id=\"myTable\"  class=\"display\"></table>");
	$("#myTable").append("<thead id=\"myTableHeader\"></thead>");
	$("#myTable").append("<tbody id=\"myTableBody\"></tbody>");
	
	displayTable();
}

function displayTable() {
	var displayList = [];
	var keyword = getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
	var head = ""; // head to be displayed
	var list = ""; // list to be displayed
	
	$(".chkItem:checked").each(function () {
		displayList.push($(this).val());
	});
	
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			// display header
			head += "<tr>";
			$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
				if (displayList.includes(getLastName(propValue))) {
					head += "<th>" + getLastName(propValue) + "</th>"; //add to the head to be displayed
				}
			});
			head += "</tr>";
			
			$("#myTableHeader").append( head );
			
			// display body
			// Subject loop
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var s = ""; // subject to be displayed
				
				s += "<tr>";
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if (displayList.includes(getLastName(prop))) {
						if ( obj.indexOf("://www.youtube.com") != -1 && obj.indexOf("v=") != -1 ) { // Insert YouTube Thumbnail
							videoId = (obj.split("v=")[1]).split("&")[0]; // get video id
							obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" + highlight(decodeURIComponent(obj), keyword) + "<br><img src=\"http://img.youtube.com/vi/" + videoId + "/mqdefault.jpg\" alt=\"YouTube video\" /><br></span></a>";
						}
						else if ( obj.indexOf("http") == 0 ) {
							if ((obj.indexOf(".jpg" )>0 || obj.indexOf(".gif" )>0 || obj.indexOf(".png" )>0) || (obj.indexOf(".JPG" )>0 || obj.indexOf(".GIF" )>0 || obj.indexOf(".PNG" )>0)) // insert image
								obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" +shortenURL(obj) + "<br><img src=\"" + obj + "\" alt=\"image\" /><br></span></a>";
							else{
								obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" + shortenURL(obj) + "</span></a>"; // Make it clicable if it starts from http
							}
						}
						else{
							obj = "<span class=\"object\">" + highlight(obj, keyword) + "</span>";
						}
						
						// s += "<br><span class=\"propertyName\">" + getLastName(prop) + ":\t</span>" +  obj;
						s += "<td>" + obj + "</td>";
					}
				});
				s += "</tr>"

				list += s; //add to the list to be displayed
			});
			
			$("#myTableBody").append( list );
		});
	});
	
	window.find(highlight);
	
	$("#myTable").DataTable({
		"language": {
			"url": "//cdn.datatables.net/plug-ins/1.10.22/i18n/Japanese.json"
		}
	});
};

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var topWindow = top.window.location.search;
	if( topWindow ){
		var q = decodeURIComponent(topWindow.substring(1,topWindow.length)).split("&");
		for ( var i = 0; i < q.length; i++ ){
			var r = q[i].split("=");
			if ( r[0] ==  paramString )
				value = r[1];
		}
	}
 	return value;
}

// Highlight keyword in the string
function highlight( string, keyword )
{
	if ( keyword.length > 0 ) {
		var ss = string.split(keyword);
		var len = ss.length;
		if ( len > 1 ) {
			string = ss[0];
			for ( i = 1; i < len; i++ )
//				string += "<font color=\"red\">"+keyword+"</font>"+ss[i];
				string += "<span class=\"highlight\">"+keyword+"</span>"+ss[i];
		}
	}
	return string;
}

// get the last name of the string separated with # and /
function getLastName( string )
{
	string = decodeURIComponent(string);
	var sharp = string.split("#");
	var slash = sharp[sharp.length-1].split("/");
	var lastName = slash[slash.length-1];
	return lastName;
}

// return a link to Google map search
function addLinkToMap( latitude, longitude )
{
	var s = "<br><a target=\"_blank\" href=\"http://www.google.com/maps/?q=" + latitude + "," + longitude + "\">Show map</a>";
	return s;
}

// shortening URL e.g. http://.../123.jpg
function shortenURL( url )
{
	url = decodeURIComponent(url);
	var slash = url.split("/");
	var lastName = slash[slash.length-1];
	return url.split(":")[0]+"://.../"+lastName;
}
