MotifCircadian = function(containerId, options) {
	new Application.motifMaxCircadian(containerId, options);
};

if (Application === "undefined" || !Application) {
	var Application = {};
}

Application.motifMaxCircadian = function() {
	this._init.apply(this, arguments);
};

Application.motifMaxCircadian.prototype = {
	
	_containerId : null,
	_baseSequence : null,
	_options : null,
	_tooltip : null,
	_motifProperty : null,
	_heptamer : null,
	_octamer : null,
	_appSequence : null,
	_motifViewDialogId : null,
	_addAnotherMotifDialogId : null,
	_motifConflictConfirmDialogId : null,
	_geneInfoContainerId : null,
	_motifView : null,
	_fixedSequence : null,
	_dataColl : null,
	
	_default : {
		appName : "MotifMaxCircadian",
		selectRangeCaption : "Select Range",
		selectPropertyAreaClass : "selectPropertyArea",
		selectPropertyClass : "selectProperty",
		resultAreaClass : "resultArea",
		replaceButtonAreaClass : "replaceButtonArea",
		replaceButtonClass : "replaceButton",
		nextButtonAreaClass : "nextButtonArea",
		replaceSequenceClass : "replaceSequence",
		errorMessageAreaClass : "errorMessage",
		dialogErrorMessageClass : "dialogErrorMessage",
		dialogOutRangeValueMessage : "Please input a value between {0} and {1}",
		noSequenceForThisRange : "No sequence found for this range",
		invalidDatabase : "Invalid database. Please select valid database.",
		databaseInfoClass : "databaseInfo",
		addAnotherMotifButtonClass : "addAnotherMotifButton",
		geneLabelClass : "geneUrl",
		dbInfoLinkClass : "dbInfoLink",
		geneInfoLinkClass : "geneInfoLink",
		geneInfoAttedLinkClass : "geneInfoAttedLink",
		geneInfoPpdbLinkClass : "geneInfoPpdbLink",
		geneInfoEfpLinkClass : "geneInfoEfpLink",
		geneInfoHannaDbLinkClass : "geneInfoHannaDbLink",
		motifSequenceProperty : "motif sequence",
		motifPositionProperty : "motif position",
		sinePhaseProperty : "Sine Phase",
		sineAmplitudeProperty : "Sine Amplitude",
		typeProperty : "type",
		validType : "REG",
		motifViewDialogId : "motifViewDialog",
		motifViewDialogClass : "motifViewDialog",
		motifViewDialogTitle : "Motif View",
		conflictionDialogTitle : "Confliction",
		minSequenceClass : "minSeq",
		maxSequenceClass : "maxSeq",
		websiteNameAtted : "ATTED",
		websiteNamePpdb : "PPDB",
		geneTypeAtted : "ATTED",
		geneTypePpdb : "PPDB",
		baseSequenceMinLength : 50,
		dialogImageUrl : "http://app.linkdata.org/asset/a06f4de4.png",
		callback : function() {},
		loadingImageContainer : "loadingImageContainer",
		loadingImageUrl : "http://app.linkdata.org/asset/67556085.gif",
		loadingMessageClass : "loadingMessage",
		fixedSequenceShowClass : "fixedSequenceMotif",
		wrappedMotifSequenceShowClass : "wrappedSequenceMotif",
		loadingMessage : "Loading linked data...",
		loadingMessageError : "There was an error with loading Linked data. Please refresh the browser",
		serverUrl : "http://linkdata.org/",
		resultAreaUserMessage : "Scroll Left/Right to inspect motifs from this promoter. click on motif sequence to enter advanced view",
		resultAreaUserMessageClass : "resultAreaUserMessageClass",
		normalizedFileIncludeWord : "normalized"
	},
	
	_tag : {
		topResult : "result_top"
	},
	
	_tooltipName : {
		selectRange : "Select Range",
		atted2 : "atted-ii",
		hanaDb : "HanaDB",
		efp : "eFP",
		ppdb : "ppdb",
		replace : "Add Motifs",
		manuallyInputMotif : "userinputmotif",
		motifExpress : "motifexpress",
		motifCircatian : "motifcircadian",
	},
	
	_init : function(containerId, options) {
		this._containerId = containerId;
		this._options = $.extend({}, this._default, options);
		this._baseSequence = this._options.baseSequence;
		this._fixedSequence = this._options.fixedSequence;
		this._dataColl = this._options.dataColl;
		var date = new Date();
		this._geneInfoContainerId = "gene_info_containerId_" + date.getTime();
		this._initToolTip();
		this._initMotifProperty(this._options);
		this._initAppSequence(this._options);
		this._initHeptamer();
		this._initOctamer();
		this._initView();
		this._initDialog();
		this._initMotifView(this._options);
	},
	
	_initToolTip : function() {
		var self = this;
		self._tooltip = (self._options.tooltip) ? self._options.tooltip : new Application.tooltip();
	},
	
	_initMotifProperty : function(opts) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._motifProperty = new Application.motifProperty(obj);
	},
	
	_initMotifView : function(opts) {
		var self = this;
		var obj = {
			baseSequenceMinLength : opts.baseSequenceMinLength,
			baseSequence : opts.baseSequence,
			replaceSequenceClass : opts.replaceSequenceClass,
			callerObj : self,
			geneLabelClass : opts.geneLabelClass,
			motifMethod : opts.motifMethod
		}
		this._motifView = new Application.MotifView(this._containerId,obj);
	},
	
	_initAppSequence : function(opts) {
		var self = this;
		var timer = new Application.timer();
		var init = function() {
			var seqProperty = self._motifProperty.getPropertyByLabel(self._options.motifSequenceProperty);
			var posProperty = self._motifProperty.getPropertyByLabel(self._options.motifPositionProperty);
			if (seqProperty && posProperty) {
				var obj = {
					workId : opts.workId,
					fileName : opts.fileName,
					baseSequence : self._baseSequence,
					motifSequenceProperty : seqProperty,
					motifPositionProperty : posProperty,
					containerId : self._containerId,
					errorMessageClass : self._options.errorMessageAreaClass,
					baseSequenceMinLength : self._options.baseSequenceMinLength
				};
				self._appSequence = new Application.sequence(obj);
			} else {
				timer.call(init);
			}
		}
		init();
	},
	
	_initHeptamer : function() {
		this._heptamer = new Application.heptamer();
	},
	
	_initOctamer : function() {
		this._octamer = new Application.octamer();
	},
	
	_initView : function() {
		this._initMainView();
		//this._initDialogView();
		this._initAddAnotherMotifDialogView();
		this._initConflictConfirmDialogView();
	},
	
	_initDialog : function() {
		//this._initMotifViewDialog();
		this._initAddAnotherMotifDialog();
		this._initMotifConflictConfirmDialog();
	},
	
	_initMainView : function() {
		var self = this;
		var timer = new Application.timer();
		var fillOptionMethod = function() {
			var optionArray = self._motifProperty.getOptionArray();
			if (optionArray) {
				var sb = [];
				sb[sb.length] = "<div class='" + self._options.selectPropertyAreaClass + " row'>";
				sb[sb.length] = "<div class='label left' title='" + self._tooltip.getByKey(self._tooltipName.selectRange) +"'>" + self._options.selectRangeCaption + "</div>";
				sb[sb.length] = "<div class='left'>";
				sb[sb.length] = "<select class='" + self._options.selectPropertyClass + "' title='" + self._tooltip.getByKey(self._tooltipName.selectRange) + "'>";
				sb[sb.length] = "<option title='" + self._tooltip.getByKey(self._tooltipName.selectRange) + "' value='-1'>-- Select Range --</option>";
				sb[sb.length] = "<option value='0-4'>0 to 4</option>";
				sb[sb.length] = "<option value='4-8'>4 to 8</option>";
				sb[sb.length] = "<option value='8-12'>8 to 12</option>";
				sb[sb.length] = "<option value='12-16'>12 to 16</option>";
				sb[sb.length] = "<option value='16-20'>16 to 20</option>";
				sb[sb.length] = "<option value='20-24'>20 to 24</option>";
				sb[sb.length] = "</select>";
				sb[sb.length] = "</div>";
				sb[sb.length] = "</div>";
				sb[sb.length] = "<div class='" + self._options.databaseInfoClass + " hidden'></div>";
				sb[sb.length] = "<div id='" + self._geneInfoContainerId + "'></div>";
				sb[sb.length] = "<div class='" + self._options.errorMessageAreaClass + " hidden'>error</div>";
				sb[sb.length] = "<div class='" + self._options.resultAreaClass + " hidden'></div>";
				sb[sb.length] = "<div class='" + self._options.resultAreaUserMessageClass + " hidden'>"+ self._options.resultAreaUserMessage +"</div>";
				sb[sb.length] = "<div class='" + self._options.replaceButtonAreaClass + " hidden'>";
				sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.replace) + "' class='" + self._options.replaceButtonClass + " btn btn-lightblue'>Add Motifs</a>&nbsp;";
				//sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.manuallyInputMotif) + "' class='" + self._options.addAnotherMotifButtonClass + " btn btn-lightblue'>Manually Input Motif</a>";
				sb[sb.length] = "</div>";
				sb[sb.length] = "<div class='" + self._options.replaceSequenceClass + " hidden'></div>";
				sb[sb.length] = "<div class='" + self._options.wrappedMotifSequenceShowClass + " hidden'></div>";
				sb[sb.length] = "<span class='" + self._options.fixedSequenceShowClass + " hidden'></span>";
				sb[sb.length] = "<div class='" + self._options.loadingImageContainer + " hidden' align='center'>";
				sb[sb.length] = "<div class='" + self._options.loadingMessageClass + "'>" + self._options.loadingMessage + "</div>";
				sb[sb.length] = "<div>";
				sb[sb.length] = "<img src='" + self._options.loadingImageUrl + "'/>";
				sb[sb.length] = "</div>";
				sb[sb.length] = "</div>";
				$("#" + self._containerId).html(sb.join(""));
				self._initListener();
			} else {
				timer.call(fillOptionMethod);
			}
		}
		fillOptionMethod();
	},
	/*
	_initDialogView : function() {
		var sb = [], self = this, date = new Date();
		this._motifViewDialogId = "motifViewDialog_id_" + self._containerId + "_" + date.getTime();
		sb[sb.length] = "<div id='" + this._motifViewDialogId + "' class='hidden'>";
		sb[sb.length] = "<input type='hidden' class='sequence'>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span>Place motif at position</span>";
		sb[sb.length] = "<input type='text' class='position'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation'>Replace with prefer position between ";
		sb[sb.length] = "<span class='minSeq'></span> and <span class='maxSeq'>";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span>Number of extra copies</span>";
		sb[sb.length] = "<input type='text' class='extraCopies' value='0'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span>Space between copies (Base Pairs)</span>";
		sb[sb.length] = "<input type='text' class='basePairs' value='0'/>";
		sb[sb.length] = "</div>";
		//sb[sb.length] = "<div class='motifImageArea'>";
		//sb[sb.length] = "<img src='" + this._options.dialogImageUrl + "'/>";
		//sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation'>Click ";
		//sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif from " + self._getDataBaseWebsiteName() + " website";
		sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='dialogErrorMessage errorMessage hidden'></span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},*/
	
	_initAddAnotherMotifDialogView : function() {
		var sb = [], self = this, date = new Date(); 
		this._addAnotherMotifDialogId = "addAnotherMotifDialog_id_" + self._containerId + "_" + date.getTime();
		sb[sb.length] = "<div id='" + this._addAnotherMotifDialogId + "' class='hidden'>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='left'>Motif Sequence</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<input type='text' class='anotherSequence'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='left'>Position(-550 to -50)</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<input type='text' class='anotherPosition'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initConflictConfirmDialogView : function() {
		var sb = [], self = this, date = new Date(); 
		self._motifConflictConfirmDialogId = "motifConflictConfirmDialog_id_" + self._containerId + "_" + date.getTime();
		sb[sb.length] = "<div id='" + self._motifConflictConfirmDialogId + "' class='hidden'>";
		sb[sb.length] = "<div>New motif overlaps with old one. Which one should be kept in overalp regions?</div>";
		sb[sb.length] = "<div class='option'>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='new'/>&nbsp;New</label></div>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='old'/>&nbsp;Old</label></div>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='discard'/>&nbsp;Discard new motif</label></div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<label><input type='checkbox' class='motifReplaceApplyToAll' value='applytoall'/>&nbsp;Apply to all</label>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initListener : function() {
		var self = this;
		self._initSelectPropertyListener();
		self._initAddAnotherMotifButtonListener();
	},
	
	_initSelectPropertyListener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		var timer = new Application.timer();
		var setSelectListener = function() {
			if ($("#" + self._containerId + " ." + self._options.selectPropertyClass).length != 0) {
				$("#" + self._containerId + " ." + self._options.selectPropertyClass).change(function() {
					$("#" + self._containerId + " ." + self._options.loadingImageContainer).show();
					self._appSequence.hideError();
					$("#" + self._containerId + " ." + self._options.resultAreaClass).hide();
					$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).hide();
					$("#" + self._containerId + " ." + self._options.resultAreaUserMessageClass).hide();
					$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html("");
					$("#" + self._containerId + " ." + self._options.replaceSequenceClass).hide();
					$("#" + self._containerId + " ." + self._options.databaseInfoClass).hide();
					$("#" + self._containerId + " #" + self._geneInfoContainerId).hide();
					var range = $("option:selected", this).val();
					if (range && range != -1) {
						self._showMotifMaxCircadian(workId, fileName, range);
					}
				});
			} else {
				timer.call(setSelectListener);
			}
		}
		setSelectListener();
	},
	
	_initAddAnotherMotifButtonListener : function() {
		var self = this;
		$("#" + self._containerId + " ." + self._options.addAnotherMotifButtonClass).click(function() {
			self._appSequence.hideError();
			$("#" + self._addAnotherMotifDialogId + " .anotherSequence").val("");
			$("#" + self._addAnotherMotifDialogId + " .anotherPosition").val("");
			$("#" + self._addAnotherMotifDialogId).dialog("open");
		});
	},
	
	_showGenePlot : function(subject) {
		var self = this;
		$("#" + self._containerId + " #" + self._geneInfoContainerId).show();
		var options = {
			workId : self._options.workId,
			fileName : self._options.fileName,
			subject : subject,
			property : ""
		};
		new Application.geneChart(self._geneInfoContainerId, options);
	},
	
	_showDataBaseInformationList : function() {
		var self = this, seqVal = [];
		$("#" + self._containerId + " .userSequence .hdnSequence").each(function() {
			var tmpPos = $(this).siblings(".hdnCorPosition").val();
			seqVal.push($(this).val() + "[" + tmpPos + "]");
		});
		self._showDatabaseInfo(seqVal.join(", "));
	},
	
	_initReplaceButtonLitener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		$("#" + self._containerId + " ." + self._options.replaceButtonClass).unbind("click");
		$("#" + self._containerId + " ." + self._options.replaceButtonClass).click(function() {
			var seqs = [], nonConflictSeqs = [], seqArray = [], posArray = [], conflictArray = [];
			$("#" + self._containerId + " .userSequence").each(function() {
				seqs.push($(this).text());
				var seq = $(this).find(".hdnSequence").val();
				var pos = $(this).find(".hdnPosition").val();
				seqArray.push(seq);
				posArray.push(pos);
				if (self._hasConfliction(seq, pos)) {
					conflictArray.push(seq + "|" + pos);
				} else {
					nonConflictSeqs.push($(this).text());
				}
			});
			$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html("");
			$("#" + self._containerId + " ." + self._options.replaceSequenceClass).hide();
			if (conflictArray.length > 0) {
				if (nonConflictSeqs.length > 0) {
					self._doReplace(nonConflictSeqs, seqArray, posArray);
				}	
				self._handleConfliction(conflictArray);
			} else {
				self._doReplace(seqs, seqArray, posArray);
			}
		});
	},
	/*
	_initMotifSequenceListener : function() {
		var self = this;
		$("#" + self._containerId + " .motifSequence").click(function() {
			$("." + self._options.motifViewDialogClass).hide();
			var parent = $(this).closest('.userSequence');
			var container = $(this).closest('.userSequence');
			var seq = $(parent).find(".hdnSequence").val();
			var pos = $(parent).find(".hdnPosition").val();
			var seqEl = self._getSeqElBySeq(seq);
			var appropriatePos = (seqEl && seqEl.getAppropriatePos()) ? seqEl.getAppropriatePos() : pos;
			self._initSequencePopup(seqEl);
			$("#" + self._motifViewDialogId + " ." + self._options.dialogErrorMessageClass).hide();
			$("#" + self._motifViewDialogId + " .sequence").val(seq);
			$("#" + self._motifViewDialogId + " .position").val("-" + appropriatePos);
			$("#" + self._motifViewDialogId + " .minSeq").html(self._getMinPosition(seq));
			$("#" + self._motifViewDialogId + " .maxSeq").html(self._getMaxPosition(seq));
			self._initPositionInsert(seq, appropriatePos);
			$("#" + self._motifViewDialogId).dialog({title: self._default.motifViewDialogTitle + " - " + seq});
			$("#" + self._motifViewDialogId).dialog("open");
			$("#" + self._motifViewDialogId).closest('.' + self._options.motifViewDialogClass).show();
		});
	},*/
	/*
	_initSequencePopup : function(seqEl) {
		var self = this;
		$("#" + self._motifViewDialogId + " .moreInfo").unbind("click");
		var url = (seqEl && seqEl.getExternalUrl()) ? seqEl.getExternalUrl() : "#";
		$("#" + self._motifViewDialogId + " .moreInfo").click(function() {
			self._showPopupWindow(url);
		});
	},*/
	
	_hasConfliction : function(seq, pos, oldSequence) {
		var self = this;
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		var formattedSeq = self._appSequence.getFormattedSequence(self._baseSequence.length, seq, pos);
		var array = [formattedSeq];
		var newSequence = self._appSequence._getMergeCharSequence(array);
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			if (nChar !== "-" && oChar !== "-" && nChar !== oChar) {
				return true;
			}
		}
		return false;
	},
	
	_handleConfliction : function(conflictArray) {
		var self = this;
		if (conflictArray.length > 0) {
			var arr = conflictArray[0].split("|");
			var bArray = self._getConflictConfirmDialogButtonArray(conflictArray);
			var dialogTitle =  self._options.conflictionDialogTitle + " - " +  arr[0] + "[" + arr[1] + "]";
			$("#" + self._motifConflictConfirmDialogId).find("input[name='motifReplaceOption'][value='new']").attr("checked", "checked");
			$("#" + self._motifConflictConfirmDialogId).find(".motifReplaceApplyToAll").attr("checked", "checked");
			$("#" + self._motifConflictConfirmDialogId).dialog({title : dialogTitle});
			$("#" + self._motifConflictConfirmDialogId).dialog({buttons : bArray});
			$("#" + self._motifConflictConfirmDialogId).dialog("open");
		}
	},
	
	_replaceWithOption : function(option, isApplyToAll, conflictArray) {
		var self = this;
		if (isApplyToAll) {
			self._replaceAllWithOption(option, conflictArray);
		} else {
			var value = conflictArray.splice(0, 1);
			var arr = value[0].split("|");
			self._replaceSequenceByOption(option, arr[0], arr[1]);
			self._handleConfliction(conflictArray);
		}
	},
	
	_replaceAllWithOption : function(option, conflictArray) {
		var self = this, html = oldSequence;
		var oldSequence = $("#" + self._containerId + " ." + self._options.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		$.each(conflictArray, function(key, conflict) {
			var arr = conflict.split("|");
			self._replaceSequenceByOption(option, arr[0], arr[1]);
		});
	},
	
	_replaceSequenceByOption : function(option, seq, pos) {
		var self = this;
		var oldSequence = $("#" + self._containerId + " ." + self._options.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		var formattedSeq = self._appSequence.getFormattedSequence(self._baseSequence.length, seq, pos);
		var seqArray = [formattedSeq];
		var newSequence = self._appSequence._getMergeCharSequence(seqArray);
		var html = oldSequence;
		if (option === "new") {
			html = self._appSequence.getHtmlByReplacingNewSequence(oldSequence, newSequence);
		} else if (option === "old") {
			html = self._appSequence.getHtmlByReplacingOldSequence(oldSequence, newSequence);
		}
		self._doReplaceWithHtml(html);
	},
	
	_getConflictConfirmDialogButtonArray : function(conflictArray) {
		var self = this;
		return [
				{
					text: "Done",
					click : function() {
						$(this).dialog("close");
						var option = $(this).find("input[name='motifReplaceOption']:checked").val();
						var isApplyToAll = $(this).find(".motifReplaceApplyToAll").is(":checked");
						self._replaceWithOption(option, isApplyToAll, conflictArray);
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog("close");
					}
				}
			];
	},
	
	_doReplace : function(seqs, seqArray, posArray) {
		var self = this;
		var html = self._appSequence.replace(seqs, seqArray, posArray);
		self._doReplaceWithHtml(html);
	},
	
	_doReplaceWithHtml : function(html) {
		var self = this, sb = [];
		var wrappedHtml = this._getAddedSquenceWithoutFixedSequence(html);
		var subject = $("#" + self._containerId + " ." + self._options.geneLabelClass).val();
		var gene = self._motifProperty.getGeneBySubject(subject);
		var geneType = self._getGeneType();
		sb[sb.length] = html;
		sb[sb.length] = "<input type='hidden' class='gene' value='" + gene + "'/>";
		sb[sb.length] = "<input type='hidden' class='geneType' value='" + geneType + "'/>";
		//self._appSequence.hideError();
		//$("#" + self._containerId + " ." + self._options.replaceSequenceClass).show();
		$("#" + self._containerId + " ." + self._default.wrappedMotifSequenceShowClass).show();
		//$("#" + self._containerId + " ." + self._default.fixedSequenceShowClass).show();
		$("#" + self._containerId + " ." + self._default.wrappedMotifSequenceShowClass).html(wrappedHtml);
		//$("#" + self._containerId + " ." + self._default.fixedSequenceShowClass).html(this._fixedSequence);
		$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html(sb.join("")); 
		//$("#" + self._containerId + " ." + self._options.replaceSequenceClass).scrollLeft(10000);
		var ref = $("#" + self._containerId + " ." + self._default.wrappedMotifSequenceShowClass);
		$(ref).animate({scrollTop: $(ref).height()}, 800);
		self._showDataBaseInformationList();
		self._options.callback();
	},
	
	_getAddedSquenceWithoutFixedSequence : function(html) {
		var index = html.lastIndexOf(this._fixedSequence);
		var length = index + this._fixedSequence.length;
		if (html.length == length) {
			var html = html.substr(0,index);
		}
		return html;
	},
	
	_addAnotherMotif : function(seq, pos) {
		var self = this, conflictArray = [];
		var oldSequence = $("#" + self._containerId + " ." + self._options.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		if (self._hasConfliction(seq, pos, oldSequence)) {
			conflictArray.push(seq + "|" + pos);
		}
		if (conflictArray.length > 0) {
			self._handleConfliction(conflictArray);
		} else {
			self._replaceSequenceByOption("new", seq, pos);
		}
	},
	
	_showPopupWindow : function(url) {
		var winWidth = 800;
		var winHeight = 800;
		var winLeft = parseInt((screen.availWidth/2) - (winWidth/2));
		var winTop = parseInt((screen.availHeight/2) - (winHeight/2));
		var winStyle = "width=" + winWidth + ",height=" + winHeight + ",left=" + winLeft + ",top=" + winTop + ",screenX=" + winLeft + ",screenY=" + winTop + ",scrollbars=1";
		window.open(url, "Motif", winStyle);
	},
	/*
	_initPositionInsert : function(seq, pos) {
		var self = this;
		var mod = seq.length % 2;
		$("#" + self._motifViewDialogId + " .position").unbind("keyup");
		$("#" + self._motifViewDialogId + " .position").keyup(function() {
			var val = $(this).val();
			if (isNaN(val)) {
				$(this).val(pos);
				return;
			}
			var tmpVal = new String(Math.abs(val));
			if (mod == 0) {
				if (tmpVal.indexOf(".") == -1) {
					$(this).val(tmpVal + ".5");
				} else {
					$(this).val(tmpVal.split(".")[0] + ".5");
				}
			} else {
				if (tmpVal.indexOf(".") > -1) {
					$(this).val(tmpVal.split(".")[0]);
				}
			}
		});
	},*/
	/*
	_initMotifViewDialog : function() {
		var self = this;
		$("#" + self._motifViewDialogId).dialog({
			autoOpen: false,
			title: self._default.motifViewDialogTitle,
			width: 520,
			dialogClass : self._options.motifViewDialogClass,
			buttons : [
				{
					text: "Replace",
					click : function() {
						var seq = $("#" + self._motifViewDialogId).find(".sequence").val();
						var pos = Math.abs($("#" + self._motifViewDialogId).find(".position").val());
						var extraCopies = parseInt($("#" + self._motifViewDialogId).find(".extraCopies").val());
						var basePairs = parseInt($("#" + self._motifViewDialogId).find(".basePairs").val());
						var minPos = parseFloat($("#" + self._motifViewDialogId).find(".minSeq").html());
						var maxPos = parseFloat($("#" + self._motifViewDialogId).find(".maxSeq").html());
						if (minPos > pos || maxPos < pos) {
							$dialogError = $("#" + self._motifViewDialogId + " ." + self._options.dialogErrorMessageClass);
							$dialogError.html(self._options.dialogOutRangeValueMessage.replace("{0}", minPos).replace("{1}", maxPos));
							$dialogError.show();
							return;
						}
						self._replaceWithSequence(seq, pos, extraCopies, basePairs);
						$(this).dialog("close");
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog("close");
					}
				}
			]
		});
	},*/
	
	_initAddAnotherMotifDialog : function() {
		var self = this;
		$("#" + self._addAnotherMotifDialogId).dialog({
			autoOpen: false,
			title: "Input Motif",
			buttons : [
				{
					text: "Add",
					click : function() {
						var seq = $(this).find(".anotherSequence").val();
						var pos = Math.abs($(this).find(".anotherPosition").val());
						if (seq && pos) {
							self._addAnotherMotif(seq, pos);
							$(this).dialog("close");
						}
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog("close");
					}
				}
			]
		});
	},
	
	_initMotifConflictConfirmDialog : function() {
		var self = this;
		$("#" + self._motifConflictConfirmDialogId).dialog({
			autoOpen: false,
			width: 420,
			dialogClass : "motifConflictionDialog"
		});
	},
	
	_getMotifMaxCircadianTriple : function(workId, fileName, range) {
		var self = this;
		var property = self._motifProperty.getPropertyByLabel(self._options.sinePhaseProperty);
		var amplitudeProperty = self._motifProperty.getPropertyByLabel(self._options.sineAmplitudeProperty);
		if (!property) {
			$("#" + self._containerId + " ." + self._options.loadingImageContainer).hide();
			self._appSequence._showError(self._options.invalidDatabase);
			return;
		}
		var index = new Application.index(1, 5000);
		var maxCircadianTriple;
		var getSinePhasePropertyList = function(sinePhaseTripleList) {
			var getSineAmplitudePropertyList = function(amplitudeTripleList) {
				var tmpMaxCircadianTriple = self._getMaxCircadianTriple(range, sinePhaseTripleList, amplitudeTripleList);
				if (tmpMaxCircadianTriple) {
					if (!maxCircadianTriple) {
						maxCircadianTriple = tmpMaxCircadianTriple;
					}
					var tmpMaxValue = parseFloat(maxCircadianTriple.object);
					var currentValue = parseFloat(tmpMaxCircadianTriple.object);
					if (Math.max(tmpMaxValue, currentValue) != tmpMaxValue) {
						maxCircadianTriple = tmpMaxCircadianTriple;
					}
				}
				if (sinePhaseTripleList && sinePhaseTripleList.length == index.getItemCount()) {
					LinkData.getTriplesByProperty(workId, fileName, property, getSinePhasePropertyList, index.increment());
				} else {
					self._motifMaxCircadianSequence(workId, fileName, maxCircadianTriple.subject);
				}
			}
			LinkData.getTriplesByProperty(workId, fileName, amplitudeProperty, getSineAmplitudePropertyList, index.getIndex());
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getSinePhasePropertyList, index.getIndex());
	},
	
	_monitorAppDataLoading : function() {
		var self = this;
		var maxRetry = 8; // 8 seconds
		var timer = new Application.timer(); 
		timer.setMaxRetryCount(maxRetry);
		var checkLoadingArea = function() {
			if (maxRetry == 0) {
				$("#" + self._containerId + " ." + self._options.loadingMessageClass).html(self._options.loadingMessageError);
				$("#" + self._containerId + " ." + self._options.loadingImageContainer + " img").hide();
				//alert("App loading error. please refresh");
				return;
			}
			var dbInfoArea = $("#" + self._containerId + " ." + self._options.databaseInfoClass);
			if (!$(dbInfoArea).is(":visible")) {
				timer.call(checkLoadingArea);
			} else {
				return;
			}
			maxRetry--;
		};
		checkLoadingArea();
	},
	
	_showMotifMaxCircadian : function(workId, fileName, range) {
		var self = this;
		var arr = range.split("-");
		var rangePhrase = "_" + arr[0] + "to" + arr[1]; 
		var fileSuffix =  rangePhrase + "_top";
		var foundTopFile = false;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(wId, fileList) {
				$.each(fileList, function(fKey, fName) { 
					var speedUpFileName = null;
					// finding weather the file name containes the 'normalized' part
					var fileNameComps = fileName.split("_");
					var filePrefix = fileNameComps[0] + "_" + fileNameComps[1];
					if (fileNameComps.indexOf(self.normalizedFileIncludeWord) > -1) {
						// generating the normalize file name
						var speedUpFileName = filePrefix + self.normalizedFileIncludeWord + fileSuffix;
					} else {
						speedUpFileName = filePrefix + fileSuffix;
					}
					if (fName.toLowerCase().trim() == speedUpFileName.toLowerCase().trim()) {
						var propLabel = self._dataColl + rangePhrase;
						self._getTopFilePropertyList(workId, fileName, wId, fName, propLabel);
						foundTopFile = true;
						return false;
					}
					/*
					var tmpName = fName.split(fileSuffix);
					if (fileName.indexOf(tmpName[0]) > -1) {
						var propLabel = fileName.split(tmpName[0] + "_")[1] + rangePhrase;
						self._getTopFilePropertyList(workId, fileName, wId, fName, propLabel);
						foundTopFile = true;
						return false;
					}*/
				});
				if (foundTopFile) {
					return false;
				}
			});
			if (!foundTopFile) {
				self._getMotifMaxCircadianTriple(workId, fileName, range);
			}
		}
		self._monitorAppDataLoading();
		LinkData.getFilesByTag(null, self._tag.topResult, getFilesByTag);
	},
	
	_getTopFilePropertyList : function(workId, fileName, topWorkId, topFileName, propLabel) {
		var self = this;
		var getProperties = function(propList) {
			$.each(propList, function(propKey, propValue) {
				var tmpProp = self._motifProperty._getLabel(propValue);
				if (tmpProp.indexOf(propLabel) > -1) {
					self._showMaxCircadian(workId, fileName, topWorkId, topFileName, propValue);
					return false;
				}
			});
		}
		LinkData.getProperties(topWorkId, topFileName, getProperties);
	},
	
	_showMaxCircadian : function(workId, fileName, topWorkId, topFileName, topProperty) {
		var self = this;
		var index = new Application.index(1, 1000);
		var getTriplesByProperty = function(tripleList) {
			self._showMotifMaxCircadianByTripleList(workId, fileName, tripleList);
		}
		LinkData.getTriplesByProperty(topWorkId, topFileName, topProperty, getTriplesByProperty, index.getIndex());
	},
	
	_showMotifMaxCircadianByTripleList : function(workId, fileName, tripleList) {
		/*
		var self = this, i = 0, subject = tripleList[i].object;
		var posProperty = self._motifProperty.getPropertyByLabel(self._options.motifPositionProperty);
		var showMaxCircadianMotif = function(posTripleList) {
			//var found = false;
			i++;
			if (self._isValidSequenceFound(workId, fileName, subject, posTripleList)) {
				self._motifMaxCircadianSequence(workId, fileName, subject);
				return false;
			} else {
				subject = tripleList[i].object;
				LinkData.getObjects(workId, fileName, subject, posProperty, showMaxCircadianMotif);
			}
			/*
			$.each(posTripleList, function(pKey, pValue) {
				var tmpPos = parseInt(pValue);
				if (self._options.baseSequenceMinLength < tmpPos && self._options.baseSequence.length >= tmpPos) {
					found = true;
					self._motifMaxCircadianSequence(workId, fileName, subject);
					return false;
				}
			});
			if (! found) {
				subject = tripleList[i].object;
				LinkData.getObjects(workId, fileName, subject, posProperty, showMaxCircadianMotif);
			}
		}
		LinkData.getObjects(workId, fileName, subject, posProperty, showMaxCircadianMotif);
		*/
		this._getPropertyListAndCheckForValidSequence(workId, fileName, tripleList, 0);
	},
	
	_checkForValidnessBySequence : function(workId, fileName, posList, tripleList, subjectIndex) {
		var self = this, i = 0, subject = tripleList[subjectIndex].object;
		var seqProperty = self._motifProperty.getPropertyByLabel(self._options.motifSequenceProperty);
		var checkForValidSequence = function(seqTripleList) {
			var found = false;
			$.each(seqTripleList, function(seqKey, seqValue) {
				var tmpPos = parseInt(posList[i]);
				if (self._isPositionValid(seqValue,tmpPos)) {
					self._motifMaxCircadianSequence(workId, fileName, subject);
					found = true;
					return false;
				}
				i++;
			});
			
			if (!found) {
				subjectIndex++;
				self._getPropertyListAndCheckForValidSequence(workId, fileName, tripleList, subjectIndex);
			}
		}
		LinkData.getObjects(workId, fileName, subject, seqProperty, checkForValidSequence);
	},
	
	_getPropertyListAndCheckForValidSequence : function(workId, fileName, tripleList, subjectIndex) {
		var self = this, i = 0, subject = tripleList[subjectIndex].object;
		var posProperty = self._motifProperty.getPropertyByLabel(self._options.motifPositionProperty);
		var checkProperties = function(posTripleList) {
			//var found = false;
			self._checkForValidnessBySequence(workId, fileName, posTripleList, tripleList, subjectIndex);
		}
		LinkData.getObjects(workId, fileName, subject, posProperty, checkProperties);
	},
	
	_isPositionValid : function(sequence,position) {
		var tHold = Math.floor(sequence.length / 2);
		var motifCorectedStartingPoint = position - (sequence.length / 2);
		var suffixLen = this._options.baseSequence.length - (tHold + position);
		if (motifCorectedStartingPoint >= this._options.baseSequenceMinLength && suffixLen >= 0) {
			return true;
		} else {
			return false;
		}
	},
	
	_getMaxCircadianTriple : function(range, sinePhaseTripleList, amplitudeTripleList) {
		var self = this, arr = range.split("-");
		var startValue = parseFloat(arr[0]), endValue = parseFloat(arr[1]);
		var maxIndex = -1, maxValue = -99999;
		$.each (sinePhaseTripleList, function(tKey, tValue) {
			var tmpVal = parseFloat(tValue.object);
			if (tmpVal != endValue && Math.max(tmpVal, startValue) == tmpVal && Math.min(tmpVal, endValue) == tmpVal) {
				$.each (amplitudeTripleList, function(aKey, aValue) {
					if (tValue.subject == aValue.subject) {
						var amplitude = parseFloat(aValue.object);
						if (Math.max(maxValue, amplitude) != maxValue) {
							maxValue = amplitude;
							maxIndex = aKey;
						}	
					}
				});
			}
		});
		if (maxIndex != -1) {
			return amplitudeTripleList[maxIndex];
		}
	},
	
	_getDataBaseWebsiteName : function() {
		var self = this;
		var fileName = self._options.fileName
		if (fileName.indexOf(self._options.websiteNameAtted) > -1) {
			return self._options.websiteNameAtted;
		} else if (fileName.indexOf(self._options.websiteNamePpdb) > -1) {
			return self._options.websiteNamePpdb;
		} else {
			return "UNKNOWN";
		}
	},
	
	_getGeneType : function() {
		var self = this, fileName = self._options.fileName;
		if (fileName.indexOf(self._options.geneTypeAtted) > -1) {
			return self._options.geneTypeAtted;
		} else if (fileName.indexOf(self._options.geneTypePpdb) > -1) {
			return self._options.geneTypePpdb;
		} else {
			return "UNKNOWN";
		}
	},
	
	_motifMaxCircadianSequence : function(workId, fileName, subject) {
		var self = this;
		var drawSequence = function(seqHtml) {
			var sb = [];
			sb[sb.length] = "<input type='hidden' class='" + self._default.geneLabelClass + "' value='" + subject + "'/>";
			sb[sb.length] = "<div class='baseSequence'>" + self._baseSequence + "</div>";
			sb[sb.length] = seqHtml;
			$("#" + self._containerId + " ." + self._options.resultAreaClass).html(sb.join(""));
			if (seqHtml.length == 0) {
				$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).hide();
			}
			self._motifView._initMotifSequenceListener();
			self._initReplaceButtonLitener();
			self._showDataBaseInformationList();
			self._showGenePlot(subject);
			$("#" + self._containerId + " ." + self._options.resultAreaClass).show();
			$("#" + self._containerId + " ." + self._options.resultAreaClass).scrollLeft(10000);
			$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).show();
			$("#" + self._containerId + " ." + self._options.resultAreaUserMessageClass).show();
			$("#" + self._containerId + " ." + self._options.loadingImageContainer).hide();
		}
		self._appSequence.getSequenceHtml(subject, drawSequence);
	},
	/*
	_getMinPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 1 : 0.5;
		return self._default.baseSequenceMinLength + Math.floor(seq.length / 2) + tHold;
	},*/
	/*
	_getMaxPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 0 : 0.5;
		return self._baseSequence.length - 1 - Math.floor(seq.length / 2) + tHold;
	},*/
	
	_getSeqElBySeq : function(seq) {
		if (seq && seq.trim().length == 7) {
			return this._heptamer.getBySequence(seq);
		} else if (seq && seq.trim().length == 8) {
			return this._octamer.getBySequence(seq);
		}
	},
	
	_showDatabaseInfo : function(seqVal) {
		var self = this, workId = self._options.workId, fileName = self._options.fileName, appName = self._options.appName;
		var propLabel = $("option:selected", "#" + self._containerId + " ." + self._options.selectPropertyClass).val();
		var subject = $("#" + self._containerId + " ." + self._options.geneLabelClass).val();
		var label = self._motifProperty._getDisplayLabel(propLabel);
		label = (label && label.trim().length != 0) ? label : propLabel;
		var usedMotif = (seqVal.length != 0) ? seqVal : "-";
		var dbInfoHtml = self._getDatabaseInfo(workId, fileName, appName, subject, label, usedMotif);
		$("#" + self._containerId + " ." + self._options.databaseInfoClass).html(dbInfoHtml);
		$("#" + self._containerId + " ." + self._options.databaseInfoClass).show();
		self._previewListener(subject);
	},
	
	_previewListener : function(subject) {
		var self = this;
		var gene = self._motifProperty.getGeneBySubject(subject);
		self._dbPreviewListener();
		self._genePreviewListener(subject);
		self._attedPreviewListener(subject);
		self._ppdbPreviewListener(gene);
		self._efpPreviewListener(gene);
		self._hannaDbPreviewListener(gene);
	},
	
	_dbPreviewListener : function() {
		var self = this;
		var workId = self._options.workId, fileName = self._options.fileName;
		var url = self._options.serverUrl + "work/" + workId + "/" + fileName + ".html#work_information";
		$("#" + self._containerId + " ." + self._options.dbInfoLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_genePreviewListener : function(subject) {
		var self = this;
		$("#" + self._containerId + " ." + self._options.geneInfoLinkClass).click(function() {
			self._showPopupWindow(subject);
		});
	},
	
	_attedPreviewListener : function(subject) {
		var self = this;
		$("#" + self._containerId + " ." + self._options.geneInfoAttedLinkClass).click(function() {
			self._showPopupWindow(subject);
		});
	},
	
	_ppdbPreviewListener : function(gene) {
		var self = this;
		var url = "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene=" + gene.toString().toUpperCase();
		$("#" + self._containerId + " ." + self._options.geneInfoPpdbLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_efpPreviewListener : function(gene) {
		var self = this;
		var url = "http://bbc.botany.utoronto.ca/efp/cgi-bin/efpWeb.cgi?dataSource=Developmental_Map&modeInput=Absolute&primaryGene=" + gene;
		$("#" + self._containerId + " ." + self._options.geneInfoEfpLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_hannaDbPreviewListener : function(gene) {
		var self = this;
		var url = "http://evolver.psc.riken.jp/seiken/GENE/" + gene.toUpperCase() + ".html";
		$("#" + self._containerId + " ." + self._options.geneInfoHannaDbLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_getDatabaseInfo : function(workId, fileName, method, subject, property, motif) {
		var self = this;
		var gene = self._motifProperty.getGeneBySubject(subject);
		var sb = [];
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Database</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<span title='" + self._tooltip.getByKey(fileName) + "'>" + fileName + "</span>";
		sb[sb.length] = "<a href='javascript:void(0);' class='externalLink " + self._options.dbInfoLinkClass + "'>LinkData</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Tool</div>";
		sb[sb.length] = "<div class='left' title='" + self._tooltip.getByKey(self._tooltipName.motifCircatian) + "'>" + method + "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Gene Locus</div>";
		sb[sb.length] = "<div class='left'>";
		//sb[sb.length] = "<a href='javascript:void(0);' class='externalLink " + self._options.geneInfoLinkClass + "'>" + gene + "</a>";
		sb[sb.length] = "<span>" + gene + "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Motif Analysis Links</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.atted2) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoAttedLinkClass + "'>ATTED-II</a>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.ppdb) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoPpdbLinkClass + "'>PPDB</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>"
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Gene Expression Visualization Links</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.efp) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoEfpLinkClass + "'>eFP</a>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.hanaDb) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoHannaDbLinkClass + "'>HanaDB</a>"
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Range</div>";
		sb[sb.length] = "<div class='left'>" + property + "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Motif</div>";
		sb[sb.length] = "<div class='left motif'>" + motif + "</div>";
		sb[sb.length] = "</div>";
		return sb.join("");
	},
	/*
	_replaceWithSequence : function(seq, pos, extraCopies, basePairs) {
		var self = this, sb = [];
		//var html = self._appSequence.replaceWith(seq, pos, extraCopies, basePairs);
		self._placeMotifViewSequnce(seq, pos, extraCopies, basePairs);
		var html = self._appSequence.getReColoredMotifViewSequnce(seq, pos, extraCopies, basePairs, self._options.replaceSequenceClass);
		var subject = $("#" + self._containerId + " ." + self._options.geneLabelClass).val();
		var gene = self._motifProperty.getGeneBySubject(subject);
		var geneType = self._getGeneType();
		sb[sb.length] = html;
		sb[sb.length] = "<input type='hidden' class='gene' value='" + gene + "'/>";
		sb[sb.length] = "<input type='hidden' class='geneType' value='" + geneType + "'/>";
		$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html(sb.join(""));
		$("#" + self._containerId + " ." + self._options.replaceSequenceClass).show();
		$("#" + self._containerId + " ." + self._options.replaceSequenceClass).scrollLeft(10000);
		var seqLabel = seq + "[" + pos + "]";
		self._showDatabaseInfo(seqLabel);
		self._options.callback();
	},*/
	/*
	_placeMotifViewSequnce : function(seq, pos, extraCopies, basePairs) {
		var self =this,conflictArray = [];
		var corPos;
		//replaceSequenceByOption 
		var oldSequence = $("#" + self._containerId + " ." + self._options.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		for (var j = 0; j < extraCopies + 1; j++) {
			if (j == 0) {
				corPos = pos;
			} else {
				corPos = corPos + (basePairs) + (seq.length);
			}
			if (self._hasConfliction(seq, corPos, oldSequence)) {
				conflictArray.push(seq + "|" + corPos);
			} else {
				self._replaceSequenceByOption("new", seq, corPos);
			}	
			self._handleConfliction(conflictArray);
		}
		//return out.join(""); 
	}*/
};

Application.Util = function() {
	this._init.apply(this, arguments);		
}

Application.Util.prototype = {
	
	_containerId : null,
	_errTextClass : null,
	_manualMotifErrorDialogId : null,
	_baseSequenceMinLength : null,
	_baseSequenceLength : null,
	
	_init : function(args) {
		this._containerId = args.containerId;
		this._errTextClass = args.errTextClass;
		this._baseSequenceMinLength = args.baseSequenceMinLength;
		this._baseSequenceLength = args.baseSequenceLength;
		
		this._motifErrorDialogId = "_manulaMotifMotif_Err_Dialog_" + this._containerId;
		this._initMotifInitErrDialogView();
		this._initMotifErrorDialog();
	},
	
	_initMotifInitErrDialogView : function() {
		var sb = [];
		sb[sb.length] = "<div id='"+ this._motifErrorDialogId +"' class='hidden'>";
		sb[sb.length] = "<div>Following error(s) found while trying to add the add/place the motif</div>";
		sb[sb.length] = "<ul class='motiferror'></ul>";
		sb[sb.length] = "</br>";
		sb[sb.length] = "<div>Would you like to correct it automatically ?</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},

	_initMotifErrorDialog : function() {
		var self = this;
		$("#" + self._motifErrorDialogId).dialog({
			autoOpen: false,
			width: 600,
			model: true
		});
	},
	
	_validateManulMotifCenterPosition : function(sequnceLength,position) {
		if (sequnceLength > 0) {
			$("#" + this._motifErrorDialogId + " .motiferror").html("");
			var corProsition = this.getCalculatedMotifInsertRange(sequnceLength);
			position = Math.abs(position);
			if ((position < corProsition.startPoint) || (position > corProsition.endPoint)) {
				position = corProsition.startPoint;
				this._putManulMotifError("Defined position is out of range. So assigned the default postion as -" + position);
			}	
			var val = sequnceLength % 2;
			position = Math.abs(position);
			var havingDecimalEntry = (position.toString().indexOf(".") != -1) ? true : false;
			if (val > 0) {
				// odd length case
				if (havingDecimalEntry == true) {
					position = position.toString().split(".")[0];
					this._putManulMotifError("Since the sequnce lenght is an odd no, the correct postion should be - " + position);
				}
			} else {
				//even length case
				if (havingDecimalEntry == false) {
					position = position + 0.5;
					this._putManulMotifError("Since the sequnce lenght is an even no, the correct postion should be - " + position);
				}else {
					var decPart = position.toString().split(".")[1];
					if (decPart != "5") {
						position = position.toString().split(".")[0] + ".5";
						this._putManulMotifError("The sequnce lenght is an odd no. For odd lengths, the correct postion should be - " + position);
					}
				}
			}
		}
		return position;
	},
	
	_putManulMotifError : function(errInfo) {
		var errText = $("#" + this._motifErrorDialogId + " .motiferror");
		var content = errText.html();
		errText.html(content + "</br>" + "<li><span class='"+ this._errTextClass +"'>" + errInfo + "</span></li>");
	},
	
	getCalculatedMotifInsertRange : function(sequnceLength) {
		var centerPos = Math.floor(sequnceLength / 2);
		var corStartPoint = this._baseSequenceMinLength + centerPos;
		var corEndPoint = this._baseSequenceLength - centerPos;
		if (this.isValueEven(sequnceLength) == false) {
			corStartPoint = corStartPoint + 1;
		} else {
			corStartPoint = corStartPoint + 0.5;
			corEndPoint = corEndPoint + 0.5;
		}
		var obj = {
			startPoint : corStartPoint,
			endPoint : corEndPoint
		};
		return obj;
	},
	
	isValueEven : function(val) {
		var val = val % 2;
		if (val > 0) {
			return false;	
		} else {
			return true;
		}
	},
	
	_getMotifEntryErrButtonArray : function(correctPos,textEleRef) {
		var self = this;
		return [
				{
					text: "Yes",
					click : function() {
						$(textEleRef).val("-" + Math.abs(correctPos));
						$(this).dialog("close");
					}
				},
				{
					text: "No",
					click : function() {
						$(this).dialog("close");
					}
				}
			];
	},
	
	_showMotifErrorDialog : function(corectedPos,textEleRef) {
		var bArray = this._getMotifEntryErrButtonArray(corectedPos,textEleRef);
		var dialogTitle =  "Motif Insert/Place Errors";
		$("#" + this._motifErrorDialogId).dialog({title : dialogTitle});
		$("#" + this._motifErrorDialogId).dialog({buttons : bArray});
		$("#" + this._motifErrorDialogId).dialog("open");
	}
};

Application.MotifView = function() {
	this._init.apply(this, arguments);		
}

Application.MotifView.prototype = {
	
	_containerId : null,
	_motifViewAreaId : null,	
	_baseSequenceMinLength : null,
	_baseSequence : null,
	_replaceSequenceClass : null,
	_callerObj : null,
	_geneLabelClass : null,
	_motifViewErrDlgId : null,
	_appUtil : null,
	_motifMethod : null,
	
	_init : function(containerId,args) {
		date = new Date(); 
		this._containerId = containerId;
		this._baseSequenceMinLength = args.baseSequenceMinLength;
		this._baseSequence = args.baseSequence;
		this._replaceSequenceClass = args.replaceSequenceClass;
		this._callerObj = args.callerObj;
		this._geneLabelClass = args.geneLabelClass;
		this._motifMethod = args.motifMethod;
		this._motifViewAreaId = "motifViewDialog_id_" + this._containerId + "_" + date.getTime();
		this._motifViewErrDlgId = "motifViewErrDlg_Id_" + this._containerId + "_" + date.getTime();
		//this._initMotivViewErrDialogView();
		//this._initMotivViewErrDialog();
		this._initAppUtil();
	},
	
	defaults : {
		dialogErrorMessageClass : 'dialogErrorMessage',
		dialogOutRangeValueMessage : "Please input a value between {0} and {1}",
		geneLabelClass : "geneUrl"
	},
	/*
	_initMotivViewErrDialogView : function() {
		$("#" + this._motifViewErrDlgId).dialog({
			resizable: false,
      		modal: true,
			autoOpen: false,
			title: 'Invalid Motif Position'
		});	
		var buttons = [
				{
					text: "Ok",
					click : function() {
						$(this).dialog("close");
					}
				}
		];
		$("#" + this._motifViewErrDlgId).dialog({buttons:buttons});
	},
	
	_initMotivViewErrDialog : function() {
		$("#" + this._motifViewErrDlgId).dialog({
			resizable: false,
      		modal: true,
			autoOpen: false
		});	
	},*/
	
	_initAppUtil : function() {
		var self = this;
		var obj = {
			containerId : self._containerId,
			errTextClass : 'errorText',
			baseSequenceMinLength : self._baseSequenceMinLength,
			baseSequenceLength : self._baseSequence.length
		}
		self._appUtil = new Application.Util(obj);
	},
	
	getMotifViewHtml : function(sequnce) {
		var sb = [], self = this, date = new Date(); 
		sb[sb.length] = "<fieldset class='motifViewDialog'>";
		sb[sb.length] = "<legend>Motif view: edit the position and copy number of a motif</legend>";
		sb[sb.length] = "<div id='" + this._motifViewAreaId + "' class='hidden "+ sequnce +"'>";
		sb[sb.length] = "<input type='hidden' class='sequence'>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Place motif at position</span>";
		sb[sb.length] = "<input type='text' class='position'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation'>Replace with prefer position between ";
		sb[sb.length] = "<span class='minSeq'></span> and <span class='maxSeq'>";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Number of extra copies</span>";
		sb[sb.length] = "<input type='text' class='extraCopies' value='0'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Space between copies (Base Pairs)</span>";
		sb[sb.length] = "<input type='text' class='basePairs' value='0'/>";
		sb[sb.length] = "</div>";
		//sb[sb.length] = "<div class='motifImageArea'>";
		//sb[sb.length] = "<img src='" + this._options.dialogImageUrl + "'/>";
		//sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation explink'>Click ";
		//sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif from " + self._getDataBaseWebsiteName() + " website";
		sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='dialogErrorMessage errorMessage hidden'></span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<a id='motifview_placeMotif' class='btn btn-lightblue'>Place Motif</a>";
		sb[sb.length] = "&nbsp;";
		//sb[sb.length] = "<a id='motifview_cancel' class='btn btn-lightblue'>Cancel</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<fieldset class='motifviewinfo'>";
		sb[sb.length] = "<div style='float:left'>Motif Sequence:</div>";
		sb[sb.length] = "<div class='motifviewsequence'></div>";
		sb[sb.length] = "<div style='width=100%;float:left'>";
		//sb[sb.length] = "<span class='motifsequence' /></br>";
		sb[sb.length] = "<span class='motifmethod' /></br>";
		sb[sb.length] = "<span class='motifrecpos' />";
		sb[sb.length] = "</div>";;
		sb[sb.length] = "</fieldset>";
		sb[sb.length] = "</fieldset>";
		sb[sb.length] = "</div>";
		return sb.join("");
	},
		
	drawMotifView : function(sequence,appropriatePos) {
		var self = this;
		var htmlContent = this.getMotifViewHtml(sequence);
		var dialogSelector = "#" + self._motifViewAreaId + "." + sequence;
		//$("#" + this._containerId).append(htmlContent);
		$("#" + self._containerId + " ." + self._replaceSequenceClass).before(htmlContent);
		$(dialogSelector).find(".motifviewsequence").html(sequence);
		$(dialogSelector).find(".motifmethod").html("User Input: " + this._motifMethod);
		$(dialogSelector).find(".motifrecpos").html("Motif Recommended Position: -" + Math.abs(appropriatePos));
		$(dialogSelector).show();
		
		$(dialogSelector).find("#motifview_placeMotif").click(function() {
			var seq = $(dialogSelector).find(".sequence").val();
			var pos = Math.abs($(dialogSelector).find(".position").val());
			var extraCopies = parseInt($(dialogSelector).find(".extraCopies").val());
			var basePairs = parseInt($(dialogSelector).find(".basePairs").val());
			var minPos = parseFloat($(dialogSelector).find(".minSeq").html());
			var maxPos = parseFloat($(dialogSelector).find(".maxSeq").html());
			//if (minPos > pos || maxPos < pos) {
				//$("#" + self._motifViewErrDlgId + " .errinfo").html(self.defaults.dialogOutRangeValueMessage.replace("{0}", minPos).replace("{1}", maxPos));
				//$dialogError = $("#" + self._motifViewAreaId + " ." + self.defaults.dialogErrorMessageClass);
				//$dialogError.html(self.defaults.dialogOutRangeValueMessage.replace("{0}", minPos).replace("{1}", maxPos));
				//$dialogError.show();
				//$("#" + self._motifViewErrDlgId).dialog('open');
				//return;
			//}
			var position = self._appUtil._validateManulMotifCenterPosition(seq.length,pos);
			if (Math.abs(pos) != position) {
				self._appUtil._showMotifErrorDialog(position,$(dialogSelector).find(".position"));
			} else {
				$(dialogSelector).find(".position").val("-" + Math.abs(pos));
				self._replaceWithSequence(seq, pos, extraCopies, basePairs);
			}
			//self.hideError();
			//$(this).dialog("close");
		});
		/*
		$("#" + this._containerId).find("#motifview_cancel").click(function() {
			$("#" + self._motifViewDialogId).remove();
		});*/
	},
	
	_replaceWithSequence : function(seq, pos, extraCopies, basePairs) {
		var self = this, sb = [];
		self._placeMotifViewSequnce(seq, pos, extraCopies, basePairs);
		var html = self._callerObj._appSequence.getReColoredMotifViewSequnce(seq, pos, extraCopies, basePairs, self._replaceSequenceClass);
		self._callerObj._doReplaceWithHtml(html);
		/*
		var subject = $("#" + self._containerId + " ." + self._geneLabelClass).val();
		var gene = self._callerObj._motifProperty.getGeneBySubject(subject);
		var geneType = "";
		if (self._callerObj._getGeneType) {
			geneType = self._callerObj._getGeneType();
		}
		sb[sb.length] = html;
		sb[sb.length] = "<input type='hidden' class='gene' value='" + gene + "'/>";
		sb[sb.length] = "<input type='hidden' class='geneType' value='" + geneType + "'/>";
		$("#" + self._containerId + " ." + self._replaceSequenceClass).html(sb.join(""));
		$("#" + self._containerId + " ." + self._replaceSequenceClass).show();
		$("#" + self._containerId + " ." + self._replaceSequenceClass).scrollLeft(10000);
		var seqLabel = seq + "[" + pos + "]";
		self._callerObj._showDatabaseInfo(seqLabel);
		self._callerObj._options.callback();*/
	},
	
	_placeMotifViewSequnce : function(seq, pos, extraCopies, basePairs) {
		var self =this,conflictArray = [];
		var corPos;
		//replaceSequenceByOption 
		var oldSequence = $("#" + self._containerId + " ." + self._replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.defaults.resultAreaClass + " .baseSequence").html();
		}
		for (var j = 0; j < extraCopies + 1; j++) {
			if (j == 0) {
				corPos = pos;
			} else {
				corPos = corPos + (basePairs) + (seq.length);
			}
			if (self._callerObj._hasConfliction(seq, corPos, oldSequence)) {
				conflictArray.push(seq + "|" + corPos);
			} else {
				self._callerObj._replaceSequenceByOption("new", seq, corPos);
			}	
			self._callerObj._handleConfliction(conflictArray);
		}
		//return out.join(""); 
	},
	
	isMotifViewExists : function(sequnce) {
		if ($("#" + this._motifViewAreaId + "."+ sequnce).length > 0) {
			return true;	
		} else {
			return false;	
		}
	},
	
	_getMinPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 1 : 0.5;
		return self._baseSequenceMinLength + Math.floor(seq.length / 2) + tHold;
	},
	
	_getMaxPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 0 : 0.5;
		return self._baseSequence.length - 1 - Math.floor(seq.length / 2) + tHold;
	},
		
	_initPositionInsert : function(seq, pos) {
		return;
		var self = this;
		var mod = seq.length % 2;
		$("#" + self._motifViewAreaId + " .position").unbind("keyup");
		$("#" + self._motifViewAreaId + " .position").keyup(function() {
			var val = $(this).val();
			if (isNaN(val)) {
				$(this).val(pos);
				return;
			}
			var tmpVal = new String(Math.abs(val));
			if (mod == 0) {
				if (tmpVal.indexOf(".") == -1) {
					$(this).val(tmpVal + ".5");
				} else {
					$(this).val(tmpVal.split(".")[0] + ".5");
				}
			} else {
				if (tmpVal.indexOf(".") > -1) {
					$(this).val(tmpVal.split(".")[0]);
				}
			}
		});
	},
	
	_initMotifSequenceListener : function() {
		var self = this;
		$("#" + self._containerId + " .motifSequence").click(function() {
			//$("." + self._options.motifViewDialogClass).hide();
			var parent = $(this).closest('.userSequence');
			var container = $(this).closest('.userSequence');
			var seq = $(parent).find(".hdnSequence").val();
			//var pos = $(parent).find(".hdnPosition").val();
			var pos = $(parent).find(".hdnCorPosition").val();
			var appropriatePos = 0;
			var seqEl = null;
			if (self._callerObj._getSeqElBySeq) {
				seqEl = self._callerObj._getSeqElBySeq(seq);
				appropriatePos = (seqEl && seqEl.getAppropriatePos()) ? seqEl.getAppropriatePos() : pos;
			} else {
				appropriatePos = pos;
			}
			if (self.isMotifViewExists(seq) == false) {
				self.drawMotifView(seq,appropriatePos);
				self._initSequencePopup(seqEl,seq);
				var dialogSelector = "#" + self._motifViewAreaId + "." + seq;
				$(dialogSelector + " ." + self.defaults.dialogErrorMessageClass).hide();
				$(dialogSelector + " .sequence").val(seq);
				$(dialogSelector + " .position").val("-" + Math.abs(appropriatePos));
				$(dialogSelector + " .extraCopies").val(0);
				$(dialogSelector + " .basePairs").val(0);
				$(dialogSelector + " .minSeq").html(self._getMinPosition(seq));
				$(dialogSelector + " .maxSeq").html(self._getMaxPosition(seq));
				self._initPositionInsert(seq, appropriatePos);
				$(dialogSelector).show();
			}
			//$("#" + self._motifViewDialogId).dialog({title: self._default.motifViewDialogTitle + " - " + seq});
			//$("#" + self._motifViewDialogId).dialog("open");
			//$("#" + self._motifViewDialogId).closest('.' + self._options.motifViewDialogClass).show();
		});
	},
	
	_initSequencePopup : function(seqEl,sequence) {
		var self = this;
		var dialogSelector = "#" + self._motifViewAreaId + "." + sequence;
		$(dialogSelector + " .moreInfo").unbind("click");
		var url = (seqEl && seqEl.getExternalUrl()) ? seqEl.getExternalUrl() : "#";
		if (url == "#") {
			$(dialogSelector + " .explink").html("&nbsp");
		} else {
			$(dialogSelector + " .explink").show();
		}
		$(dialogSelector + " .moreInfo").click(function() {
			self._callerObj._showPopupWindow(url);
		});
	}
};

Application.geneChart = function() {
	this._init.apply(this, arguments);
};

Application.geneChart.prototype = {
	
	_containerId : null,
	_options : null,
	_workId : null,
	_fileName : null,
	_subject : null,
	_property : null,
	_highChartContainerId : null,
	_appProperty : null,
	
	_default : {
		filterNamespace : "http://linkdata.org/",
		acceptPropLabelPrefix : "label:",
		yAxisLabel : "Gene Expression Level"
	},
	
	_init : function(containerId, options) {
		this._containerId = containerId;
		this._options = $.extend({}, this._default, options);
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		this._subject = this._options.subject;
		this._property = this._options.property;
		var date = new Date();
		this._highChartContainerId = "gene_chart_" + date.getTime();
		this._initAppProperty(this._options);
		this._initView();
		this._drawHighChart(this._subject, this._property);
	},
	
	_initAppProperty : function(opts) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._appProperty = new Application.motifProperty(obj);
	},
	
	_initView : function() {
		var self = this;
		var sb = [];
		sb[sb.length] = "<div id='" + self._highChartContainerId + "'></div>";
		$("#" + self._containerId).html(sb.join(""));
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_drawHighChart : function(subject, highlightProperty) {
		var self = this;
		var getDataArray = function(tripleList) {
			var dataArray = [];
			var dataObject = {};
			var array = [];
			var duplicateProperty = [];
			$.each (tripleList, function(tKey, tValue) {
				var property = tValue.property;
				if (property.indexOf(self._options.filterNamespace) == -1) {
					return;
				}
				if ($.inArray(property, duplicateProperty) > -1) {
					return;
				}
				var label = self._getLabelAfterHash(property);
				if (!self._ignore(label)) {
					var val = parseFloat(tValue.object);
					if (highlightProperty === property) {
						val = self._getHighLightColumn(parseFloat(tValue.object));
					}
					array.push(val);
					duplicateProperty.push(property);
				}
			});
			dataObject.name = self._getLabel(subject);
			dataObject.data = array;
			dataArray.push(dataObject);
			self._getXCategory(tripleList, dataArray, highlightProperty);
		}
		LinkData.getTriplesBySubject(self._workId, self._fileName, subject, getDataArray);
	},
	
	_getXCategory : function(tripleList, dataArray, highlightProperty) {
		var self = this;
		var array = [];
		var duplicateProperty = [];
		var hLabel = self._getLabelAfterHash(highlightProperty);
		$.each (tripleList, function(tKey, tValue) {
			var property = tValue.property;
			if (property.indexOf(self._options.filterNamespace) == -1) {
				return;
			}
			if ($.inArray(property, duplicateProperty) > -1) {
				return;
			}
			var label = self._getLabelAfterHash(property);
			if (!self._ignore(label)) {
				var displayLabel = self._getDisplayLabel(label);
				var hDisplayLabel = self._getDisplayLabel(hLabel);
				if (displayLabel === hDisplayLabel) {
					displayLabel = "<span style=\"color:#FB3B44\">" + hDisplayLabel + "</span>";
				}
				array.push(displayLabel);
				duplicateProperty.push(property);
			}
		});
		self._drawChart(self._highChartContainerId, dataArray, array);
	},
	
	_getHighLightColumn : function(val) {
		var obj = {};
		obj.y = val;
		obj.marker = {
			lineWidth: 3,
			lineColor: "#FB3B44",
			fillColor: "#FB3B44"
		};
		return obj;
	},
	
	_drawChart : function(containerId, dataArray, xCategory) {
		var self = this;
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: containerId,
				type: 'line',
				marginRight: 130,
				marginBottom: 125
			},
			title: {
				text: self._fileName
			},
			xAxis: {
				categories: xCategory,
				labels : {
					rotation: 315
				}
			},
			yAxis: {
				title: {
        			text: self._default.yAxisLabel
    			}
			},
			tooltip: {
				formatter: function() {
					return '<b>'+ this.series.name + '</b><br/>' + this.x + ' [' + this.y + ']';
				}
			},
			legend: {
				layout: 'vertical',
				align: 'right',
				verticalAlign: 'top',
				x: -10,
				y: 100,
				borderWidth: 0
			},
			series: dataArray
 		});
	},
	
	_getLabel : function(value) {
		var self = this, label;
		if (value.indexOf("#") > -1) {
			label = self._getLabelAfterHash(value);
		} else {
			label = self._appProperty.getGeneBySubject(value);
		}
		if (!label) {
			label = value;
		}
		return label;
	},
	
	_getPropertyLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
			propLabel = this._appProperty.getPropertyNameByLabel(propLabel);
		}
		return propLabel;
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

Application.motifProperty = function() {
	this._init.apply(this, arguments);
};

Application.motifProperty.prototype = {

	_options : null,
	_propMap : null,
	_nameMap : null,
	_optionArray : null,
	
	_default : {
		acceptPropLabelPrefix : "label:",
		subjectATTEDUriPhrase : "http://atted.jp/data/locus/",
		subjectPPDBUriPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene="
	},
	
	_init : function(options) {
		this._options = $.extend({}, this._default, options);
		this._propMap = [];
		this._nameMap = [];
		this._initPropMap(this._options);
	},
	
	_initPropMap : function(opts) {
		var self = this, workId = opts.workId, fileName = opts.fileName;
		var method = function(properties) {
			self._fillPropMap(self, properties);
			self._initOptionArray(properties);
		}
		LinkData.getProperties(workId, fileName, method);
	},
	
	_fillPropMap : function(self, properties) {
		$.each(properties, function(key, value) {
			var label = self._getLabel(value);
			if (!self._propMap[label]) {
				self._propMap[label] = value;
			}
		});
	},
	
	_initOptionArray : function(propertyList) {
		var self = this, list = new Object();
		var workId = self._options.workId, fileName = self._options.fileName;
		self._optionArray = [];
		$.each(propertyList, function(key, value) {
			var propLabel = self._getLabel(value);
			if (!self._ignore(propLabel)) {
				var obj = {};
				obj.key = propLabel;
				obj.value = self._getDisplayLabel(propLabel);
				self._optionArray.push(obj);
			}
		});
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},

	getOptionArray : function() {
		return this._optionArray;
	},
	
	getPropertyByLabel : function(label) {
		return this._propMap[label];
	},
	
	getGeneBySubject : function(subject) {
		var self = this, htmlExt = ".html", geneLabel;
		if (subject.indexOf(self._default.subjectATTEDUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectATTEDUriPhrase, "");
		} else if (subject.indexOf(self._default.subjectPPDBUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectPPDBUriPhrase, "");
		}
		if (geneLabel && geneLabel.indexOf(htmlExt) > -1) {
			geneLabel = geneLabel.replace(htmlExt, "");
		}
		return geneLabel;
	}
	
};

Application.sequence = function() {
	this._init.apply(this, arguments);
};

Application.sequence.prototype = {
	
	CHAR_SEQ_EMPTY : "-",
	
	_options : null,
	_workId : null,
	_fileName : null,
	_seqProperty : null,
	_posProperty : null,
	_baseSequence : null,
	_sequenceList : null,
	_positionList : null,
	_containerId : null,
	_errorContainerClass : null,
	_outOfRangeArray : null,
	
	_default : {
		msgInvalidSequence: "invalid sequence.",
		msgOutOfRangeSequence: "Some motifs overlap the protected (minimal promoter) region : {0}",
	},
	
	_init : function(options) {
		this._options = options;
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		this._seqProperty = this._options.motifSequenceProperty;
		this._posProperty = this._options.motifPositionProperty;
		this._baseSequence = this._options.baseSequence;
		this._containerId = this._options.containerId;
		this._errorContainerClass = this._options.errorMessageClass;
	},
	
	_getCustomSequenceHtml : function(baseSequence, sequence, position) {
		var seqLen = sequence.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(position);
		var baseSeqLen = baseSequence.length;
		var suffixLen = baseSeqLen - (tHold + pos);
		var motifCorectedStartingPoint = position - (seqLen / 2);
		
		var sb = [];
		if (motifCorectedStartingPoint >= this._options.baseSequenceMinLength && suffixLen >= 0) {
			for (var i = 0; i < suffixLen; i++) {
				sb.push(this.CHAR_SEQ_EMPTY);
			}
			sb.push("<a href='javascript:void(0)' class='motifSequence'>" + sequence + "</a>");
			sb.push("<input type='hidden' class='hdnSequence' value='" + sequence + "'/>");
			sb.push("<input type='hidden' class='hdnPosition' value='" + pos + "'/>");
			sb.push("<input type='hidden' class='hdnCorPosition' value='-" + position + "'/>");
		} else {
			//_showError($appContainer, opts.msgOutOfRangeSequence.replace("{0}", sequence));
			this._outOfRangeArray.push(sequence + "[-" + position + "]");
			this._showError(this._default.msgOutOfRangeSequence.replace("{0}", this._outOfRangeArray.join(", ")));
		}
		return sb.join("");
	},
	
	_isValidSequenceList : function(seqs) {
		var count = seqs.length;
		var maxlength = 0;
		for (var i = 0; i < count; i++) {
			if (seqs[i].length > maxlength) {
				maxlength = seqs[i].length;
			}
		}
		var result = true;
		for (var i = 0; i < maxlength; i++) {
			var chars = [];
			for (var j = 0; j < count; j++) {
				chars.push(seqs[j].charAt(i));
			}
			if (! this._isValidChars(chars.join(""))) {
				result = false;
				break;
			}
		}
		return result;
	},
	
	_isValidBaseReplacementMotif : function(baseSequence, seqs) {
		var self = this;
		var mergeSequence = this._getMergeCharSequence(seqs);
		var length = baseSequence.length;
		for (var i = 0; i < length; i++) {
			var bChar = baseSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			if (mChar !== this.CHAR_SEQ_EMPTY && bChar !== this.CHAR_SEQ_EMPTY && mChar !== bChar) {
				return false;
			}
		}
		return true;
	},
	
	_isValidChars : function(charString) {
		var charLen = charString.length;
		var result = true;
		var first = null;
		for (var i = 0; i < charLen; i++) {
			if (charString.charAt(i) == this.CHAR_SEQ_EMPTY) {
				continue;
			}
			if (! first) {
				first = charString.charAt(i);
			}
			var current = charString.charAt(i);
			if (current && first != current) {
				result = false;
				break;
			}
		}
		return result;
	},
	
	_getReplacedCustomSequence : function(seqs) {
		var mergeSequence = this._getMergeCharSequence(seqs);
		var maxlength = this._baseSequence.length;
		var sb = [];
		for (var i = 0; i < maxlength; i++) {
			var bChar = this._baseSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			if (mChar !== this.CHAR_SEQ_EMPTY) {
				// replaced
				sb.push(mChar);
			} else {
				sb.push(bChar);
			}
		}
		
		return sb.join("");
	},
	
	_getMergeCharSequence : function(seqs) {
		var count = seqs.length;
		var maxlength = this._baseSequence.length;
		var sb = [];
		for (var i = 0; i < maxlength; i++) {
			var chars = [];
			for (var j = 0; j < count; j++) {
				chars.push(seqs[j].charAt(i) ? seqs[j].charAt(i) : this.CHAR_SEQ_EMPTY);
			}
			sb.push(this._getMergeChar(chars.join("")));
		}
		return sb.join("");
	},
	
	_getMergeChar : function(charString) {
		var charLen = charString.length;
		var result = null;
		for (var i = 0; i < charLen; i++) {
			if (charString.charAt(i) !== this.CHAR_SEQ_EMPTY) {
				result = charString.charAt(i);
				break;
			}
		}
		if (!result) {
			result = this.CHAR_SEQ_EMPTY;
		}
		return result;
	},
	
	_wrappedReplacedSequenceHtml : function(replaceSequence, seqs) {
		var self = this, sb = [];
		var mergeSequence = this._getMergeCharSequence(seqs);
		var length = this._baseSequence.length;
		for (var i = 0; i < length; i++) {
			var bChar = this._baseSequence.charAt(i);
			var rChar = replaceSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			var seqChar = (bChar !== rChar) ? "<span class='replace'>" + rChar + "</span>" : rChar;
			if (mChar !== this.CHAR_SEQ_EMPTY) {
				sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
			} else {
				sb.push(seqChar);
			}
		}
		return sb.join("");
	},
	
	_getSequenceAndPositionHiddenHtml : function(seqArray, posArray) {
		var self = this, sb = [];
		if (!seqArray || !posArray) {
			return sb.join("");
		}
		for (var i = 0; i < seqArray.length; i++) {
			sb[sb.length] = "<input type='hidden' class='hdnReplacedMotif' value='" + seqArray[i] + "|" + posArray[i] + "'/>";
		}
		return sb.join("");
	},
	
	_showError : function(message) {
		$errorMessageContainer = $("#" + this._containerId + " ." + this._errorContainerClass);
		$errorMessageContainer.html(message);
		$errorMessageContainer.show();
	},
	
	getHtmlByReplacingOldSequence : function(oldSequence, newSequence) {
		var self = this, sb = [];
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			var seqChar = (oChar !== nChar) ? "<span class='replace'>" + oChar + "</span>" : oChar;
			if (nChar !== self.CHAR_SEQ_EMPTY) {
				if (oChar !== self.CHAR_SEQ_EMPTY) {
					sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
				} else {
					sb.push(nChar);
				}
			} else {
				sb.push(oChar);
			}
		}
		return sb.join("");
	},
	
	getHtmlByReplacingNewSequence : function(oldSequence, newSequence) {
		var self = this, sb = [];
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			var seqChar = (oChar !== nChar) ? "<span class='replace'>" + nChar + "</span>" : nChar;
			if (nChar !== self.CHAR_SEQ_EMPTY) {
				sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
			} else {
				sb.push(oChar);
			}
		}
		return sb.join("");
	},
	
	getSequenceHtml : function(subject, drawSequence) {
		var self = this;
		self._outOfRangeArray = [];
		var sb = [], baseSequence = self._baseSequence;
		var getTriplesBySequenceProperty = function(sequenceList) {
			self._getTriplesBySequenceProperty(subject, drawSequence, sequenceList);
		}
		LinkData.getObjects(self._workId, self._fileName, subject, self._seqProperty, getTriplesBySequenceProperty);
	},
	
	_getTriplesBySequenceProperty : function(subject, drawSequence, sequenceList) {
		var self = this;
		var getTriplesByPositionProperty = function(positionList) {
			self._drawSequenceList(drawSequence, sequenceList, positionList);
		}
		LinkData.getObjects(self._workId, self._fileName, subject, self._posProperty, getTriplesByPositionProperty);
	},
	
	_drawSequenceList : function(drawSequence, sequenceList, positionList) {
		var self = this, sb = [];
		if (!sequenceList || sequenceList.length == 0) {
			return;
		}
		for (var i = 0; i < sequenceList.length; i++) {
			var customSeqString = self._getCustomSequenceHtml(self._baseSequence, sequenceList[i], positionList[i]);
			if (customSeqString.length > 0) {
				sb.push("<div>");
				sb.push("<div class='userSequence'>" + customSeqString + "</div>");
				sb.push("&nbsp;<span class='deletelink "+ sequenceList[i] +"' onclick='self._deleteUserSequence("+ "&quot;" + sequenceList[i] + "&quot;" +","+ "&quot;" + self._containerId + "&quot;" +");'>");
				sb.push("<img src='http://app.linkdata.org/asset/c6bf2a0f.png' title='Delete' /></span>");
				//sb.push("<div>&nbsp;</div>");
				sb.push("</div>");
			}
		}
		sb.push("<div>&nbsp;</div>");
		drawSequence(sb.join("\n"));
	},
	
	getFormattedSequence : function(baseSeqLen, seq, pos) {
		var self = this, sb = [];
		var seqLen = seq.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(pos);
		var len = baseSeqLen - (tHold + pos);
		for (var i = 0; i < len; i++) {
			sb[sb.length] = self.CHAR_SEQ_EMPTY;
		}
		sb[sb.length] = seq;
		return sb.join("");
	},
	
	replace : function(seqs, seqArray, posArray) {
		var self = this, isValid = self._isValidSequenceList(seqs);
		if (isValid) {
			if (seqs.length > 0) {
				var sb = [];
				var replaceSeq = self._getReplacedCustomSequence(seqs);
				sb[sb.length] = self._wrappedReplacedSequenceHtml(replaceSeq, seqs);
				sb[sb.length] = self._getSequenceAndPositionHiddenHtml(seqArray, posArray);
				return sb.join("");
			}
		} else {
			this._showError(self._default.msgInvalidSequence);
		}
	},
	
	replaceWith : function(seq, pos, extraCopies, basePairs) {
		var main = [], seqArray = [], posArray = [];
		var seqLen = seq.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(pos);
		var baseSeqLen = this._baseSequence.length;
		var len = baseSeqLen - (tHold + pos);
		seqArray.push(seq);
		posArray.push(pos);
		for (var j = 0; j < extraCopies + 1; j++) {
			var array = [];
			for (var i = 0; i < len; i++) {
				array.push(this.CHAR_SEQ_EMPTY);
			}
			array.push(seq);
			main.push(array.join(""));
			len = len - seqLen - basePairs;
			if (len < 0) {
				break;
			}
		}
		//return this.replace(main, seqArray, posArray);
		return main;
	},
	
	getReColoredMotifViewSequnce : function(seq, pos, extraCopies, basePairs, replaceDivClass) {
		
		var self = this;
		var sb = [];
		
		var seqs = self.replaceWith(seq, pos, extraCopies, basePairs);
		var replaceSeq = self._getReplacedCustomSequence(seqs);
		var existingSequence = $("#" + self._containerId + " ." + replaceDivClass).text();
		var repSeqLen = replaceSeq.length;
		
		for (var index = 0 ; index < repSeqLen ; index++) {
			var oChar = existingSequence.charAt(index);
			var nChar = replaceSeq.charAt(index);
			//var seqChar = (oChar !== nChar) ? "<span class='replace'>" + nChar + "</span>" : nChar;
			if (index < (repSeqLen - 50)) {
				if (nChar == oChar && nChar !== self.CHAR_SEQ_EMPTY) {
					sb.push("<span class='highlight-sequence replace'>" + nChar + "</span>");
				} else {
					sb.push(oChar);
				} 
			} else {
				sb.push(oChar);
			}
		}
		//self._doReplaceWithHtml(sb.join(""));
		return sb.join("");
	},
	
	hideError : function() {
		$errorMessageContainer = $("#" + this._containerId + " ." + this._errorContainerClass).hide();
	}
	
};

Application.heptamer = function() {
	this._init.apply(this, arguments);
};

Application.heptamer.prototype = {
	
	_heptamerMap : null,
	_motifSequenceProperty : null,
	_appropriatePositionProperty : null,
	
	_default : {
		heptamerTag : "heptamer",
		filterSequencePropertyPhrase : "motif_sequence",
		filterMaxCEGPropertyPhrase : "maxCEG",
		filterAppropriatePosition : "Appropriateposition(%C2%B1%2040%20bp)"
	},
	
	_init : function() {
		this._heptamerMap = [];
		this._initHeptamerList();
	},
	
	_initHeptamerList : function() {
		var self = this;
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._initHeptamer(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._default.heptamerTag, getFilesByTag);
	},
	
	_initHeptamer : function(workId, fileName) {
		var self = this;
		var getPropertyList = function(propertyList) {
			self._initProperty(propertyList);
			self._getSequenceTriple(workId, fileName);
		}
		LinkData.getProperties(workId, fileName, getPropertyList);
	},
	
	_initProperty : function(propertyList) {
		var self = this;
		$.each(propertyList, function(propKey, propValue) {
			if (propValue.indexOf(self._default.filterSequencePropertyPhrase) > -1) {
				self._motifSequenceProperty = propValue;
			} else if (propValue.indexOf(self._default.filterAppropriatePosition) > -1) {
				self._appropriatePositionProperty = propValue;
			}
		});
	},
	
	_getSequenceTriple : function(workId, fileName) {
		var self = this;
		var getSequenceTripleList = function(sequenceTripleList) {
			self._fillHeptamerMap(workId, fileName, sequenceTripleList);
		}
		LinkData.getTriplesByProperty(workId, fileName, self._motifSequenceProperty, getSequenceTripleList);
	},
	
	_fillHeptamerMap : function(workId, fileName, sequenceTripleList) {
		var self = this;
		var getPositionTripleList = function(positionTripleList) {
			for (var i = 0; i < sequenceTripleList.length; i++) {
				var seqTriple = sequenceTripleList[i];
				var posTriple = positionTripleList[i];
				var seqEl = new Application.seqElement();
				seqEl.setExternalUrl(seqTriple.subject);
				seqEl.setSequence(seqTriple.object);
				seqEl.setAppropriatePos(posTriple.object);
				self._heptamerMap[seqTriple.object] = seqEl;
			}
		}
		LinkData.getTriplesByProperty(workId, fileName, self._appropriatePositionProperty, getPositionTripleList);
	},
	
	getBySequence : function(sequence) {
		return this._heptamerMap[sequence];
	}
	
};
	
Application.octamer = function() {
	this._init.apply(this, arguments);
}
	
Application.octamer.prototype = {
	
	_octamerMap : null,
	_motifSequenceProperty : null,
	_appropriatePositionProperty : null,
	
	_default : {
		octamerTag : "octamer",
		filterSequencePropertyPhrase : "sequence",
		filterAppropriatePosition : "Appropriate%20position"
	},
	
	_init : function() {
		this._octamerMap = [];
		this._initOctamerList();
	},
	
	_initOctamerList : function() {
		var self = this;
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._initOctamer(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._default.octamerTag, getFilesByTag);
	},
	
	_initOctamer : function(workId, fileName) {
		var self = this;
		var getProperties = function(propertyList) {
			self._initProperty(propertyList);
			self._getSequenceTriple(workId, fileName);
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_initProperty : function(propertyList) {
		var self = this;
		$.each(propertyList, function(propKey, propValue) {
			if (propValue.indexOf(self._default.filterSequencePropertyPhrase) > -1) {
				self._motifSequenceProperty = propValue;
			} else if (propValue.indexOf(self._default.filterAppropriatePosition) > -1) {
				self._appropriatePositionProperty = propValue;
			}
		});
	},
	
	_getSequenceTriple : function(workId, fileName) {
		var self = this;
		var getSequenceTripleList = function(sequenceTripleList) {
			self._fillOctamerMap(workId, fileName, sequenceTripleList);
		}
		LinkData.getTriplesByProperty(workId, fileName, self._motifSequenceProperty, getSequenceTripleList);
	},
	
	_fillOctamerMap : function(workId, fileName, sequenceTripleList) {
		var self = this;
		var getPositionTripleList = function(positionTripleList) {
			for (var i = 0; i < sequenceTripleList.length; i++) {
				var j = Math.floor(i / 2);
				var seqTriple = sequenceTripleList[i];
				var posTriple = positionTripleList[j];
				var seqEl = new Application.seqElement();
				seqEl.setExternalUrl(seqTriple.subject);
				seqEl.setSequence(seqTriple.object);
				seqEl.setAppropriatePos(posTriple.object);
				self._octamerMap[seqTriple.object] = seqEl;
			}
		}
		LinkData.getTriplesByProperty(workId, fileName, self._appropriatePositionProperty, getPositionTripleList);
	},
	
	getBySequence : function(sequence) {
		return this._octamerMap[sequence];
	}
	
};

Application.seqElement = function() {
	this._init.apply(this, arguments);
};

Application.seqElement.prototype = {
	
	_externalUrl : null,
	_sequence : null,
	_appropriatePos : null,
	
	_init : function() {},
	
	getExternalUrl : function() {
		return this._externalUrl;
	},

	setExternalUrl : function(externalUrl) {
		this._externalUrl = externalUrl;
	},
	
	getSequence : function() {
		return this._sequence;
	},
	
	setSequence : function(sequence) {
		this._sequence = sequence;
	},
	
	getAppropriatePos : function() {
		return this._appropriatePos;
	},
	
	setAppropriatePos : function(appropriatePos) {
		this._appropriatePos = appropriatePos;
	}
	
};

Application.timer = function() {
	this._init.apply(this, arguments);
};

Application.timer.prototype = {
	
	_delay : null,
	_retry : null,
	_maxRetry : null,
	
	_init : function() {
		this._delay = 1000;
		this._retry = 0;
		this._maxRetry = 1000;
	},
	
	call : function(func) {
		if (this._retry < this._maxRetry) {
			setTimeout(func, this._delay);
		}
		this._retry++;
	},
	
	setMaxRetryCount : function(no) {
		this._maxRetry = no;
	}
};

Application.index = function() {
	this._init.apply(this, arguments);
}

Application.index.prototype = {
	
	_start : null,
	_end : null,
	
	_init : function(start, end) {
		this._start = start;
		this._end = end;
	},
	
	getIndex : function() {
		return {start : this._start, end : this._end};
	},
	
	getItemCount : function() {
		return (this._end - this._start + 1);
	},
	
	increment : function() {
		var itemCount = this.getItemCount();
		this._start = this._start + itemCount;
		this._end = this._end + itemCount;
		return {start : this._start, end : this._end};
	},
	
	getStartIndex : function() {
		return this._start;
	},
	
	getEndIndex : function() {
		return this._end;
	}
	
};

Application.tooltip = function() {
	this._init.apply(this, arguments);
};

Application.tooltip.prototype = {
	
	_toolTipList : null,
	
	_default : {
		explanationProperty : "explanation"
	},
	
	_init : function() {
		this._toolTipList = [];
		this._initToolTip();
	},
	
	_initToolTip : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._getFilePropertyList(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, "tooltip", getFilesByTag);
	},
	
	_getFilePropertyList : function(workId, fileName) {
		var self = this;
		var index = new Application.index(1, 10000);
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				if (pValue.indexOf(self._default.explanationProperty) > -1) {
					self._getSubjectList(workId, fileName, pValue, index);
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_getSubjectList : function(workId, fileName, property, index) {
		var self = this;
		var getSubjects = function(subjectList) {
			self._getPropertyList(subjectList, workId, fileName, property, index);
		}
		LinkData.getSubjects(workId, fileName, getSubjects, index);
	},
	
	_getPropertyList : function(subjectList, workId, fileName, property, index) {
		var self = this;
		var getTriplesByProperty = function(tripleList) {
			self._addToolTipToList(subjectList, tripleList, workId, fileName, property, index);
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getTriplesByProperty, index);
	},
	
	_addToolTipToList : function(subjectList, tripleList, workId, fileName, property, index) {
		var self = this;
		for (var i = 0; i < subjectList.length; i++) {
			var key = self._getLabelAfterHash(subjectList[i]);
			if (tripleList[i]) {
				var value = tripleList[i].object;
				self._addToolTip(key, value);
			}
			//var value = tripleList[i].object;
			//self._addToolTip(key, value);
		}
		if (subjectList && subjectList.length == index.getItemCount()) {
			self._getSubjectList(workId, fileName, property, index.increment());
		}
	},
	
	_addToolTip : function(key, tooltip) {
		var obj = {};
		obj.key = key;
		obj.tooltip = tooltip;
		this._toolTipList.push(obj);
	},
	
	getByKey : function(key) {
		var self = this, tooltip;
		$.each(self._toolTipList, function(objKey, obj) {
			if (obj.key.toString().toLowerCase() === key.toString().toLowerCase()) {
				tooltip = obj.tooltip;
				return false;
			}
		});
		return (tooltip) ? tooltip : "";
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

$(document).ready(function() {
	var fillDatabase = function(resultList) {
		$(".motifMaxCircadianDatabase").append("<option value='-1' selected='selected'>-- Select Database --</option>");
		$.each(resultList, function(workId, fileList) {
			$.each(fileList, function(fileKey, fileName) {
				$(".motifMaxCircadianDatabase").append("<option value='" + workId + "|" + fileName + "'>" + fileName + "</option>");
			});
		});
		$(".motifMaxCircadianDatabase").change(function() {
			var dbKey = $("option:selected", $(this)).val();
			if (dbKey == -1) {
				$("#container").html("");
				return;
			}
			var array = dbKey.split("|");
			var containerId = "container";
			var options = {
				workId : array[0],
				fileName : array[1],
				//baseSequence : "GAAAAAAGACGTTCCAACCACGTCTTCAAAGCAAGTGATTGGATTAAGGTTCTTCCACACGGTAAGGGATGGCACTAACACCTACCATCCTTCGCAAGACCCTTCCTCTATATAAGGAAGTTCATTTCATTTGGAGAGGACCTCGAC"
				baseSequence : "------------------------------------------------------------------GGGATGGCAC---------------------GACCCTTCCTCTATATAAGGAAGTTCATTTCATTTGGAGAGGACCTCGAC"
			};
			new Application.motifMaxCircadian(containerId, options);
		});
	}
	LinkData.getFilesByTag(null, "database", fillDatabase);
});
