MotifNonCircadian = function(containerId, options) {
	//new Application.motifMaxCircadian(containerId, options);
	new Application.motifNonCircadian(containerId, options);
};

if (Application === "undefined" || !Application) {
	var Application = {};
}

//Application.motifMaxCircadian = function() {
Application.motifNonCircadian = function() {
	this._init.apply(this, arguments);
};

//Application.motifMaxCircadian.prototype = {
Application.motifNonCircadian.prototype = {
	
	_containerId : null,
	_baseSequence : null,
	_options : null,
	_tooltip : null,
	_motifProperty : null,
	_heptamer : null,
	_octamer : null,
	_appSequence : null,
	_motifViewDialogId : null,
	_addAnotherMotifDialogId : null,
	_motifConflictConfirmDialogId : null,
	_geneInfoContainerId : null,
	_motifView : null,
	_fixedSequence : null,
	_dataColl : null,
	_extLinks : null,
	_appMenuHandler : null,
	_rankListWorkId : null,
	_plotingWorkId : null,
	
	_default : {
		appName : "MotifNonCircadian",
		selectRangeCaption : "Select Range",
		selectPropertyAreaClass : "selectPropertyArea",
		selectPropertyClass : "selectProperty",
		resultAreaClass : "resultArea",
		replaceButtonAreaClass : "replaceButtonArea",
		replaceButtonClass : "replaceButton",
		nextButtonAreaClass : "nextButtonArea",
		replaceSequenceClass : "replaceSequence",
		errorMessageAreaClass : "errorMessage",
		dialogErrorMessageClass : "dialogErrorMessage",
		dialogOutRangeValueMessage : "Please input a value between {0} and {1}",
		noSequenceForThisRange : "No sequence found for this range",
		invalidDatabase : "Invalid database. Please select valid database.",
		databaseInfoClass : "databaseInfo",
		addAnotherMotifButtonClass : "addAnotherMotifButton",
		geneLabelClass : "geneUrl",
		dbInfoLinkClass : "dbInfoLink",
		geneInfoLinkClass : "geneInfoLink",
		geneInfoAttedLinkClass : "geneInfoAttedLink",
		geneInfoPpdbLinkClass : "geneInfoPpdbLink",
		geneInfoEfpLinkClass : "geneInfoEfpLink",
		geneInfoHannaDbLinkClass : "geneInfoHannaDbLink",
		motifSequenceProperty : "motif sequence",
		motifPositionProperty : "motif position",
		sinePhaseProperty : "Sine Phase",
		sineAmplitudeProperty : "Sine Amplitude",
		typeProperty : "type",
		validType : "REG",
		motifViewDialogId : "motifViewDialog",
		motifViewDialogClass : "motifViewDialog",
		motifViewDialogTitle : "Motif View",
		conflictionDialogTitle : "Confliction",
		minSequenceClass : "minSeq",
		maxSequenceClass : "maxSeq",
		websiteNameAtted : "ATTED",
		websiteNamePpdb : "PPDB",
		geneTypeAtted : "ATTED",
		geneTypePpdb : "PPDB",
		baseSequenceMinLength : 50,
		dialogImageUrl : "http://app.linkdata.org/asset/a06f4de4.png",
		callback : function() {},
		loadingImageContainer : "loadingImageContainer",
		loadingImageUrl : "http://app.linkdata.org/asset/67556085.gif",
		loadingMessageClass : "loadingMessage",
		fixedSequenceShowClass : "fixedSequenceMotif",
		wrappedMotifSequenceShowClass : "wrappedSequenceMotif",
		loadingMessage : "Loading linked data...",
		loadingMessageError : "There was an error with loading Linked data. Please refresh the browser",
		serverUrl : "http://linkdata.org/",
		resultAreaUserMessage : "Scroll Left/Right to inspect motifs from this promoter. Click on a motif sequence to enter the advanced motif view.",
		resultAreaUserMessageClass : "resultAreaUserMessageClass",
		normalizedFileIncludeWord : "normalized"
	},
	
	_tag : {
		topResult : "result_top",
		speedupDb : "motifcircadian"
	},
	
	_tooltipName : {
		selectRange : "Select Range",
		atted2 : "atted-ii",
		hanaDb : "HanaDB",
		efp : "eFP",
		ppdb : "ppdb",
		replace : "Add Motifs",
		manuallyInputMotif : "userinputmotif",
		motifExpress : "motifexpress",
		motifCircatian : "motifcircadian",
	},
	
	_init : function(containerId, options) {
		this._containerId = containerId;
		this._options = $.extend({}, this._default, options);
		this._baseSequence = this._options.baseSequence;
		this._fixedSequence = this._options.fixedSequence;
		this._dataColl = this._options.dataColl;
		this._rankListWorkId = this._options.rankListWorkId;
		this._plotingWorkId = this._options.plotingWorkId;
		var date = new Date();
		this._geneInfoContainerId = "gene_info_containerId_" + date.getTime();
		this._initToolTip();
		this._initMotifProperty(this._options);
		this._initAppSequence(this._options);
		this._initExternalLinks();
		this._initHeptamer();
		this._initOctamer();
		this._initView();
		this._initDialog();
		this._initMotifView(this._options);
	},
	
	_initExternalLinks : function() {
		this._extLinks = new Application.externalLink("MotifNonCircadian");
	},
	
	_initToolTip : function() {
		var self = this;
		self._tooltip = (self._options.tooltip) ? self._options.tooltip : new Application.tooltip();
	},
	
	_initMotifProperty : function(opts) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._motifProperty = new Application.motifProperty(obj);
	},
	
	_initMotifView : function(opts) {
		var self = this;
		var obj = {
			baseSequenceMinLength : opts.baseSequenceMinLength,
			baseSequence : self._baseSequence,
			replaceSequenceClass : opts.replaceSequenceClass,
			callerObj : self,
			geneLabelClass : opts.geneLabelClass,
			motifMethod : opts.motifMethod
		}
		this._motifView = new Application.MotifView(this._containerId,obj);
	},
	
	_initAppSequence : function(opts) {
		var self = this;
		var timer = new Application.timer();
		var init = function() {
			var seqProperty = self._motifProperty.getPropertyByLabel(self._options.motifSequenceProperty);
			var posProperty = self._motifProperty.getPropertyByLabel(self._options.motifPositionProperty);
			if (seqProperty && posProperty) {
				var obj = {
					workId : opts.workId,
					fileName : opts.fileName,
					baseSequence : self._baseSequence,
					motifSequenceProperty : seqProperty,
					motifPositionProperty : posProperty,
					containerId : self._containerId,
					errorMessageClass : self._options.errorMessageAreaClass,
					baseSequenceMinLength : self._options.baseSequenceMinLength
				};
				self._appSequence = new Application.sequence(obj);
			} else {
				timer.call(init);
			}
		}
		init();
	},
	
	_initHeptamer : function() {
		this._heptamer = new Application.heptamer();
	},
	
	_initOctamer : function() {
		this._octamer = new Application.octamer();
	},
	
	_initView : function() {
		this._initMainView();
		this._initAddAnotherMotifDialogView();
		this._initConflictConfirmDialogView();
	},
	
	_initDialog : function() {
		this._initAddAnotherMotifDialog();
		this._initMotifConflictConfirmDialog();
	},
	
	_initMainView : function() {
		var self = this;
		var timer = new Application.timer();
		var fillOptionMethod = function() {
			var optionArray = self._motifProperty.getOptionArray();
			if (optionArray) {
				var sb = [];
				sb[sb.length] = "<div class='" + self._options.selectPropertyAreaClass + " row'>";
				sb[sb.length] = "<div class='label left' title='" + self._tooltip.getByKey(self._tooltipName.selectRange) +"'>" + self._options.selectRangeCaption + "</div>";
				sb[sb.length] = "<div class='left'>";
				sb[sb.length] = "<select class='" + self._options.selectPropertyClass + "' title='" + self._tooltip.getByKey(self._tooltipName.selectRange) + "'>";
				sb[sb.length] = "<option title='" + self._tooltip.getByKey(self._tooltipName.selectRange) + "' value='-1'>-- Select Range --</option>";
				sb[sb.length] = "<option value='0-4'>0 to 4 Hours</option>";
				sb[sb.length] = "<option value='4-8'>4 to 8 Hours</option>";
				sb[sb.length] = "<option value='8-12'>8 to 12 Hours</option>";
				sb[sb.length] = "<option value='12-16'>12 to 16 Hours</option>";
				sb[sb.length] = "<option value='16-20'>16 to 20 Hours</option>";
				sb[sb.length] = "<option value='20-24'>20 to 24 Hours</option>";
				sb[sb.length] = "</select>";
				sb[sb.length] = "</div>";
				sb[sb.length] = "</div>";
				sb[sb.length] = "<div class='" + self._options.databaseInfoClass + " hidden'></div>";
				sb[sb.length] = "<div id='" + self._geneInfoContainerId + "'></div>";
				sb[sb.length] = "<div class='" + self._options.errorMessageAreaClass + " hidden'>error</div>";
				sb[sb.length] = "<div class='" + self._options.resultAreaClass + " hidden'></div>";
				sb[sb.length] = "<div class='" + self._options.resultAreaUserMessageClass + " hidden'>"+ self._options.resultAreaUserMessage +"</div>";
				sb[sb.length] = "<div class='" + self._options.replaceButtonAreaClass + " hidden'>";
				sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.replace) + "' class='" + self._options.replaceButtonClass + " btn btn-lightblue'>Add Motifs</a>&nbsp;";
				//sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.manuallyInputMotif) + "' class='" + self._options.addAnotherMotifButtonClass + " btn btn-lightblue'>Manually Input Motif</a>";
				sb[sb.length] = "</div>";
				sb[sb.length] = "<div class='" + self._options.replaceSequenceClass + " hidden'></div>";
				sb[sb.length] = "<div class='" + self._options.wrappedMotifSequenceShowClass + " hidden'></div>";
				sb[sb.length] = "<span class='" + self._options.fixedSequenceShowClass + " hidden'></span>";
				sb[sb.length] = "<div class='" + self._options.loadingImageContainer + " hidden' align='center'>";
				sb[sb.length] = "<div class='" + self._options.loadingMessageClass + "'>" + self._options.loadingMessage + "</div>";
				sb[sb.length] = "<div>";
				sb[sb.length] = "<img src='" + self._options.loadingImageUrl + "'/>";
				sb[sb.length] = "</div>";
				sb[sb.length] = "</div>";
				$("#" + self._containerId).html(sb.join(""));
				self._initListener();
				self._scrollDown();
			} else {
				timer.call(fillOptionMethod);
			}
		}
		fillOptionMethod();
	},
	
	_initAddAnotherMotifDialogView : function() {
		var sb = [], self = this, date = new Date(); 
		this._addAnotherMotifDialogId = "addAnotherMotifDialog_id_" + self._containerId + "_" + date.getTime();
		sb[sb.length] = "<div id='" + this._addAnotherMotifDialogId + "' class='hidden'>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='left'>Motif Sequence</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<input type='text' class='anotherSequence'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='left'>Position(-550 to -50)</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<input type='text' class='anotherPosition'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initConflictConfirmDialogView : function() {
		var sb = [], self = this, date = new Date(); 
		self._motifConflictConfirmDialogId = "motifConflictConfirmDialog_id_" + self._containerId + "_" + date.getTime();
		sb[sb.length] = "<div id='" + self._motifConflictConfirmDialogId + "' class='hidden'>";
		sb[sb.length] = "<div>New motif overlaps with old one. Which one should be kept in overalp regions?</div>";
		sb[sb.length] = "<div class='option'>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='new'/>&nbsp;New</label></div>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='old'/>&nbsp;Old</label></div>";
		sb[sb.length] = "<div><label><input type='radio' name='motifReplaceOption' value='discard'/>&nbsp;Discard new motif</label></div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<label><input type='checkbox' class='motifReplaceApplyToAll' value='applytoall'/>&nbsp;Apply to all</label>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},
	
	_initListener : function() {
		var self = this;
		self._initSelectPropertyListener();
		self._initAddAnotherMotifButtonListener();
	},
	
	_initSelectPropertyListener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		var timer = new Application.timer();
		var setSelectListener = function() {
			if ($("#" + self._containerId + " ." + self._options.selectPropertyClass).length != 0) {
				$("#" + self._containerId + " ." + self._options.selectPropertyClass).change(function() {
					$("#" + self._containerId + " ." + self._options.loadingImageContainer).show();
					$("#" + self._containerId + " ." + self._options.loadingImageContainer + " ." + self._options.loadingMessageClass).html(self._options.loadingMessage);
					self._appSequence.hideError();
					$("#" + self._containerId + " ." + self._options.resultAreaClass).hide();
					$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).hide();
					$("#" + self._containerId + " ." + self._options.resultAreaUserMessageClass).hide();
					$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html("");
					$("#" + self._containerId + " ." + self._options.replaceSequenceClass).hide();
					$("#" + self._containerId + " ." + self._options.databaseInfoClass).hide();
					$("#" + self._containerId + " #" + self._geneInfoContainerId).hide();
					var range = $("option:selected", this).val();
					if (range && range != -1) {
						//self._showMotifMaxCircadian(workId, fileName, range);
						self._showMotifNonCircadian(workId, fileName, range);
					}
					self._scrollDown();
				});
			} else {
				timer.call(setSelectListener);
			}
		}
		setSelectListener();
	},
	
	_initAddAnotherMotifButtonListener : function() {
		var self = this;
		$("#" + self._containerId + " ." + self._options.addAnotherMotifButtonClass).click(function() {
			self._appSequence.hideError();
			$("#" + self._addAnotherMotifDialogId + " .anotherSequence").val("");
			$("#" + self._addAnotherMotifDialogId + " .anotherPosition").val("");
			$("#" + self._addAnotherMotifDialogId).dialog("open");
		});
	},
	
	_showGenePlot : function(workId, fileName, subject, property) {
		var self = this;
		var plotWorkId;
		if (self._plotingWorkId == "-") {
			plotWorkId = workId;
		} else {
			plotWorkId = self._plotingWorkId
		}
		$("#" + self._containerId + " #" + self._geneInfoContainerId).show();
		var options = {
			workId : plotWorkId,
			fileName : self._getPlotFileName(fileName),
			originalFileName : fileName,
			subject : subject,
			property : property,
			appName : self._options.appName,
			dataCollection : self._dataColl,
			geneLocus : self._motifProperty.getGeneBySubject(subject)
		};
		new Application.geneChart(self._geneInfoContainerId, options);
	},
	
	_getPlotFileName : function(fileName) {
		if (fileName.indexOf("_mean") != -1) {
			var strComp = fileName.split("_mean");
			return strComp[0];
		} else if (fileName.indexOf("_median") != -1) {
			var strComp = fileName.split("_median");
			return strComp[0];
		} else {
			return fileName;
		}
	},
	
	_showDataBaseInformationList : function() {
		var self = this, seqVal = [];
		$("#" + self._containerId + " .userSequence .hdnSequence").each(function() {
			var tmpPos = $(this).siblings(".hdnCorPosition").val();
			seqVal.push($(this).val() + "[" + tmpPos + "]");
		});
		self._showDatabaseInfo(seqVal.join(", "));
	},
	
	_initReplaceButtonLitener : function() {
		var self = this, workId = self._options.workId, fileName = self._options.fileName;
		$("#" + self._containerId + " ." + self._options.replaceButtonClass).unbind("click");
		$("#" + self._containerId + " ." + self._options.replaceButtonClass).click(function() {
			var seqs = [], nonConflictSeqs = [], seqArray = [], posArray = [], conflictArray = [];
			$("#" + self._containerId + " .userSequence").each(function() {
				seqs.push($(this).text());
				var seq = $(this).find(".hdnSequence").val();
				var pos = $(this).find(".hdnPosition").val();
				seqArray.push(seq);
				posArray.push(pos);
				if (self._hasConfliction(seq, pos)) {
					conflictArray.push(seq + "|" + pos);
				} else {
					nonConflictSeqs.push($(this).text());
				}
			});
			$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html("");
			$("#" + self._containerId + " ." + self._options.replaceSequenceClass).hide();
			if (conflictArray.length > 0) {
				if (nonConflictSeqs.length > 0) {
					self._doReplace(nonConflictSeqs, seqArray, posArray);
				}	
				self._handleConfliction(conflictArray);
			} else {
				self._doReplace(seqs, seqArray, posArray);
			}
			self._scrollDown();
		});
	},
	
	_scrollDown : function() {
		$("html, body").animate({ scrollTop: $(document).height() }, 1000);
	},
	
	_hasConfliction : function(seq, pos, oldSequence) {
		var self = this;
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		var formattedSeq = self._appSequence.getFormattedSequence(self._baseSequence.length, seq, pos);
		var array = [formattedSeq];
		var newSequence = self._appSequence._getMergeCharSequence(array);
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			if (nChar !== "-" && oChar !== "-" && nChar !== oChar) {
				return true;
			}
		}
		return false;
	},
	
	_handleConfliction : function(conflictArray) {
		var self = this;
		if (conflictArray.length > 0) {
			var arr = conflictArray[0].split("|");
			var bArray = self._getConflictConfirmDialogButtonArray(conflictArray);
			var dialogTitle =  self._options.conflictionDialogTitle + " - " +  arr[0] + "[" + arr[1] + "]";
			$("#" + self._motifConflictConfirmDialogId).find("input[name='motifReplaceOption'][value='new']").attr("checked", "checked");
			var checkBox = $("#" + self._motifConflictConfirmDialogId).find("input[class='motifReplaceApplyToAll']");
			$(checkBox).attr("checked",$(checkBox).is(':checked'));
			$("#" + self._motifConflictConfirmDialogId).dialog({title : dialogTitle});
			$("#" + self._motifConflictConfirmDialogId).dialog({buttons : bArray});
			$("#" + self._motifConflictConfirmDialogId).dialog("open");
		} else {
			$("#" + self._motifConflictConfirmDialogId).find("input[class='motifReplaceApplyToAll']").attr("checked", "checked");
		}
	},
	
	_replaceWithOption : function(option, isApplyToAll, conflictArray) {
		var self = this;
		if (isApplyToAll) {
			self._replaceAllWithOption(option, conflictArray);
		} else {
			var value = conflictArray.splice(0, 1);
			var arr = value[0].split("|");
			self._replaceSequenceByOption(option, arr[0], arr[1]);
			self._handleConfliction(conflictArray);
		}
	},
	
	_replaceAllWithOption : function(option, conflictArray) {
		var self = this, html = oldSequence;
		var oldSequence = $("#" + self._containerId + " ." + self._options.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		$.each(conflictArray, function(key, conflict) {
			var arr = conflict.split("|");
			self._replaceSequenceByOption(option, arr[0], arr[1]);
		});
	},
	
	_replaceSequenceByOption : function(option, seq, pos) {
		var self = this;
		var oldSequence = $("#" + self._containerId + " ." + self._options.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		var formattedSeq = self._appSequence.getFormattedSequence(self._baseSequence.length, seq, pos);
		var seqArray = [formattedSeq];
		var newSequence = self._appSequence._getMergeCharSequence(seqArray);
		var html = oldSequence;
		if (option === "new") {
			html = self._appSequence.getHtmlByReplacingNewSequence(oldSequence, newSequence);
		} else if (option === "old") {
			html = self._appSequence.getHtmlByReplacingOldSequence(oldSequence, newSequence);
		}
		self._doReplaceWithHtml(html);
	},
	
	_getConflictConfirmDialogButtonArray : function(conflictArray) {
		var self = this;
		return [
				{
					text: "Done",
					click : function() {
						$(this).dialog("close");
						var option = $(this).find("input[name='motifReplaceOption']:checked").val();
						var isApplyToAll = $(this).find(".motifReplaceApplyToAll").is(":checked");
						self._replaceWithOption(option, isApplyToAll, conflictArray);
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog("close");
					}
				}
			];
	},
	
	_doReplace : function(seqs, seqArray, posArray) {
		var self = this;
		var html = self._appSequence.replace(seqs, seqArray, posArray);
		self._doReplaceWithHtml(html);
	},
	
	_doReplaceWithHtml : function(html) {
		var self = this, sb = [];
		var wrappedHtml = this._getAddedSquenceWithoutFixedSequence(html);
		var subject = $("#" + self._containerId + " ." + self._options.geneLabelClass).val();
		var gene = self._motifProperty.getGeneBySubject(subject);
		var geneType = self._getGeneType();
		sb[sb.length] = html;
		sb[sb.length] = "<input type='hidden' class='gene' value='" + gene + "'/>";
		sb[sb.length] = "<input type='hidden' class='geneType' value='" + geneType + "'/>";
		$("#" + self._containerId + " ." + self._default.wrappedMotifSequenceShowClass).show();
		$("#" + self._containerId + " ." + self._default.wrappedMotifSequenceShowClass).html(wrappedHtml);
		$("#" + self._containerId + " ." + self._options.replaceSequenceClass).html(sb.join("")); 
		var ref = $("#" + self._containerId + " ." + self._default.wrappedMotifSequenceShowClass);
		$(ref).animate({scrollTop: $(ref).height()}, 800);
		self._showDataBaseInformationList();
		self._options.callback();
	},
	
	_getAddedSquenceWithoutFixedSequence : function(html) {
		var index = html.lastIndexOf(this._fixedSequence);
		var length = index + this._fixedSequence.length;
		if (html.length == length) {
			var html = html.substr(0,index);
		}
		return html;
	},
	
	_addAnotherMotif : function(seq, pos) {
		var self = this, conflictArray = [];
		var oldSequence = $("#" + self._containerId + " ." + self._options.replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self._options.resultAreaClass + " .baseSequence").html();
		}
		if (self._hasConfliction(seq, pos, oldSequence)) {
			conflictArray.push(seq + "|" + pos);
		}
		if (conflictArray.length > 0) {
			self._handleConfliction(conflictArray);
		} else {
			self._replaceSequenceByOption("new", seq, pos);
		}
	},
	
	_showPopupWindow : function(url) {
		var winWidth = 800;
		var winHeight = 800;
		var winLeft = parseInt((screen.availWidth/2) - (winWidth/2));
		var winTop = parseInt((screen.availHeight/2) - (winHeight/2));
		var winStyle = "width=" + winWidth + ",height=" + winHeight + ",left=" + winLeft + ",top=" + winTop + ",screenX=" + winLeft + ",screenY=" + winTop + ",scrollbars=1";
		window.open(url, "Motif", winStyle);
	},
	
	_initAddAnotherMotifDialog : function() {
		var self = this;
		$("#" + self._addAnotherMotifDialogId).dialog({
			autoOpen: false,
			title: "Input Motif",
			buttons : [
				{
					text: "Add",
					click : function() {
						var seq = $(this).find(".anotherSequence").val();
						var pos = Math.abs($(this).find(".anotherPosition").val());
						if (seq && pos) {
							self._addAnotherMotif(seq, pos);
							$(this).dialog("close");
						}
					}
				},
				{
					text: "Cancel",
					click : function() {
						$(this).dialog("close");
					}
				}
			]
		});
	},
	
	_initMotifConflictConfirmDialog : function() {
		var self = this;
		$("#" + self._motifConflictConfirmDialogId).dialog({
			autoOpen: false,
			width: 420,
			dialogClass : "motifConflictionDialog"
		});
	},
	
//	_getMotifMaxCircadianTriple : function(workId, fileName, range) {
	_getMotifNonCircadianTriple : function(workId, fileName, range) {
		var self = this;
		var property = self._motifProperty.getPropertyByLabel(self._options.sinePhaseProperty);
		var amplitudeProperty = self._motifProperty.getPropertyByLabel(self._options.sineAmplitudeProperty);
		if (!property) {
			$("#" + self._containerId + " ." + self._options.loadingImageContainer).hide();
			self._appSequence._showError(self._options.invalidDatabase);
			return;
		}
		var index = new Application.index(1, 5000);
		//var maxCircadianTriple;
		var minCircadianTriple;
		var getSinePhasePropertyList = function(sinePhaseTripleList) {
			var getSineAmplitudePropertyList = function(amplitudeTripleList) {
				//var tmpMaxCircadianTriple = self._getMaxCircadianTriple(range, sinePhaseTripleList, amplitudeTripleList);
				//if (tmpMaxCircadianTriple) {
				var tmpNonCircadianTriple = self._getNonCircadianTriple(range, sinePhaseTripleList, amplitudeTripleList);
				if (tmpNonCircadianTriple) {
					//if (!maxCircadianTriple) {
					if (!minCircadianTriple) {
						//maxCircadianTriple = tmpMaxCircadianTriple;
						minCircadianTriple = tmpNonCircadianTriple;
					}
					//var tmpMaxValue = parseFloat(maxCircadianTriple.object);
					//var currentValue = parseFloat(tmpMaxCircadianTriple.object);
					//if (Math.max(tmpMaxValue, currentValue) != tmpMaxValue) {
					//	maxCircadianTriple = tmpMaxCircadianTriple;
					//}
					var tmpMinValue = parseFloat(minCircadianTriple.object);
					var currentValue = parseFloat(tmpNonCircadianTriple.object);
					if (Math.min(tmpMinValue, currentValue) != tmpMinValue) {
						minCircadianTriple = tmpNonCircadianTriple;
					}
				}
				if (sinePhaseTripleList && sinePhaseTripleList.length == index.getItemCount()) {
					LinkData.getTriplesByProperty(workId, fileName, property, getSinePhasePropertyList, index.increment());
				} else {
					//self._motifMaxCircadianSequence(workId, fileName, maxCircadianTriple.subject, property);
					self._motifNonCircadianSequence(workId, fileName, minCircadianTriple.subject, property);
				}
			}
			LinkData.getTriplesByProperty(workId, fileName, amplitudeProperty, getSineAmplitudePropertyList, index.getIndex());
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getSinePhasePropertyList, index.getIndex());
	},
	
	_monitorAppDataLoading : function() {
		var self = this;
		var maxRetry = 240; // 120 seconds
		var timer = new Application.timer(); 
		timer.setMaxRetryCount(maxRetry);
		var checkLoadingArea = function() {
			if (maxRetry == 0) {
				if (LinkData.activeAjaxConnections > 0) {
					maxRetry = 10;
					timer.call(checkLoadingArea);
				} else {
					$("#" + self._containerId + " ." + self._options.loadingMessageClass).html(self._options.loadingMessageError);
					$("#" + self._containerId + " ." + self._options.loadingImageContainer + " img").hide();
					return;
				}
				//$("#" + self._containerId + " ." + self._options.loadingMessageClass).html(self._options.loadingMessageError);
				//$("#" + self._containerId + " ." + self._options.loadingImageContainer + " img").hide();
				////alert("App loading error. please refresh");
				//return;
			}
			var dbInfoArea = $("#" + self._containerId + " ." + self._options.databaseInfoClass);
			if (!$(dbInfoArea).is(":visible")) {
				timer.call(checkLoadingArea);
			} else {
				return;
			}
			maxRetry--;
		};
		checkLoadingArea();
	},
	
	//_showMotifMaxCircadian : function(workId, fileName, range) {
	_showMotifNonCircadian : function(workId, fileName, range) {
		var self = this;
		var arr = range.split("-");
		var rangePhrase = "_" + arr[0] + "to" + arr[1]; 
		//var rangePhrase = arr[0] + "to" + arr[1]; 
		//var fileSuffix =  rangePhrase + "_top";
		var foundSpeedUpDbFile = false;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(wId, fileList) {
				$.each(fileList, function(fKey, fName) { 
					if (wId == self._rankListWorkId) {
						var propLabel = self._dataColl + rangePhrase;
						self._getTopFilePropertyList(workId, fileName, wId, fName, propLabel);
						foundSpeedUpDbFile = true;
						return false;
					}
					/*
					var speedUpFileName = null;
					// finding weather the file name containes the 'normalized' part
					var fileNameComps = fileName.split("_");
					var filePrefix = fileNameComps[0] + "_" + fileNameComps[1];
					if (fileNameComps.indexOf(self.normalizedFileIncludeWord) > -1) {
						// generating the normalize file name
						var speedUpFileName = filePrefix + self.normalizedFileIncludeWord + fileSuffix;
					} else {
						speedUpFileName = filePrefix + fileSuffix;
					}
					if (fName.toLowerCase().trim() == speedUpFileName.toLowerCase().trim()) {
						var propLabel = self._dataColl + rangePhrase;
						self._getTopFilePropertyList(workId, fileName, wId, fName, propLabel);
						foundTopFile = true;
						return false;
					}*/
				});
				if (foundSpeedUpDbFile) {
					return false;
				}
			});
			if (!foundSpeedUpDbFile) {
				//self._getMotifMaxCircadianTriple(workId, fileName, range);
				self._getMotifNonCircadianTriple(workId, fileName, range);
			}
		}
		self._monitorAppDataLoading();
		//LinkData.getFilesByTag(null, self._tag.topResult, getFilesByTag);
		LinkData.getFilesByTag(null, self._tag.speedupDb, getFilesByTag);
	},
	
	_getTopFilePropertyList : function(workId, fileName, speedUpDbWorkId, speedUpDbFileName, propLabel) {
		var self = this;
		var getProperties = function(propList) {
			$.each(propList, function(propKey, propValue) {
				var tmpProp = self._motifProperty._getLabel(propValue);
				if (tmpProp.indexOf(propLabel) > -1) {
				//	self._showMaxCircadian(workId, fileName, speedUpDbWorkId, speedUpDbFileName, propValue);
					self._getSubjectCountandShowMotifMin(workId, fileName, speedUpDbWorkId, speedUpDbFileName, propValue);
					return false;
				}
				/*var tmpProp = self._motifProperty._getLabel(propValue);
				var endsWithPhrase = tmpProp.match(range_phrase + "$");
				if (tmpProp.indexOf(self._dataColl) > -1 && endsWithPhrase) {
					self._showMaxCircadian(workId, fileName, speedUpDbWorkId, speedUpDbFileName, propValue);
					return false;
				}*/
			});
		}
		LinkData.getProperties(speedUpDbWorkId, speedUpDbFileName, getProperties);
	},
	
	//_showMaxCircadian : function(workId, fileName, speedUpDbWorkId, speedUpDbFileName, speedUpDbProperty, subjectCount) {
	_showMinCircadian : function(workId, fileName, speedUpDbWorkId, speedUpDbFileName, speedUpDbProperty, subjectCount) {
		var self = this;
		var index = new Application.index((subjectCount - 1000 ), subjectCount);
		var getTriplesByProperty = function(tripleList) {
			//self._showMotifMaxCircadianByTripleList(workId, fileName, tripleList);
			self._showMotifMinCircadianByTripleList(workId, fileName, tripleList);
		}
		LinkData.getTriplesByProperty(speedUpDbWorkId, speedUpDbFileName, speedUpDbProperty, getTriplesByProperty, index.getIndex());
	},


        _getSubjectCountandShowMotifMin : function(workId, fileName, speedUpDbWorkId, speedUpDbFileName,property ) {
                var self = this;
                var getSubjectsCount = function(count) {
                        //self._showMaxCircadian(workId, fileName,  speedUpDbWorkId, speedUpDbFileName, property, count)
                        self._showMinCircadian(workId, fileName,  speedUpDbWorkId, speedUpDbFileName, property, count)
                }
                LinkData.getSubjectsCount(speedUpDbWorkId,speedUpDbFileName,getSubjectsCount);
        },

	
	//_showMotifMaxCircadianByTripleList : function(workId, fileName, tripleList) {
	_showMotifMinCircadianByTripleList : function(workId, fileName, tripleList) {
		this._getPropertyListAndCheckForValidSequence(workId, fileName, tripleList, 0);
	},
	
	_checkForValidnessBySequence : function(workId, fileName, posList, tripleList, subjectIndex) {
		var self = this, i = 0, subject = tripleList[subjectIndex].object;
		var seqProperty = self._motifProperty.getPropertyByLabel(self._options.motifSequenceProperty);
		var checkForValidSequence = function(seqTripleList) {
			var found = false;
			$.each(seqTripleList, function(seqKey, seqValue) {
				var tmpPos = parseInt(posList[i]);
				if (self._isPositionValid(seqValue,tmpPos)) {
					//self._motifMaxCircadianSequence(workId, fileName, subject, seqProperty);
					self._motifNonCircadianSequence(workId, fileName, subject, seqProperty);
					//console.debug("found subject " + subject);
					found = true;
					return false;
				}
				i++;
			});
			
			if (!found) {
				subjectIndex++;
				self._getPropertyListAndCheckForValidSequence(workId, fileName, tripleList, subjectIndex);
			}
		}
		LinkData.getObjects(workId, fileName, subject, seqProperty, checkForValidSequence);
		
	},
	
	_getPropertyListAndCheckForValidSequence : function(workId, fileName, tripleList, subjectIndex) {
		var self = this, i = 0, subject = tripleList[subjectIndex].object;
		var posProperty = self._motifProperty.getPropertyByLabel(self._options.motifPositionProperty);
		var checkProperties = function(posTripleList) {
			self._checkForValidnessBySequence(workId, fileName, posTripleList, tripleList, subjectIndex);
		}
		LinkData.getObjects(workId, fileName, subject, posProperty, checkProperties);
	},
	
	_isPositionValid : function(sequence,position) {
		var tHold = Math.floor(sequence.length / 2);
		var motifCorectedStartingPoint = position - (sequence.length / 2);
		var suffixLen = this._baseSequence.length - (tHold + position);
		if (motifCorectedStartingPoint >= this._options.baseSequenceMinLength && suffixLen >= 0) {
			return true;
		} else {
			return false;
		}
	},
	
	//_getMaxCircadianTriple : function(range, sinePhaseTripleList, amplitudeTripleList) {
	_getNonCircadianTriple : function(range, sinePhaseTripleList, amplitudeTripleList) {
		var self = this, arr = range.split("-");
		var startValue = parseFloat(arr[0]), endValue = parseFloat(arr[1]);
		//var maxIndex = -1, maxValue = -99999;
		var minIndex = -1, minValue = 99999;
		$.each (sinePhaseTripleList, function(tKey, tValue) {
			var tmpVal = parseFloat(tValue.object);
			//if (tmpVal != endValue && Math.max(tmpVal, startValue) == tmpVal && Math.min(tmpVal, endValue) == tmpVal) {
			if (tmpVal != endValue && Math.min(tmpVal, startValue) == tmpVal && Math.min(tmpVal, endValue) == tmpVal) {
				$.each (amplitudeTripleList, function(aKey, aValue) {
					if (tValue.subject == aValue.subject) {
						var amplitude = parseFloat(aValue.object);
						//if (Math.max(maxValue, amplitude) != maxValue) {
						//	maxValue = amplitude;
						//	maxIndex = aKey;
						//}	
						if (Math.min(minValue, amplitude) != minValue) {
							minValue = amplitude;
							minIndex = aKey;
						}	
					}
				});
			}
		});
		//if (maxIndex != -1) {
		//	return amplitudeTripleList[maxIndex];
		//}
		if (minIndex != -1) {
			return amplitudeTripleList[minIndex];
		}
	},
	
	_getDataBaseWebsiteName : function() {
		var self = this;
		var fileName = self._options.fileName
		if (fileName.indexOf(self._options.websiteNameAtted) > -1) {
			return self._options.websiteNameAtted;
		} else if (fileName.indexOf(self._options.websiteNamePpdb) > -1) {
			return self._options.websiteNamePpdb;
		} else {
			return "UNKNOWN";
		}
	},
	
	_getGeneType : function() {
		var self = this, fileName = self._options.fileName;
		if (fileName.indexOf(self._options.geneTypeAtted) > -1) {
			return self._options.geneTypeAtted;
		} else if (fileName.indexOf(self._options.geneTypePpdb) > -1) {
			return self._options.geneTypePpdb;
		} else {
			return "UNKNOWN";
		}
	},
	
	//_motifMaxCircadianSequence : function(workId, fileName, subject, property) {
	_motifNonCircadianSequence : function(workId, fileName, subject, property) {
		var self = this;
		var drawSequence = function(seqHtml) {
			var sb = [];
			sb[sb.length] = "<input type='hidden' class='" + self._default.geneLabelClass + "' value='" + subject + "'/>";
			sb[sb.length] = "<div class='baseSequence'>" + self._baseSequence + "</div>";
			sb[sb.length] = seqHtml;
			$("#" + self._containerId + " ." + self._options.resultAreaClass).html(sb.join(""));
			if (seqHtml.length == 0) {
				$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).hide();
			}
			self._motifView._initMotifSequenceListener();
			self._initReplaceButtonLitener();
			self._showDataBaseInformationList();
			self._showGenePlot(workId, fileName, subject, property);
			$("#" + self._containerId + " ." + self._options.resultAreaClass).show();
			$("#" + self._containerId + " ." + self._options.resultAreaClass).scrollLeft(10000);
			$("#" + self._containerId + " ." + self._options.replaceButtonAreaClass).show();
			$("#" + self._containerId + " ." + self._options.resultAreaUserMessageClass).show();
			$("#" + self._containerId + " ." + self._options.loadingImageContainer).hide();
			self._scrollDown();
		}
		self._appSequence.getSequenceHtml(subject, drawSequence);
	},
	
	_getSeqElBySeq : function(seq) {
		if (seq && seq.trim().length == 7) {
			return this._heptamer.getBySequence(seq);
		} else if (seq && seq.trim().length == 8) {
			return this._octamer.getBySequence(seq);
		}
	},
	
	_showDatabaseInfo : function(seqVal) {
		var self = this, workId = self._options.workId, fileName = self._options.fileName, appName = self._options.appName;
		var propLabel = $("option:selected", "#" + self._containerId + " ." + self._options.selectPropertyClass).val();
		var subject = $("#" + self._containerId + " ." + self._options.geneLabelClass).val();
		var label = self._motifProperty._getDisplayLabel(propLabel);
		label = (label && label.trim().length != 0) ? label : propLabel;
		var usedMotif = (seqVal.length != 0) ? seqVal : "-";
		var dbInfoHtml = self._getDatabaseInfo(workId, fileName, appName, subject, label, usedMotif);
		$("#" + self._containerId + " ." + self._options.databaseInfoClass).html(dbInfoHtml);
		$("#" + self._containerId + " ." + self._options.databaseInfoClass).show();
		self._previewListener(subject);
		this._scrollDown();
	},
	
	_previewListener : function(subject) {
		var self = this;
		var gene = self._motifProperty.getGeneBySubject(subject);
		self._dbPreviewListener();
		self._initExternalLinksListner(gene);
	},
	
	_initExternalLinksListner : function(gene) {
		var self = this;
		$("#" + this._containerId + " .externalLink").click(function() {
			var curGene = gene;
			var url = $(this).attr("linkurl");
			if (!(url)) return;
			var geneCase = $(this).attr("genecase");
			if (geneCase == "U") {
				curGene = gene.toUpperCase();
			}
			url = url.replace("{0}",curGene);
			self._showPopupWindow(url);
		})
	},

	_dbPreviewListener : function() {
		var self = this;
		var workId = self._options.workId, fileName = self._options.fileName;
		var url = self._options.serverUrl + "work/" + workId + "/" + fileName + ".html#work_information";
		$("#" + self._containerId + " ." + self._options.dbInfoLinkClass).click(function() {
			self._showPopupWindow(url);
		});
	},
	
	_getDatabaseInfo : function(workId, fileName, method, subject, property, motif) {
		var self = this;
		var gene = self._motifProperty.getGeneBySubject(subject);
		var sb = [];
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Database</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<span title='" + self._tooltip.getByKey(fileName) + "'>" + fileName + "</span>";
		sb[sb.length] = "<a href='javascript:void(0);' class='externalLink " + self._options.dbInfoLinkClass + "'>LinkData</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Tool</div>";
		sb[sb.length] = "<div class='left' title='" + self._tooltip.getByKey(self._tooltipName.motifCircatian) + "'>" + method + "</div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Gene Locus</div>";
		sb[sb.length] = "<div class='left'>";
		//sb[sb.length] = "<a href='javascript:void(0);' class='externalLink " + self._options.geneInfoLinkClass + "'>" + gene + "</a>";
		sb[sb.length] = "<span>" + gene + "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		/*
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Motif Analysis Links</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.atted2) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoAttedLinkClass + "'>ATTED-II</a>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.ppdb) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoPpdbLinkClass + "'>PPDB</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>"
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Gene Expression Visualization Links</div>";
		sb[sb.length] = "<div class='left'>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.efp) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoEfpLinkClass + "'>eFP</a>";
		sb[sb.length] = "<a title='" + self._tooltip.getByKey(self._tooltipName.hanaDb) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoHannaDbLinkClass + "'>HanaDB</a>"
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";*/
		this._prepareExternalLinks(sb);
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Range</div>";
		sb[sb.length] = "<div class='left'>" + property + " Hours </div>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<div class='label left'>Motif</div>";
		sb[sb.length] = "<div class='left motif'>" + motif + "</div>";
		sb[sb.length] = "</div>";
		return sb.join("");
	},
	
	_prepareExternalLinks : function(htmlArray) {
		var self = this;
		var categoryNames = this._extLinks._getDistinctCategories();
		for (var index = 0 ; index < categoryNames.length ; index++) {
			var categoryName = categoryNames[index];
			var links = this._extLinks._getExternalLinksForCategory(categoryName);
			htmlArray[htmlArray.length] = "<div class='row'>";
			htmlArray[htmlArray.length] = "<div class='label left'>"+ categoryName +"</div>";
			for (var i = 0 ; i < links.length ; i++) {
				var linkInfo = links[i];
				htmlArray[htmlArray.length] = "<div class='left'>";
				htmlArray[htmlArray.length] = "<a title='" + self._tooltip.getByKey(linkInfo.linkName) + "' href='javascript:void(0);' class='externalLink " + self._options.geneInfoEfpLinkClass + "' linkurl='"+ linkInfo.url +"' genecase='"+ linkInfo.geneCase +"'>"+ linkInfo.linkName +"</a>";
				htmlArray[htmlArray.length] = "</div>";
			}
			htmlArray[htmlArray.length] = "</div>";
		}
	},
};

Application.Util = function() {
	this._init.apply(this, arguments);		
}

Application.Util.prototype = {
	
	_containerId : null,
	_errTextClass : null,
	_manualMotifErrorDialogId : null,
	_baseSequenceMinLength : null,
	_baseSequenceLength : null,
	
	_init : function(args) {
		this._containerId = args.containerId;
		this._errTextClass = args.errTextClass;
		this._baseSequenceMinLength = args.baseSequenceMinLength;
		this._baseSequenceLength = args.baseSequenceLength;
		
		this._motifErrorDialogId = "_manulaMotifMotif_Err_Dialog_" + this._containerId;
		this._initMotifInitErrDialogView();
		this._initMotifErrorDialog();
	},
	
	_initMotifInitErrDialogView : function() {
		var sb = [];
		sb[sb.length] = "<div id='"+ this._motifErrorDialogId +"' class='hidden'>";
		sb[sb.length] = "<div>Following error(s) found while trying to add the add/place the motif</div>";
		sb[sb.length] = "<ul class='motiferror'></ul>";
		sb[sb.length] = "</br>";
		sb[sb.length] = "<div>Would you like to correct it automatically ?</div>";
		sb[sb.length] = "</div>";
		$("#" + this._containerId).append(sb.join(""));
	},

	_initMotifErrorDialog : function() {
		var self = this;
		$("#" + self._motifErrorDialogId).dialog({
			autoOpen: false,
			width: 600,
			model: true
		});
	},
	
	_validateManulMotifCenterPosition : function(sequnceLength,position) {
		if (sequnceLength > 0) {
			$("#" + this._motifErrorDialogId + " .motiferror").html("");
			var corProsition = this.getCalculatedMotifInsertRange(sequnceLength);
			position = Math.abs(position);
			if ((position < corProsition.startPoint) || (position > corProsition.endPoint)) {
				position = corProsition.startPoint;
				this._putManulMotifError("Defined position is out of range. So assigned the default postion as -" + position);
			}	
			var val = sequnceLength % 2;
			position = Math.abs(position);
			var havingDecimalEntry = (position.toString().indexOf(".") != -1) ? true : false;
			if (val > 0) {
				// odd length case
				if (havingDecimalEntry == true) {
					position = position.toString().split(".")[0];
					this._putManulMotifError("Since the sequnce lenght is an odd no, the correct postion should be - " + position);
				}
			} else {
				//even length case
				if (havingDecimalEntry == false) {
					position = position + 0.5;
					this._putManulMotifError("Since the sequnce lenght is an even no, the correct postion should be - " + position);
				}else {
					var decPart = position.toString().split(".")[1];
					if (decPart != "5") {
						position = position.toString().split(".")[0] + ".5";
						this._putManulMotifError("The sequnce lenght is an odd no. For odd lengths, the correct postion should be - " + position);
					}
				}
			}
		}
		return position;
	},
	
	_putManulMotifError : function(errInfo) {
		var errText = $("#" + this._motifErrorDialogId + " .motiferror");
		var content = errText.html();
		errText.html(content + "</br>" + "<li><span class='"+ this._errTextClass +"'>" + errInfo + "</span></li>");
	},
	
	getCalculatedMotifInsertRange : function(sequnceLength) {
		var centerPos = Math.floor(sequnceLength / 2);
		var corStartPoint = this._baseSequenceMinLength + centerPos;
		var corEndPoint = this._baseSequenceLength - centerPos;
		if (this.isValueEven(sequnceLength) == false) {
			corStartPoint = corStartPoint + 1;
		} else {
			corStartPoint = corStartPoint + 0.5;
			corEndPoint = corEndPoint + 0.5;
		}
		var obj = {
			startPoint : corStartPoint,
			endPoint : corEndPoint
		};
		return obj;
	},
	
	isValueEven : function(val) {
		var val = val % 2;
		if (val > 0) {
			return false;	
		} else {
			return true;
		}
	},
	
	_getMotifEntryErrButtonArray : function(correctPos,textEleRef) {
		var self = this;
		return [
				{
					text: "Yes",
					click : function() {
						$(textEleRef).val("-" + Math.abs(correctPos));
						$(this).dialog("close");
					}
				},
				{
					text: "No",
					click : function() {
						$(this).dialog("close");
					}
				}
			];
	},
	
	_showMotifErrorDialog : function(corectedPos,textEleRef) {
		var bArray = this._getMotifEntryErrButtonArray(corectedPos,textEleRef);
		var dialogTitle =  "Motif Insert/Place Errors";
		$("#" + this._motifErrorDialogId).dialog({title : dialogTitle});
		$("#" + this._motifErrorDialogId).dialog({buttons : bArray});
		$("#" + this._motifErrorDialogId).dialog("open");
	}
};

Application.MotifView = function() {
	this._init.apply(this, arguments);		
}

Application.MotifView.prototype = {
	
	_containerId : null,
	_motifViewAreaId : null,	
	_baseSequenceMinLength : null,
	_baseSequence : null,
	_replaceSequenceClass : null,
	_callerObj : null,
	_geneLabelClass : null,
	_motifViewErrDlgId : null,
	_appUtil : null,
	_motifMethod : null,
	
	_init : function(containerId,args) {
		date = new Date(); 
		this._containerId = containerId;
		this._baseSequenceMinLength = args.baseSequenceMinLength;
		this._baseSequence = args.baseSequence;
		this._replaceSequenceClass = args.replaceSequenceClass;
		this._callerObj = args.callerObj;
		this._geneLabelClass = args.geneLabelClass;
		this._motifMethod = args.motifMethod;
		this._motifViewAreaId = "motifViewDialog_id_" + this._containerId + "_" + date.getTime();
		this._motifViewErrDlgId = "motifViewErrDlg_Id_" + this._containerId + "_" + date.getTime();
		this._initAppUtil();
	},
	
	defaults : {
		dialogErrorMessageClass : 'dialogErrorMessage',
		dialogOutRangeValueMessage : "Please input a value between {0} and {1}",
		geneLabelClass : "geneUrl"
	},
	
	_initAppUtil : function() {
		var self = this;
		var obj = {
			containerId : self._containerId,
			errTextClass : 'errorText',
			baseSequenceMinLength : self._baseSequenceMinLength,
			baseSequenceLength : self._baseSequence.length
		}
		self._appUtil = new Application.Util(obj);
	},
	
	getMotifViewHtml : function(sequnce) {
		var sb = [], self = this, date = new Date(); 
		sb[sb.length] = "<fieldset class='motifViewDialog'>";
		sb[sb.length] = "<legend>Motif view: edit the position and copy number of a motif</legend>";
		sb[sb.length] = "<div id='" + this._motifViewAreaId + "' class='hidden "+ sequnce +"'>";
		sb[sb.length] = "<input type='hidden' class='sequence'>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Place motif at position</span>";
		sb[sb.length] = "<input type='text' class='position'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='explanation left'>Place motif with center position between <br/>";
		sb[sb.length] = "<span class='minSeq'></span> and <span class='maxSeq'>";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Number of extra copies</span>";
		sb[sb.length] = "<input type='text' class='extraCopies' value='0'/>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div class='row'>";
		sb[sb.length] = "<span class='label left'>Space between copies (Base Pairs)</span>";
		sb[sb.length] = "<input type='text' class='basePairs' value='0'/>";
		sb[sb.length] = "</div>";
		//sb[sb.length] = "<div class='motifImageArea'>";
		//sb[sb.length] = "<img src='" + this._options.dialogImageUrl + "'/>";
		//sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='explanation explink'>Click ";
		//sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif from " + self._getDataBaseWebsiteName() + " website";
		sb[sb.length] = "<a class='moreInfo'>here</a> to see the additional information about motif";
		sb[sb.length] = "</span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<span class='dialogErrorMessage errorMessage hidden'></span>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<div>";
		sb[sb.length] = "<a id='motifview_placeMotif' class='btn btn-lightblue'>Place Motif</a>";
		sb[sb.length] = "&nbsp;";
		//sb[sb.length] = "<a id='motifview_cancel' class='btn btn-lightblue'>Cancel</a>";
		sb[sb.length] = "</div>";
		sb[sb.length] = "<fieldset class='motifviewinfo'>";
		sb[sb.length] = "<div style='float:left'>Motif Sequence:</div>";
		sb[sb.length] = "<div class='motifviewsequence'></div>";
		sb[sb.length] = "<div style='width=100%;float:left'>";
		//sb[sb.length] = "<span class='motifsequence' /></br>";
		sb[sb.length] = "<span class='motifmethod' /></br>";
		sb[sb.length] = "<span class='motifrecpos' />";
		sb[sb.length] = "</div>";;
		sb[sb.length] = "</fieldset>";
		sb[sb.length] = "</fieldset>";
		sb[sb.length] = "</div>";
		return sb.join("");
	},
		
	drawMotifView : function(sequence,appropriatePos) {
		var self = this;
		var htmlContent = this.getMotifViewHtml(sequence);
		var dialogSelector = "#" + self._motifViewAreaId + "." + sequence;
		$("#" + self._containerId + " ." + self._replaceSequenceClass).before(htmlContent);
		$(dialogSelector).find(".motifviewsequence").html(sequence);
		$(dialogSelector).find(".motifmethod").html("Motif Type: " + (this._motifMethod ? this._motifMethod : ""));
		$(dialogSelector).find(".motifrecpos").html("Motif default position: -" + Math.abs(appropriatePos));
		$(dialogSelector).show();
		
		$(dialogSelector).find("#motifview_placeMotif").click(function() {
			var seq = $(dialogSelector).find(".sequence").val();
			var pos = Math.abs($(dialogSelector).find(".position").val());
			var extraCopies = parseInt($(dialogSelector).find(".extraCopies").val());
			var basePairs = parseInt($(dialogSelector).find(".basePairs").val());
			var minPos = parseFloat($(dialogSelector).find(".minSeq").html());
			var maxPos = parseFloat($(dialogSelector).find(".maxSeq").html());
			var position = self._appUtil._validateManulMotifCenterPosition(seq.length,pos);
			if (Math.abs(pos) != position) {
				self._appUtil._showMotifErrorDialog(position,$(dialogSelector).find(".position"));
			} else {
				$(dialogSelector).find(".position").val("-" + Math.abs(pos));
				self._replaceWithSequence(seq, pos, extraCopies, basePairs);
			}
		});
	},
	
	_replaceWithSequence : function(seq, pos, extraCopies, basePairs) {
		var self = this, sb = [];
		self._placeMotifViewSequnce(seq, pos, extraCopies, basePairs);
		var html = self._callerObj._appSequence.getReColoredMotifViewSequnce(seq, pos, extraCopies, basePairs, self._replaceSequenceClass);
		self._callerObj._doReplaceWithHtml(html);
	},
	
	_placeMotifViewSequnce : function(seq, pos, extraCopies, basePairs) {
		var self =this,conflictArray = [];
		var corPos;
		//replaceSequenceByOption 
		var oldSequence = $("#" + self._containerId + " ." + self._replaceSequenceClass).text();
		if (!oldSequence) {
			oldSequence = $("#" + self._containerId + " ." + self.defaults.resultAreaClass + " .baseSequence").html();
		}
		for (var j = 0; j < extraCopies + 1; j++) {
			if (j == 0) {
				corPos = pos;
			} else {
				corPos = corPos + (basePairs) + (seq.length);
			}
			if (self._callerObj._hasConfliction(seq, corPos, oldSequence)) {
				conflictArray.push(seq + "|" + corPos);
			} else {
				self._callerObj._replaceSequenceByOption("new", seq, corPos);
			}	
			self._callerObj._handleConfliction(conflictArray);
		}
		//return out.join(""); 
	},
	
	isMotifViewExists : function(sequnce) {
		if ($("#" + this._motifViewAreaId + "."+ sequnce).length > 0) {
			return true;	
		} else {
			return false;	
		}
	},
	
	_getMinPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 1 : 0.5;
		return self._baseSequenceMinLength + Math.floor(seq.length / 2) + tHold;
	},
	
	_getMaxPosition : function(seq) {
		var self = this;
		var mod = seq.length % 2;
		var tHold = (mod == 1) ? 0 : 0.5;
		return self._baseSequence.length - 1 - Math.floor(seq.length / 2) + tHold;
	},
		
	_initPositionInsert : function(seq, pos) {
		return;
		var self = this;
		var mod = seq.length % 2;
		$("#" + self._motifViewAreaId + " .position").unbind("keyup");
		$("#" + self._motifViewAreaId + " .position").keyup(function() {
			var val = $(this).val();
			if (isNaN(val)) {
				$(this).val(pos);
				return;
			}
			var tmpVal = new String(Math.abs(val));
			if (mod == 0) {
				if (tmpVal.indexOf(".") == -1) {
					$(this).val(tmpVal + ".5");
				} else {
					$(this).val(tmpVal.split(".")[0] + ".5");
				}
			} else {
				if (tmpVal.indexOf(".") > -1) {
					$(this).val(tmpVal.split(".")[0]);
				}
			}
		});
	},
	
	_initMotifSequenceListener : function() {
		var self = this;
		$("#" + self._containerId + " .motifSequence").click(function() {
			//$("." + self._options.motifViewDialogClass).hide();
			var parent = $(this).closest('.userSequence');
			var container = $(this).closest('.userSequence');
			var seq = $(parent).find(".hdnSequence").val();
			//var pos = $(parent).find(".hdnPosition").val();
			var pos = $(parent).find(".hdnCorPosition").val();
			var appropriatePos = 0;
			var seqEl = null;
			if (self._callerObj._getSeqElBySeq) {
				seqEl = self._callerObj._getSeqElBySeq(seq);
				appropriatePos = (seqEl && seqEl.getAppropriatePos()) ? seqEl.getAppropriatePos() : pos;
			} else {
				appropriatePos = pos;
			}
			if (self.isMotifViewExists(seq) == false) {
				self.drawMotifView(seq,appropriatePos);
				self._initSequencePopup(seqEl,seq);
				var dialogSelector = "#" + self._motifViewAreaId + "." + seq;
				$(dialogSelector + " ." + self.defaults.dialogErrorMessageClass).hide();
				$(dialogSelector + " .sequence").val(seq);
				$(dialogSelector + " .position").val("-" + Math.abs(appropriatePos));
				$(dialogSelector + " .extraCopies").val(0);
				$(dialogSelector + " .basePairs").val(0);
				$(dialogSelector + " .minSeq").html("-" + Math.abs(self._getMinPosition(seq)));
				$(dialogSelector + " .maxSeq").html("-" + Math.abs(self._getMaxPosition(seq)));
				self._initPositionInsert(seq, appropriatePos);
				$(dialogSelector).show();
			}
		});
	},
	
	_initSequencePopup : function(seqEl,sequence) {
		var self = this;
		var dialogSelector = "#" + self._motifViewAreaId + "." + sequence;
		$(dialogSelector + " .moreInfo").unbind("click");
		var url = (seqEl && seqEl.getExternalUrl()) ? seqEl.getExternalUrl() : "#";
		if (url == "#") {
			$(dialogSelector + " .explink").html("&nbsp");
		} else {
			$(dialogSelector + " .explink").show();
		}
		$(dialogSelector + " .moreInfo").click(function() {
			self._callerObj._showPopupWindow(url);
		});
	}
};

Application.geneChart = function() {
	this._init.apply(this, arguments);
};

Application.geneChart.prototype = {
	
	_containerId : null,
	_options : null,
	_workId : null,
	_fileName : null,
	_subject : null,
	_property : null,
	_highChartContainerId : null,
	_appProperty : null,
	
	_default : {
		filterNamespace : "http://linkdata.org/",
		acceptPropLabelPrefix : "label:",
		yAxisLabel : "Gene Expression Level",
		loadingImage : "http://app.linkdata.org/asset/67556085.gif",
		loadingText : "Loading Chart....",
		loadingMessageClass : "loadChartMessage",
		loadingChartContainerClass : "loadingChart"
	},
	
	_init : function(containerId, options) {
		this._containerId = containerId;
		this._options = $.extend({}, this._default, options);
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		this._subject = this._options.subject;
		this._property = this._options.property;
		var date = new Date();
		this._highChartContainerId = "gene_chart_" + date.getTime();
		this._initAppProperty(this._options);
		this._initView();
		this._drawHighChart(this._subject, this._property);
	},
	
	_initAppProperty : function(opts) {
		var obj = {
			workId : opts.workId,
			fileName : opts.fileName
		};
		this._appProperty = new Application.motifProperty(obj);
	},
	
	_initView : function() {
		var self = this;
		var sb = [];
		sb[sb.length] = "<div class='"+ this._default.loadingChartContainerClass +"' id='" + self._highChartContainerId + "'>";
		sb[sb.length] = "<div class='"+ this._default.loadingMessageClass +"'>"+ this._default.loadingText +"</div>";
		sb[sb.length] = "<div><img src='"+ this._default.loadingImage +"' /></div>";
		sb[sb.length] = "</div>";
		$("#" + self._containerId).html(sb.join(""));
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_drawHighChart : function(subject, highlightProperty) {
		var self = this;
		var getDataArray = function(tripleList) {
			var dataArray = [];
			var dataObject = {};
			var duplicateProperty = [];
			var equalIndex = 0;
			var madianArr = [];
			var errorArr = [];
			var valArr = [];
			var highLightColumnFound = false;
			// adding dummy object to the triple list. otherwise logic does not pick up the last values in 'valArr'
			var obj = {
				subject : 'subject',
				property : 'label:property',
				object : 'name'
			};
			tripleList.push(obj);
			$.each (tripleList, function(tKey, tValue) {
				var property = tValue.property;
				if (property.indexOf(self._options.filterNamespace) == -1 && property != "label:property") {
					return;
				}
				var label = self._getLabelAfterHash(property);
				if (!self._ignore(label)) {
					var val = parseFloat(tValue.object);
					var hLabel = self._getLabelAfterHash(highlightProperty);
					var propLabel = self._getLabelAfterHash(property);
					if (hLabel == propLabel) {
						highLightColumnFound = true;
						equalIndex++;
					}
					if ($.inArray(property, duplicateProperty) == -1 && duplicateProperty.length > 0) {
						var ele = self._getMadianCoordinate(valArr);
						if (ele != "") {
							if (highLightColumnFound && equalIndex > 1) {
								ele = self._getHighLightColumn(parseFloat(ele));
								highLightColumnFound = false;
								equalIndex = 0;
							}
							madianArr.push(ele);
						}
						var arr = self._getErrorCoordinates(valArr);
						if (arr.length == 2) {
							errorArr.push([arr[0],arr[1]]);
						}
						valArr = [];
						valArr.push(val);
					} else {
						valArr.push(val);
					}
					duplicateProperty.push(property);
				}
			});
			dataArray.push(self._getMadianGraphObj(madianArr,subject));
			dataArray.push(self._getErrorGraphObj(errorArr));
			self._getXCategory(tripleList, dataArray, highlightProperty);
		}
		LinkData.getTriplesBySubject(self._workId, self._fileName, subject, getDataArray);
	},
	
	_getXCategory : function(tripleList, dataArray, highlightProperty) {
		var self = this;
		var array = [];
		var duplicateProperty = [];
		var hLabel = self._getLabelAfterHash(highlightProperty);
		$.each (tripleList, function(tKey, tValue) {
			var property = tValue.property;
			if (property.indexOf(self._options.filterNamespace) == -1) {
				return;
			}
			if ($.inArray(property, duplicateProperty) > -1) {
				return;
			}
			var label = self._getLabelAfterHash(property);
			if (!self._ignore(label)) {
				var displayLabel = self._getDisplayLabel(label);
				var hDisplayLabel = self._getDisplayLabel(hLabel);
				if (displayLabel === hDisplayLabel) {
					displayLabel = "<span style=\"color:#FB3B44\">" + hDisplayLabel + "</span>";
				}
				array.push(displayLabel);
				duplicateProperty.push(property);
			}
		});
		self._drawChart(self._highChartContainerId, dataArray, array);
	},
	
	_getMadianCoordinate : function(unsortedArray) {
		var sortedArr = this._getSortedArray(unsortedArray);
		var ele = "";
		if (sortedArr.length == 3) {
			ele = sortedArr[1];
		} else if (sortedArr.length > 0) {
			ele = sortedArr[0]
		} else {
			//alert("Plot value can only containes 3 values");
			console.debug("error");
		}
		return ele;
	},
	
	_getErrorCoordinates : function(unsortedArray) {
		var sortedArr = this._getSortedArray(unsortedArray);
		var errorVals = [];
		if (this._isAllCoordinatesAreSame(sortedArr)) {
			return errorVals;
		}
		if (sortedArr.length == 3) {
			errorVals.push(sortedArr[0]);
			errorVals.push(sortedArr[2]);
		} else {
			//alert("Plot value can only containes 3 values");
			console.debug("error");
		}
		return errorVals;
	},
	
	_isAllCoordinatesAreSame : function(arr) {
		if (arr.length == 1 || arr.length == 0) {
     		return true;
  		}
  		for (var i = 0 ; i < arr.length ; i++){
     		if (i > 0 && arr[i] != arr[i-1]) {
       			return false;
     		}
  		}
  		return true;
	},
	
	_getMadianGraphObj : function(values, subject) {
		var dataObject = {};
		var toolTip = {};
		toolTip.pointFormat = '<span style="font-weight: bold;">{series.name} [ {point.y} ]</span>';
		dataObject.name = this._getLabel(subject);
		dataObject.data = values;
		//dataObject.type = 'spline';
		dataObject.tooltip = toolTip;
		return dataObject;
	},
	
	_getErrorGraphObj : function(values) {
		var dataObject = {};
		var toolTip = {};
		toolTip.pointFormat = '<br/><span style="color:#287A4B">(error range: from {point.low} to {point.high})</span><br/>';
		dataObject.name = "errors";
		dataObject.data = values;
		dataObject.type = 'errorbar';
		dataObject.tooltip = toolTip;
		return dataObject;
	},
	
	_getSortedArray : function(values) {
		var allMinus = false;
		values = this._getRequiredTriplicateValues(values);
		for (var index=0 ; index < values.length ; index++) {
			if (values[index] < 0) {
				allMinus = true;	
			} else {
				allMinus = false;
				break;
			}
		}
		if (allMinus) {
			values.sort(function(a,b) {
				return b-a;
			});
		} else {
			values.sort(function(a,b) {
				return a-b;
			});
		}
		return values;
	},
	
	_getRequiredTriplicateValues : function(unsortedVals) {
		var vals = [];
		if (unsortedVals.length > 3) {
			for (var i = 0 ; i < 3 ; i++) {
				vals[i] = unsortedVals[i];
			}
		} else {
			return unsortedVals;
		}
		return vals;
    },
	
	_getHighLightColumn : function(val) {
		var obj = {};
		obj.y = val;
		obj.marker = {
			lineWidth: 3,
			lineColor: "#FB3B44",
			fillColor: "#FB3B78"
		};
		return obj;
	},
	
	_drawChart : function(containerId, dataArray, xCategory) {
		var self = this;
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: containerId,
				type: 'line',
				marginRight: 130,
				marginBottom: 125,
				zoomType: 'xy'
			},
			title: {
				text: self._fileName
			},
			xAxis: {
				categories: xCategory,
				labels : {
					rotation: 315
				}
			},
			yAxis: {
				title: {
        			text: self._default.yAxisLabel
    			}
			},
			/*tooltip: {
				formatter: function() {
					return '<b>'+ this.series.name + '</b><br/>' + this.x + ' [' + this.y + ']';
				}
			},*/
			tooltip: {
				shared: true
			},
			legend: {
				layout: 'vertical',
				align: 'right',
				verticalAlign: 'top',
				x: -10,
				y: 100,
				borderWidth: 0
			},
			series: dataArray
 		});
		self._scrollDown();
	},
	
	_scrollDown : function() {
		$("html, body").animate({ scrollTop: $(document).height() }, 1000);
	},
	
	_getLabel : function(value) {
		var self = this, label;
		if (value.indexOf("#") > -1) {
			label = self._getLabelAfterHash(value);
		} else {
			label = self._appProperty.getGeneBySubject(value);
		}
		if (!label) {
			label = value;
		}
		return label;
	},
	
	_getPropertyLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
			propLabel = this._appProperty.getPropertyNameByLabel(propLabel);
		}
		return propLabel;
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
};

Application.motifProperty = function() {
	this._init.apply(this, arguments);
};

Application.motifProperty.prototype = {

	_options : null,
	_propMap : null,
	_nameMap : null,
	_optionArray : null,
	
	_default : {
		acceptPropLabelPrefix : "label:",
		subjectATTEDUriPhrase : "http://atted.jp/data/locus/",
		subjectPPDBUriPhrase : "http://ppdb.agr.gifu-u.ac.jp/ppdb/cgi-bin/display.cgi?organism=At&gene=",
		subjectTAIRUriPhrase : "http://arabidopsis.org/servlets/TairObject?type=locus&name=",
		atted : "ATTED",
		ppdb : "PPDB"
	},
	
	_init : function(options) {
		this._options = $.extend({}, this._default, options);
		this._propMap = [];
		this._nameMap = [];
		this._initPropMap(this._options);
	},
	
	_initPropMap : function(opts) {
		var self = this, workId = opts.workId, fileName = opts.fileName;
		var method = function(properties) {
			self._fillPropMap(self, properties);
			self._initOptionArray(properties);
		}
		LinkData.getProperties(workId, fileName, method);
	},
	
	_fillPropMap : function(self, properties) {
		$.each(properties, function(key, value) {
			var label = self._getLabel(value);
			if (!self._propMap[label]) {
				self._propMap[label] = value;
			}
		});
	},
	
	_initOptionArray : function(propertyList) {
		var self = this, list = new Object();
		var workId = self._options.workId, fileName = self._options.fileName;
		self._optionArray = [];
		$.each(propertyList, function(key, value) {
			var propLabel = self._getLabel(value);
			if (!self._ignore(propLabel)) {
				var obj = {};
				obj.key = propLabel;
				obj.value = self._getDisplayLabel(propLabel);
				self._optionArray.push(obj);
			}
		});
	},
	
	_ignore : function(label) {
		var self = this;
		if (label.indexOf(self._default.acceptPropLabelPrefix) > -1) {
			return false;
		}
		return true;
	},
	
	_getDisplayLabel : function(value) {
		var self = this;
		var propLabel = value;
		var arr = value.split(self._default.acceptPropLabelPrefix);
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	},

	getOptionArray : function() {
		return this._optionArray;
	},
	
	getPropertyByLabel : function(label) {
		return this._propMap[label];
	},
	
	getGeneBySubject : function(subject) {
		var self = this, htmlExt = ".html", geneLabel;
		if (subject.indexOf(self._default.subjectATTEDUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectATTEDUriPhrase, "");
		} else if (subject.indexOf(self._default.subjectPPDBUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectPPDBUriPhrase, "");
		} else if (subject.indexOf(self._default.subjectTAIRUriPhrase) > -1) {
			geneLabel = subject.replace(self._default.subjectTAIRUriPhrase, "");
		}
		if (geneLabel && geneLabel.indexOf(htmlExt) > -1) {
			geneLabel = geneLabel.replace(htmlExt, "");
		}
		return geneLabel;
	},
	
	getSubjectUrl : function(analysisMethod, subjectPartWithoutUrl) {
		// sample format 'ATTED:At1g79040.html'
		var subjectUrl = "";
		subjectPartWithoutUrl = subjectPartWithoutUrl.replace(this._default.atted,"");
		subjectPartWithoutUrl = subjectPartWithoutUrl.replace(this._default.ppdb,"");
		subjectPartWithoutUrl = subjectPartWithoutUrl.replace(":","");
		subjectPartWithoutUrl = subjectPartWithoutUrl.trim();
		if (analysisMethod.trim().toLowerCase() == this._default.atted.trim().toLowerCase()) {
			subjectUrl = this._default.subjectATTEDUriPhrase + subjectPartWithoutUrl;
		} else if (analysisMethod.trim().toLowerCase() == this._default.ppdb.trim().toLowerCase()) {
			subjectUrl = this._default.subjectPPDBUriPhrase + subjectPartWithoutUrl;
		}
		return subjectUrl;
	}
};

Application.sequence = function() {
	this._init.apply(this, arguments);
};

Application.sequence.prototype = {
	
	CHAR_SEQ_EMPTY : "-",
	
	_options : null,
	_workId : null,
	_fileName : null,
	_seqProperty : null,
	_posProperty : null,
	_baseSequence : null,
	_sequenceList : null,
	_positionList : null,
	_containerId : null,
	_errorContainerClass : null,
	_outOfRangeArray : null,
	
	_default : {
		msgInvalidSequence: "invalid sequence.",
		msgOutOfRangeSequence: "Some motifs fall outside the Promoter Design region of -50 to -550 base pairs : {0}"
	},
	
	_init : function(options) {
		this._options = options;
		this._workId = this._options.workId;
		this._fileName = this._options.fileName;
		this._seqProperty = this._options.motifSequenceProperty;
		this._posProperty = this._options.motifPositionProperty;
		this._baseSequence = this._options.baseSequence;
		this._containerId = this._options.containerId;
		this._errorContainerClass = this._options.errorMessageClass;
	},
	
	_getCustomSequenceHtml : function(baseSequence, sequence, position) {
		var seqLen = sequence.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(position);
		var baseSeqLen = baseSequence.length;
		var suffixLen = baseSeqLen - (tHold + pos);
		var motifCorectedStartingPoint = position - (seqLen / 2);
		
		var sb = [];
		if (motifCorectedStartingPoint >= this._options.baseSequenceMinLength && suffixLen >= 0) {
			for (var i = 0; i < suffixLen; i++) {
				sb.push(this.CHAR_SEQ_EMPTY);
			}
			sb.push("<a href='javascript:void(0)' class='motifSequence'>" + sequence + "</a>");
			sb.push("<input type='hidden' class='hdnSequence' value='" + sequence + "'/>");
			sb.push("<input type='hidden' class='hdnPosition' value='" + pos + "'/>");
			sb.push("<input type='hidden' class='hdnCorPosition' value='-" + position + "'/>");
		} else {
			//_showError($appContainer, opts.msgOutOfRangeSequence.replace("{0}", sequence));
			this._outOfRangeArray.push(sequence + "[-" + position + "]");
			this._showError(this._default.msgOutOfRangeSequence.replace("{0}", this._outOfRangeArray.join(", ")));
		}
		return sb.join("");
	},
	
	_isValidSequenceList : function(seqs) {
		var count = seqs.length;
		var maxlength = 0;
		for (var i = 0; i < count; i++) {
			if (seqs[i].length > maxlength) {
				maxlength = seqs[i].length;
			}
		}
		var result = true;
		for (var i = 0; i < maxlength; i++) {
			var chars = [];
			for (var j = 0; j < count; j++) {
				chars.push(seqs[j].charAt(i));
			}
			if (! this._isValidChars(chars.join(""))) {
				result = false;
				break;
			}
		}
		return result;
	},
	
	_isValidBaseReplacementMotif : function(baseSequence, seqs) {
		var self = this;
		var mergeSequence = this._getMergeCharSequence(seqs);
		var length = baseSequence.length;
		for (var i = 0; i < length; i++) {
			var bChar = baseSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			if (mChar !== this.CHAR_SEQ_EMPTY && bChar !== this.CHAR_SEQ_EMPTY && mChar !== bChar) {
				return false;
			}
		}
		return true;
	},
	
	_isValidChars : function(charString) {
		var charLen = charString.length;
		var result = true;
		var first = null;
		for (var i = 0; i < charLen; i++) {
			if (charString.charAt(i) == this.CHAR_SEQ_EMPTY) {
				continue;
			}
			if (! first) {
				first = charString.charAt(i);
			}
			var current = charString.charAt(i);
			if (current && first != current) {
				result = false;
				break;
			}
		}
		return result;
	},
	
	_getReplacedCustomSequence : function(seqs) {
		var mergeSequence = this._getMergeCharSequence(seqs);
		var maxlength = this._baseSequence.length;
		var sb = [];
		for (var i = 0; i < maxlength; i++) {
			var bChar = this._baseSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			if (mChar !== this.CHAR_SEQ_EMPTY) {
				// replaced
				sb.push(mChar);
			} else {
				sb.push(bChar);
			}
		}
		
		return sb.join("");
	},
	
	_getMergeCharSequence : function(seqs) {
		var count = seqs.length;
		var maxlength = this._baseSequence.length;
		var sb = [];
		for (var i = 0; i < maxlength; i++) {
			var chars = [];
			for (var j = 0; j < count; j++) {
				chars.push(seqs[j].charAt(i) ? seqs[j].charAt(i) : this.CHAR_SEQ_EMPTY);
			}
			sb.push(this._getMergeChar(chars.join("")));
		}
		return sb.join("");
	},
	
	_getMergeChar : function(charString) {
		var charLen = charString.length;
		var result = null;
		for (var i = 0; i < charLen; i++) {
			if (charString.charAt(i) !== this.CHAR_SEQ_EMPTY) {
				result = charString.charAt(i);
				break;
			}
		}
		if (!result) {
			result = this.CHAR_SEQ_EMPTY;
		}
		return result;
	},
	
	_wrappedReplacedSequenceHtml : function(replaceSequence, seqs) {
		var self = this, sb = [];
		var mergeSequence = this._getMergeCharSequence(seqs);
		var length = this._baseSequence.length;
		for (var i = 0; i < length; i++) {
			var bChar = this._baseSequence.charAt(i);
			var rChar = replaceSequence.charAt(i);
			var mChar = mergeSequence.charAt(i);
			var seqChar = (bChar !== rChar) ? "<span class='replace'>" + rChar + "</span>" : rChar;
			if (mChar !== this.CHAR_SEQ_EMPTY) {
				sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
			} else {
				sb.push(seqChar);
			}
		}
		return sb.join("");
	},
	
	_getSequenceAndPositionHiddenHtml : function(seqArray, posArray) {
		var self = this, sb = [];
		if (!seqArray || !posArray) {
			return sb.join("");
		}
		for (var i = 0; i < seqArray.length; i++) {
			sb[sb.length] = "<input type='hidden' class='hdnReplacedMotif' value='" + seqArray[i] + "|" + posArray[i] + "'/>";
		}
		return sb.join("");
	},
	
	_showError : function(message) {
		$errorMessageContainer = $("#" + this._containerId + " ." + this._errorContainerClass);
		$errorMessageContainer.html(message);
		$errorMessageContainer.show();
	},
	
	getHtmlByReplacingOldSequence : function(oldSequence, newSequence) {
		var self = this, sb = [];
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			var seqChar = (oChar !== nChar) ? "<span class='replace'>" + oChar + "</span>" : oChar;
			if (nChar !== self.CHAR_SEQ_EMPTY) {
				if (oChar !== self.CHAR_SEQ_EMPTY) {
					sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
				} else {
					sb.push(nChar);
				}
			} else {
				sb.push(oChar);
			}
		}
		return sb.join("");
	},
	
	getHtmlByReplacingNewSequence : function(oldSequence, newSequence) {
		var self = this, sb = [];
		for (var i = 0; i < oldSequence.length; i++) {
			var oChar = oldSequence.charAt(i);
			var nChar = newSequence.charAt(i);
			var seqChar = (oChar !== nChar) ? "<span class='replace'>" + nChar + "</span>" : nChar;
			if (nChar !== self.CHAR_SEQ_EMPTY) {
				sb.push("<span class='highlight-sequence'>" + seqChar + "</span>");
			} else {
				sb.push(oChar);
			}
		}
		return sb.join("");
	},
	
	getSequenceHtml : function(subject, drawSequence) {
		var self = this;
		self._outOfRangeArray = [];
		var sb = [], baseSequence = self._baseSequence;
		var getTriplesBySequenceProperty = function(sequenceList) {
			self._getTriplesBySequenceProperty(subject, drawSequence, sequenceList);
		}
		LinkData.getObjects(self._workId, self._fileName, subject, self._seqProperty, getTriplesBySequenceProperty);
	},
	
	_getTriplesBySequenceProperty : function(subject, drawSequence, sequenceList) {
		var self = this;
		var getTriplesByPositionProperty = function(positionList) {
			self._drawSequenceList(drawSequence, sequenceList, positionList);
		}
		LinkData.getObjects(self._workId, self._fileName, subject, self._posProperty, getTriplesByPositionProperty);
	},
	
	_drawSequenceList : function(drawSequence, sequenceList, positionList) {
		var self = this, sb = [];
		if (!sequenceList || sequenceList.length == 0) {
			return;
		}
		for (var i = 0; i < sequenceList.length; i++) {
			var customSeqString = self._getCustomSequenceHtml(self._baseSequence, sequenceList[i], positionList[i]);
			if (customSeqString.length > 0) {
				sb.push("<div>");
				sb.push("<div class='userSequence'>" + customSeqString + "</div>");
				//sb.push("&nbsp;<span class='deletelink "+ sequenceList[i] +"' onclick='self._deleteUserSequence("+ "&quot;" + sequenceList[i] + "&quot;" +","+ "&quot;" + self._containerId + "&quot;" +");'>");
				sb.push("&nbsp;<span class='deletelink "+ sequenceList[i] +"'>");
				sb.push("<img src='http://app.linkdata.org/asset/c6bf2a0f.png' title='Delete' /></span>");
				//sb.push("<div>&nbsp;</div>");
				sb.push("</div>");
			}
		}
		sb.push("<div>&nbsp;</div>");
		drawSequence(sb.join("\n"));
		self._attachDeleteEvent();
	},
	
	_attachDeleteEvent : function () {
		var self = this;
		var timer = new Application.timer();
		var attachEvent = function() {
			var length = $("#" + self._containerId + " .deletelink").length;
			if (length > 0) {
				$("#" + self._containerId + " .deletelink").unbind("click");
				$("#" + self._containerId + " .deletelink").click(function() {
					var parent = $(this).parent();
					$(parent).remove();
				});
			} else {
				timer.call(attachEvent);
			}
		}
		attachEvent();
	},
	
	getFormattedSequence : function(baseSeqLen, seq, pos) {
		var self = this, sb = [];
		var seqLen = seq.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(pos);
		var len = baseSeqLen - (tHold + pos);
		for (var i = 0; i < len; i++) {
			sb[sb.length] = self.CHAR_SEQ_EMPTY;
		}
		sb[sb.length] = seq;
		return sb.join("");
	},
	
	replace : function(seqs, seqArray, posArray) {
		var self = this, isValid = self._isValidSequenceList(seqs);
		if (isValid) {
			if (seqs.length > 0) {
				var sb = [];
				var replaceSeq = self._getReplacedCustomSequence(seqs);
				sb[sb.length] = self._wrappedReplacedSequenceHtml(replaceSeq, seqs);
				sb[sb.length] = self._getSequenceAndPositionHiddenHtml(seqArray, posArray);
				return sb.join("");
			}
		} else {
			this._showError(self._default.msgInvalidSequence);
		}
	},
	
	replaceWith : function(seq, pos, extraCopies, basePairs) {
		var main = [], seqArray = [], posArray = [];
		var seqLen = seq.length;
		var tHold = Math.floor(seqLen / 2);
		var pos = parseInt(pos);
		var baseSeqLen = this._baseSequence.length;
		var len = baseSeqLen - (tHold + pos);
		seqArray.push(seq);
		posArray.push(pos);
		for (var j = 0; j < extraCopies + 1; j++) {
			var array = [];
			for (var i = 0; i < len; i++) {
				array.push(this.CHAR_SEQ_EMPTY);
			}
			array.push(seq);
			main.push(array.join(""));
			len = len - seqLen - basePairs;
			if (len < 0) {
				break;
			}
		}
		//return this.replace(main, seqArray, posArray);
		return main;
	},
	
	getReColoredMotifViewSequnce : function(seq, pos, extraCopies, basePairs, replaceDivClass) {
		
		var self = this;
		var sb = [];
		
		var seqs = self.replaceWith(seq, pos, extraCopies, basePairs);
		var replaceSeq = self._getReplacedCustomSequence(seqs);
		var existingSequence = $("#" + self._containerId + " ." + replaceDivClass).text();
		var repSeqLen = replaceSeq.length;
		
		for (var index = 0 ; index < repSeqLen ; index++) {
			var oChar = existingSequence.charAt(index);
			var nChar = replaceSeq.charAt(index);
			//var seqChar = (oChar !== nChar) ? "<span class='replace'>" + nChar + "</span>" : nChar;
			if (index < (repSeqLen - 50)) {
				if (nChar == oChar && nChar !== self.CHAR_SEQ_EMPTY) {
					sb.push("<span class='highlight-sequence replace'>" + nChar + "</span>");
				} else {
					sb.push(oChar);
				} 
			} else {
				sb.push(oChar);
			}
		}
		//self._doReplaceWithHtml(sb.join(""));
		return sb.join("");
	},
	
	hideError : function() {
		$errorMessageContainer = $("#" + this._containerId + " ." + this._errorContainerClass).hide();
	}
	
};

Application.heptamer = function() {
	this._init.apply(this, arguments);
};

Application.heptamer.prototype = {
	
	_heptamerMap : null,
	_motifSequenceProperty : null,
	_appropriatePositionProperty : null,
	
	_default : {
		heptamerTag : "heptamer",
		filterSequencePropertyPhrase : "motif_sequence",
		filterMaxCEGPropertyPhrase : "maxCEG",
		//filterAppropriatePosition : "Appropriateposition(%C2%B1%2040%20bp)"
		filterAppropriatePosition : "Appropriateposition%28%C2%B1%2040%20bp%29"
	},
	
	_init : function() {
		this._heptamerMap = [];
		this._initHeptamerList();
	},
	
	_initHeptamerList : function() {
		var self = this;
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._initHeptamer(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._default.heptamerTag, getFilesByTag);
	},
	
	_initHeptamer : function(workId, fileName) {
		var self = this;
		var getPropertyList = function(propertyList) {
			self._initProperty(propertyList);
			self._getSequenceTriple(workId, fileName);
		}
		LinkData.getProperties(workId, fileName, getPropertyList);
	},
	
	_initProperty : function(propertyList) {
		var self = this;
		$.each(propertyList, function(propKey, propValue) {
			if (propValue.indexOf(self._default.filterSequencePropertyPhrase) > -1) {
				self._motifSequenceProperty = propValue;
			} else if (propValue.indexOf(self._default.filterAppropriatePosition) > -1) {
				self._appropriatePositionProperty = propValue;
			}
		});
	},
	
	_getSequenceTriple : function(workId, fileName) {
		var self = this;
		var getSequenceTripleList = function(sequenceTripleList) {
			self._fillHeptamerMap(workId, fileName, sequenceTripleList);
		}
		LinkData.getTriplesByProperty(workId, fileName, self._motifSequenceProperty, getSequenceTripleList);
	},
	
	_fillHeptamerMap : function(workId, fileName, sequenceTripleList) {
		var self = this;
		var getPositionTripleList = function(positionTripleList) {
			for (var i = 0; i < sequenceTripleList.length; i++) {
				var seqTriple = sequenceTripleList[i];
				var posTriple = positionTripleList[i];
				var seqEl = new Application.seqElement();
				seqEl.setExternalUrl(seqTriple.subject);
				seqEl.setSequence(seqTriple.object);
				seqEl.setAppropriatePos(posTriple.object);
				self._heptamerMap[seqTriple.object] = seqEl;
			}
		}
		LinkData.getTriplesByProperty(workId, fileName, self._appropriatePositionProperty, getPositionTripleList);
	},
	
	getBySequence : function(sequence) {
		return this._heptamerMap[sequence];
	}
	
};
	
Application.octamer = function() {
	this._init.apply(this, arguments);
}
	
Application.octamer.prototype = {
	
	_octamerMap : null,
	_motifSequenceProperty : null,
	_appropriatePositionProperty : null,
	
	_default : {
		octamerTag : "octamer",
		filterSequencePropertyPhrase : "sequence",
		filterAppropriatePosition : "Appropriate%20position"
	},
	
	_init : function() {
		this._octamerMap = [];
		this._initOctamerList();
	},
	
	_initOctamerList : function() {
		var self = this;
		var getFilesByTag = function(result) {
			$.each(result, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._initOctamer(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, self._default.octamerTag, getFilesByTag);
	},
	
	_initOctamer : function(workId, fileName) {
		var self = this;
		var getProperties = function(propertyList) {
			self._initProperty(propertyList);
			self._getSequenceTriple(workId, fileName);
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_initProperty : function(propertyList) {
		var self = this;
		$.each(propertyList, function(propKey, propValue) {
			if (propValue.indexOf(self._default.filterSequencePropertyPhrase) > -1) {
				self._motifSequenceProperty = propValue;
			} else if (propValue.indexOf(self._default.filterAppropriatePosition) > -1) {
				self._appropriatePositionProperty = propValue;
			}
		});
	},
	
	_getSequenceTriple : function(workId, fileName) {
		var self = this;
		var getSequenceTripleList = function(sequenceTripleList) {
			self._fillOctamerMap(workId, fileName, sequenceTripleList);
		}
		LinkData.getTriplesByProperty(workId, fileName, self._motifSequenceProperty, getSequenceTripleList);
	},
	
	_fillOctamerMap : function(workId, fileName, sequenceTripleList) {
		var self = this;
		var getPositionTripleList = function(positionTripleList) {
			for (var i = 0; i < sequenceTripleList.length; i++) {
				var j = Math.floor(i / 2);
				var seqTriple = sequenceTripleList[i];
				var posTriple = positionTripleList[j];
				var seqEl = new Application.seqElement();
				seqEl.setExternalUrl(seqTriple.subject);
				seqEl.setSequence(seqTriple.object);
				seqEl.setAppropriatePos(posTriple.object);
				self._octamerMap[seqTriple.object] = seqEl;
			}
		}
		LinkData.getTriplesByProperty(workId, fileName, self._appropriatePositionProperty, getPositionTripleList);
	},
	
	getBySequence : function(sequence) {
		return this._octamerMap[sequence];
	}
	
};

Application.seqElement = function() {
	this._init.apply(this, arguments);
};

Application.seqElement.prototype = {
	
	_externalUrl : null,
	_sequence : null,
	_appropriatePos : null,
	
	_init : function() {},
	
	getExternalUrl : function() {
		return this._externalUrl;
	},

	setExternalUrl : function(externalUrl) {
		this._externalUrl = externalUrl;
	},
	
	getSequence : function() {
		return this._sequence;
	},
	
	setSequence : function(sequence) {
		this._sequence = sequence;
	},
	
	getAppropriatePos : function() {
		return this._appropriatePos;
	},
	
	setAppropriatePos : function(appropriatePos) {
		this._appropriatePos = appropriatePos;
	}
	
};

Application.timer = function() {
	this._init.apply(this, arguments);
};

Application.timer.prototype = {
	
	_delay : null,
	_retry : null,
	_maxRetry : null,
	
	_init : function() {
		this._delay = 1000;
		this._retry = 0;
		this._maxRetry = 1000;
	},
	
	call : function(func) {
		if (this._retry < this._maxRetry) {
			setTimeout(func, this._delay);
		}
		this._retry++;
	},
	
	setMaxRetryCount : function(no) {
		this._maxRetry = no;
	}
};

Application.index = function() {
	this._init.apply(this, arguments);
}

Application.index.prototype = {
	
	_start : null,
	_end : null,
	
	_init : function(start, end) {
		this._start = start;
		this._end = end;
	},
	
	getIndex : function() {
		return {start : this._start, end : this._end};
	},
	
	getItemCount : function() {
		return (this._end - this._start + 1);
	},
	
	increment : function() {
		var itemCount = this.getItemCount();
		this._start = this._start + itemCount;
		this._end = this._end + itemCount;
		return {start : this._start, end : this._end};
	},
	
	getStartIndex : function() {
		return this._start;
	},
	
	getEndIndex : function() {
		return this._end;
	}
	
};

Application.tooltip = function() {
	this._init.apply(this, arguments);
};

Application.tooltip.prototype = {
	
	_toolTipList : null,
	
	_default : {
		explanationProperty : "explanation"
	},
	
	_init : function() {
		this._toolTipList = [];
		this._initToolTip();
	},
	
	_initToolTip : function() {
		var self = this;
		var getFilesByTag = function(resultList) {
			$.each(resultList, function(workId, fileList) {
				$.each(fileList, function(fileKey, fileName) {
					self._getFilePropertyList(workId, fileName);
					return false;
				});
			});
		}
		LinkData.getFilesByTag(null, "tooltip", getFilesByTag);
	},
	
	_getFilePropertyList : function(workId, fileName) {
		var self = this;
		var index = new Application.index(1, 10000);
		var getProperties = function(propertyList) {
			$.each(propertyList, function(pKey, pValue) {
				if (pValue.indexOf(self._default.explanationProperty) > -1) {
					self._getSubjectList(workId, fileName, pValue, index);
					return false;
				}
			});
		}
		LinkData.getProperties(workId, fileName, getProperties);
	},
	
	_getSubjectList : function(workId, fileName, property, index) {
		var self = this;
		var getSubjects = function(subjectList) {
			self._getPropertyList(subjectList, workId, fileName, property, index);
		}
		LinkData.getSubjects(workId, fileName, getSubjects, index);
	},
	
	_getPropertyList : function(subjectList, workId, fileName, property, index) {
		var self = this;
		var getTriplesByProperty = function(tripleList) {
			self._addToolTipToList(subjectList, tripleList, workId, fileName, property, index);
		}
		LinkData.getTriplesByProperty(workId, fileName, property, getTriplesByProperty, index);
	},
	
	_addToolTipToList : function(subjectList, tripleList, workId, fileName, property, index) {
		var self = this;
		for (var i = 0; i < subjectList.length; i++) {
			var key = self._getLabelAfterHash(subjectList[i]);
			if (tripleList[i]) {
				var value = tripleList[i].object;
				self._addToolTip(key, value);
			}
			//var value = tripleList[i].object;
			//self._addToolTip(key, value);
		}
		if (subjectList && subjectList.length == index.getItemCount()) {
			self._getSubjectList(workId, fileName, property, index.increment());
		}
	},
	
	_addToolTip : function(key, tooltip) {
		var obj = {};
		obj.key = key;
		obj.tooltip = tooltip;
		this._toolTipList.push(obj);
	},
	
	getByKey : function(key) {
		var self = this, tooltip;
		$.each(self._toolTipList, function(objKey, obj) {
			if (obj.key.toString().toLowerCase() === key.toString().toLowerCase()) {
				tooltip = obj.tooltip;
				return false;
			}
		});
		return (tooltip) ? tooltip : "";
	},
	
	_getLabelAfterHash : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

Application.externalLink = function(toolName) {
	this._init.apply(this, arguments);
};

Application.externalLink.prototype = {
	
	_externalLinksTriples : [],
	_toolName : null,
	
	_default : {
		externalLinkTag : "external_links"
	},
	
	_props : {
		toolList : "tool%20list",
		category : "category",
		url : "url",
		geneCase : "gene%20case",
		upperCase : "U",
		lowerCase : "L"
	},
	
	_init : function(toolName) {
		this._toolName = toolName;
		this._loadExtrnalLinksFile();
	},
	
	// reading the whole external links file as triple objects
	_loadExtrnalLinksFile : function() {
		var self = this;
		var findExtarnlLinkFile = function(resultList) {
			$.each(resultList, function(wId, fileList) {
				$.each(fileList, function(fileKey, fName) {
					self._loadFileTriples(wId,fName);
				});
			});
		};
		LinkData.getFilesByTag(null, this._default.externalLinkTag, findExtarnlLinkFile);
	},
		
	_loadFileTriples : function(workId,fileName) {
		var self = this;
		var loadTriples = function(results) {
			self._externalLinksTriples = results;
			self._filterTriplesByToolName(results);
		};
		LinkData.getTriples(workId,fileName,loadTriples,{start:1, end:100});
	},
	
	_filterTriplesByToolName : function(linkTriples) {
		var filtredList = [];
		for (var index = 0 ; index < linkTriples.length ; index++) {
			var triple = linkTriples[index];
			var prop = this._getProperty(triple.property);
			if (prop == this._props.toolList) {
				var toolNames = triple.object.split(",");
				for (var i = 0 ; i < toolNames.length ; i++) {
					var toolName = toolNames[i].trim();
					if (toolName.toLowerCase() == this._toolName.toLowerCase()) {
						var triplesBySubject = this._getTriplesBySubject(triple.subject);
						for (var j = 0 ; j < triplesBySubject.length ; j++) {
							var otherTriple = triplesBySubject[j];
							filtredList.push(otherTriple);
						}
						break;
					}
				}
			}
		}
		this._externalLinksTriples = filtredList;
	},
		
	_getDistinctCategories : function() {
		var distinctCategoryNames = this._getDistinctStringList(this._props.category,this._externalLinksTriples);
		return distinctCategoryNames;
	},
	
	_getExternalLinksForCategory : function(categoryName) {
		var extLinks = [];
		var geneCase,url;
		var triplesByPropVal = this._getTriplesByPropertyValue(this._props.category,categoryName);
		for (var index = 0 ; index < triplesByPropVal.length ; index++) {
			var triple = triplesByPropVal[index];
			var subject = triple.subject;
			var triples = this._getTriplesBySubject(subject);
			for (var i = 0 ; i < triples.length ; i++) {
				var linkTriple = triples[i];
				var prop = this._getProperty(linkTriple.property).trim();
				if (prop.toLowerCase() == this._props.geneCase) {
					geneCase = linkTriple.object;
				} else if (prop.toLowerCase() == this._props.url) {
					url = linkTriple.object;
				}
				if (url && geneCase) {
					var linkName = linkTriple.subject.split("#")[1];
					var obj = {
						linkName : linkName,
						geneCase : geneCase,
						url : url
					}
					extLinks.push(obj);	
					url = null;
					geneCase = null;
					break;
				}
			}
		}
		return extLinks;
	},
	
	_getTriplesBySubject : function(subject) {
		var filteredList = [];
		var currentList = this._externalLinksTriples;
		for (var index = 0 ; index < currentList.length ; index++) {
			var triple = currentList[index];
			var triSubject = triple.subject;
			if (triSubject.trim() == subject.trim()) {
				filteredList.push(triple);
			}
		}
		return filteredList;
	},
		
	_getProperty : function(propertyUrl) {
		var comps = propertyUrl.split("#");
		return comps[comps.length-1];
	},
		
	_getTriplesByPropertyValue : function(propName,value) {
		/*
          this function first will find the triple with the passed property and then
		  this will take the subject of it and will find other properties of that
          subject
		*/
		var filteredList = [];
		for (var index = 0 ; index < this._externalLinksTriples.length ; index++) {
			var triple = this._externalLinksTriples[index];
			var prop = this._getProperty(triple.property);
			if (prop.toLowerCase() == propName.toLowerCase()) {
				var propVal = triple.object;
				if (propVal.trim() == value.trim()) {
					filteredList.push(triple);
					//break;
				}
			}
		}
		return filteredList;
	},
		
	// returns a string array
	_getDistinctStringList : function(propName,tripleList) {
		var distinctList = [];
		for (var index = 0 ; index < tripleList.length ; index++) {
			var triple = tripleList[index];
			var prop = this._getProperty(triple.property);
			if (prop && prop.toLowerCase() == propName.toLowerCase()) {
				var objVal = triple.object;
				if (distinctList.indexOf(objVal) == -1) {
					distinctList.push(objVal);
				}
			}
		}
		return distinctList;
	},
};

Application.DbHandler = function() {
	this._init.apply(this,arguments);
}

Application.DbHandler.prototype = {
	
	_fullList : [],
	
	_properties : {
		motifAnalysisMethod : "motif%20analysis%20method",
		geneExpressionData : "gene%20expression%20data",
		menuDisplayName : "menu%20display%20name",
		toolsList : "tool%20list",
		workIdInTest : "test.linkdata.org",
		workIdPublic : "linkdata.org",
		ranklistWorkIdTest : "rank%20list%20test.linkdata.org",
		ranklistWorkIdPublic : "rank%20list%20linkdata.org"
    },
	
	_tags : {
		menuDataSourceTag : "menu"
	},
	
	_defaults : {
		linkdataTestUrl : "test.linkdata.org",
		linkdataPublicUrl : "linkdata.org",
	},
	
	_init : function(args) {
		this._initMenuDataSource();
	},
	
	_fillFileProperties : function() {
		var self = this;
		var setProperties = function(props) {
			self._fileProperties = props;
		};
		LinkData.getProperties(this._workId,this._fileName,setProperties);
	},
	
	_initMenuDataSource : function() {
		var self = this;
		var foundMenuFiles = [];
		var loadMenuFiles = function(resultList) {
			$.each(resultList, function(wId, fileList) {
				$.each(fileList, function(fileKey, fName) {
					var obj = {
						workId : wId,
						fileName : fName
					};
					foundMenuFiles.push(obj);
				});
			});
			self._foundMenuFiles = foundMenuFiles;
			self._loadMenuFileContent(foundMenuFiles);
			self._fillFileProperties();
		};
		LinkData.getFilesByTag(null, this._tags.menuDataSourceTag, loadMenuFiles);
	},
	
	_loadMenuFileContent : function(menuFiles) {
		var self = this;
		var addFileContent = function(triples) {
			self._fullList = triples;
		};
		if (menuFiles.length > 1) {
			alert("There can be only one file that can be tagged with 'menu'");
			return;
		}
		if (menuFiles.length == 0) {
			return;
		}
		var obj = menuFiles.shift(); // removing the first element
		this._fileName = obj.fileName;
		this._workId = obj.workId;
		LinkData.getTriples(this._workId,this._fileName,addFileContent,{start:1, end:2000});
	},
	
	_getDataCollectionNameByDbName : function(dbName) {
		var dataCollection = null;
		if (!(this._fullList)) return null;
		for (var index = 0 ; index < this._fullList.length ; index++) {
			var triple = this._fullList[index];
			var dbOnlyPart = triple.subject.split("#")[1];
			if (dbOnlyPart.toLowerCase().trim() == dbName.toLowerCase().trim()) {
				var prop = this._getProperty(triple.property);
				if (prop.trim().toLowerCase() == this._properties.menuDisplayName.toLowerCase()) {
					dataCollection = triple.object;
					break;
				}
			}
		}
		return dataCollection;
	},
	
	_getDistinctDbNamesByToolName : function(toolName) {
		var self = this;
		if (!(toolName)) return self._fullList;
		if (!(this._fullList)) return null;
		var listByTool = self._getTriplesByProperty(this._properties.toolsList,self._fullList);
		if (!listByTool) return null;
		var dbInfoObjs = [];
		for (var index = 0 ; index < listByTool.length ; index++) {
			var triple = listByTool[index];
			if (triple.object) {
				var toolList = triple.object.split(",");
				for (var index1 = 0 ; index1 < toolList.length ; index1++) {
					var tool = toolList[index1];
					if (tool.trim() == toolName.trim()) {
						var subject = triple.subject;
						var otherPropTripleList = self._getTriplesBySubject(subject);
						var obj = self._getDbInfoObject(otherPropTripleList);
						dbInfoObjs.push(obj);
						break;
					}
				}
			}
		}
	    return dbInfoObjs;
	},
	
	_getDbInfoObject : function(triplesListForSubject) {
		var workId, fileName, dataColl = null, analysisMethod = null, rankListId = null;
		for (var index1 = 0 ; index1 < triplesListForSubject.length ; index1++) {
			var triple = triplesListForSubject[index1];
			var property = this._getProperty(triple.property);
			var workIdProp = this._getWorkIdProperty();
			var rankWorkIdProp = this._getRankingWorkIdProperty();
			var analysisMethodProp = this._getProperty(triple.property);
			if (property.trim().toLowerCase() == workIdProp.trim().toLowerCase()) {
				var workIdComps = triple.object.toString().split("/");
				workId = workIdComps[workIdComps.length-1];
			}
			if (property.trim().toLowerCase() == this._properties.menuDisplayName.trim().toLowerCase()) {
				dataColl = triple.object;
			}
			if (property.trim().toLowerCase() == this._properties.motifAnalysisMethod.trim().toLowerCase()) {
				analysisMethod = triple.object;
			}
			if (property.trim().toLowerCase() == rankWorkIdProp.trim().toLowerCase()) {
				var rankListIdComps = triple.object.toString().split("/");
				rankListId = rankListIdComps[rankListIdComps.length-1];
			}
			
			if (workId && dataColl && analysisMethod && rankListId) {
				fileName = triple.subject.split("#")[1];
				break;
			}
		}
		var obj = {
			fileName : fileName,
			workId : workId,
			dataColl : dataColl,
			analysisMethod : analysisMethod,
			rankListWorkId : rankListId,
		};
		return obj;
	},
	
	_getProperty : function(propertyUrl) {
		var comps = propertyUrl.split("#");
		return comps[comps.length-1];
	},
	
	_getWorkIdProperty : function() {
		var hostName = window.location.hostname;
		if (hostName.indexOf(this._defaults.linkdataTestUrl) != -1) {
			return this._properties.workIdInTest;
		} else if (hostName.indexOf(this._defaults.linkdataPublicUrl) != -1) {
			return this._properties.workIdPublic;
		}
	},
	
	_getTriplesByProperty : function(propName,currentList) {
		var filteredList = [];
		for (var index = 0 ; index < currentList.length ; index++) {
			var triple = currentList[index];
			var prop = this._getProperty(triple.property);
			if (prop == propName) {
				filteredList.push(triple);
			}
		}
		return filteredList;
	},
	
	_getTriplesBySubject : function(subject) {
		var filteredList = [];
		for (var index = 0 ; index < this._fullList.length ; index++) {
			var triple = this._fullList[index];
			var triSubject = triple.subject;
			if (triSubject.trim() == subject.trim()) {
				filteredList.push(triple);
			}
			if (filteredList.length == this._fileProperties.length) {
				break;
			}
		}
		return filteredList;
	},
	
	// returns a string array
	_getDistinctObjectList : function(propName,currentList) {
		var distinctList = [];
		for (var index = 0 ; index < currentList.length ; index++) {
			var triple = currentList[index];
			var prop = triple.property;
			if (prop && prop.indexOf(propName) != -1) {
				var objVal = triple.object;
				if (distinctList.indexOf(objVal) == -1) {
					distinctList.push(objVal);
				}
			}
		}
		return distinctList;
	},
	
	_getRankingWorkIdProperty : function() {
		var hostName = window.location.hostname;
		if (hostName.indexOf(this._defaults.linkdataTestUrl) != -1) {
			return this._properties.ranklistWorkIdTest;
		} else if (hostName.indexOf(this._defaults.linkdataPublicUrl) != -1) {
			return this._properties.ranklistWorkIdPublic;
		}
	},
}
	
$(document).ready(function() {
	var dbHandler = new Application.DbHandler();
	var timer = new Application.timer();
	var fillDatabase = function(resultList) {
		var dbNames = dbHandler._getDistinctDbNamesByToolName("MotifCircadian");
		if (dbNames && dbNames.length > 0) {
			$(".motifMaxCircadianDatabase").append("<option value='-1' selected='selected'>-- Select Database --</option>");
			for (var index = 0 ; index < dbNames.length ; index++) {
				var obj = dbNames[index];
				$(".motifMaxCircadianDatabase").append("<option value='" + obj.workId + "|" + obj.fileName + "|" + obj.dataColl + "|" + obj.rankListWorkId + "'>" + obj.fileName + "</option>");
			}
		
			$(".motifMaxCircadianDatabase").change(function() {
				var dbKey = $("option:selected", $(this)).val();
				if (dbKey == -1) {
					$("#container").html("");
					return;
				}
				var array = dbKey.split("|");
				var containerId = "container";
				var options = {
					workId : array[0],
					fileName : array[1],
					rankListWorkId : array[2],
					baseSequence : "--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------GATCCCAAGACCCTTCCTCTATATAAGGAAGTTCATTTCATTTGGAGAGG",
					fixedSequence : "GATCCCAAGACCCTTCCTCTATATAAGGAAGTTCATTTCATTTGGAGAGG",
					dataColl : array[2]
				};
				//new Application.motifMaxCircadian(containerId, options);
				new Application.motifNonCircadian(containerId, options);
			});
		} else {
			timer.call(fillDatabase);
		}
	}
	fillDatabase();
	//LinkData.getFilesByTag(null, "database", fillDatabase);
});
