if(typeof Example==="undefined"||!Example){var Example = {};}

var data = {};
data.limit = 1;
data.count = 0;
data.workIds = [];
data.fileNames = [];
data.subjects = [];
data.properties = [];

var limit = 50;
var objValue = "";
var objList = [];

// 画像検索のキーワードとして使うオブジェクトのプロパティを指定
var keyProperty = "http://www.w3.org/2000/01/rdf-schema#label";

// LinkDataからデータを取得
Example.getWorks = function() {
	var callback = function(res) {
		$.each(res, function(key, workId) {
			data.workIds.push(workId);
		});
		$.each(data.workIds, function(key, workId) {
			Example.getFiles(workId);
		});
	}
	LinkData.getWorks(callback);
};

Example.getFiles = function(workId) {
	var callback = function(res) {
		$.each(res, function(fileKey, fileName) {
			Example.getSubjects(workId, fileName);
		});
	}
	LinkData.getFiles(workId, callback);
};

Example.getSubjects = function(workId, fileName) {
	var callback = function(res) {
		$.each(res, function(subjectKey, subjectValue) {
			data.subjects.push(subjectValue);
		});
		
		Example.getProperties(workId, fileName);
	}
	
	LinkData.getSubjects(workId, fileName, callback);
};

Example.getProperties = function(workId, fileName) {
	var callback = function(res) {
		$.each(res, function(propertyKey, propertyValue) {
			data.properties.push(propertyValue);
		});
		
		Example.getObjectList(workId, fileName);
	}
	LinkData.getProperties(workId, fileName, callback);
};

Example.getObjectList = function(workId, fileName) {
	$.each(data.subjects, function(sKey, sValue) {
		data.count = 0;
		$.each(data.properties, function(pKey, pValue) {
			if(data.count++ > data.limit) {
				return false;
			}
			Example.getObjects(workId, fileName, sValue, pValue);
		});
	});
}

// Google画像検索APIのロード
google.load('search', '1');
google.setOnLoadCallback(Example.getWorks);

// 検索でヒットした画像を表示
function searchComplete(searcher) {
    if (searcher.results && searcher.results.length > 0) {
		var results = searcher.results;
		var result = results[0];
		var newImg = document.createElement('img');
		$('#contents').append('<a href="' + result.url + '" target="_blank"><img src="'
			+ result.tbUrl + '" class="item" title="' + result.titleNoFormatting + '" /></a>');
    }
}

Example.getObjects = function(workId, fileName, subject, property) {
	var callback = function(res) {
		$.each(res, function(objKey, objValue) {
			if(objList.length > limit || objList.indexOf(objValue) != -1) {
				return false;
			}
			//画像検索
	    	var imageSearch = new google.search.ImageSearch();
	    	imageSearch.setRestriction(google.search.ImageSearch.RESTRICT_IMAGESIZE, google.search.ImageSearch.IMAGESIZE_MIDIUM, 
				google.search.Search.RESTRICT_SAFESEARCH, google.search.Search.SAFESEARCH_STRICT, 
				google.search.ImageSearch.RESTRICT_IMAGETYPE, google.search.ImageSearch.IMAGETYPE_PHOTO);
	    	imageSearch.setSearchCompleteCallback(this, searchComplete, [imageSearch]);
	    	imageSearch.execute(objValue);
			objList.push(objValue);
		});
	}
	LinkData.getObjects(workId, fileName, subject, keyProperty, callback);
};

// 画像の整頓
function arrange() {
	$('#container').imagesLoaded(function(){
		$('#container').masonry({
	    	itemSelector : '.item',
	    	columnWidth : 170
		});
  });      
}

// 画像の整頓の遅延処理
window.onload = function(){
    setTimeout('arrange()',3000);
}

