density = {};
density.url = {};
density.url.LAT = "http://www.w3.org/2003/01/geo/wgs84_pos#lat";
density.url.LON = "http://www.w3.org/2003/01/geo/wgs84_pos#long";



$(window).on("load", function(){
	
	$.jqplot.config.enablePlugins = true;
	var workList = LinkData.getWorks();
	for (var i = 0 ; i < workList.length;i++){
		var workId = workList[i];
		var fileList = LinkData.getFiles(workId);
		for (var j = 0 ; j < fileList.length;j++){
			var sb =[];
			sb[sb.length] ="<option value='";
			sb[sb.length] =workId;
			sb[sb.length] ="|";
			sb[sb.length] =fileList[j];
			sb[sb.length] ="'>";
			sb[sb.length] =LinkData.getWorkName(workId)[0]+ " - " +  fileList[j];
			sb[sb.length] ="</option>";
			$("#dataSelect").append(sb.join(""));
		}
	}

	fixHeight();
	initMap();

	$("#dataSelect").change(function () {
		var value = $("#dataSelect option:selected").val().split("|");
		changeDataSet(value[0], value[1]);
		lastDataListValue = $("#dataSelect option:selected").val();
	}).change();
});

$(parent).on("resize", fixHeight ) ;

function fixHeight(){

	var pageHeight = $(parent).height();
	var pageWidth = $(parent).width();

	// This is very big bad hack!!!
	pageHeight = pageHeight - 178;
	pageWidth = pageWidth - 200;
	$("#debugmessage").text(pageHeight );
	$("#zoomLevel").text(pageWidth );

	
	$("#bodyContainer").height(pageHeight );
	$("#map").height(pageHeight);
	$("#map").width(pageWidth );
	if(map){
		map.refresh() ;
	}
}

	/** map itself by ZDC.Map  */
	map = null;
	/** pop-up to show information of the place by ZDC.MsgInfo  */
	msg = null;
	/** pop-up to show density history graph of the place by ZDC.MsgInfo  */
	historyMsg = null;


	placeData = {};
	placeData.subjects = [];
	placeData.properties = [];
	placeData.data = [];
	placeData.limit = 50;
	prevPolyLine = null;
	densityCache = [];
	densityWidget = null;

	lastDataListValue = null;


function changeDataSet(workId, fileName) {
	removeMarker();
	try{
		setupData(workId, fileName);
		refreshMap();
//		setTimeout( showData, 3000);
		checkPickedAndShowData();
	}catch (e) {
		alert(e.message);
		$('#dataSelect').val(lastDataListValue);
		$('#dataSelect').change();
	}
}
function initMap() {
	var option = {
		mapType : ZDC.MAPTYPE_DEFAULT
	};
	map = new ZDC.Map(document.getElementById('map'), option);
	initMsgInfo();
	
	var density = new ZDC.Density( {layer : "BLUE" });
	map.addWidget(density);
	
	var widget_normal = new ZDC.Control(
		{
			pos: {
				top: 70,
				left: 15
			},
			type: ZDC.CTRL_TYPE_NORMAL
		}
	);
	map.addWidget(widget_normal);

	scaleBar = new ZDC.ScaleBar();
	map.addWidget(scaleBar);

	ZDC.Search.getDensInfo( {} , initLastDataCreation);
	
	ZDC.addListener(map, ZDC.MAP_CHG_ZOOM, 	function(){
		$("#zoomLevel").html(map.getZoom());
		refreshDensityInfo();
	});
	densityWidget = new ZDC.UserWidget(map.getLatLon(), { offset : new ZDC.Pixel(0,20)});
	map.addWidget(densityWidget);
	
	ZDC.addListener(map, ZDC.MAP_MOUSEMOVE , drawRectangle );
	ZDC.addListener(map, ZDC.MAP_MOUSEMOVE , moveDensityWidget );
	ZDC.addListener(map, ZDC.MAP_DRAG_END , refreshDensityInfo );
}
function initMsgInfo(){
	msg = new ZDC.MsgInfo(new ZDC.LatLon(34.984608, 135.773678),
   	{
		offset: ZDC.Pixel(3, -18)
	});
	map.addWidget(msg);
	historyMsg = new ZDC.MsgInfo(new ZDC.LatLon(34.984608, 135.773678),
   	{
		offset: ZDC.Pixel(3, -18)
	});
	map.addWidget(historyMsg);
}
function refreshMap() {
	msg.close();
	historyMsg.close();
	var latlons = createAllLatLonAry();
	var adjustZoom = map.getAdjustZoom(latlons);
	map.moveLatLon(adjustZoom.latlon);
	map.setZoom(adjustZoom.zoom);
	map.setHome();
}


function createAllLatLonAry(){
	var result = [];
	for(var i = 0; i < placeData.data.length ; i++){
		result.push( new ZDC.LatLon(placeData.data[i].lat, placeData.data[i].lon));
	}
	return result;
}

function refreshDensityInfo(){
	var box = map.getLatLonBox();
	var query = {
			box : box ,
			meshlvl : getMeshlvlByZoom(map.getZoom() ),
			retronum : "1",
			limit : "1,2000"
	};
	var callback = function(status, result) {
		if(result){
			densityCache = result.item;
		}
	}
	ZDC.Search.getDensByBox(query, callback) ;
	if(prevPolyLine ){
		map.removeWidget(prevPolyLine);
		prevPolyLine = null;
	}
}
function drawRectangle(){
	var latlon =  map.getPointerPosition();

	if(prevPolyLine  && ZDC.isPolygonContainLatLon(latlon, prevPolyLine.getPoints())){
		//return without update polyline.
		return;
	}
	if(prevPolyLine){
		map.removeWidget(prevPolyLine);
	}
	for(var i = 0 ; i < densityCache.length; i++){
		var bounds = densityCache[i].bounds;
		if( 
			bounds.sw.lat  <= latlon.lat && latlon.lat <= bounds.ne.lat &&
			bounds.sw.lon  <= latlon.lon && latlon.lon <= bounds.ne.lon){
			
			var latlons = [];
			latlons.push(new ZDC.LatLon(bounds.ne.lat , bounds.ne.lon));
			latlons.push(new ZDC.LatLon(bounds.ne.lat , bounds.sw.lon));
			latlons.push(new ZDC.LatLon(bounds.sw.lat , bounds.sw.lon));        
			latlons.push(new ZDC.LatLon(bounds.sw.lat , bounds.ne.lon));     
		
			var pl = new ZDC.Polyline( latlons, 
									  {
										  strokeWeight: 3,
										  strokeColor: '#FF0000',
										  closePath: true
									  });
			prevPolyLine = pl;
			map.addWidget(pl);
//			$("#debugmessage").html( densityCache[i].densities[0].density);
			var density = getComma(densityCache[i].densities[0].density);
			densityWidget.setHtml("<div id='densityWidget'>推定人数：<span id='densityNum'>"+ density + "</span></div>") ;
			densityWidget.open();
			break;
		}
	}

}

function moveDensityWidget(){
	var latlon = map.getPointerPosition();
	densityWidget.moveLatLon(latlon);
}
function initLastDataCreation(result, value){
	var month = parseInt(value.item.date.substring(4,6));
	var day =  parseInt(value.item.date.substring(6,8));
	var hour =  parseInt(value.item.date.substring(8,10));
	var sb = [];
	sb[sb.length] = month; 
	sb[sb.length] = "月"; 
	sb[sb.length] = day; 
	sb[sb.length] = "日";
	sb[sb.length] = hour -1; 
	sb[sb.length] = ":00～"; 
	sb[sb.length] = hour ; 
	sb[sb.length] = ":00"; 
	 var widgetlabel = 
        {
            html: '<div id="lastDataUpdate"><b>'+sb.join("")+'</b></div>',
            size: new ZDC.WH(200, 50)
        };
	var suw = new ZDC.StaticUserWidget({ top: 20,left: 20 }, widgetlabel);
	map.addWidget(suw);
	suw.open();
}
function checkPickedAndShowData(){
	var i = 0
	for(i = 0; i < placeData.data.length ;i++){
		if( typeof placeData.data[i].density === "undefined"){
			break;
		}
	}
	if(i < placeData.data.length){
		setTimeout( checkPickedAndShowData, 500);
	}else{
		showData();
	}

}

function showData(){
	sortPlaceData();
	showMarker();
	$("#result").html("");
	showPositionInfo();
	refreshDensityInfo();
}

function sortPlaceData(){
	placeData.data.sort(
	function(a,b){
    	if( a.density < b.density ) return 1;
        if( a.density > b.density ) return -1;
        return 0;
	}
	);
}


function showPositionInfo(){
	for(var i = 0 ; i < placeData.data.length; i++){
		var place = placeData.data[i];
		var sb = [];
		var rank = i + 1;
		
		var numPos = (i * -30) - 30;
		sb[sb.length] = "<div id ='place" +place.id+ "' style='cursor: pointer;'>";
		
		sb[sb.length] = "<div style='position: relative;float:left'>";
		sb[sb.length] = "<a class='pinImageWrapper' >";

		
		sb[sb.length] = "<img class='pinImage' style='top: "+getMarkerPosByRanking(rank,placeData.data.length )+"px; ' src='http://test.api.its-mo.com/img/mapicon-color.png'>";
		sb[sb.length] ="</a>";
		if(i < 	30){
			sb[sb.length] ="<a class='pinImageNumWrapper' >";
			sb[sb.length] ="<img class='pinImageNum' style='top: "+numPos+"px;' src='http://test.api.its-mo.com/img/mapicon-num.png'></a>";
		}
		sb[sb.length] = "</div>";

//		sb[sb.length] = getDensityTitleByRanking(rank,placeData.data.length );
//		sb[sb.length] = "<div style='clear:both;'></div>";
		
		
		sb[sb.length] = "<div>";
		sb[sb.length] =  place.name;
		sb[sb.length] = '<br>周辺の推定人数　' + getComma(place.density);
		sb[sb.length] = "</div>";
		sb[sb.length] = "</div>";
		$("#result").append(sb.join(""));
		$("#place"+ place.id).click(popupSelectedPoint);
	}
}
function popupSelectedPoint(event){
	var id = event.delegateTarget.id.substring(5);
	for(var i = 0 ; i < placeData.data.length ; i++){
		var place = placeData.data[i];
		if(place.id == id){
			map.moveLatLon(new ZDC.LatLon(place.lat, place.lon));
			ZDC.trigger(place.marker , ZDC.MARKER_CLICK);
			break;
		}
	}
}
function removeMarker(){
	for(var i = 0 ; i <  placeData.data.length ; i++){
		var onePlace = placeData.data[i];
		map.removeWidget(onePlace.marker);
	}
}
function showMarker(){
	// to show 1st as top position, scan from end to start.
	for(var i = placeData.data.length - 1 ; 0 <= i; i--){
		var onePlace = placeData.data[i];
		var latlon = new ZDC.LatLon(onePlace.lat, onePlace.lon);
		var rank = i + 1;
		var color = getColorByRanking(i, placeData.data.length );
		var size = "L" ;
		var markerOpt = {
            /* マーカのサイズに合わせて位置を調整する */
//            offset: new ZDC.Pixel(1, -38),
//			color : ZDC.MARKER_COLOR_ID_RED_L ,
			color : ZDC["MARKER_COLOR_ID_"+ color +"_L" ] ,
			number: ZDC["MARKER_NUMBER_ID_" +rank +"_L" ]
		};
		var mrk = new ZDC.Marker(latlon, markerOpt);
		onePlace.marker = mrk;
		mrk.setTitle(onePlace.name);
		map.addWidget(mrk);
		ZDC.bind(mrk, ZDC.MARKER_CLICK,
				 {place: onePlace , latlon: latlon, msg: msg , historyMsg: historyMsg , rank : rank},
				 showMsgInfo);
	}
}


function showMsgInfo(){
	this.historyMsg.close();
	this.msg.moveLatLon(this.latlon);
	sb = [];
	sb[sb.length] = '<table class="info">';
	sb[sb.length] = '<tr>';
	sb[sb.length] = '<th>名称</th>';
	sb[sb.length] = '<td>'+ this.place.name + '</td>';
	sb[sb.length] = '</tr>';
	
	for(var key in this.place.other){
		var title = "";
		if( key.indexOf("#") != -1){
			title = key.split("#")[1];
		} else if ( key.indexOf("/") != -1 && ! key.endsWith("/") ){
			title = key.substring(key.lastIndexOf("/") + 1);
		} else {
			title = key;
		}
		
		if(title.match(/^%[A-Za-z0-9]{2}/) && (title.length > 4 && title.charAt(3) == "%")){
			title = decodeURIComponent(title);
		}
		sb[sb.length] = '<tr>';
		sb[sb.length] = '<th>'+title+'</th>';
		sb[sb.length] = '<td>'+ this.place.other[key] + '</td>';
		sb[sb.length] = '</tr>';
	}
	sb[sb.length] = '<tr>';
	sb[sb.length] = '<th>スポット周辺の推定人数<br>';
	sb[sb.length] = '（<span id="showGraphMsg" placeId='+this.place.id+'>最近24時間の推移を見る</span>）</th>';
	sb[sb.length] = '<td class="dencity">'+ getComma(this.place.density) + '</td>';
	sb[sb.length] = '</tr>';
	
	sb[sb.length] = '</table>';

	this.msg.setHtml(sb.join(""));
	this.msg.open();
	ZDC.bindDom(document.getElementById("showGraphMsg"), "click", {
		historyMsg:this.historyMsg, msg :this.msg, latlon : this.latlon 
	}, showGraphInfo) 
}

function showGraphInfo(){
	var latlon = this.latlon
	var latlon2 = new ZDC.LatLon(latlon.lat + 0.00001 ,latlon.lon + 0.00001);
	var box = new ZDC.LatLonBox(latlon , latlon2);
	$("historyGraph").html("");
	var sb = [];
	sb[sb.length] = "<div id='historyMsgContent'><div id='graphAddress' style='text-align:center;'></div>";
	sb[sb.length] = "<div id='historyGraph' ></div>";
	sb[sb.length] = "</div>";
	this.historyMsg.setHtml(sb.join("") );
	this.historyMsg.moveLatLon(latlon);
	
	var query = {
		box : box ,
		meshlvl : "5",
		retronum : 24
	};
	
	var callback = function(status, result) {
		var densities =[];
		var times =[];
		for(var i = 0 ; i < result.item[0].densities.length; i++){
			densities[densities.length] = result.item[0].densities[i].density;
			times[times.length] = result.item[0].densities[i].date.slice(-2);
		}
		var orgDens = result.item[0].densities;
		var title = orgDens[0].date + " - " + orgDens[orgDens.length - 1].date;
		var start = orgDens[0].date;
		var end = orgDens[orgDens.length - 1].date;
		var month = parseInt(start.substring(4,6));
		var day =  parseInt(start.substring(6,8));
		var hour =  parseInt(start.substring(8,10));

		var monthEnd = parseInt(end.substring(4,6));
		var dayEnd =  parseInt(end.substring(6,8));
		var hourEnd =  parseInt(end.substring(8,10));
		
		var sb = [];
		sb[sb.length] = month; 
		sb[sb.length] = "月"; 
		sb[sb.length] = day; 
		sb[sb.length] = "日";
		sb[sb.length] = hour; 
		sb[sb.length] = ":00～"; 
		
		sb[sb.length] = monthEnd; 
		sb[sb.length] = "月"; 
		sb[sb.length] = dayEnd; 
		sb[sb.length] = "日";
		sb[sb.length] = hourEnd; 
		sb[sb.length] = ":00"; 
		
		
        plot1 = $.jqplot('historyGraph', [densities], {
            // Only animate if we're not using excanvas (not in IE 7 or IE 8)..
            animate: !$.jqplot.use_excanvas,
            seriesDefaults:{
                renderer:$.jqplot.BarRenderer,
                pointLabels: { show: true }
            },
            axes: {
                xaxis: {
                    renderer: $.jqplot.CategoryAxisRenderer,
                    ticks: times ,
					label: "時間帯",
                },
				yaxis : {
					label: "人数"
				}
            },
			title : sb.join(""), 
            highlighter: { show: false }
        });
	}
	ZDC.Search.getDensByBox(query, callback) ;

	var addressQuery = { latlons : [latlon]}
	var addressCallback = function(status, result) {
		$("#graphAddress").html(result[0].address.text +" 付近");
	}
	ZDC.Search.getAddrByLatLon(addressQuery, addressCallback) 
	
	this.msg.close();
	this.historyMsg.open();
}


function setupData(workId, fileName) {
	placeData.subjects = LinkData.getSubjects(workId, fileName);
	placeData.properties = LinkData.getProperties(workId, fileName);
	validateProperties(placeData.properties);
	getObjectList(workId, fileName);
}
function validateProperties(properties) {
	properties = properties;
	var latFound = false;
	var lonFound = false;
	
	for(var i = 0 ; i < properties.length; i++){
		if(properties[i] == density.url.LAT){
			latFound = true;
			continue;
		}
		if(properties[i] == density.url.LON){
			lonFound = true;
			continue;
		}
	}
	if( !latFound ){
		throw new Error("データに" + density.url.LAT + "がありませんでした。");
	}
	if( !lonFound ){
		throw new Error("データに" + density.url.LON + "がありませんでした。");
	}

}
function getObjectList(workId, fileName) {
	placeData.count = 0;
	placeData.data = [];
	$.each(placeData.subjects, function(sKey, sValue) {
		if(placeData.count++ > placeData.limit) {
			return false;
		}
		var onePlace = {};
		onePlace.subject = sValue;
		onePlace.id = sKey;
		onePlace.other = {};
		placeData.data.push(onePlace);
		
		var nameCandidateByLabel = null;
		var nameCandidateByName = null;
		$.each(placeData.properties, function(pKey, pValue) {
			var obj = LinkData.getObjects(workId, fileName, sValue, pValue);

			if(pValue == "http://www.w3.org/2000/01/rdf-schema#label"){
				nameCandidateByLabel = obj.join("_");
			}else if( (pValue.match(/name$/) || pValue.match(/Name$/)) && nameCandidateByName == null ){
//			}else if( (pValue.endsWith("name") || pValue.endsWith("Name")) && nameCandidateByName == null ){
				nameCandidateByName = obj[0];
				onePlace.other[pValue] = obj.join("_");
			} else if(pValue == density.url.LAT){
				onePlace.lat = parseFloat(obj[0]);
				// this is bad work around... 
				onePlace.lat = onePlace.lat - 0.0032;
			} else if(pValue == density.url.LON){
				onePlace.lon = parseFloat(obj[0]);
				// this is bad work around... 
				onePlace.lon = onePlace.lon + 0.00274;
			} else{
				onePlace.other[pValue] = obj.join("_");
			}	
		});
		if (nameCandidateByName){
			onePlace.name = nameCandidateByName;
		}else if( nameCandidateByLabel ){
			onePlace.name = nameCandidateByLabel;	
		}else{
			onePlace.name = sValue;
		}
		
		pickupDensity(onePlace);
	});
}

function pickupDensity(onePlace){
	var latlon = new ZDC.LatLon(onePlace.lat ,onePlace.lon);
	var latlon2 = new ZDC.LatLon(latlon.lat + 0.00001 ,latlon.lon + 0.00001);
	var box = new ZDC.LatLonBox(latlon , latlon2);
	
	var query = {
		box : box ,
		meshlvl : "5",
		retronum : "1"
	};
	
	var callback = function(status, result) {
		onePlace.density = result.item[0].densities[0].density;
	}
	ZDC.Search.getDensByBox(query, callback) ;
}


// temporary moved from smallfunction.js





function getComma(num) {
	num = new String(num).replace(/,/g, ""); 
	while(num != (num = num.replace(/^(-?\d+)(\d{3})/, "$1,$2"))); 
	return num;
}
function getDensityTitleByRanking(ranking, max ){
		var quarter = max / 4;
	
	if(ranking < quarter){
		return "<span class='densityTitle1'>混んでいる</span>";
	}
	if(ranking < quarter * 2){
		return "<span class='densityTitle2'>やや混んでいる</span>";
	}
	if(ranking < quarter *3){
		return "<span class='densityTitle3'>やや空いている</span>";
	} else{
		return "<span class='densityTitle4'>空いている</span>";
	}
}
function getMarkerPosByRanking(ranking, max ){
		var quarter = max / 4;
	
	if(ranking < quarter){
		return 0;
	}
	if(ranking < quarter * 2){
		return -150;
	}
	if(ranking < quarter *3){
		return -100;
	} else{
		return -50;
	}
}
function getColorByRanking(ranking, max ){
	var quarter = max / 4;
	
	if(ranking < quarter){
		return "RED";
	}
	if(ranking < quarter * 2){
		return "YELLOW";
	}
	if(ranking < quarter *3){
		return "GREEN";
	} else{
		return "BLUE";
	}
}

function getMeshlvlByZoom(zoom){
	if(zoom <=2){
		return "1";
	}
	if(zoom <=5){
		return "2";
	}
	if(zoom <=8){
		return "3";
	}
	if(zoom <=10){
		return "4";
	}else {
		return "5";
	}


}
