if(typeof Application==="undefined"||!Application){var Application= {};}

Application.bc = function() {
	this._init.apply(this, arguments);
}

Application.bc.prototype = {
	
	_data : null,
	_options : null,
	_mainArray : null,
	
	_init : function() {
		this._mainArray = [];
		this._mainArray = this._getObjectArray();
		this._options = this._getGoogleOption();
		this._initCheckBox();
	},

	_initCheckBox : function() {
		var array = this._getSubjectKeyValuePair();
		$.each(array, function(i, obj) {
			var checked = "";
			if (i == 0 || i ==2) {
				checked = "checked='checked'";
			}
			$("<div class='entry'><input type='checkbox' class='chkPrefecture' value='" + obj.key + "' " + checked + "/><span>" + obj.value + "</span></div>").appendTo("#checkBoxAreaId");
		});
	},
	
	_configArray : function() {
		var array = [
			{
				"caption" : "平成18年",
				"property" : "平成18年"
			},
			{
				"caption" : "平成19年",
				"property" : "平成19年"
			},
			{
				"caption" : "平成20年",
				"property" : "平成20年"
			},
			{
				"caption" : "平成21年",
				"property" : "平成21年"
			},
			{
				"caption" : "平成22年",
				"property" : "平成22年"
			}
		];
		return array;
	},
	
	_getGoogleOption : function() {	
		var options = {
			title: '従業者数',
			hAxis: {title: '単位：人', titleTextStyle: {color: '#A9A9A9'}}
      	};
		return options;
	},
	
	_getObjectArray : function() {
		var main = [];
		$.each(LinkData.getWorks(), function(workKey, workValue) {
			$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
				$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
					var array = [];
					$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
						var propLabel = propValue;
						var arr = propValue.split("#");
						if (arr.length > 1) {
							propLabel = decodeURIComponent(arr[1]);
						}
						var obj = {};
						var objValue = LinkData.getObjects(workValue, fileValue, subjValue, propValue)[0];
						obj.property = propLabel;
						obj.value = objValue;
						array.push(obj);
					});
					main[subjValue] = array;
				});
			});
		});
		return main;
	},
	
	_getSubjectKeyValuePair : function() {
		var array = [];
		for (var key in this._mainArray) {
			var obj = {};
			var label = key.replace("http://ja.wikipedia.org/wiki/", "");
			obj.key = key;
			obj.value = label;
    		array.push(obj);
		}
		return array;
	},
	
	getDataByKey : function(keyArray) {
		var self = this;
		var main = [];
		var titleArray = [];
		titleArray.push("");
		$.each(keyArray, function(i, key) {
			key = key.replace("http://ja.wikipedia.org/wiki/", "");
			titleArray.push(key);
		});
		main.push(titleArray);
		var configArray = this._configArray();
		$.each(configArray, function(k, obj) {
			var arr = [];
			arr.push(obj.property);
			$.each(keyArray, function(i, key) {
				var array = self._mainArray[key];
				$.each(array, function(j, objData) {
					if (objData.property === obj.property) {
						//alert(objData.property + " | " + obj.property + " | " + objData.value);
						var val = objData.value;
						if (! isNaN(val)) {
							val = parseFloat(val);
						}
						arr.push(val);
					}
				});
			});
			main.push(arr);
		});
		return main;
	},
	
	getData : function() {
		return this._data;
	},
	
	getOptions : function() {
		return this._options;
	}
	
}      

var drawMarkersMap = function() {
	var bc = new Application.bc();
	var options = bc.getOptions();
	var chart = new google.visualization.BarChart(document.getElementById('chart_div'));
	var runApp = function(dataArray) {
		$("#chart_div").show();
		if (dataArray.length == 0) {
			$("#chart_div").hide();
			return;
		}
		var array = bc.getDataByKey(dataArray);
		var data = google.visualization.arrayToDataTable(array);
		chart.draw(data, options);	
	}
	var initArray = [];
	$(".chkPrefecture:checked").each(function() {
		initArray.push($(this).val());
	});
	runApp(initArray);
	$(".chkPrefecture").change(function() {
		var arr = [];
		$(".chkPrefecture:checked").each(function () {
			arr.push($(this).val());
		});
		runApp(arr);
	});
	$("#selectAllButton").click(function() {
		var arr = [];
		$(".chkPrefecture").each(function () {
			$(this).attr("checked", "checked");
			arr.push($(this).val());
		});
		runApp(arr);
	});
	$("#clearAllButton").click(function() {
		var arr = [];
		$(".chkPrefecture").each(function () {
			$(this).removeAttr("checked");
		});
		runApp(arr);
	});
}

google.load("visualization", "1", {packages:["corechart"]});
google.setOnLoadCallback(drawMarkersMap);
