function init(){
 sessionStorage.clear();
 $.each(LinkData.getWorks(),function(k, v){
	 $.each(LinkData.getFiles(v), function(fk, fv) {
	   loadData(v,fv);
	 });
 });
}

function loadData(id,fname){
  $.when(LinkData.getTriples(id,fname)).done(
	  function(data){
		  var result = {};
		  var i = 0;
		  for(i = 0; i < data.length; i++){
			  var e = data[i];
			  if(e.property === "http://linkdata.org/property/rdf1s222i#Sequence"){
				  result[e.subject] = e.object;
			  }
		  }
		  sessionStorage.setItem(fname,JSON.stringify(result));
	  }
  );
}

function getSequence(type,name){
  var data = JSON.parse(sessionStorage.getItem(type));
  var seq = data[name];
  return seq;
}

var map = {};

function reverseTranslation(ps) {
 var ns = "";
 var i = 0;
 for (i=0; i<ps.length;i++) {
 ns += map[ps.charAt(i)];
 }
 return ns;
}


window.onload = function() {
  init();
  // 1. Obtain protein sequences of HPS.
  // 1. HPSのたんぱく質配列を取得
  $("#result").append("<b>[STEP 1]</b>");
  var hpsSeq = getSequence("protein","http://www.uniprot.org/uniprot/Q9LBW4");
  $("#result").append("HPS Protein sequence has been obtained from LinkData<br/>" + hpsSeq + "<br/>");
  // 2. Reverse translate the obtained protein sequences of HPS to DNA sequences.
  // 2. 取得したHPSのたんぱく質配列をDNA配列に逆翻訳
  $("#result").append("<b>[STEP 2]</b>");
  var hpsDnaSeq = reverseTranslation(hpsSeq);
  $("#result").append("HPS DNA Sequence has been generated<br/>" + hpsDnaSeq + "<br/><br/>");

 // 3. Obtain protein sequences of PHI.
 // 3. PHIのたんぱく質配列を取得
 $("#result").append("<b>[STEP 3]</b>");
 var phiSeq = getSequence("protein","http://www.uniprot.org/uniprot/Q9LBW5");
 $("#result").append("PHI Protein sequence has been obtained from LinkData<br/>" + phiSeq + "<br/>");
 
 // 4. Reverse-translate the obtained protein sequences of PHI to DNA sequences.
 // 4. 取得したPHIのたんぱく質配列をDNA配列に逆翻訳
 $("#result").append("<b>[STEP 4]</b>");
 var phiDnaSeq = reverseTranslation(phiSeq);
 $("#result").append("PHI DNA Sequence has been generated<br/>" + phiDnaSeq + "<br/><br/>");

 // 5. Combine those two DNA sequences.
 // 5. ２つのDNA配列を結合
 $("#result").append("<b>[STEP 5]</b>");
 var dnaSeq = hpsDnaSeq + phiDnaSeq;
 $("#result").append("Designed sequence is <font color='red'>" + dnaSeq + "</font><br/>");
};

map.M = "atg";
map.F = "ttt";
map.L = "tta";
map.I = "att";
map.V = "gtt";
map.S = "tct";
map.P = "cct";
map.T = "act";
map.A = "gct";
map.Y = "tat";
map.H = "cat";
map.Q = "caa";
map.N = "aat";
map.K = "aaa";
map.D = "gat";
map.E = "gaa";
map.C = "tgt";
map.W = "tgg";
map.S = "agt";
map.R = "cgt";
map.G = "ggt";
