google.load("jquery", "1");
google.load("jqueryui", "1");
google.load("visualization", "1", {'packages' : [ 'motionchart' ]});

$(window).load(function() {
	sparql = new Sparql();
 	
	//SPARQL検索の実行
	$('#find_query').click(function(){
		var category = $('#category').val();
		
		//sparql.findByQuery($('#query_area').val().replace(/[\n\r]/g,""));
		//使用するSPARQLクエリの設定
		query = 'select ?s ?name ?year ?place ?employee ?shipment ?value\n'
+'where{\n'
 + '?s <http://lodosaka.hozo.jp/category> "'+category+'"@ja.\n'
 + '?s <http://lodosaka.hozo.jp/name> ?name;\n'
 + '  <http://lodosaka.hozo.jp/year> ?year;\n'
 +    '<http://lodosaka.hozo.jp/num_of_business_place> ?place;\n'
 +    '<http://lodosaka.hozo.jp/num_of_employee> ?employee;\n'
 +    '<http://lodosaka.hozo.jp/shipment_value> ?shipment;\n'
 +    '<http://lodosaka.hozo.jp/added_value> ?value;\n'
 + '}'
		//結果を表示する欄の設定
		sparql.result_div = $('#result_div');
		//クエリの実行
		sparql.findByQuery(query);
	});

	$('#result_div').hide();

	init();
});


function init(){
	// Servletサーバアドレス
	sparql.server = "http://lod.hozo.jp";

	// 検索対象エンドポイント（途中での改行は不可）
 	//var endpoint = $('#endpoint_url').val();
	sparql.endpoint = {"endpoint": "http://lod.hozo.jp/repositories/osaka_IndustryChange", "namespaces": ""};
	sparql.init();
	
	//結果表示処理を行う関数を指定
//	sparql.result_func = result_table;
	sparql.result_func = motion_chart;
	
}

function motion_chart(data){
	var category = $('#category').val();
	
	$('#result_div').show();
	var datatable = new google.visualization.DataTable();

	
	datatable.addColumn('string', category);
	datatable.addColumn('number', '年');
	datatable.addColumn('number', '事業所数');
	datatable.addColumn('number', '製造品出荷額等');
	datatable.addColumn('number', '従業員数');
	datatable.addColumn('number', '事業所付加価値額');

	for(var i=0; i<data.length; i++){
		datatable.addRow(
			[data[i].name, 
			 parseInt(data[i].year, 10), 
			 parseInt(data[i].place, 10),
			 parseInt(data[i].shipment, 10),
		 	 parseInt(data[i].employee, 10),
			 parseInt(data[i].value, 10)
			]);
	}
	

	var chart = new google.visualization.MotionChart(
	 document.getElementById('result_div'));
	 chart.draw(datatable, {'width': 900, 'height': 400});

}
