/*
2014-03-05
以下のコミットと同期した。

コミット: 80334b8a93f4f0cfeb54a1dc5ba9fc964ef24560 [80334b8]
親: 4e922f9028
作者: 50river <mr.50river@gmail.com>
日時: 2014年3月4日 16:12:05
ラベル: origin/gh-pages
*/

/**
  エリア(ごみ処理の地域）を管理するクラスです。
*/
var AreaModel = function() {
  this.label;
  this.centerName;
  this.center;
  this.trash = new Array();
  /**
  各ゴミのカテゴリに対して、最も直近の日付を計算します。
*/
  this.calcMostRect = function() {
    for (var i = 0; i < this.trash.length; i++) {
      this.trash[i].calcMostRect(this);
    }
  }
  /**
    休止期間（主に年末年始）かどうかを判定します。
  */
  this.isBlankDay = function(currentDate) {
	  var period = [this.center.startDate, this.center.endDate];

    if (period[0].getTime() <= currentDate.getTime() &&
      currentDate.getTime() <= period[1].getTime()) {
      return true;
    }
    return false;
  }
  /**
    ゴミ処理センターを登録します。
    名前が一致するかどうかで判定を行っております。
  */
  this.setCenter = function(center_data) {
    for (var i in center_data) {
      if (this.centerName == center_data[i].name) {
        this.center = center_data[i];
      }
    }
  }
  /**
  ゴミのカテゴリのソートを行います。
*/
  this.sortTrash = function() {
    this.trash.sort(function(a, b) {
      var at = a.mostRecent.getTime();
      var bt = b.mostRecent.getTime();
      if (at < bt) return -1;
      if (at > bt) return 1;
      return 0;
    });
  }
}

/**
  各ゴミのカテゴリを管理するクラスです。
*/
var TrashModel = function(_lable, _cell) {
  this.dayLabel;
  this.mostRecent;
  this.dayList;
  this.mflag = new Array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
  if (_cell.search(/:/) >= 0) {
    var flag = _cell.split(":");
    this.dayCell = flag[0].split(" ");
    var mm = flag[1].split(" ");
  } else {
    this.dayCell = _cell.split(" ");
    var mm = new Array("4", "5", "6", "7", "8", "9", "10", "11", "12", "1", "2", "3");
  }
  for (var m in mm) {
    this.mflag[mm[m] - 1] = 1;
  }
  this.label = _lable;
  this.description;
  this.regularFlg = 1;      // 定期回収フラグ（デフォルトはオン:1）

  var result_text = "";
  var today = new Date();

  for (var j in this.dayCell) {
    if (this.dayCell[j].length == 1) {
      result_text += "毎週" + this.dayCell[j] + "曜日 ";
    } else if (this.dayCell[j].length == 2) {
      result_text += "第" + this.dayCell[j].charAt(1) + this.dayCell[j].charAt(0) + "曜日 ";
    } else {
      // 不定期回収の場合（YYYYMMDD指定）
      result_text = "不定期 ";
      this.regularFlg = 0;  // 定期回収フラグオフ
    }
  }
  this.dayLabel = result_text;

  this.getDateLabel = function() {
    var result_text = this.mostRecent.getFullYear() + "/" + (1 + this.mostRecent.getMonth()) + "/" + this.mostRecent.getDate();
    return this.dayLabel + " " + result_text;
  }

  var day_enum = ["日", "月", "火", "水", "木", "金", "土"];

  function getDayIndex(str) {
    for (var i = 0; i < day_enum.length; i++) {
      if (day_enum[i] == str) {
        return i;
      }
    };
    return -1;
  }
  /**
  このゴミの年間のゴミの日を計算します。
  センターが休止期間がある場合は、その期間１週間ずらすという実装を行っております。
*/
  this.calcMostRect = function(areaObj) {
    var day_mix = this.dayCell;
    var result_text = "";
    var day_list = new Array();
    
    // 定期回収の場合
    if (this.regularFlg == 1) {

      var today = new Date();
        
      // 12月 +3月　を表現
      for (var i = 0; i < MaxMonth; i++) {

        var curMonth = today.getMonth() + i;
        var curYear = today.getFullYear() + Math.floor(curMonth / 12);
        var month = (curMonth % 12) + 1;

        // 収集が無い月はスキップ
        if (this.mflag[month - 1] == 0) {
            continue;
        }
        for (var j in day_mix) {
          //休止期間だったら、今後一週間ずらす。 
          var isShift = false;

          //week=0が第1週目です。
          for (var week = 0; week < 5; week++) {
            //4月1日を起点として第n曜日などを計算する。
            var date = new Date(curYear, month - 1, 1);
            var d = new Date(date);
            //コンストラクタでやろうとするとうまく行かなかった。。
            //
            //4月1日を基準にして曜日の差分で時間を戻し、最大５週までの増加させて毎週を表現
            d.setTime(date.getTime() + 1000 * 60 * 60 * 24 *
              ((7 + getDayIndex(day_mix[j].charAt(0)) - date.getDay()) % 7) + week * 7 * 24 * 60 * 60 * 1000
            );
            //年末年始のずらしの対応
            //休止期間なら、今後の日程を１週間ずらす
            if (areaObj.isBlankDay(d)) {
              if (WeekShift) {
                isShift = true;
              } else {
                continue;
              }
            }
            if (isShift) {
              d.setTime(d.getTime() + 7 * 24 * 60 * 60 * 1000);
            }
            //同じ月の時のみ処理したい
            if (d.getMonth() != (month - 1) % 12) {
              continue;
            }
            //特定の週のみ処理する
            if (day_mix[j].length > 1) {
              if (week != day_mix[j].charAt(1) - 1) {
                continue;
              }
            }

            day_list.push(d);
          }
        }
      }
    } else {
      // 不定期回収の場合は、そのまま指定された日付をセットする
      for (var j in day_mix) {
        var year = parseInt(day_mix[j].substr(0, 4));
        var month = parseInt(day_mix[j].substr(4, 2)) - 1;
        var day = parseInt(day_mix[j].substr(6, 2));
        var d = new Date(year, month, day);
        day_list.push(d);
      }
    }
    //曜日によっては日付順ではないので最終的にソートする。
    //ソートしなくてもなんとなりそうな気もしますが、とりあえずソート
    day_list.sort(function(a, b) {
      var at = a.getTime();
      var bt = b.getTime();
      if (at < bt) return -1;
      if (at > bt) return 1;
      return 0;
    })
    //直近の日付を更新
    var now = new Date();

    for (var i in day_list) {
      if (this.mostRecent == null && now.getTime() < day_list[i].getTime() + 24 * 60 * 60 * 1000) {
        this.mostRecent = day_list[i];
        break;
      }
    };

    this.dayList = day_list;
  }
  /**
   計算したゴミの日一覧をリスト形式として取得します。
  */
  this.getDayList = function() {
    var day_text = "<ul>";
    for (var i in this.dayList) {
      var d = this.dayList[i];
      day_text += "<li>" + d.getFullYear() + "/" + (d.getMonth() + 1) + "/" + d.getDate() + "</li>";
    };
    day_text += "</ul>";
    return day_text;
  }
}
/**
センターのデータを管理します。
*/
var CenterModel = function(row) {
  function getDay(center, index) {
    var tmp = center[index].split("-");
    return new Date(tmp[0], tmp[1] - 1, tmp[2]);
  }

  this.name = row[0];
  this.startDate = getDay(row, 1);
  this.endDate = getDay(row, 2);
}
/**
* ゴミのカテゴリを管理するクラスです。
* description.csvのモデルです。
* linkdata ではgarbage 
*/
var DescriptionModel = function(data) {
  this.targets = new Array();

  this.label = data[0];
  this.sublabel = data[1];//not used
  this.description = data[2];//not used
  this.styles = data[3];
  this.background = data[4];

	this.hasNoPickDay = function() {
	  for(var i = 0 ; i < this.targets.length ; i++){
		  if(this.targets[i].noPickAt){
		  	return true;
		  }
	  }
	return false;
  }
}
/**
 * ゴミのカテゴリの中のゴミの具体的なリストを管理するクラスです。
 * target.csvのモデルです。
 */
var TargetRowModel = function(data) {
  this.type = data[0];
  this.name = data[1];
  this.notice = data[2];
  this.furigana = data[3];
  this.noPickAt = data[4];
	
	this.getNoticeWithNoPickAt = function(){
		if(this.noPickAt){
			var msg = this.noPickAt.split("|").join("と");
			return this.notice +" 　　但し、"+ msg +"の日には出せません。";
		}else{
			return this.notice ;
		}
	}
}

/* var windowHeight; */

$(function() {
/*   windowHeight = $(window).height(); */

  var center_data = new Array();
  var descriptions = new Array();
  var areaModels = new Array();
	var garbageNameAry = null;
	/** 週間天気予報を保持する配列 */
	var weatherDataAry = [];
	/** 今日明日の天気予報を保持する配列 */
//	var todayTomorrowWeatherDataAry = [];
	var workValue = LinkData.getWorks()[0];
	var weeklyForecastUrl ="";
	
	
	
  function getSelectedAreaName() {
    return localStorage.getItem("selected_area_name");
  }

  function setSelectedAreaName(name) {
    localStorage.setItem("selected_area_name", name);
  }

  function csvToArray(filename, cb) {
    $.get(filename, function(csvdata) {
      //CSVのパース作業
      //CRの解析ミスがあった箇所を修正しました。
      //以前のコードだとCRが残ったままになります。
      // var csvdata = csvdata.replace("\r/gm", ""),
       csvdata = csvdata.replace(/\r/gm, "");
      var line = csvdata.split("\n"),
          ret = [];
      for (var i in line) {
        //空行はスルーする。
        if (line[i].length == 0) continue;

        var row = line[i].split(",");
        ret.push(row);
      }
      cb(ret);
    });
  }

//エリア選択ドロップボックス初期化
  function updateAreaList() {
	var fileValue ="area";
	var areaNameProp = "http://www.w3.org/2000/01/rdf-schema#label";
	var proplist = LinkData.getProperties( workValue , fileValue) ;
	var centerNameProp = "http://linkdata.org/5374/center"; // proplist[1];
	  
	  
	proplist.shift();
	proplist.shift();
	garbageNameAry = proplist;

	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		
		var areaName = LinkData.getObjects(workValue, fileValue, subjValue, areaNameProp)[0];
		var centerName = LinkData.getObjects(workValue, fileValue, subjValue, centerNameProp)[0];
//		$("#result").append("<div style='padding-left:30px;'>" + areaName + "</div>");
//		$("#result").append("<div style='padding-left:30px;'>" + centerName + "</div>");
		var area = new AreaModel();
        area.label = areaName;
        area.centerName = centerName;

        areaModels.push(area);
		for (var r = 0; r < garbageNameAry.length ; r++) {
			var garbageName = garbageNameAry[r];
			var dayToDrop = LinkData.getObjects(workValue, fileValue, subjValue, garbageName).join(" ");
            var trash = new TrashModel(garbageName, dayToDrop);
            area.trash.push(trash);
        }
	});
	 
		var centerFileName ="center";
		var centerTitleProp = "http://www.w3.org/2000/01/rdf-schema#label";;
		var suspendStartProp = "http://linkdata.org/5374/center#suspendStart";
		var suspendEndProp = "http://linkdata.org/5374/center#suspendEnd";
	 	$.each(LinkData.getSubjects(workValue, centerFileName), function(subjKey, subjValue) {
	  		var centerName = LinkData.getObjects(workValue, centerFileName, subjValue, centerTitleProp)[0];
	  		var startDay = LinkData.getObjects(workValue, centerFileName, subjValue, suspendStartProp)[0];
	  		var endDay = LinkData.getObjects(workValue, centerFileName, subjValue, suspendEndProp)[0];
			var center = new CenterModel([centerName,startDay,endDay]);
			center_data.push(center);
		} );
	  
	  
	  
        //ゴミ処理センターを対応する各地域に割り当てます。
        for (var i in areaModels) {
          var area = areaModels[i];
          area.setCenter(center_data);
        };

        var selected_name = getSelectedAreaName();
        var area_select_form = $("#select_area");
        var select_html = "";
        select_html += '<option value="-1">地域を選択してください</option>';
        for (var row_index in areaModels) {
          var area_name = areaModels[row_index].label;
          var selected = (selected_name == area_name) ? 'selected="selected"' : "";

          select_html += '<option value="' + row_index + '" ' + selected + " >" + area_name + "</option>";
        }

        //HTMLへの適応
        area_select_form.html(select_html);
		area_select_form.change();
  }

  function createMenuList(after_action) {
	var garbageFile ="garbage";

	var areaNameProp = "http://www.w3.org/2000/01/rdf-schema#label";
	var colorProp ="http://schema.org/color";
//  	var garbageProplist = LinkData.getProperties ( workValue , garbageFile  ) ;
	$.each(LinkData.getSubjects(workValue, garbageFile), function(subjKey, subjValue) {
		  var data = [];
		  data.push(LinkData.getObjects(workValue, garbageFile, subjValue, areaNameProp)[0]);
		  data.push("");
		  data.push("");
		  data.push("");
		  var bgcolor = LinkData.getObjects(workValue, garbageFile, subjValue, colorProp)[0];
		  data.push(bgcolor);

		  descriptions.push(new DescriptionModel(data));
	});

	var itemFile ="item";
//	var itemProplist = LinkData.getProperties( workValue , itemFile  ) ;
	var itemLabelProp = "http://www.w3.org/2000/01/rdf-schema#label";
	var garbageProp = "http://schema.org/category";
	var descProp = "http://purl.org/dc/elements/1.1/description";
	var rubyProp = "http://linkdata.org/5374/index";
	var noPickAtProp = "http://linkdata.org/この天気の日はゴミ出し禁止";
	  $.each(LinkData.getSubjects(workValue, itemFile), function(subjKey, subjValue) {
		  
		  var label = LinkData.getObjects(workValue, itemFile, subjValue, itemLabelProp)[0];
		  var garbage = LinkData.getObjects(workValue, itemFile, subjValue, garbageProp)[0];
		  var desc = LinkData.getObjects(workValue, itemFile, subjValue, descProp).join("");
		  var ruby = LinkData.getObjects(workValue, itemFile, subjValue, rubyProp)[0];
		  var noPickAt = LinkData.getObjects(workValue, itemFile, subjValue, noPickAtProp).join("|");

		  var data = [];
		  data.push(garbage);
		  data.push(label);
		  data.push(desc);
		  data.push(ruby);
		  data.push(noPickAt);

		   var row = new TargetRowModel(data);
          for (var j = 0; j < descriptions.length; j++) {
            //一致してるものに追加する。
            if (descriptions[j].label == row.type) {
              descriptions[j].targets.push(row);
              break;
            }
          };
		  
	  });
	  
	   after_action();
        $("#accordion2").show();
  }

  function updateData(row_index) {
    //SVG が使えるかどうかの判定を行う。
    //TODO Android 2.3以下では見れない（代替の表示も含め）不具合が改善されてない。。
    //参考 http://satussy.blogspot.jp/2011/12/javascript-svg.html
    var ableSVG = (window.SVGAngle !== void 0);
    //var ableSVG = false;  // SVG未使用の場合、descriptionの1項目目を使用
    var areaModel = areaModels[row_index];
    var today = new Date();
    //直近の一番近い日付を計算します。
    areaModel.calcMostRect();
    //トラッシュの近い順にソートします。
    areaModel.sortTrash();
    var accordion_height = window.innerHeight / descriptions.length;
    if(descriptions.length>4){
      accordion_height = window.innerHeight / 4.1;
      if (accordion_height>140) {accordion_height = window.innerHeight / descriptions.length;};
      if (accordion_height<130) {accordion_height=130;};
    }
    
    var styleHTML = "";
    var accordionHTML = "";
    //アコーディオンの分類から対応の計算を行います。
    for (var i in areaModel.trash) {
      var trash = areaModel.trash[i];

      for (var d_no in descriptions) {
        var description = descriptions[d_no];
		var trashLabel = trash.label.substr(trash.label.indexOf("#") + 1);
		trashLabel = decodeURI(trashLabel);
		if (description.label != trashLabel) {
			continue;
		}

          var target_tag = "";
          var furigana = "";
          var target_tag = "";
          var targets = description.targets;
          for (var j in targets) {
            var target = targets[j];
            if (furigana != target.furigana) {
              if (furigana != "") {
                target_tag += "</ul>";
              }

              furigana = target.furigana;

              target_tag += '<h4 class="initials">' + furigana + "</h4>";
              target_tag += "<ul>";
            }

            target_tag += '<li style="list-style:none;">' + target.name + "</li>";
            target_tag += '<p class="note">' + target.getNoticeWithNoPickAt() + "</p>";
          }

          target_tag += "</ul>";

          var dateLabel = trash.getDateLabel();
          //あと何日かを計算する処理です。
          var leftDay = Math.ceil((trash.mostRecent.getTime() - today.getTime()) / (1000 * 60 * 60 * 24))

          var leftDayText = "";
          if (leftDay == 0) {
            leftDayText = "今日";
          } else if (leftDay == 1) {
            leftDayText = "明日";
          } else if (leftDay == 2) {
            leftDayText = "明後日"
          } else {
            leftDayText = leftDay + "日後";
          }
		  var weatherTitle = "";
		  
/*		  
		  if(leftDay == 0 || leftDay == 1){
			  if( todayTomorrowWeatherDataAry.length != 0){
				  weatherTitle = getWeatherTitle(todayTomorrowWeatherDataAry[leftDay ].telop) ;
				  weatherTitle = weatherTitle +" 降水確率" + todayTomorrowWeatherDataAry[leftDay ].possibility +"％";
			  } else{
  				  weatherTitle ="天気予報サービス停止中";
			  }
		  } */
		  if(leftDay == 0){
		  	weatherTitle = "";
		  }
		  if(leftDay == 1){
			if( weatherDataAry.length != 0){
				  //今日の予報というものはない。明日の予想が配列の0番目に来るのでそのように修正。
				  var index = leftDay - 1;
		  		weatherTitle = getWeatherTitle(weatherDataAry[index ].telop) ;
		  			weatherTitle = weatherTitle +" 降水確率 - %";
		  	  }else{
				  weatherTitle ="天気予報サービス停止中";
			  }
		  }
		  if(1 < leftDay && leftDay < 7 ){
			  if( weatherDataAry.length != 0){
				  //今日の予報というものはない。明日の予想が配列の0番目に来るのでそのように修正。
				  var index = leftDay - 1;
		  		weatherTitle = getWeatherTitle(weatherDataAry[index ].telop) ;
		  			weatherTitle = weatherTitle +" 降水確率" + weatherDataAry[index ].possibility +"％";
		  	  }else{
				  weatherTitle ="天気予報サービス停止中";
			  }
		  }
		  weatherTitle = "<span class='toWeeklyForecast' >" + weatherTitle +"</span>";
		  
          styleHTML += '#accordion-group' + d_no + '{background-color:  ' + description.background + ';} ';

          accordionHTML +=
            '<div class="accordion-group" id="accordion-group' + d_no + '">' +
            '<div class="accordion-heading">' +
            '<a class="accordion-toggle" style="height:' + accordion_height + 'px" data-toggle="collapse" data-parent="#accordion" href="#collapse' + i + '">' +
            '<div class="left-day">' + leftDayText + '</div>' +
            '<div class="weather">'+weatherTitle+'</div>' +
            '<div class="accordion-table" >';
          if (ableSVG && SVGLabel) {
            accordionHTML += '<img src="' + description.styles + '" alt="' + description.label + '"  />';
          } else {
            accordionHTML += '<p class="text-center">' + description.label + "</p>";
          }
		  if(description.hasNoPickDay()){
            accordionHTML += '<p class="text-center note">※雨の日には出せないものが含まれています</p>';
		  }
          accordionHTML += "</div>" +
            '<h6><p class="text-left date">' + dateLabel + "</p></h6>" +
            "</a>" +
            "</div>" +
            '<div id="collapse' + i + '" class="accordion-body collapse">' +
            '<div class="accordion-inner">' +
            description.description + "<br />" + target_tag +
            '<div class="targetDays"></div></div>' +
            "</div>" +
            "</div>";
      }
    }
    
    $("#accordion-style").html('<!-- ' + styleHTML + ' -->');

    var accordion_elm = $("#accordion");
    accordion_elm.html(accordionHTML);

    $('html,body').animate({scrollTop: 0}, 'fast');

    //アコーディオンのラベル部分をクリックしたら  
    $(".accordion-body").on("shown.bs.collapse", function() {
      var body = $('body');
      var accordion_offset = $($(this).parent().get(0)).offset().top;
      body.animate({
        scrollTop: accordion_offset
      }, 50);
    });
    //アコーディオンの非表示部分をクリックしたら  
    $(".accordion-body").on("hidden.bs.collapse", function() {
      if ($(".in").length == 0) {
        $("html, body").scrollTop(0);
      }
    });
	  $(".toWeeklyForecast").click( function(){
		window.open(weeklyForecastUrl);
		  return false;
	  });
  }

  function onChangeSelect(row_index) {　
    if (row_index == -1) {
      $("#accordion").html("");
      setSelectedAreaName("");
      return;
    }
    setSelectedAreaName(areaModels[row_index].label);

    if ($("#accordion").children().length === 0 && descriptions.length === 0) {

      createMenuList(function() {
        updateData(row_index);
      });
    } else {
      updateData(row_index);
    }
  }



  function getAreaIndex(area_name) {
    for (var i in areaModels) {
      if (areaModels[i].label == area_name) {
        return i;
      }
    }
    return -1;
  }
  //リストが選択されたら
  $("#select_area").change(function(data) {
    var row_index = $(data.target).val();
    onChangeSelect(row_index);
  });

  //-----------------------------------
  //位置情報をもとに地域を自動的に設定する処理です。
  //これから下は現在、利用されておりません。 
  //将来的に使うかもしれないので残してあります。
  $("#gps_area").click(function() {
    navigator.geolocation.getCurrentPosition(function(position) {
      $.getJSON("area_candidate.php", {
        latitude: position.coords.latitude,
        longitude: position.coords.longitude
      }, function(data) {
        if (data.result == true) {
          var area_name = data.candidate;
          var index = getAreaIndex(area_name);
          $("#select_area").val(index).change();
          alert(area_name + "が設定されました");
        } else {
          alert(data.reason);
        }
      })

    }, function(error) {
      alert(getGpsErrorMessage(error));
    });
  });

  if (getSelectedAreaName() == null) {
    $("#accordion2").show();
    $("#collapseZero").addClass("in");
  }
  if (!navigator.geolocation) {
    $("#gps_area").css("display", "none");
  }

  function getGpsErrorMessage(error) {
    switch (error.code) {
      case error.PERMISSION_DENIED:
        return "User denied the request for Geolocation."
      case error.POSITION_UNAVAILABLE:
        return "Location information is unavailable."
      case error.TIMEOUT:
        return "The request to get user location timed out."
      case error.UNKNOWN_ERROR:
      default:
        return "An unknown error occurred."
    }
  }

	
	function getWeatherTitle(telop) {
		if(telop.charAt(0) ==  '1'){
			return "<img src='http://app.linkdata.org/asset/b57bdf9c.png' class='weatherImg'/>晴れ";
		}
		if(telop.charAt(0) == '2'){
			return "<img src='http://app.linkdata.org/asset/df639013.png' class='weatherImg'/>くもり";
		}
		if(telop.charAt(0) == '3'){
			return "<img src='http://app.linkdata.org/asset/048cdf8a.png' class='weatherImg'/>雨";
		}
		if(telop.charAt(0) == '4'){
			return "<img src='http://app.linkdata.org/asset/3568e0e7.png' class='weatherImg'/>雪";
		}
	}
  function initWeatherInformation() {
	var tenkiAreaFile ="tenki_area";
	var selectedPropName = "http://linkdata.org/5374/tenki_area#selected";
	var micCodePropName = "http://linkdata.org/5374/tenki_area#micCode";
	var homepagePropName = "http://xmlns.com/foaf/0.1/homepage";
	  var micCode ="";

	 // 地方自治体コードと対応するお天気ナビゲータURLを取得
  	$.each(LinkData.getSubjects(workValue, tenkiAreaFile), function(subjKey, subjValue) {
		var data = LinkData.getObjects(workValue, tenkiAreaFile, subjValue, selectedPropName).join("");
		if(  data == "selected"){
			micCode = LinkData.getObjects(workValue, tenkiAreaFile, subjValue, micCodePropName)[0];
			weeklyForecastUrl = LinkData.getObjects(workValue, tenkiAreaFile, subjValue, homepagePropName)[0];
		}
	});

	  // 今日明日の天気予報を取得
/*	
	$.ajax({
		type: 'GET',
		url: 'http://app.linkdata.org/proxy-api/otenkiapi_asw?micCode=' + micCode,
		dataType: 'json',
		timeout : 2000,
		success: function(json){  
		//	  $("#result").append("<div style='padding-left:30px;'>" + JSON.stringify(json) + "</div>");
			if(json.result && json.result.length > 0){
				var poss = 0; // TODO 今日の降水確率を平均値として算出するとか。今日06-12 時の降水確率とするとか。
				var obj = json.result[0];
			  todayTomorrowWeatherDataAry.push({telop :obj["weatherToday"] + "" , possibility : poss  });
			  todayTomorrowWeatherDataAry.push({telop :obj["weatherTomorrow"] + "" , possibility : poss  });
		}
			initMoreWeatherInformation(micCode);
		},
		error: function (json){
//			initMoreWeatherInformation(micCode);
			//エラー時は再度問い合わせても無意味なので問い合わせずに次の処理を実行。
			updateAreaList();
		}
	}); */
	initMoreWeatherInformation(micCode);
  }
  
	  /**2日目以降の天気予報を取得*/
	function initMoreWeatherInformation(micCode) {
	$.ajax({
		type: 'GET',
		url: 'http://app.linkdata.org/proxy-api/otenkiapi_ass?micCode=' + micCode,
		dataType: 'json',
		timeout : 2000,
		success: function(json){  
//	  $("#result").append("<div style='padding-left:30px;'>" + JSON.stringify(json) + "</div>");
			if(json.result){
	  			var obj = json.result;
	 			for(var i = 1 ; i < 8 ; i++){
			 		var poss = "";
				  if ( i != 1 ){
					  poss = obj["popDay" +i];
				  }
				  weatherDataAry.push({telop :obj["weatherDay" +i] + "" , possibility : poss  });
			  	}
			}
			updateAreaList();
		},
		error: function (json){
			updateAreaList();
		}
	});
  }
	
	window.onload = initWeatherInformation;
});


