/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/


// グローバル変数
eventlist_data	= new Array();	// イベントリスト
genre_data		= new Array();	// イベントジャンルリスト
spot_data		= new Array();	// スポットリスト 
eventtime_data	= new Array();	// イベントタイムテーブル

stop_data 		= new Array();	// バス停リスト
week_data		= new Array();	// 平日時刻表
holi_data 		= new Array();	// 休日時刻表

var user_lat	= '';			// ユーザの緯度
var user_lng	= '';			// ユーザの経度
var sel_spot_id = null;
var map;						
var currentWindow = null;		// 表示中のinfoWindow

// ページが表示されたときに関数を呼び出す
$('#list').bind('pageshow',checkChoice);
$('#detail').bind('pageshow',detailMapCanvas);
$('#map').bind('pageshow',mapCanvas);
$('#bus').bind('pageshow',busMapCanvas);

// 画面起動時の関数
window.onload = function() {
	initialize();
	//ユーザーの現在の位置情報を取得
	navigator.geolocation.getCurrentPosition(successCallback, errorCallback);
}

// 初期化の関数
function initialize(){
	//現在地の取得
	getGeoLocation();
	// LinkDataからデータの読み込み
	loadData();
	// バス停情報のロード
	loadBusStopData();
}

//######################################################################################################################################
//  地図関連
//######################################################################################################################################

//--------------------------------------
//  位置情報関連
//--------------------------------------

// 位置情報の取得
function getGeoLocation(){
	
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {
			// ユーザの現在位置を取得
			user_lat = position.coords.latitude; user_lng = position.coords.longitude;	// オリジナル
			//user_lat = 35.177541; user_lng = 137.087564;								// 公園駅
			//user_lat = 35.173806; user_lng = 137.089160;								// プール
			//user_lat = 35.168942; user_lng = 137.092158;								// 展望塔
			//user_lat = 35.182279; user_lng = 137.021347;								// 藤が丘駅
			//user_lat = 35.154545; user_lng = 136.961582;								// 名大
			var user_pos = new google.maps.LatLng(user_lat, user_lng);
			
		}, function() {
			handleNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		handleNoGeolocation(false);
	}
	
}

// 位置情報取得のエラー処理
function handleNoGeolocation(errorFlag) {
	if (errorFlag) {
		var content = '位置情報が取得できませんでした';
	} else {
		var content = 'ブラウザが位置情報機能に対応していません';
	}
	alert(content);
}


// 測地線航海算法の公式
function geoDistance(lat1, lng1, lat2, lng2, precision) {
  // 引数　precision は小数点以下の桁数（距離の精度）
  var distance = 0;
  if ((Math.abs(lat1 - lat2) < 0.00001) && (Math.abs(lng1 - lng2) < 0.00001)) {
    distance = 0;
  } else {
    lat1 = lat1 * Math.PI / 180;
    lng1 = lng1 * Math.PI / 180;
    lat2 = lat2 * Math.PI / 180;
    lng2 = lng2 * Math.PI / 180;
 
    var A = 6378140;
    var B = 6356755;
    var F = (A - B) / A;
 
    var P1 = Math.atan((B / A) * Math.tan(lat1));
    var P2 = Math.atan((B / A) * Math.tan(lat2));
 
    var X = Math.acos(Math.sin(P1) * Math.sin(P2) + Math.cos(P1) * Math.cos(P2) * Math.cos(lng1 - lng2));
    var L = (F / 8) * ((Math.sin(X) - X) * Math.pow((Math.sin(P1) + Math.sin(P2)), 2) / Math.pow(Math.cos(X / 2), 2) - (Math.sin(X) - X) * Math.pow(Math.sin(P1) - Math.sin(P2), 2) / Math.pow(Math.sin(X), 2));
 
    distance = A * (X + L);
    var decimal_no = Math.pow(10, precision);
    distance = Math.round(decimal_no * distance / 1) / decimal_no;   // kmに変換するときは(1000で割る)
  }
  return distance;
}

//--------------------------------------
//  全体マップ
//--------------------------------------

// 全体地図の表示
function mapCanvas() {
	
	createMap('map-canvas');
	
	// スポットにマーカーを設置
	var spotIcon =  new google.maps.MarkerImage('http://app.linkdata.org/asset/a5b95d25.png');
	spotIcon.scaledSize = new google.maps.Size(32, 51);
	
	for (var i in spot_data){
		if (spot_data[i].name) {
			// マップにマーカーを追加
			var spot_pos = new google.maps.LatLng(spot_data[i].lat, spot_data[i].lng);
			var contentString = '<b>'+ spot_data[i].name+'</b>';
			createMarker(spot_data[i].id,contentString,spot_pos,spotIcon,map);
		}
	}
	
	// マップの画面を合わせる
	var pageHeight = $(document).height();
	$("#map-canvas").css("height",pageHeight - 40);
}

// マップ作成
function createMap(divId){
	
	var mapOptions = {
		zoom: 16,
		mapTypeControl: false,
		streetViewControl: false,
		panControl: false,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	map = new google.maps.Map(document.getElementById(divId),mapOptions);
	
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {
			// 地図の中央をモリコロへ
			var mori_pos = new google.maps.LatLng(35.172687, 137.087550);
			map.setCenter(mori_pos);
			
			// ユーザの現在位置にマーカーを設置
			user_lat = position.coords.latitude;
			user_lng = position.coords.longitude;
			var user_pos = new google.maps.LatLng(user_lat, user_lng);
			var userIcon = new google.maps.MarkerImage('http://app.linkdata.org/asset/26cb1671.png');
			userIcon.scaledSize = new google.maps.Size(32, 51);
			
			var user_mk = new google.maps.Marker({
				 position: user_pos,
				 map: map,
				 icon: userIcon,
				 title: '現在位置'
			});
			var user_iw = new google.maps.InfoWindow({
				content: '現在位置'
			});
			google.maps.event.addListener(user_mk, 'click', function() {
				user_iw.open(map,user_mk);
			});
			
		}, function() {
			mapNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		mapNoGeolocation(false);
	}
	
}


// スポットマーカーの設置
function createMarker(id,content,latlng,icon,map){
	var spot_iw = new google.maps.InfoWindow();

		
	var spot_mk = new google.maps.Marker({
		id: id,
		position: latlng,
		map: map,
		icon: icon
	});
	
	google.maps.event.addListener(spot_mk, 'click', function() {
		if (currentWindow) {
			currentWindow.close();
		}
		spot_iw.setContent(content);
		spot_iw.open(map,spot_mk);
		currentWindow = spot_iw;
	});
} 


// エラー処理
function mapNoGeolocation(errorFlag) {
	if (errorFlag) {
		var content = '位置情報が取得できませんでした';
	} else {
		var content = 'ブラウザが位置情報機能に対応していません';
	}
	
	var options = {
		map: map,
		zoom: 15,
		position: new google.maps.LatLng(35.172778, 137.089797),
		content: content
	};
	var infowindow = new google.maps.InfoWindow(options);
	map.setCenter(options.position);
}



//--------------------------------------
//  バスマップ
//--------------------------------------

// バスマップ画面の地図
function busMapCanvas() {
	// 初期設定
	var cr_time	= new Date();				// オリジナル
	//var cr_time	= new Date(2014,6,13,10,50);	// 7/13 10:50
	var min_distance = '100000';	// 現在地とバス停の距離の中でもっとも近いものの距離
	var nearest_stop = '1';	// もっとも近いバス停のid
	var nearest_stop_str = '<b>地球市民交流センター</b>';
	var nearest_stop_str2 = '<b>地球市民交流センター</b>';
	var icon =  new google.maps.MarkerImage('http://app.linkdata.org/asset/be213440.png');
	icon.scaledSize = new google.maps.Size(32, 51);
	
	// マップ作成
	createBusMap('bus-map-canvas');
	
	// マーカー設置
	for (var i in stop_data){
		if (stop_data[i].name) {
			// 距離を計算
			var stop_pos = new google.maps.LatLng(stop_data[i].lat, stop_data[i].lng);
			var distance = geoDistance(user_lat, user_lng, stop_data[i].lat, stop_data[i].lng, -1);
			
			// マーカーの内容
			var str = '';
			var str2 = '';
			// 1km以内の場合
			if (distance < 1000) {
				// 徒歩時分を計算
				var walk_time = Math.round(distance / 50);
				// 到着時刻を計算
				var ar_time = new Date(cr_time.getTime() + walk_time * 60 * 1000);
				var hour 	= ar_time.getHours();
				var min 	= ar_time.getMinutes();
				if (min < 10) {
					min = '0' + min;
				}
				// 表示する形ににまとめる
				str = '<br>約'+ distance + 'm, 徒歩約'+ walk_time +'分, '+ hour +':'+ min +'頃到着見込';
				str2 = '<br>徒歩約'+ walk_time +'分';
				
			// 4km以内の場合
			} else if (distance < 4000) {
				// 徒歩時分を計算
				var walk_time = Math.round(distance / 50);
				// 到着時刻を計算
				var ar_time = new Date(cr_time.getTime() + walk_time * 60 * 1000);
				var hour 	= ar_time.getHours();
				var min 	= ar_time.getMinutes();
				if (min < 10) {
					min = '0' + min;
				}
				// 表示する形ににまとめる
				var dis_str = Math.round(distance / 100) / 10;
				str = '<br>約'+ dis_str + 'km, 徒歩約'+ walk_time +'分, '+ hour +':'+ min +'頃到着見込';
				str2 = '<br>徒歩約'+ walk_time +'分';
				
			// 10km以内の場合
			} else if (distance < 10000) {
				var dis_str = Math.round(distance / 100) / 10;
				str = '<br>約'+ dis_str + 'km';
			}
			
			var content = '<b>'+ stop_data[i].name+'</b>'+ str2;		// infoWindowに表示するのは、バス停名と徒歩時分
			var contentString = '<b>'+ stop_data[i].name+'</b>'+ str;	// ヘッダーに表示するのは、バス停名と距離と徒歩時分と到着見込み時刻
			
			// マーカーを作成
			createBusStopMarker(stop_data[i].id,content,contentString,stop_pos,icon,map);
			
			// 距離を比較して最小値を求める
			if (min_distance == '' || distance < min_distance) {
				min_distance = distance;
				nearest_stop = stop_data[i].id;
				nearest_stop_name = stop_data[i].name;
				nearest_stop_str = content;
				nearest_stop_str2 = contentString;
			}
		}
	}
	
	// 公園から離れている場合は、もっともちかいバス停を地球市民交流センターにする
	if (min_distance > 10000) {
		nearest_stop = 1;
		nearest_stop_str = '<b>地球市民交流センター</b>';
		nearest_stop_str2 = '<b>地球市民交流センター</b>';
	}
	// バス停のうちもっとも近いものをピックアップして情報を表示
	showStopData(nearest_stop);
	nearest_stop = nearest_stop - 1;
	
	// 地図の中央をもっとも近いバス停付近へ
	var lat = parseFloat(stop_data[nearest_stop].lat) + 0.0009;
	var pos = new google.maps.LatLng(lat, stop_data[nearest_stop].lng);
	map.setCenter(pos);
	
	// infoWindowの表示
	var spot_iw = new google.maps.InfoWindow();
	spot_iw.setContent(nearest_stop_str);
	spot_iw.setPosition(pos);
	spot_iw.open(map);
	currentWindow = spot_iw;
	
	// ヘッダーにバス停情報の表示
	$("#stop-name").empty();
	$("#stop-name").append(nearest_stop_str2);
	
	// マップの画面を合わせる
	var pageHeight = $(document).height();
	$("#bus-map-canvas").css("height",200);
}


// マップ作成
function createBusMap(divId){
	
	var mapOptions = {
		zoom: 16,
		mapTypeControl: false,
		streetViewControl: false,
		panControl: false,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	map = new google.maps.Map(document.getElementById(divId),mapOptions);
	
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {
			
			
			// ユーザの現在位置にマーカーを設置
			user_lat = position.coords.latitude;
			user_lng = position.coords.longitude;
			var user_pos = new google.maps.LatLng(user_lat, user_lng);
			
			var userIcon = new google.maps.MarkerImage('http://app.linkdata.org/asset/26cb1671.png');
			userIcon.scaledSize = new google.maps.Size(32, 51);
			
			var user_mk = new google.maps.Marker({
				 position: user_pos,
				 map: map,
				 icon: userIcon,
				 title: '現在位置'
			});
			var user_iw = new google.maps.InfoWindow({
				content: '現在位置'
			});
			google.maps.event.addListener(user_mk, 'click', function() {
				user_iw.open(map,user_mk);
			});
		}, function() {
			busMapNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		busMapNoGeolocation(false);
	}
	
}

//バス停マーカーの設置
function createBusStopMarker(id,content,contentString, latlng,icon,map){
	var spot_iw = new google.maps.InfoWindow();
		
	var spot_mk = new google.maps.Marker({
		id: id,
		position: latlng,
		map: map,
		icon: icon
	});
	
	google.maps.event.addListener(spot_mk, 'click', function() {
		if (currentWindow) {
			currentWindow.close();
		}
		spot_iw.setContent(content);
		spot_iw.open(map,spot_mk);
		currentWindow = spot_iw;
		// ヘッダーにバス停情報の表示
		$("#stop-name").empty();
		$("#stop-name").append(contentString);
		// 時刻表の表示
		showStopData(id);
	});
} 

// バス停が選択されたときにデータを表示
//----------------------------
function showStopData(selectedId) {
	//データのリセット
	$("#stop-info").empty();
	$("#stop-info2").empty();
	$("#timetable").empty();
	$("#timetable2").empty();
	var cr_time	= new Date();
	//var cr_time	= new Date(2014,6,13,10,50);
	var hour 	= cr_time.getHours();
	
	// 地球市民交流センター, 公園西口の場合の処理
	if (selectedId == 12){
		selectedId = 1;
	}
	if (selectedId == 9){
		selectedId = 6;
	}
	
	// 停留所データ
	if (selectedId == 1) {
		$("#stop-info").append('<b>フィールドセンター（もりの学舎）方面</b>');
		$("#stop-info2").append('<b>当停留所終点(到着時刻)</b>');
	} else if (selectedId == 6) {
		$("#stop-info").append('<b>フィールドセンター（もりの学舎）方面</b>');
		$("#stop-info2").append('<b>地球市民交流センター方面</b>');
	} else if (selectedId < 8) {
		$("#stop-info").append('<b>フィールドセンター（もりの学舎）方面</b>');
	} else {
		$("#stop-info").append('<b>地球市民交流センター方面</b>');
	}
	
	// 時刻表データ
	var table = $("#timetable");
	var tbody = $('<tbody>');
	var th = $('<tr class="tr-timetable">').append('<th class="th-hour">時</th><th class="th-week">平日</th><th class="th-holi">土・休日</th>');
	table.append($('<thead>').append(th));
	
		
	// 8~17時の毎時の発車時刻を抽出する
	for (var i=8; i<18; i++) {
		
		// 平日時刻データを入れる
		var week_min = '';
		for (var j in week_data){
			// 選択したバス停idのものを抜き出す
			if (week_data[j].stop_num == selectedId) {
				var timeArray = week_data[j].d_time.split(":");
					
				// 時が一致している場合、分を取り出す
				if (timeArray[0]==i) {
					week_min = week_min +'<a href="#busTimePopup" onclick="popupWeekBusTime('+ week_data[j].bus_id +')" data-rel="popup" data-role="none" data-transition="pop">'+ timeArray[1] + '</a> ';
				}
			}
		}
		var td_week = '<td class="td-week">'+ week_min + '</td>';
		
		
		// 休日の時刻データをいれる
		var holi_min = '';
		for (var k in holi_data) {
			// 選択したバス停idのものを抜き出す
			if (holi_data[k].stop_num == selectedId) {
				var timeArray = holi_data[k].d_time.split(":");
				// 時が一致している場合、分を取り出す
				if (timeArray[0]==i) {
					holi_min = holi_min +'<a href="#busTimePopup" onclick="popupHoliBusTime('+ holi_data[k].bus_id +')" data-rel="popup" data-role="none" data-transition="pop">'+ timeArray[1] + '</a> ';
				}
			}
		}
		var td_holi = '<td class="td-holi">'+ holi_min + '</td>';
		
		// 時間の行を表示する
		var td_hour = '<td class="td-hour">'+ i +'</td>';
		// いまの時刻の行のスタイルを変える
		if (hour == i || hour == i-1) {
			var tr = $('<tr class="tr-timetable tr-now">').append(td_hour + td_week + td_holi);
		} else {
			var tr = $('<tr class="tr-timetable tr-other">').append(td_hour + td_week + td_holi);
		}
		tbody.append(tr);
		
	}
	table.append(tbody);
	
	// 地球市民交流センター, 公園西口の場合の処理
	if (selectedId == 1 || selectedId == 6){
		// 停留所idの切り替え
		if (selectedId == 1){selectedId = 12;}
		if (selectedId == 6){ selectedId = 9;}
		
		var table2 = $("#timetable2");
		var tbody = $('<tbody>');
		var th = $('<tr class="tr-timetable">').append('<th class="th-hour">時</th><th class="th-week">平日</th><th class="th-holi">土・休日</th>');
		table2.append($('<thead>').append(th));
		
		// 8~17時の毎時の発車時刻を抽出する
		for (var i=8; i<18; i++) {
			
			// 平日時刻データを入れる
			var week_min = '';
			for (var j in week_data){
				// 選択したバス停idのものを抜き出す
				if (week_data[j].stop_num == selectedId) {
					var timeArray = week_data[j].d_time.split(":");
					// 時が一致している場合、分を取り出す
					if (timeArray[0]==i) {
						week_min = week_min +'<a href="#busTimePopup" onclick="popupWeekBusTime('+ week_data[j].bus_id +')" data-rel="popup" data-role="none" data-transition="pop">'+ timeArray[1] + '</a> ';
					}
				}
			}
			var td_week = '<td class="td-week">'+ week_min + '</td>';
			
			
			// 休日の時刻データをいれる
			var holi_min = '';
			for (var k in holi_data) {
				// 選択したバス停idのものを抜き出す
				if (holi_data[k].stop_num == selectedId) {
					var timeArray = holi_data[k].d_time.split(":");
					// 時が一致している場合、分を取り出す
					if (timeArray[0]==i) {
						holi_min = holi_min +'<a href="#busTimePopup" onclick="popupHoliBusTime('+ holi_data[k].bus_id +')" data-rel="popup" data-role="none" data-transition="pop">'+ timeArray[1] +'</a> ';
					}
				}
			}
			var td_holi = '<td class="td-holi">'+ holi_min + '</td>';
		
			// 時間の行を表示する
			var td_hour = '<td class="td-hour">'+ i +'</td>';
			if (hour == i || hour == i-1) {
				var tr = $('<tr class="tr-timetable tr-now">').append(td_hour + td_week + td_holi);
			} else {
				var tr = $('<tr class="tr-timetable tr-other">').append(td_hour + td_week + td_holi);
			}
			tbody.append(tr);
		
		}
		table2.append(tbody);
	}
	
	

}


// 平日バス時刻の表示
function popupWeekBusTime(bus_id) {
	// ページ初期化
	$('#busTimePopup').empty();
	// 時刻を表示
	for (var i in week_data) {
		if (week_data[i].bus_id == bus_id) {
			$('#busTimePopup').append('<p>'+ week_data[i].depart +' '+ week_data[i].stop_name +'</p>');
		}
	}
}
// 休日バス時刻の表示
function popupHoliBusTime(bus_id) {
	// ページ初期化
	$('#busTimePopup').empty();
	// 時刻を表示
	for (var i in holi_data) {
		if (holi_data[i].bus_id == bus_id) {
			$('#busTimePopup').append('<p>'+ holi_data[i].depart +' '+ holi_data[i].stop_name +'</p>');
		}
	}
}

// バスマップ用エラー処理
function busMapNoGeolocation(errorFlag) {
	if (errorFlag) {
		var content = '位置情報が取得できませんでした';
	} else {
		var content = 'ブラウザが位置情報機能に対応していません';
	}
	
	var options = {
		map: map,
		zoom: 15,
		position: new google.maps.LatLng(stop_data[0].lat, stop_data[0].lng),
		content: content
	};
	var infowindow = new google.maps.InfoWindow(options);
	map.setCenter(options.position);
}

//######################################################################################################################################
//  リスト表示関連
//######################################################################################################################################
//---------------------------------------------
//  イベントリストの表示
//---------------------------------------------

// イベントを探すボタン
function checkChoice () {
	
	// 絞り込みラジオボタンの値
	var radio = $('[name=time_choice]:checked').val();
	if (radio == 'now') {
		showEnableEvent ();
	} else if (radio == 'all') {
		showEventList ();
	}
}


// イベント情報の読み込み
function showEventList () {

	// ページ初期化
	$('.eventList').empty();
	
	// イベントリストの作成
	var eventCn  = 0; // イベント数のカウント
	var eventSum = 0; // イベント数合計
	
	// イベントタイムテーブルをループ
	for (var i in eventtime_data) {
		var event_id = eventtime_data[i].event_id;
		var onclick = 'onclick="showDetail('+  event_id  + ')"';
		
		// イベントリストをループさせ、該当するイベントを抜き出す
		for (var j in eventlist_data) {
			if (eventtime_data[i].event_id == eventlist_data[j].id) {
				var li = '';
				var devider = ''
					
				//---------------------
				//  リスト区切りとイベント数表示について
				//---------------------
				// リスト1行目の場合
				if (i == 0){
					// 日付毎のセクション区切りを挿入
					devider = '<li data-role="list-divider">'+ eventtime_data[i].date +'のイベント一覧<span class="ui-li-count '+ eventtime_data[i].date2 +'event"></span></li>';
					$('.eventList').append(devider);
					
				// リスト最終行の場合
				} else if (i == eventtime_data.length - 1) {
					// 最終セクションのイベント数欄に値を代入
					var str = '.'+ eventtime_data[i].date2 +'event';
					$(str).append(eventCn + 1);
					
				// 日付が変わった場合	
				} else if (eventtime_data[i].date != eventtime_data[i-1].date){
					// 前のセクションのイベント数欄に値を代入
					var str = '.'+ eventtime_data[i-1].date2 +'event';
					$(str).append(eventCn);
					// イベント数カウントを初期化
					eventCn = 0;
					// 日付毎のセクション区切りを挿入
					devider = '<li data-role="list-divider">'+ eventtime_data[i].date +'のイベント一覧<span class="ui-li-count '+ eventtime_data[i].date2 +'event"></span></li>';
					$('.eventList').append(devider);
				}
				
				//---------------------
				//  各イベントの内容をリストに加えるところ
				//---------------------
				
				// このあたりで、チェックボックスの選択によって、表示に加えるか否かを振り分ける予定
				
				// リンク部分
				li = li + '<li><a href="#detail" data-transition="slide" '+ onclick +'>';
				// イベントジャンル
				li = li + '<p style="font-size:70%;">'+ eventlist_data[j].genre +'</p>';
				var genre_id = eventlist_data[j].genre_id;
				
				// 開始時刻（なければ「未定」表示）
				if (eventtime_data[i].start) {
					li = li + '<p class="ui-li-aside"><span style="font-size:130%;">'+ eventtime_data[i].start +'</span> ~ ';
				} else {
					li = li + '<p class="ui-li-aside"><span style="font-size:130%;">未定</span> ~';
				}
				// 終了時刻（なければ表示しない）
				if (eventtime_data[i].end) {
					li = li + '<span style="font-size:90%;">'+ eventtime_data[i].end +'</span>';
				}
				// イベント名
				li = li + '</p><h4>'+ eventlist_data[j].title +'</h4>';
				// イベント紹介文（なければ表示しない）
				if (eventlist_data[j].text) {
					li = li + '<p><b>'+ eventlist_data[j].text +'</b></p>';
				}
				// 場所
				li = li + '<p>●'+ eventlist_data[j].spot +'</p></a></li>';
				
				
			}
			
		}
		// リストに追加
		var genre_choice = '#genre_'+ genre_id;
		if ($(genre_choice).prop('checked')) {
			$('.eventList').append(li);
			// イベント数カウントを増やす
			eventCn++;
			eventSum++;
		}

	}
	// 全てのイベント数を表示
	$('.allEventCount').empty();
	$('.allEventCount').append(eventSum);
	
	// CSSの初期化
	$('.eventList').listview().listview('refresh'); // イベントリスト
	
}


// 参加可能イベント情報の読み込み
function showEnableEvent () {
	// ページ初期化
	$('.eventList').empty();
	$('.allEventCount').empty();
	var eventCn  = 0; // イベント数のカウント
	var eventSum = 0; // イベント数合計
	
	// 現在時刻取得
	var cr_time	= new Date();
	//var cr_time	= new Date(2014,6,13,10,50);
	var year 	= cr_time.getFullYear();
	var month 	= cr_time.getMonth()+1;
	var day 	= cr_time.getDate();
	var hour 	= cr_time.getHours();
	var min 	= cr_time.getMinutes();
	if (min < 10) {
		min = '0' + min;
	}
	
	//---------------------
	//  リスト区切り
	//---------------------
	var devider = '<li data-role="list-divider">'+ month +'/'+ day +' '+ hour +':'+ min +'現在</li>';
	$('.eventList').append(devider);
	var before_timing = '';
	
	// イベントタイムテーブルをループ
	for (var i in eventtime_data) {
		var li = '';
		var event_id = eventtime_data[i].event_id;
		var onclick = 'onclick="showDetail('+  event_id  + ')"';
		eventtime_data[i].timing = '';
		
		
		// タイミングを調べる。今日のイベントでまだ終わっていないものを抽出
		if(year  == eventtime_data[i].s_time.getFullYear() &&
		   month == eventtime_data[i].s_time.getMonth() +1 &&
		   day   == eventtime_data[i].s_time.getDate() ){
			// 開始時間が入っているか
			if (eventtime_data[i].start) {
				
				// 終了時間が入っているか
				if (eventtime_data[i].end) {
					// 両方入っている場合の処理
					
					// まだ終わっていないものを抽出
					if (cr_time.getTime() < eventtime_data[i].e_time.getTime() ) {
			 			// 既に始まっているものはtiming=1
						if (cr_time.getTime() > eventtime_data[i].s_time.getTime()) {
							eventtime_data[i].timing = 1;
						// 30分以内に始まるものはtiming=2
						} else if (cr_time.getTime() + 31 * 60 * 1000 > eventtime_data[i].s_time.getTime()) {
							eventtime_data[i].timing = 2;
						// 30分以降に始まるものはtiming=3
						} else {
							eventtime_data[i].timing = 3;
						}
					}
					
				} else{
					// 開始時間のみ入っている場合の処理
					if (cr_time.getTime() > eventtime_data[i].s_time.getTime()) {
						// 既に始まっているものはtimingなし
					} else if (cr_time.getTime() + 31 * 60 * 1000 > eventtime_data[i].s_time.getTime()) {
						// 30分以内に始まるものはtiming=2
						eventtime_data[i].timing = 2;
					} else {
						// 30分以降に始まるものはtiming=3
						eventtime_data[i].timing = 3;
					}
					
				}
			} else {
				
				// 終了時間が入っているか
				if (eventtime_data[i].end) {
					// 終了時間のみ入っている場合の処理
					if (cr_time.getTime() < eventtime_data[i].e_time.getTime() ) {
						// まだ終わっていないものを抽出
						eventtime_data[i].timing = 3;
					}
				}
			}
		} 
		
			
		if (eventtime_data[i].timing) {
			
			// イベントリストをループさせ、該当するイベントを抜き出す
			for (var j in eventlist_data) {
				if (eventtime_data[i].event_id == eventlist_data[j].id) {
					
					
					//---------------------
					//  リスト区切り
					//---------------------
					// タイミングが変わった場合、区切りを挿入
					if (eventtime_data[i].timing != before_timing){
						if (eventtime_data[i].timing == 1) {
							// 開催中イベントについて
							devider = '<li data-role="list-divider">開催中のイベント</li>';
						} else if (eventtime_data[i].timing == 2) {
							// 30分以内の開催イベントについて
							devider = '<li data-role="list-divider">まもなく開始のイベント</li>';
						} else {
							// 本日中に開催するイベントについて
							devider = '<li data-role="list-divider">本日中に開催するイベント</li>';
						}
						$('.eventList').append(devider);
					}
					
					//---------------------
					//  各イベントの内容をリストに加えるところ
					//---------------------
					// リンク部分
					li = li + '<li><a href="#detail" data-transition="slide" '+ onclick +'>';
					// イベントジャンル
					li = li + '<p style="font-size:70%;">'+ eventlist_data[j].genre +'</p>';
					var genre_id = eventlist_data[j].genre_id;
					
					// 既に始まっているイベントは終了時間を大きく表示
					if (eventtime_data[i].timing == 1) {
						// 開始時刻（なければ「未定」表示）
						if (eventtime_data[i].start) {
							li = li + '<p class="ui-li-aside"><span style="font-size:80%;">'+ eventtime_data[i].start +'</span> ~ ';
						} else {
							li = li + '<p class="ui-li-aside"><span style="font-size:80%;">未定</span> ~';
						}
						// 終了時刻（なければ表示しない）
						if (eventtime_data[i].end) {
							li = li + '<span style="font-size:130%;">'+ eventtime_data[i].end +'</span>';
						}
					// まだ始まっていないイベントは開始時間を大きく表示 
					} else {
						// 開始時刻（なければ「未定」表示）
						if (eventtime_data[i].start) {
							li = li + '<p class="ui-li-aside"><span style="font-size:130%;">'+ eventtime_data[i].start +'</span> ~ ';
						} else {
							li = li + '<p class="ui-li-aside"><span style="font-size:130%;">未定</span> ~';
						}
						// 終了時刻（なければ表示しない）
						if (eventtime_data[i].end) {
							li = li + '<span style="font-size:90%;">'+ eventtime_data[i].end +'</span>';
						}
					}
					// イベント名
					li = li + '</p>'+ eventlist_data[j].title +'</h4>';
					// イベント紹介文（なければ表示しない）
					if (eventlist_data[j].text) {
						li = li + '<p><b>'+ eventlist_data[j].text +'</b></p>';
					}
					// 場所
					li = li + '<p>●'+ eventlist_data[j].spot +'</p></a></li>';
					
					// timingを保存
					before_timing = eventtime_data[i].timing;
					break;
				}
			}
		}
		
		// リストに追加
		var genre_choice = '#genre_'+ genre_id;
		if ($(genre_choice).prop('checked')) {
			$('.eventList').append(li);
			// イベント数カウントを増やす
			eventCn++;
			eventSum++;
		}
	}
	if (eventSum == 0) {
		$('.eventList').append('<li>本日開催のイベントはありません。<br>（夏まつりは7/12,13開催です）</li>');
	}
	
	// CSSの初期化
	$('.eventList').listview().listview('refresh'); // イベントリスト

}

//######################################################################################################################################
//  イベント詳細ページ関連
//######################################################################################################################################

//--------------------------------------------
// イベント詳細ページ
//--------------------------------------------

// イベント詳細ページを開く
function showDetail(event_id) {
	// テーブルの配列に合わせる
	var id = event_id - 1;
	sel_spot_id = eventlist_data[id].spot_id;
	// ページ初期化
	$('#detail-content').empty();
	
	// イベントジャンル
	if (eventlist_data[id].genre){
		$('#detail-content').append('<p style="font-size:80%;">'+ eventlist_data[id].genre +'</p>');
	}
	// イベントタイトル
	$('#detail-content').append('<h3>'+ eventlist_data[id].title +'</h3>');
	// 本文
	if (eventlist_data[id].text){
		$('#detail-content').append('<p>'+ eventlist_data[id].text +'</p>');
	}
	
	//---------------------------
	// 情報テーブルの作成
	//---------------------------
 	var table = '<table id="tbl" data-role="table" data-mode="column-toggle" class="ui-responsive"><thead></thead><tbody>';
	
	// 日時
	table = table + '<tr><td class="event-table-item">日時</td><td>'
	for (var i in eventtime_data){
		if (event_id == eventtime_data[i].event_id){
			table = table + '<p>'+ eventtime_data[i].date +' '+ eventtime_data[i].start +'~'+ eventtime_data[i].end +'</p>';
		}
	}
	table = table + '</td></tr>'
	
	// スポット
	if (eventlist_data[id].spot){
		table = table + '<tr><td class="event-table-item">場所</td><td>'+ eventlist_data[id].spot +'</td></tr>'
	}
	
	// 料金
	if (eventlist_data[id].fee){
		if (eventlist_data[id].fee == '0'){
			table = table + '<tr><td class="event-table-item">料金</td><td>無料</td></tr>'
		} else {
			table = table + '<tr><td class="event-table-item">料金</td><td>'+ eventlist_data[id].fee +'</td></tr>'
		}
	}
	// 定員
	if (eventlist_data[id].limit && eventlist_data[id].limit != '0'){
		table = table + '<tr><td class="event-table-item">定員</td><td>'+ eventlist_data[id].limit +'</td></tr>'
	}
	// 対象
	if (eventlist_data[id].target){
		table = table + '<tr><td class="event-table-item">対象</td><td>'+ eventlist_data[id].target +'</td></tr>'
	}
	// 参加方法
	if (eventlist_data[id].how){
		table = table + '<tr><td class="event-table-item">受付</td><td>'+ eventlist_data[id].how +'</td></tr>'
	}
	// 備考
	if (eventlist_data[id].info){
		table = table + '<tr><td class="event-table-item">備考</td><td>'+ eventlist_data[id].info +'</td></tr>'
	}
	
	table = table + '</tbody></table>'
		
	$('#detail-content').append(table);
	$('</table>').appendTo( ".ui-page" ).trigger( "create" );
	
}



//--------------------------------------
//  イベント詳細マップ
//--------------------------------------

// イベント詳細画面の地図
function detailMapCanvas() {
	var id = sel_spot_id - 1;
	
	createDetailMap('detail-map-canvas');
	
	// スポットにマーカーを設置
	var spotIcon =  new google.maps.MarkerImage('http://app.linkdata.org/asset/a5b95d25.png');
	spotIcon.scaledSize = new google.maps.Size(32, 51);
	var pos = new google.maps.LatLng(spot_data[id].lat, spot_data[id].lng);
	var distance = geoDistance(user_lat, user_lng, spot_data[id].lat, spot_data[id].lng, -1);
			
	// マーカーの内容
	var str = '';
	var str2 = '';
	
	// 1km以内の場合
	if (distance < 1000) {
		// 徒歩時分を計算
		//var walk_time = Math.round(distance / 50);
		// 到着時刻を計算
		//var ar_time = new Date(cr_time.getTime() + walk_time * 60 * 1000);
		//var hour 	= ar_time.getHours();
		//var min 	= ar_time.getMinutes();
		//if (min < 10) {
		//	min = '0' + min;
		//}
		// 表示する形ににまとめる
		str = '<br>約'+ distance + 'm';
		//str = '<br>約'+ distance + 'm, 徒歩約'+ walk_time +'分, '+ hour +':'+ min +'頃到着見込';
		//str2 = '<br>徒歩約'+ walk_time +'分';
		
		// 4km以内の場合
	} else if (distance < 4000) {
		
		// 徒歩時分を計算
		//var walk_time = Math.round(distance / 50);
		// 到着時刻を計算
		//var ar_time = new Date(cr_time.getTime() + walk_time * 60 * 1000);
		//var hour 	= ar_time.getHours();
		//var min 	= ar_time.getMinutes();
		//if (min < 10) {
		//	min = '0' + min;
		//}
		// 表示する形ににまとめる
		var dis_str = Math.round(distance / 100) / 10;
		str = '<br>約'+ dis_str + 'km';
		//str = '<br>約'+ dis_str + 'km, 徒歩約'+ walk_time +'分, '+ hour +':'+ min +'頃到着見込';
		//str2 = '<br>徒歩約'+ walk_time +'分';
		
	// 10km以内の場合
	} else if (distance < 10000) {
		var dis_str = Math.round(distance / 100) / 10;
		str = '<br>約'+ dis_str + 'km';
	} 
	
	var content = '<b>'+ spot_data[id].name+'</b>'+ str2;		// 
	var contentString = '<b>アクセス</b> <a href="http://maps.google.com/maps?q='+ spot_data[id].lat +','+ spot_data[id].lng +'" target="_blank">マップで開く</a>'+ str;	// 
	
	// マップにマーカーを追加
	createDetailMarker(id,content,pos,spotIcon,map);
	
	// 地図の中央をスポットへ
	var lat = parseFloat(spot_data[id].lat) + 0.0009;
	var pos = new google.maps.LatLng(lat, spot_data[id].lng);
	map.setCenter(pos);
	
	// ヘッダーにアクセスの表示
	$("#detail_spot_name").empty();
	$("#detail_spot_name").append(contentString);
	
	// バス停情報の表示
	$("#bus_info").empty();
	$("#bus_info").append(spot_data[id].bus_info);
	
}


// マップ作成
function createDetailMap(divId){
	
	var mapOptions = {
		zoom: 16,
		center: new google.maps.LatLng(35.172687, 137.087550),
		mapTypeControl: false,
		streetViewControl: false,
		panControl: false,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	map = new google.maps.Map(document.getElementById(divId),mapOptions);
	// HTML5 geolocation 機能で現在地を取得
	if(navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(function(position) {

			
			// ユーザの現在位置にマーカーを設置
			user_lat = position.coords.latitude;
			user_lng = position.coords.longitude;
			var user_pos = new google.maps.LatLng(user_lat ,user_lng);
			var userIcon = new google.maps.MarkerImage('http://app.linkdata.org/asset/26cb1671.png');
			userIcon.scaledSize = new google.maps.Size(32, 51);
			
			var user_mk = new google.maps.Marker({
				 position: user_pos,
				 map: map,
				 icon: userIcon,
				 title: '現在位置'
			});
			var user_iw = new google.maps.InfoWindow({
				content: '現在位置'
			});
			google.maps.event.addListener(user_mk, 'click', function() {
				user_iw.open(map,user_mk);
			});
		}, function() {
			//mapNoGeolocation(true);
		});
	} else {
		// ブラウザがGeolocationをサポートしていない
		//mapNoGeolocation(false);
	}
	
}

// スポットマーカーの設置
function createDetailMarker(id,content,latlng,icon,map){
	// マーカーの作成
	var marker = new google.maps.Marker({
		id: id,
		position: latlng,
		map: map,
		icon: icon
	});
	
	// infoWindowの作成
	var infoWindow = new google.maps.InfoWindow();
	google.maps.event.addListener(marker, 'click', function() {
		if (currentWindow) {
			currentWindow.close();
		}
		infoWindow.setContent(content);
		infoWindow.open(map,marker);
		currentWindow = infoWindow;
	});
	// infoWindowを開く
	if (currentWindow) {
		currentWindow.close();
	}
	infoWindow.setContent(content);
	infoWindow.open(map,marker);
	currentWindow = infoWindow;
} 

//######################################################################################################################################
//  データ読み込み関連
//######################################################################################################################################

//--------------------------------------------
// データの読み込み
//--------------------------------------------

// LinkDataからデータの読み込み
function loadData() {
	
	// LinkDataからのデータの取得
	var workValue = 'rdf1s1588i';
	
	//---------------------------------------------------
	// スポットデータの読み込み
	//---------------------------------------------------
	var fileValue = 'moricoro_event_spot_list';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#name'){
					tmp_data['name'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#yomi_name'){
					tmp_data['yomi_name'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#lat'){
					tmp_data['lat'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#lng'){
					tmp_data['lng'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#bus_info'){
					tmp_data['bus_info'] = objValue;
				} 
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	spot_data = tmp_dataArray; // スポットデータを代入
	
	//---------------------------------------------------
	// イベントジャンルデータの読み込み
	//---------------------------------------------------
	var fileValue = 'moricoro_event_genre';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#genre'){
					tmp_data['genre'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#info'){
					tmp_data['info'] = objValue;
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	genre_data = tmp_dataArray; // イベントジャンルデータを代入
	
		
	//---------------------------------------------------
	// イベントタイムテーブルの読み込み
	//---------------------------------------------------
	var fileValue = 'moricoro_fes_2014sum_event_timetable';
	tmp_dataArray = new Array();
	
		$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = {}
		s_time = new Date();
		e_time = new Date();
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#event_id'){
					tmp_data['event_id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#date'){
					var array = objValue.split("-");
					tmp_data['date'] = array[1] +'/'+ array[2];
					tmp_data['date2']= array[1] + array[2];
					s_time.setFullYear(array[0]);
					s_time.setMonth(array[1]-1);
					s_time.setDate(array[2]);
					e_time.setFullYear(array[0]);
					e_time.setMonth(array[1]-1);
					e_time.setDate(array[2]);
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#start'){
					var array = objValue.split(":");
					tmp_data['start'] = array[0] +':'+ array[1];
					s_time.setHours(array[0]);
					s_time.setMinutes(array[1]);
					tmp_data['s_time'] = s_time;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#end'){
					var array = objValue.split(":");
					tmp_data['end'] = array[0] +':'+ array[1];
					e_time.setHours(array[0]);
					e_time.setMinutes(array[1]);
					tmp_data['e_time'] = e_time;
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	eventtime_data = tmp_dataArray; // イベントデータを代入
	
	//---------------------------------------------------
	// イベントリストデータの読み込み
	//---------------------------------------------------
	var fileValue = 'moricoro_fes_2014sum_event_list';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		
		var tmp_data = {}
		
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
					tmp_data['id'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#event_title'){
					tmp_data['title'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#subtitle'){
					tmp_data['text'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#spot'){
					tmp_data['spot_id'] = objValue;
					for (var i in spot_data) {
						if (objValue == spot_data[i].id){
							tmp_data['spot'] = spot_data[i].name;
						}
					}
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#genre'){
					tmp_data['genre_id'] = objValue;
					for (var i in genre_data) {
						if (objValue == genre_data[i].id){
							tmp_data['genre'] = genre_data[i].genre;
						}
					}
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#fee'){
					tmp_data['fee'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#limit'){
					tmp_data['limit'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#target'){
					tmp_data['target'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#how_to_participate'){
					tmp_data['how'] = objValue;
				} else if (propValue == 'http://linkdata.org/property/rdf1s1588i#info'){
					tmp_data['info'] = objValue;
				}
			});
		});
		
		tmp_dataArray.push(tmp_data);
	});
	
	eventlist_data = tmp_dataArray; // イベントデータを代入
}

// LinkDataからバスデータの読み込み
function loadBusStopData() {
	
	// LinkDataからのデータの取得
	var workValue = 'rdf1s1494i';
	var fileValue = 'moricoro_park_busstops';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
		var tmp_data = {}
			$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
				$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
					if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
						tmp_data['id'] = objValue;
					} else if (propValue == "http://linkdata.org/property/rdf1s1494i#number"){
						tmp_data["num"] = objValue;
					} else if (propValue == "http://linkdata.org/property/rdf1s1494i#name"){
						tmp_data["name"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1494i#yomi_name"){
						tmp_data["yomi_name"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1494i#total_time"){
						tmp_data["total_time"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1494i#lat"){
						tmp_data["lat"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1494i#lon"){
						tmp_data["lng"] = objValue;
					} 
			});
		});
		tmp_dataArray.push(tmp_data);
	});
	
	stop_data = tmp_dataArray; // 停留所データをstop_dataに代入
	
	// 平日時刻表の読み込み
	//------------------
	var fileValue = 'moricoro_park_bus_timetable_weekday';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
	 	var tmp_data = {}
	  	$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
						tmp_data['id'] = objValue;
				} else if (propValue == "http://linkdata.org/property/rdf1s1494i#stop_num"){
					tmp_data["stop_num"] = objValue;
				} else if (propValue == "http://linkdata.org/property/rdf1s1494i#stop_name"){
					tmp_data["stop_name"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#destination_name"){
					tmp_data["destination"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#depature_time"){
					tmp_data["d_time"] = objValue;
					var array = objValue.split(":");
					tmp_data['depart'] = array[0] +':'+ array[1];
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#bus_num"){
					tmp_data["bus_id"] = objValue;
				} 
			});
		});
		tmp_dataArray.push(tmp_data);
	});
	
	// 平日時刻表データ
	week_data = tmp_dataArray;
	
	// 休日時刻表の読み込み
	//--------------------
	fileValue = 'moricoro_park_bus_timetable_holiday';
	tmp_dataArray = new Array();
	
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
		var tmp_data = {}
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				if (propValue == 'http://www.w3.org/2000/01/rdf-schema#label'){
						tmp_data['id'] = objValue;
				} else if (propValue == "http://linkdata.org/property/rdf1s1494i#stop_num"){
					tmp_data["stop_num"] = objValue;
				} else if (propValue == "http://linkdata.org/property/rdf1s1494i#stop_name"){
					tmp_data["stop_name"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#destination_name"){
					tmp_data["destination"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#depature_time"){
					tmp_data["d_time"] = objValue;
					var array = objValue.split(":");
					tmp_data['depart'] = array[0] +':'+ array[1];
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#bus_num"){
					tmp_data["bus_id"] = objValue;
				} 
			});
		});
		tmp_dataArray.push(tmp_data);
	});
	// 休日時刻表データ
	holi_data = tmp_dataArray;
}
	
/*	ここから先は未使用



//---------------------------------------------------------
// 停留所データの表示
//---------------------------------------------------------
	
function showData(selectedId){
	
	//データのリセット
	$("#result").empty();
	$("#table").empty();
	tmp_b_data = new Array();
	tmp_c_data = new Array();
	
	// 時刻表シートから該当停留所の発車時刻を読み取る
	// 平日
	//------------------
	var fileValue = 'moricoro_park_bus_timetable_weekday';
	
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
		
	 	var tmp_data = {}
		
	  	tmp_data["id"] = subjValue;
		
	  	$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				
				if (propValue == "http://linkdata.org/property/rdf1s1494i#stop_num"){
					tmp_data["stop_num"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#destination_name"){
					tmp_data["destination"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#depature_time"){
					tmp_data["d_time"] = objValue;
				} 
			});
		});
		
	  	if (tmp_data["stop_num"] == selectedId) {
			tmp_b_data.push(tmp_data);
		}
	});
	
	// 平日時刻表データ
	week_data = tmp_b_data;
	
	// 休日
	//---------------
	fileValue = 'moricoro_park_bus_timetable_holiday';
	
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
		
		var tmp_data = {}
		tmp_data["id"] = subjValue;
		
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				
				if (propValue == "http://linkdata.org/property/rdf1s1494i#stop_num"){
					tmp_data["stop_num"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#destination_name"){
					tmp_data["destination"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#depature_time"){
					tmp_data["d_time"] = objValue;
				} 
			});
		});
		
		if (tmp_data["stop_num"] == selectedId) {
			tmp_c_data.push(tmp_data);
		}
	});
	// 休日時刻表データ
	holi_data = tmp_c_data;
	
	
	// データを表示
	//----------------------------
	
	// 停留所データ
	for (var i in stop_data){
		if (stop_data[i].num === selectedId){
			$("#result").append("<dt><b>停留所名</b><dt><dd>"+ stop_data[i].name +"<br>（"+ stop_data[i].yomi_name + "）</dd>");
			
			if (selectedId < 8) {
				$("#result").append("<h4>フィールドセンター（もりの学舎）方面</h4>");
			} else if (selectedId < 12) {
				$("#result").append("<h4>地球市民交流センター方面</h4>");
			} else {
				$("#result").append("<h4>当停留所終点(到着時刻)</h4>");
			}
		}
	}
	
	// 時刻表データ
	var table = $("#table");
	var tbody = $('<tbody>');
	var th = $('<tr class="tr-timetable">').append('<th class="th-hour">時</th><th class="th-week">平日</th><th class="th-holi">土・休日</th>');
	table.append($('<thead>').append(th));

	// 8~17時の毎時の発車時刻を抽出する
	for (var i=8; i<18; i++) {
		
		// 平日の時刻
		var week_min = '';
		for (var j in week_data) {
			var timeArray = week_data[j].d_time.split(":");
			
			if (timeArray[0]==i) {
				week_min = week_min + timeArray[1] + ' ';
			}
			
			var td_week = '<td class="td-week">'+ week_min + '</td>';
		}
		
		// 休日の時刻
		var holi_min = '';
		for (var k in holi_data) {
			var timeArray = holi_data[k].d_time.split(":");
			
			if (timeArray[0]==i) {
				holi_min = holi_min + timeArray[1] + ' ';
			}
			
			var td_holi = '<td class="td-holi">'+ holi_min + '</td>';
		}
		
		// 時間の行を表示する
		var td_hour = '<td class="td-hour">'+ i +'</td>';
		var td = $('<tr class="tr-timetable">').append(td_hour).append(td_week).append(td_holi);
		tbody.append(td);
		
	}
	table.append(tbody);
}
*/
