/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/


// グローバル変数
stop_data = new Array();
week_data = new Array();
holi_data = new Array();
var workValue = 'rdf1s1494i';

// Infoウィンドウの初期化
var currentWindow = null;

window.onload = function() {
	// マップの表示
	var myLatlng = new google.maps.LatLng(35.174849, 137.088325);
  	var mapOptions = {
		zoom: 17,
		center: myLatlng
	};
	var map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
	
	// LinkDataからのデータの取得
	var fileValue = 'moricoro_park_busstops';
	tmp_a_data = new Array();
	
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
		var tmp_data = {}
		tmp_data["id"] = subjValue;
			$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
				$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
					if (propValue == "http://linkdata.org/property/rdf1s1494i#number"){
						tmp_data["num"] = objValue;
					} else if (propValue == "http://linkdata.org/property/rdf1s1494i#name"){
						tmp_data["name"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1494i#yomi_name"){
						tmp_data["yomi_name"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1494i#total_time"){
						tmp_data["total_time"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1494i#lat"){
						tmp_data["lat"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1494i#lon"){
						tmp_data["lng"] = objValue;
					} 
			});
		});
		tmp_a_data.push(tmp_data);
	});
	
	stop_data = tmp_a_data; // 停留所データをstop_dataに代入
	
	// プルダウンメニューに停留所名を入れる
	$(".selectstop").append("<option value='-1' selected='selected'>停留所を選択してください</option>");
	for (var i in stop_data){
		if (stop_data[i].name) {
			var stop_id = stop_data[i].num;
			
			$(".selectstop").append("<option value='"+ stop_id +"'>" + stop_data[i].name + "</option>");
			
			if (i < 11) {
				// マップにマーカーを追加
				var stopLatlng = new google.maps.LatLng(stop_data[i].lat, stop_data[i].lng);
				var contentString = '<b>'+ stop_data[i].name+'</b>';
				createMarker(stop_id,contentString,stopLatlng,map);
  			}
		}
	}
	// 停留所間に経路を引く
	createPolyline(map);
	
	//---------------------------------------------------------
	//バス停が選択、変更された時の処理
	//---------------------------------------------------------
	$(".selectstop").change(function() {

		
		//選択された課の詳細データの表示
		var selectedId = $("option:selected", $(this)).val();
		if (selectedId == -1) {
			return;
		}
		
		showData(selectedId);

	});
	

}
	
	
//---------------------------------------------------------
// 停留所データの表示
//---------------------------------------------------------
	
function showData(selectedId){
	
	//データのリセット
	$("#result").empty();
	$("#table").empty();
	tmp_b_data = new Array();
	tmp_c_data = new Array();
	
	// 時刻表シートから該当停留所の発車時刻を読み取る
	// 平日
	//------------------
	var fileValue = 'moricoro_park_bus_timetable_weekday';
	
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
		
	 	var tmp_data = {}
		
	  	tmp_data["id"] = subjValue;
		
	  	$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				
				if (propValue == "http://linkdata.org/property/rdf1s1494i#stop_num"){
					tmp_data["stop_num"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#destination_name"){
					tmp_data["destination"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#depature_time"){
					tmp_data["d_time"] = objValue;
				} 
			});
		});
		
	  	if (tmp_data["stop_num"] == selectedId) {
			tmp_b_data.push(tmp_data);
		}
	});
	
	// 平日時刻表データ
	week_data = tmp_b_data;
	
	// 休日
	//---------------
	fileValue = 'moricoro_park_bus_timetable_holiday';
	
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
		
		var tmp_data = {}
		tmp_data["id"] = subjValue;
		
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
				
				if (propValue == "http://linkdata.org/property/rdf1s1494i#stop_num"){
					tmp_data["stop_num"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#destination_name"){
					tmp_data["destination"] = objValue;
				} else if(propValue == "http://linkdata.org/property/rdf1s1494i#depature_time"){
					tmp_data["d_time"] = objValue;
				} 
			});
		});
		
		if (tmp_data["stop_num"] == selectedId) {
			tmp_c_data.push(tmp_data);
		}
	});
	// 休日時刻表データ
	holi_data = tmp_c_data;
	
	
	// データを表示
	//----------------------------
	
	// 停留所データ
	for (var i in stop_data){
		if (stop_data[i].num === selectedId){
			$("#result").append("<dt><b>停留所名</b><dt><dd>"+ stop_data[i].name +"<br>（"+ stop_data[i].yomi_name + "）</dd>");
			
			if (selectedId < 8) {
				$("#result").append("<h4>フィールドセンター（もりの学舎）方面</h4>");
			} else if (selectedId < 12) {
				$("#result").append("<h4>地球市民交流センター方面</h4>");
			} else {
				$("#result").append("<h4>当停留所終点(到着時刻)</h4>");
			}
		}
	}
	
	// 時刻表データ
	var table = $("#table");
	var tbody = $('<tbody>');
	var th = $('<tr class="tr-timetable">').append('<th class="th-hour">時</th><th class="th-week">平日</th><th class="th-holi">土・休日</th>');
	table.append($('<thead>').append(th));

	// 8~17時の毎時の発車時刻を抽出する
	for (var i=8; i<18; i++) {
		
		// 平日の時刻
		var week_min = '';
		for (var j in week_data) {
			var timeArray = week_data[j].d_time.split(":");
			
			if (timeArray[0]==i) {
				week_min = week_min + timeArray[1] + ' ';
			}
			
			var td_week = '<td class="td-week">'+ week_min + '</td>';
		}
		
		// 休日の時刻
		var holi_min = '';
		for (var k in holi_data) {
			var timeArray = holi_data[k].d_time.split(":");
			
			if (timeArray[0]==i) {
				holi_min = holi_min + timeArray[1] + ' ';
			}
			
			var td_holi = '<td class="td-holi">'+ holi_min + '</td>';
		}
		
		// 時間の行を表示する
		var td_hour = '<td class="td-hour">'+ i +'</td>';
		var td = $('<tr class="tr-timetable">').append(td_hour).append(td_week).append(td_holi);
		tbody.append(td);
		
	}
	table.append(tbody);
}

//---------------------------------------------------------
// Google Maps
//---------------------------------------------------------

function createMarker(id,name,latlng,map){
	var infoWindow = new google.maps.InfoWindow();
	var marker = new google.maps.Marker({
		id: id,
		position: latlng,
		map: map
	});
	
	google.maps.event.addListener(marker, 'click', function() {
		if (currentWindow) {
			currentWindow.close();
		}
		infoWindow.setContent(name);
		infoWindow.open(map,marker);
		currentWindow = infoWindow;
		
		showData(id);
	});
} 

function createPolyline(map){
	// LinkDataからバス経路のデータ取得
	var workValue = 'rdf1s1845i';
	var fileValue = 'moricoro_park_bus_route';
	bus_route = new Array();
	tmp_array = new Array();
	var arrow_color;
	$.each(LinkData.getSubjects(workValue,fileValue),function(subjKey,subjValue) {
		var tmp_data = {}
		tmp_data["id"] = subjValue;
			$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
				$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
					if (propValue == "http://www.w3.org/2000/01/rdf-schema#label"){
						tmp_data["name"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1845i#bus_stop_flg"){
						tmp_data["bus_stop_flg"] = objValue;
					} else if(propValue == "http://linkdata.org/property/rdf1s1845i#color"){
						tmp_data["color"] = objValue;
					} else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#lat"){
						tmp_data["lat"] = objValue;
					} else if(propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#long"){
						tmp_data["lng"] = objValue;
					} 
			});
		});
		// 取得したバス経路と色を配列に代入
		tmp_array.push(new google.maps.LatLng(tmp_data["lat"], tmp_data["lng"]));
		if(tmp_data["bus_stop_flg"]==1){
			if(!arrow_color){arrow_color=tmp_data["color"]}
			bus_route.push({route:tmp_array, color:arrow_color});
			
			// 次の始点
			tmp_array = [new google.maps.LatLng(tmp_data["lat"], tmp_data["lng"])];
			arrow_color = tmp_data["color"];
		}
	});

	for(var i=0; i<bus_route.length;i++){


		// Polylineを矢印にする
		var lineSymbol = {
			path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW
		};
		

		var line = new google.maps.Polyline({
			path: bus_route[i]["route"],
			strokeColor: bus_route[i]["color"],
			//strokeColor: "#FF0000",
			icons: [{
				icon: lineSymbol,
				offset: '100%',
			}],
			map: map
		});

	}

}

//google.maps.event.addDomListener(window, 'load', initialize);

