function Gmap_init(){
	var directionsDisplay = new google.maps.DirectionsRenderer();
	var initPos = new google.maps.LatLng(36.065219,136.221642);
	var myOptions = {
		noClear : true,
		center : initPos,
		zoom : 13,
 		mapTypeId : google.maps.MapTypeId.ROADMAP
	};
	map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
	directionsDisplay.setMap(map);
}

// linkdataからmarkerのデータ取得
function Get_markers_data(workValue,fileValue,icon,array){
	"use strict";
	$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
		var tmp_data = new Array();
		$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
			$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
					if (propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#long"){
						tmp_data["lng"] = objValue;
					} else if (propValue == "http://www.w3.org/2003/01/geo/wgs84_pos#lat"){
						tmp_data["lat"] = objValue;
					} else if (propValue == "http://www.w3.org/2000/01/rdf-schema#label"){
						tmp_data["name"] = objValue;
					} else if (propValue == "http://xmlns.com/foaf/0.1/homepage"){
						tmp_data["url"] = objValue;
					}
			});
		});
		Set_markers(array,tmp_data["lat"],tmp_data["lng"],tmp_data["name"],tmp_data["url"],icon);
	});
}

// Markerの作成
function Set_markers(array ,lat, lng, name, url, icon) {
	//var array = rain_gauge_stations;
	var icon = icon;
	var info = "<div id='infowindow_class'>"
		+ '<a href="' + url +'">' + name + '</a><hr>'
 		+ "<object style='height:100%;width:100%;' data='"
 		+ url
 		+ "'>表示できませんでした</object></div>";



	var myLatlng = new google.maps.LatLng(lat,lng);
	var marker = new google.maps.Marker({
		position: myLatlng,
		map: map,
		icon: icon,
		title:name
	});


	// 作成したmarkerを配列にコピー
	// 直接入れるmarkerを作るとclick eventがなぜか上手く取れないのでヘタレる
	var i = array.length;
	array[i] = marker;
	delete marker;
	array[i].ext=new const_marker(name,url);


	// markerクリックでinfoWindow表示
	// infoWindowを配列にして動的に追加・削除すると上手く動かないのでこれで逃げる
	// 多分markerと違い非表示状態のinfoWindowを追加・削除しようとして不具合を生じさせていると予想
	google.maps.event.addListener(array[i], 'click', function() {
		var infoWindow = new google.maps.InfoWindow();
		infoWindow.setContent(info);
		infoWindow.setPosition(myLatlng);
		infoWindow.open(map);
	});
}


function const_marker(name,url){
	this.name = name;
	this.url = url;
}
