queryData = {};
	queryData.subjects = [];
	queryData.properties = [];
	queryData.data = [];
	queryData.pURI = "source("http://linkdata.org/api/1/rdf1s1899i/sotsuken3/R"

$(window).load(function() {

	sparql = new Sparql();

	$('#find_query').click(function(){
		$('#result_div').hide();
		sparql.findByQuery($('#query_area').val().replace(/[\n\r]/g,""));
	});

	$('#result_div').hide();

	setupData();
	
	init();
	
});

function init(){

	// Servletサーバアドレス
	sparql.server = "http://lod.hozo.jp";

	// エンドポイントのURLを取得
	var endpoint = $("#endpointName option:selected").val();
	sparql.endpoint = {"endpoint": endpoint, "namespaces": ""};
	
	//結果表示処理を行う関数を指定
	sparql.result_func = result_table;
	
	sparql.init();
}

//結果表示用の関数
function result_table(data){
	var result_div = $('#result_div');
	var table = $('#result_list')[0];

	if (table == undefined) {
		result_div.append($('<table border="1"></table>').attr({
			'id' : 'result_list',
			'class' : 'table'
		}));
		table = $('#result_list')[0];
	}

	while (table.rows.length > 0) {
		table.deleteRow(0); // 行を追加
	}

	if (data instanceof Array) {
		result_div.show();
		// ヘッダ
		var header = table.createTHead(); // 行を追加
		var headerRow = header.insertRow(0);
		id = 1;
		for (var d = 0; d < data.length; d++) {
			var row1 = table.insertRow(d + 1); // 行を追加

			if (d == 0) {
				for ( var key in data[0]) {
					var th = document.createElement('th');
					var label = key;
					th.innerHTML = key;
					headerRow.appendChild(th);
				}
			}
			var i = 0;
			// ID
			for ( var key in data[d]) {
				var cell = row1.insertCell(i++); // ２つ目以降のセルを追加
				var value = data[d][key];
				if (value.uri != undefined){
					value = value.uri;
				}
				if (value == null) {
					value = '';
				}
				var link = true;
				if (link) {
					if (value != null && value.indexOf("http://") == 0) {
						value = '<a href="'+value+'" target="_blank">'
								+ value + '</a>';
					}
				}
				cell.innerHTML = value;
			}
		}
	}
};

function setupData() {
	var workList = LinkData.getWorks();
	for (var i = 0 ; i < workList.length; i++){
		var workId = workList[i];
		var fileList = LinkData.getFiles(workId);
		for (var j = 0 ; j < fileList.length; j++){
			var fileName = fileList[j];
			queryData.subjects = LinkData.getSubjects(workId, fileName);
			queryData.properties = LinkData.getProperties(workId, fileName);
			initEndpoint(workId, fileName);
			showQuery(workId, fileName);
		}
	}
};

function initEndpoint(workId, fileName){
	var label =[];
	var comment = [];
	$.each(queryData.subjects, function(sKey, sValue) {
		$.each(queryData.properties, function(pKey, pValue) {
			var obj = LinkData.getObjects(workId, fileName, sValue, pValue);
			if(pValue == "http://www.w3.org/2000/01/rdf-schema#label"){
				label[label.length] = "<option value=\"" + sValue + "\">"+ obj[0] +"</option>";
			}
		});
	});
	$("#endpointName").append(label.join(""));
	showEndpointInfo(workId, fileName);
	
	$("#endpointName").change(function () {
		showEndpointInfo(workId, fileName);
	}).change();	
};

function showEndpointInfo(workId, fileName) {
	var sValue = $("#endpointName option:selected").val();
	var comment = [];
	var creator = [];
	var homepage = [];
	var license = [];
	$.each(queryData.properties, function(pKey, pValue) {
		var obj = LinkData.getObjects(workId, fileName, sValue, pValue);
		if(pValue == "http://purl.org/dc/elements/1.1/description"){
			comment[comment.length] = obj[0];
		} else if (pValue == "http://purl.org/dc/elements/1.1/creator") {
			creator[creator.length]=obj[0];
		} else if (pValue == "http://xmlns.com/foaf/0.1/homepage") {
			homepage[homepage.length]=obj[0];
		} else if (pValue == (queryData.pURI + workId + "#license")) {
			license[license.length]=obj[0];
		}
	});
	$("#endpointURL").html('<a target="_blank" href="' + sValue + '">' + sValue +'</a>');
	$("#endpointComment").text(comment[0]);
	$("#endpointCreator").text(creator[0]);
	$("#endpointHomepage").html('<a target="_blank" href="' + homepage[0] + '">' + homepage[0] +'</a>');
	if (license[0] == "http://creativecommons.org/licenses/by/2.1/jp/") {
		$("#endpointLicense").html('<a target="_blank" href="' + license[0] + '"><img src="http://creativecommons.jp/wp/wp-content/uploads/2009/10/by.png"></a>');
	} else if (license[0] == "http://creativecommons.org/licenses/by-nd/2.1/jp/") {
		$("#endpointLicense").html('<a target="_blank" href="' + license[0] + '"><img src="http://creativecommons.jp/wp/wp-content/uploads/2009/10/by-nd.png"></a>');
	} else {
		$("#endpointLicense").html('<a target="_blank" href="' + license[0] + '">' + license[0] +'</a>');
	}
	$("#query_area").val("select * {?s ?p ?o} LIMIT 100");
	$("#queryComment").attr("style", "display:none;");
	$("input[name='options']:radio").attr("checked", false);
	init();
}

function showQuery(workId, fileName) {
	$("input[name='options']:radio").change(function() {
		$("#query_area").val("");
		var sValue = $("#endpointName option:selected").val();
		var pQuery = "";
		var pComment = "";
		if ($(this).attr("id") == "sampleQ1") {
			pQuery = queryData.pURI + workId + "#ex1-query";
			pComment = queryData.pURI + workId + "#ex1-comment";
		} else if ($(this).attr("id") == "sampleQ2") {
			pQuery = queryData.pURI + workId + "#ex2-query";
			pComment = queryData.pURI + workId + "#ex2-comment";
		} else if ($(this).attr("id") == "sampleQ3") {
			pQuery = queryData.pURI + workId + "#ex3-query";
			pComment = queryData.pURI + workId + "#ex3-comment";
		}
		var oQuery = LinkData.getObjects(workId, fileName, sValue, pQuery);
		$("#query_area").val(oQuery[0]);
		var oComment = LinkData.getObjects(workId, fileName, sValue, pComment);
		$("#queryComment").attr("style", "display:inline-block;").text(oComment[0]);
	});
}
