if (typeof Application == "undefined" || !Application) {
	var Application = {};
}

Application.genocon = function() {
	this._init.apply(this, arguments);
};

Application.genocon.prototype = {
	
	_baseSequence : null,
	
	_default : {
		baseSequenceContainerId : "baseSequenceContainer",
		hiddenBaseSequenceClass : "hdnBaseSequence",
		fixedSequenceClass : "fixedSequence",
		baseErrorMessageClass : "baseErrorMessage",
		errorMessageEnterSequence : "Please enter a sequence of minimum length {0}",
		useButtonClass : "useButton",
		nextButtonClass : "nextButton",
		nextButtonContainerClass : "nextButtonContainer",
		collapseButton : "collapseButton",
		expandButton : "expandButton",
		removeButton : "removeButton",
		appContainerClass : "applicationContainer",
		appDataContainerClass : "applicationDataContainer",
		actionButtonContainer : "actionButtonContainer",
		actionResultContainer : "actionResultContainer",
		baseSequenceBoxClass : "baseSequenceBox",
		baseSequenceClass : "baseSequence",
		selectDataBaseList : "databaseList",
		selectMethodList : "optionList",
		hiddenBaseSequence : "hdnBaseSequence",
		databaseFilteringProperty : "#motif%20sequence",
		methodFilteringProperty : "#application%20URL",
		baseSequenceMinLength : 50
	},
	
	_init : function() {
		this._initBaseInput();
		this._initDefaultContainer();
		this._initUseButtonListener();
	},
	
	_initBaseInput : function() {
		var val = $("#" + this._default.baseSequenceContainerId + " ." + this._default.hiddenBaseSequenceClass).val();
		if (val && val.length < this._default.baseSequenceMinLength) {
			$errMsgEl = $("#" + this._default.baseSequenceContainerId + " ." + this._default.baseErrorMessageClass);
			$errMsgEl.html(self._default.errorMessageEnterSequence.replace("{0}", self._default.baseSequenceMinLength));
			$errMsgEl.show();
			return;
		}
		$baseInput = $("#" + this._default.baseSequenceContainerId + " ." + this._default.baseSequenceClass);
		var index = val.length - this._default.baseSequenceMinLength;
		$baseInput.attr("size", index);
		var inputVal = val.substring(0, index);
		var fixedVal = val.substring(index);
		$baseInput.val(inputVal);
		$("#" + this._default.baseSequenceContainerId + " ." + this._default.fixedSequenceClass).html(fixedVal);
		$baseInput.keyup(function() {
			var size = ($baseInput.val().length != 0) ? $baseInput.val().length : 1;
			$baseInput.attr("size", size);
		});
	},
	
	_initDefaultContainer : function() {
		this._initDatabase();
		this._initMethod();
		this._initActionButton();
		this._initDatabaseListener();
		this._initMethodListener();
	},
	
	_initDatabase : function() {
		var self = this;
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		$("option", $select).remove();
		$select.append("<option value='-1' selected='selected'>-- Select Database --</option>");
		$.each(LinkData.getFiles(), function(workId, fileNameList) {
			$.each(fileNameList, function(key, fileName) {
				var dbKey = self._getDatabaseOptionKey(workId, fileName);
				$.each(LinkData.getProperties(workId, fileName), function(pKey, pValue) {
					if (pValue.indexOf(self._default.databaseFilteringProperty) > 0) {
						$select.append("<option value='" + dbKey + "'>" + fileName + "</option>");
					}
				});
			});
		});
	},
	
	_initMethod : function() {
		var self = this;
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectMethodList);
		$("option", $select).remove();
		$select.append("<option value='-1' selected='selected'>-- Select Option --</option>");
		$.each(LinkData.getFiles(), function(workId, fileNameList) {
			$.each(fileNameList, function(key, fileName) {
				$.each(LinkData.getProperties(workId, fileName), function(pKey, pValue) {
					if (pValue.indexOf(self._default.methodFilteringProperty) > 0) {
						$.each(LinkData.getTriplesByProperty(workId, fileName, pValue), function(tKey, tValue) {
							var label = self._getLabel(tValue.subject);
							$select.append("<option value='" + tValue.object + "'>" + label + "</option>");
						});
					}
				});
			});
		});
	},
	
	_initActionButton : function() {
		var self = this;
		$("." + self._default.actionButtonContainer + " ." + self._default.collapseButton).click(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.appDataContainerClass).hide();
		});
		$("." + self._default.actionButtonContainer + " ." + self._default.expandButton).click(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.appDataContainerClass).show();
		});
		$("." + self._default.actionButtonContainer + " ." + self._default.removeButton).click(function() {
			$(this).closest("." + self._default.appContainerClass).remove();
		});
	},
	
	_initDatabaseListener : function() {
		var self = this;
		var $selectDb = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		$selectDb.change(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$(parent).find("." + self._default.selectMethodList + " option").removeAttr("selected");
			$(parent).find("." + self._default.nextButtonContainerClass).hide();
			$container = $(parent).find("." + self._default.actionResultContainer);
			$container.html("");
		});
	},
	
	_initMethodListener : function() {
		var self = this;
		var $selectDb = $("." + self._default.appContainerClass + " ." + self._default.selectDataBaseList);
		var $select = $("." + self._default.appContainerClass + " ." + self._default.selectMethodList);
		$select.change(function() {
			var parent = $(this).closest("." + self._default.appContainerClass);
			$container = $(parent).find("." + self._default.actionResultContainer);
			$container.html("");
			$(parent).find("." + self._default.nextButtonContainerClass).hide();
			var date = new Date();
			var id = "container_id_" + date.getTime();
			$container.attr("id", id);
			var method = $("option:selected", $(this)).text();
			var database = $("option:selected", $(parent).find("." + self._default.selectDataBaseList)).val();
			var func = function() {
				self._callback(self);
			}
			if (database != -1) {
				var arr = database.split("|");
				var obj = {
					workId : arr[0],
					fileName : arr[1],
					appName : method,
					baseSequence : self._baseSequence,
					callback : func
				};
				eval(method)(id, obj);
			}
		});
	},
	
	_initUseButtonListener : function() {
		var self = this;
		$("#" + self._default.baseSequenceContainerId + " ." + self._default.useButtonClass).click(function() {
			$txtSeq = $("#" + self._default.baseSequenceContainerId + " ." + self._default.baseSequenceClass);
			$fixedSeq = $("#" + self._default.baseSequenceContainerId + " ." + self._default.fixedSequenceClass);
			self._baseSequence = $txtSeq.val() + $fixedSeq.html();
			$errMsgEl = $("#" + self._default.baseSequenceContainerId + " ." + self._default.baseErrorMessageClass);
			$errMsgEl.hide();
			if (!self._baseSequence || self._baseSequence.length < self._default.baseSequenceMinLength) {
				$errMsgEl.html(self._default.errorMessageEnterSequence.replace("{0}", self._default.baseSequenceMinLength));
				$errMsgEl.show();
				//_showError($baseContainer, opts.msgEmptySequence);
			} else {
				$txtSeq.attr('readonly', true).addClass("noborder");
				$(this).hide();
				$("." + self._default.appContainerClass).show();
			}
		});
	},
	
	_callback : function(self) {
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonContainerClass).show();
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonClass).unbind('click');
		$("." + self._default.appContainerClass + " ." + self._default.nextButtonClass).click(function() {
			$parent = $(this).closest("." + self._default.appContainerClass);
			var clone = $parent.clone(true);
			var text = $(clone).find(".replaceSequence").text();
			if (text && text.trim().length != 0) {
				self._baseSequence = text;
			}
			$(clone).find("." + self._default.actionResultContainer).html("");
			$(clone).find("." + self._default.nextButtonContainerClass).hide();
			$parent.parent().append(clone);
		});
	},
	
	_getDatabaseOptionKey : function(workId, fileName) {
		return workId + "|" + fileName;
	},
	
	_getLabel : function(value) {
		var propLabel = value;
		var arr = value.split("#");
		if (arr.length > 1) {
			propLabel = decodeURIComponent(arr[1]);
		}
		return propLabel;
	}
	
};

$(document).ready(function() {
	new Application.genocon();
});
