/*
This is a Example program to retrieve and display the list of the data. Press the play/reload button on the right of the upper screen, and the program is executed. The program first displayes the subjects that match the keyword completely. The program highlights the list fragments that match the keyword. The keyword is retrieved from the query following "subject=" in the URL, where the keyword must be encoded. Please create a new application by rewriting this program work. The following is the same content in Japanese.
このサンプルプログラムはデータを取得してリスト表示します。画面右上のplay又はreloadボタンを押すとプログラムが実行されます。プログラムはキーワードに完全一致するサブジェクトを最初に表示します。またプログラムはキーワードに部分一致するリスト中の部分をハイライトします。キーワードはURLの中で"subject="に続くクエリーから取得されます。ただし、キーワードはURIエンコードされている必要があります。このプログラムを書き変えて新しいアプリケーションを作成してください。
*/

window.onload = function() {
	var keyword = getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
	var list = ""; // list to be displayed
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		$("#result").append("<h3>" + LinkData.getWorkName(workValue) + "</h3>");
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			var hit = ""; // list of subjects whose URI matches keyword
			var nHit = 0; // number of subjects whose URI matches keyword
			list += "<hr><h4>Viewing file: " + fileValue + "</h4>";
			// Subject loop
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var longitude = null;
				var latitude = null;
				var s = ""; // subject to be displayed
				s += "<hr><a href=\"" + subjValue + "\" target=\"_top\"><span class=\"subject\">" + highlight(decodeURIComponent(subjValue), keyword) + "</span></a>";
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ( prop == "http://www.w3.org/2003/01/geo/wgs84_pos#long" ) longitude = obj;// longitude found
					if ( prop == "http://www.w3.org/2003/01/geo/wgs84_pos#lat" ) latitude = obj;// latitude found
					if ( obj.indexOf("://www.youtube.com") != -1 && obj.indexOf("v=") != -1 ) { // Insert YouTube Thumbnail
						videoId = (obj.split("v=")[1]).split("&")[0]; // get video id
						obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" + highlight(decodeURIComponent(obj), keyword) + "<br><img src=\"http://img.youtube.com/vi/" + videoId + "/mqdefault.jpg\" alt=\"YouTube video\" /><br></span></a>";
						}
						else if ( obj.indexOf("http") == 0 ) {
							if ((obj.indexOf(".jpg" )>0 || obj.indexOf(".gif" )>0 || obj.indexOf(".png" )>0) || (obj.indexOf(".JPG" )>0 || obj.indexOf(".GIF" )>0 || obj.indexOf(".PNG" )>0)) // insert image
								 obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" +shortenURL(obj) + "<br><img src=\"" + obj + "\" alt=\"image\" /><br></span></a>";
							else
								obj = "<a href=\"" + obj + "\" target=\"_blank\"><span class=\"object\">" + shortenURL(obj) + "</span></a>"; // Make it clicable if it starts from http
					}
					else
						obj = "<span class=\"object\">" + highlight(obj, keyword) + "</span>";
					s += "<br><span class=\"propertyName\">" + getLastName(prop) + ":\t</span>" +  obj;
				});
				if ( latitude != null && longitude != null ) s += addLinkToMap( latitude, longitude );
				list += s; //add to the list to be displayed
				if ( decodeURIComponent(subjValue) == keyword ) { // found subject whose URI matches keyword
					hit += s;
					nHit++;
				}
				//link to map display if coordinates exist
			});
			if ( nHit > 0 ) {
				if ( nHit == 1 )
					$("#result").append( "<hr><h4>" + "1 subject hit in file: "+fileValue+"</h4>" );
				else
					$("#result").append( "<hr><h4>" + nHit + " subjects hit in file: "+fileValue+"</h4>" );
				$("#result").append( hit + "<br><br>" );
			}
		});
	});
	$("#result").append( list );
	window.find(highlight);
};

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var topWindow = top.window.location.search;
	if( topWindow ){
		var q = decodeURIComponent(topWindow.substring(1,topWindow.length)).split("&");
		for ( var i = 0; i < q.length; i++ ){
			var r = q[i].split("=");
			if ( r[0] ==  paramString )
				value = r[1];
		}
	}
 	return value;
}

// Highlight keyword in the string
function highlight( string, keyword )
{
	if ( keyword.length > 0 ) {
		var ss = string.split(keyword);
		var len = ss.length;
		if ( len > 1 ) {
			string = ss[0];
			for ( i = 1; i < len; i++ )
//				string += "<font color=\"red\">"+keyword+"</font>"+ss[i];
				string += "<span class=\"highlight\">"+keyword+"</span>"+ss[i];
		}
	}
	return string;
}

// get the last name of the string separated with # and /
function getLastName( string )
{
	string = decodeURIComponent(string);
	var sharp = string.split("#");
	var slash = sharp[sharp.length-1].split("/");
	var lastName = slash[slash.length-1];
	return lastName;
}

// return a link to Google map search
function addLinkToMap( latitude, longitude )
{
	var s = "<br><a target=\"_blank\" href=\"http://www.google.com/maps/?q=" + latitude + "," + longitude + "\">Show map</a>";
	return s;
}

// shortening URL e.g. http://.../123.jpg
function shortenURL( url )
{
	url = decodeURIComponent(url);
	return url;
}
