// Created by Tetsuro Toyoda ver 2015.1.27.0
var localwiki = "http://ja.localwiki.org";//localwikiのドメイン
var region    = "mr";//localwikiのregion
var titlepre  = "夜景スポット｜";//タイトルの名の前に付ける文字列
var titlepost = "からの夜景";//タイトル名の後に付ける文字列
var property  = "label"; //タイトル名のもととなるプロパティ名（複数ある場合は後者を採用）
var comment   ="LocalWikiは地域のスポットについて誰でも自由に追記できるページです。自分の知識を各ページに記載して、地域の情報を共有しましょう！ アプリ開発できる方はデータをダウンロードして、観光アプリをつくってみてはいかがでしょうか。<br><a href='"+localwiki+"/"+region+"' target='_top'><span class='link'>地域のLocalWikiトップページを開く</span></a>";
function download(workValue, fileKey, fileValue)
{
	var win = window.open();
	win.document.writeln("<table>");
		$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
			var titlename = "";
//			var data = "";
			$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
				var prop = tripleValue.property;
				var obj = tripleValue.object;
				if ( getLastName(prop) == property ) titlename = obj;
			});
			var url = localwiki + "/" + region + "/" + titlepre + titlename + titlepost;
			win.document.writeln("<tr><td>"+url+"</td><td>"+subjValue+"</td></tr>");
		});
	win.document.writeln("</table>");
}

window.onload = function() {
	var keyword = getParameterFromURL("subject"); // obtain keyword from the URL "?subject="
	var list = ""; // list to be displayed
	var ruteToHitPoint = "";
	var prefs = new Array();
	var downloadbutton = "";
	// Work loop
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		list += "<h3>LocalWikiへのリンク | " + LinkData.getWorkName(workValue) + "</h3>" + comment;
		// File loop
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			var hit = ""; // list of subjects whose URI matches keyword
			var nHit = 0; // number of subjects whose URI matches keyword
			// Subject loop
			
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var longitude = null;
				var latitude = null;
				var titlename = "";
				var s = ""; // subject to be displayed
				if ( decodeURIComponent(subjValue).indexOf("linkdata.org/resource/") > 0 )
					s += "<a href=\"" + subjValue + "\" target=\"_top\"><span class=\"link\">【他のアプリを表示】</span></a>";
				else
					s += "<a href=\"" + subjValue + "\" target=\"_top\"><span class=\"link\">"+decodeURIComponent(subjValue)+"</span></a>";
				$.each( LinkData.getTriplesBySubject(workValue, fileValue, subjValue), function( tripleKey, tripleValue ) {
					var prop = tripleValue.property;
					var obj = tripleValue.object;
					if ( getLastName(prop) == property ) titlename = obj;
					if ( prop == "http://www.w3.org/2003/01/geo/wgs84_pos#long" ) longitude = obj;// longitude found
					if ( prop == "http://www.w3.org/2003/01/geo/wgs84_pos#lat" ) latitude = obj;// latitude found
					if ( obj.indexOf("://www.youtube.com") != -1 && obj.indexOf("v=") != -1 ) { // Insert YouTube Thumbnail
						videoId = (obj.split("v=")[1]).split("&")[0]; // get video id
						obj = "<a href=\"" + obj + "\" target=\"_top\"><span class=\"object\">" + highlight(decodeURIComponent(obj), keyword) + "<br><img src=\"http://img.youtube.com/vi/" + videoId + "/mqdefault.jpg\" alt=\"YouTube video\" /><br></span></a>";
						}
						else if ( obj.indexOf("http") == 0 ) {
							if ((obj.indexOf(".jpg" )>0 || obj.indexOf(".gif" )>0 || obj.indexOf(".png" )>0) || (obj.indexOf(".JPG" )>0 || obj.indexOf(".GIF" )>0 || obj.indexOf(".PNG" )>0)) // insert image
								 obj = "<a href=\"" + obj + "\" target=\"_top\"><span class=\"object\">" +shortenURL(obj) + "<br><img src=\"" + obj + "\" alt=\"image\" /><br></span></a>";
							else
								obj = "<a href=\"" + obj + "\" target=\"_top\"><span class=\"object\">" + shortenURL(obj) + "</span></a>"; // Make it clicable if it starts from http
					}
					else
						obj = "<span class=\"object\">" + highlight(obj, keyword) + "</span>";
					s += "<br><span class=\"propertyName\">" + getLastName(prop) + ":\t</span>" +  obj;
				});
				if ( latitude != null && longitude != null ) s += addLinkToMap( latitude, longitude );
				var url = localwiki + "/" + region + "/" + titlepre + titlename + titlepost;
				s = "<hr><a href=\"" + url + "\" target=\"_top\"><h3><span class='subject'>" + titlepre + titlename + titlepost + "</span></h3></a><a href='"+url+"/_edit' target=\"_top\"><span class='link'>【LocalWikiを編集】</span></a> " + s;
				prefs.push([s,latitude,longitude]);
				if ( decodeURIComponent(subjValue) == keyword ) { // found subject whose URI matches keyword
					hit += s;
					ruteToHitPoint = "http://www.google.com/maps/?daddr=" + latitude + "," + longitude;
					nHit++;
				}
				//link to map display if coordinates exist
			});
			if ( nHit > 0 ) {
				list += hit;
			}
			downloadbutton = "<input type='button' value='ページリストのダウンロード' onclick='download(\""+workValue+"\",\""+fileKey+"\",\""+fileValue+"\");'> <input type='button' value='データのダウンロード' onclick='window.open(\"http://linkdata.org/view/"+workValue+"\");'>";
		});
	});
	$("#result").append( list + "この端末からの位置情報の取得を許可してからもう一度アクセスしてください。" );

  	navigator.geolocation.getCurrentPosition(function(pos) {
    	var lat = pos.coords.latitude;
    	var long = pos.coords.longitude;
		$('#result').empty();
		$('#result').append( list );
		if ( ruteToHitPoint != "" )
		{
			$('#result').append(" <a target=\"_top\" href=\""+ ruteToHitPoint + "&saddr=" + lat + "," + long + "\"><span class='link'>【ここから目的地へのルートを表示】</span></a>");
		}
			$('#result').append( "<hr>" + downloadbutton + "<hr><h4>以下、現在地から近い順にページをリスト表示します。</h4>");
    		$.each(prefs, function(i, p) {
      			p[3] = Distance(long, lat, p[2], p[1]);
    		});
    		prefs.sort(function(p1, p2) {
      			return p1[3] - p2[3];
    		});
	   		$.each(prefs, function(i, p) {
      			$('#result').append(p[0]);
     			$('#result').append(" <a target=\"_top\" href=\"http://www.google.com/maps/?saddr=" + lat + "," + long + "&daddr=" + p[1] + "," + p[2] + "\"><span class='link'>【ここから目的地へのルートを表示】</span></a>");
      			$('#result').append("<br>ここから目的地までの直線距離は"+Math.floor(p[3])/1000+"kmです<br>");
			});
	}, function(error) {
		$('#result').empty();
		$('#result').append( list + "<hr>" + downloadbutton + "<hr><h4>以下、登録順にページをリスト表示します。</h4>");
	   	$.each(prefs, function(i, p) {
      		$('#result').append(p[0]);
		});
	});
};

// Get a parameter value in URL (e.g. ?paramString=value )
function getParameterFromURL( paramString )
{			
	var value = "";
	var topWindow = top.window.location.search;
	if( topWindow ){
		var q = decodeURIComponent(topWindow.substring(1,topWindow.length)).split("&");
		for ( var i = 0; i < q.length; i++ ){
			var r = q[i].split("=");
			if ( r[0] ==  paramString )
				value = r[1];
		}
	}
 	return value;
}

// Highlight keyword in the string
function highlight( string, keyword )
{
	if ( keyword.length > 0 ) {
		var ss = string.split(keyword);
		var len = ss.length;
		if ( len > 1 ) {
			string = ss[0];
			for ( i = 1; i < len; i++ )
//				string += "<font color=\"red\">"+keyword+"</font>"+ss[i];
				string += "<span class=\"highlight\">"+keyword+"</span>"+ss[i];
		}
	}
	return string;
}

// get the last name of the string separated with # and /
function getLastName( string )
{
	string = decodeURIComponent(string);
	var sharp = string.split("#");
	var slash = sharp[sharp.length-1].split("/");
	var lastName = slash[slash.length-1];
	return lastName;
}

// return a link to Google map search
function addLinkToMap( latitude, longitude )
{
	var s = "<br><a target=\"_top\" href=\"http://www.google.com/maps/?q=" + latitude + "," + longitude + "\"><span class='link'>【地図表示】</span></a>";
	return s;
}

// shortening URL e.g. http://.../123.jpg
function shortenURL( url )
{
	url = decodeURIComponent(url);
	var slash = url.split("/");
	var lastName = slash[slash.length-1];
	return url.split(":")[0]+"://.../"+lastName;
}

function Distance( long1, lat1, long2, lat2 )
{
	var r = 6378137; //地球の半径(m)
	var d = r * Math.acos( Math.sin(lat1/180*Math.PI)*Math.sin(lat2/180*Math.PI) + Math.cos(lat1/180*Math.PI)*Math.cos(lat2/180*Math.PI)*Math.cos((long2-long1)/180*Math.PI) );
	return d;
}
