//全データを入れるデータ
var all_data;
//初期処理
function initialize(){
	//新しい配列
	all_data = new Array();
	tmp_a_data = new Array();
	
	//①インプットとして指定されているデータを取得する(今回は信州御城プロジェクト)
	//workValueはデータの中身のオール、workkeyはよく分からないらしい
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		//②ファイルの中身を取得に行く
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			//③subjValueが行の情報、propValueが列の情報です。
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				//tempデータを宣言
				var tmp_data = {}
				//名前を取ってくる？多分、一番左の行
				tmp_data["name"] = subjValue;
				
				//④ここで列の情報を取得
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					//⑤ここでデータを取得する
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						//列の情報が名前の時、オブジェクトをセット
						if(propValue　==　
						 "http://linkdata.org/property/rdf1s2675i#jyoushu")
						{tmp_data["jyoushu"] = objValue;}
						else if(propValue == 
						 "http://linkdata.org/property/rdf1s2675i#yomi_name")
						{tmp_data["yomi_name"] = objValue;}
						else if(propValue == 	"http://www.w3.org/2003/01/geo/wgs84_pos#lat")
						{tmp_data["lat"] = objValue;}
						else if(propValue == 	"http://www.w3.org/2003/01/geo/wgs84_pos#long")
						{tmp_data["lng"] = objValue;}
						else if(propValue == 	"http://linkdata.org/property/rdf1s2675i#GMAP")
						{tmp_data["gmap"] = objValue;}
					});
				});
				tmp_a_data.push(tmp_data);　//ここで一行分のデータがセットされる
			});
		});
	});
	//全データ
	all_data = tmp_a_data;
	
	//全データを地図上に表示

    // 地図センター緯度経度の初期値は「葛尾城」
    var latlng = new google.maps.LatLng(	36.473982,138.173133);
    var myOptions = {
        zoom: 15,
    	center: latlng,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    var map = new google.maps.Map(document.getElementById("result"), myOptions);
	// ウィンドウに表示するデータをつくる
    var data = new Array();
	for (var i in all_data)
	{ 
		var value = decodeURI(all_data[i].name);
		var tmp_name = value.split("#");　//#で文字列を分解する。メタデータ分
		var point_name = tmp_name[1]; //一番左のやつ
		//Array.pushは配列の末尾に要素を追加する、
		data.push({position: new google.maps.LatLng
				   (all_data[i].lat,all_data[i].lng), 
					content: point_name + '<br>' +  
					all_data[i].yomi_name + '<br>' +
					all_data[i].jyoushu
				  });
	};     
    // 地図上にウィンドウで表示
    for (i = 0; i < data.length; i++)
	{var marker 
		= new google.maps.Marker({position: data[i].position,map: map});
		//御城の情報を載せる
        attachMessage(marker, data[i].content);
    };
};


// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	new google.maps.InfoWindow({
			content: msg
        }).open(marker.getMap(), marker);
    });
};
//最初に動く
window.onload = function() {
    $(function(){
    	initialize();        
    });	
};
