var rendererOptions = {
	draggable: true,
	preserveViewport:false
};
var directionsDisplay = new google.maps.DirectionsRenderer(rendererOptions);
var directionsService = new google.maps.DirectionsService();
function calcRoute(origin, destination) {
	if (origin === destination) return;
	var request = {
		origin: origin,
		destination: destination,
		travelMode: google.maps.DirectionsTravelMode.DRIVING,
		unitSystem: google.maps.DirectionsUnitSystem.METRIC,
		optimizeWaypoints: true,
		avoidHighways: false,
		avoidTolls: false
	};
	directionsService.route(request,
		function(response,status){
		  	if (status == google.maps.DirectionsStatus.OK){
				directionsDisplay.setDirections(response);
				directionsDisplay.setPanel(document.getElementById("directionsPanel"));
			}
		});
	}
//全データを入れるデータ
var all_data;
//初期処理
function initialize(){
	google.maps.event.addListener(directionsDisplay,
								  'directions_changed',
								  function(){});

	//新しい配列
	all_data = new Array();
	tmp_a_data = new Array();
	
	//①インプットとして指定されているデータを取得する(今回は信州御城プロジェクト)
	//workValueはデータの中身のオール、workkeyはよく分からないらしい
	$.each(LinkData.getWorks(), function(workKey, workValue) {
		//②ファイルの中身を取得に行く
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			//③subjValueが行の情報、propValueが列の情報です。
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				//tempデータを宣言
				var tmp_data = {}
				//名前を取ってくる？多分、一番左の行
				tmp_data["name"] = subjValue;
				
				//④ここで列の情報を取得
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					//⑤ここでデータを取得する
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						//列の情報が名前の時、オブジェクトをセット
						tmp_data.name = subjValue;
						if(propValue.indexOf("#address") > 0) {
							tmp_data.address = objValue;
						} else if(propValue.indexOf("#lat") > 0) {
							tmp_data.lat = objValue;
						} else if(propValue.indexOf("#long") > 0) {
							tmp_data.lng = objValue;
						} else if(propValue.indexOf("#url") > 0) {
							tmp_data.url = objValue;
						} else if(propValue.indexOf("#pool_exists") > 0) {
							tmp_data.pool_exists = objValue;
						} else if(propValue.indexOf("#pool_permit_quick_turn") > 0) {
							tmp_data.pool_permit_quick_turn = objValue;
						} else if(propValue.indexOf("#pool_pace_clock_exists") > 0) {
							tmp_data.pool_pace_clock_exists = objValue;
						} else if(propValue.indexOf("#fee_per_month") > 0) {
							tmp_data.fee_per_month = objValue;
						} else if(propValue.indexOf("#biz_hours") > 0) {
							tmp_data.biz_hours = objValue;
						} else if(propValue.indexOf("#closed_day") > 0) {
							tmp_data.closed_day = objValue;
						} else if(propValue.indexOf("#memo") > 0) {
							tmp_data.memo = !objValue ? '' : objValue;
						}
					});
				});
				tmp_a_data.push(tmp_data);　//ここで一行分のデータがセットされる
			});
		});
	});
	//全データ
	all_data = tmp_a_data;
	
	//全データを地図上に表示

    // 地図センター緯度経度の初期値
    var latlng = new google.maps.LatLng(36.643,138.188686);
    var myOptions = {
        zoom: 13,
    	center: latlng,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    var map = new google.maps.Map(document.getElementById("result"), myOptions);
	directionsDisplay.setMap(map);
	google.maps.event.addListener(map, 'click', function (event) {
		calcRoute(prevLatLng.k + "," + prevLatLng.D, event.latLng.k + "," + event.latLng.D);
		prevLatLng = event.latLng;
	});
	// ウィンドウに表示するデータをつくる
    var data = new Array();
	for (var i in all_data)
	{ 
		var value = decodeURI(all_data[i].name);
		var tmp_name = value.split("#");　//#で文字列を分解する。メタデータ分
		var point_name = tmp_name[1]; //一番左のやつ
		//Array.pushは配列の末尾に要素を追加する、
		//			biz_hours
		data.push({position: new google.maps.LatLng
				   (all_data[i].lat,all_data[i].lng), 
					content: point_name + '<br>' +  
					"<a target='_blank' href='" + all_data[i].url + "'>url</a><br>"
				   + "プール：" + all_data[i].pool_exists + "<br/>"
				   + "クイックターン：" + all_data[i].pool_permit_quick_turn + "<br/>"
				   + 'ペースクロック：' + all_data[i].pool_pace_clock_exists + "<br/>"
				   + "月謝：" + all_data[i].fee_per_month + "<br/>"
				   + "営業時間：" + all_data[i].biz_hours + "<br/>"
				   + "メモ：" + all_data[i].memo + "<br/>"
					+ "休館日" + all_data[i].closed_day + "<br/>"
				  });
	};     
    // 地図上にウィンドウで表示
    for (i = 0; i < data.length; i++)
	{
		var iconUrl = all_data[i].pool_permit_quick_turn === "不可"
			? "http://maps.google.co.jp/mapfiles/ms/icons/blue-dot.png"
			: "http://maps.google.co.jp/mapfiles/ms/icons/orange-dot.png";
		var marker = new google.maps.Marker({position: data[i].position,map: map, icon: iconUrl});
		//ジムの情報を載せる
        attachMessage(marker, data[i].content);
    };
};


var prevInfoWindow = null;
var prevLatLng = null;
// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
		var infoWindow = new google.maps.InfoWindow({
			content: msg
        });
		if (prevLatLng) {
			var currentLatLng = event.latLng;
			calcRoute(prevLatLng.k + "," + prevLatLng.D, currentLatLng.k + "," + currentLatLng.D);
		}
		setTimeout(function() {
			prevLatLng = event.latLng;
		}, 100);
		//直前に開いていたwindowを閉じる
		if (prevInfoWindow) {
			prevInfoWindow.close();
		}
		infoWindow.open(marker.getMap(), marker);
		prevInfoWindow = infoWindow;
    });
};

//最初に動く
window.onload = function() {
    $(function(){
    	initialize();        
    });	
};
