/*
This is a Example program to retrieve and display the data. 
Press the Run button on the right of the screen (described the behavior of the Example program below). 
Please create a new application rewrite this program work. 
*/

var all_data;        
function initialize(){
	all_data = new Array();
	// データをLinkDataから取得 
	tmp_a_data = new Array();

	$.each(LinkData.getWorks(), function(workKey, workValue) {
		//$("#result").append("<h3>Work: " + workValue + "</h3>");
		$.each(LinkData.getFiles(workValue), function(fileKey, fileValue) {
			$.each(LinkData.getSubjects(workValue, fileValue), function(subjKey, subjValue) {
				var tmp_data = {}
				tmp_data["name"] = subjValue;
				$.each(LinkData.getProperties(workValue, fileValue), function(propKey, propValue) {
					$.each(LinkData.getObjects(workValue, fileValue, subjValue, propValue), function(objKey, objValue) {
						var tmp_name = propValue.split("#");
						tmp_data[tmp_name[1]] = objValue;
					});
				});
				tmp_a_data.push(tmp_data);
			});
		});
	});
	//全データ
	all_data = tmp_a_data;
	
	//全データを地図上に表示

    // 地図センター緯度経度の初期値は「長野市役所」
    var latlng = new google.maps.LatLng(36.6491119,138.168098);
    var myOptions = {
        zoom: 6,
    	center: latlng,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    var map = new google.maps.Map(document.getElementById("result"), myOptions);

	// ウィンドウに表示するデータをつくる
    var data = new Array();
	for (var i in all_data){ 
        var value = decodeURI(all_data[i].name);
		var tmp_name = value.split("#");
		var point_name = tmp_name[1];
		var content = point_name + "<br>人口：" + all_data[i].population + "人" + "<br>歳入：" + parseInt(all_data[i].in / 100000000, 10) + "億円" + "<br>歳出：" + parseInt(all_data[i].out / 100000000, 10) + "億円" + "<br>余剰金：" + parseInt(all_data[i].benefit / 10000000, 10) + "億円" + "<br>一人当り：" + Math.ceil(all_data[i].benefit_by_a_person) + "円";
		data.push({position: new google.maps.LatLng(all_data[i].lat, all_data[i].long), content: content, label: point_name });
	};     
    // 地図上にウィンドウで表示
    for (i = 0; i < data.length; i++) {

		var marker = new google.maps.Marker({
            position: data[i].position,
            map: map,
        });
        attachMessage(marker, data[i].content);

		if(data[i].label == "福島県" || data[i].label == "宮城県" || data[i].label == "岩手県"){ continue; } 

		var color = "#00ff00";
		var radius = parseFloat(all_data[i].benefit_by_a_person) * 3;

		new google.maps.Circle({
  			center: data[i].position,       // 中心点(google.maps.LatLng)
  			fillColor: color,   // 塗りつぶし色
  			fillOpacity: 0.5,       // 塗りつぶし透過度（0: 透明 ⇔ 1:不透明）
  			map: map,             // 表示させる地図（google.maps.Map）
  			radius: radius,          // 半径（ｍ）
  			strokeColor: color, // 外周色 
  			strokeOpacity: 1,       // 外周透過度（0: 透明 ⇔ 1:不透明）
  			strokeWeight: 1         // 外周太さ（ピクセル）
 		});

	};
};

// 地図のマーカーをクリックするとウィンドウを表示する処理
function attachMessage(marker, msg) {
	google.maps.event.addListener(marker, 'click', function(event) {
    	new google.maps.InfoWindow({
			content: msg
        }).open(marker.getMap(), marker);
    });
};

window.onload = function() {
    $(function(){
    	initialize();        
    });	
};
